/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia;

import jakarta.security.jacc.EJBMethodPermission;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.Policy;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyFactory;
import jakarta.security.jacc.PrincipalMapper;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.Permissions;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import org.glassfish.exousia.DefaultPolicyContextHandler;
import org.glassfish.exousia.constraints.SecurityConstraint;
import org.glassfish.exousia.constraints.transformer.ConstraintsToPermissionsTransformer;
import org.glassfish.exousia.mapping.DefaultPrincipalMapper;
import org.glassfish.exousia.mapping.SecurityRoleRef;
import org.glassfish.exousia.modules.def.DefaultPolicy;
import org.glassfish.exousia.modules.def.DefaultPolicyConfigurationFactory;
import org.glassfish.exousia.permissions.JakartaPermissions;
import org.glassfish.exousia.permissions.RolesToPermissionsTransformer;

public class AuthorizationService {
    private static final System.Logger LOG = System.getLogger(AuthorizationService.class.getName());
    public static final String ENTERPRISE_BEAN = "jakarta.ejb.EnterpriseBean";
    public static final String ENTERPRISE_BEAN_ARGUMENTS = "jakarta.ejb.arguments";
    private final String contextId;
    private final Policy policy;
    private final PolicyFactory policyFactory;
    private final PolicyConfiguration policyConfiguration;
    private final PolicyConfigurationFactory policyConfigurationFactory;
    private final Map<String, PrincipalMapper> principalMapper = new ConcurrentHashMap<String, PrincipalMapper>();
    private String constrainedUriRequestAttribute;

    public AuthorizationService(ServletContext servletContext, Supplier<Subject> subjectSupplier) {
        this(DefaultPolicyConfigurationFactory.class, DefaultPolicy.class, AuthorizationService.getServletContextId(servletContext), subjectSupplier);
    }

    public AuthorizationService(String contextId, Supplier<Subject> subjectSupplier) {
        this(DefaultPolicyConfigurationFactory.class, DefaultPolicy.class, contextId, subjectSupplier);
    }

    public AuthorizationService(Class<?> factoryClass, Class<? extends Policy> policyClass, String contextId, Supplier<Subject> subjectSupplier) {
        this(factoryClass, policyClass, contextId, subjectSupplier, null);
    }

    public AuthorizationService(Class<?> factoryClass, Class<? extends Policy> policyClass, String contextId, Supplier<Subject> subjectSupplier, Supplier<PrincipalMapper> principalMapperSupplier) {
        this(AuthorizationService.installPolicyConfigurationFactory(factoryClass), AuthorizationService.installPolicy(policyClass), contextId, subjectSupplier, principalMapperSupplier);
    }

    public AuthorizationService(String contextId, Supplier<Subject> subjectSupplier, Supplier<PrincipalMapper> principalMapperSupplier) {
        this(PolicyConfigurationFactory.get(), null, contextId, subjectSupplier, principalMapperSupplier);
    }

    public AuthorizationService(PolicyConfigurationFactory factory, Policy policy, String contextId, Supplier<Subject> subjectSupplier, Supplier<PrincipalMapper> principalMapperSupplier) {
        try {
            this.policyConfigurationFactory = factory;
            this.policyConfiguration = factory.getPolicyConfiguration(contextId, false);
            this.policy = policy;
            this.contextId = contextId;
            this.policyFactory = PolicyFactory.getPolicyFactory();
            PolicyContext.setContextID(contextId);
            PolicyContext.registerHandler("javax.security.auth.Subject.container", new DefaultPolicyContextHandler(contextId, "javax.security.auth.Subject.container", subjectSupplier), true);
            PolicyContext.registerHandler("jakarta.security.jacc.PrincipalMapper", new DefaultPolicyContextHandler(contextId, "jakarta.security.jacc.PrincipalMapper", () -> this.getOrCreatePrincipalMapper(contextId, principalMapperSupplier != null ? principalMapperSupplier : () -> this.getDefaultRoleMapper(contextId))), true);
        }
        catch (PolicyContextException | IllegalArgumentException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setRequestSupplier(String contextId, Supplier<HttpServletRequest> requestSupplier) {
        try {
            PolicyContext.registerHandler("jakarta.servlet.http.HttpServletRequest", new DefaultPolicyContextHandler(contextId, "jakarta.servlet.http.HttpServletRequest", requestSupplier), true);
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setSubjectSupplier(String contextId, Supplier<Subject> subjectSupplier) {
        try {
            PolicyContext.registerHandler("javax.security.auth.Subject.container", new DefaultPolicyContextHandler(contextId, "javax.security.auth.Subject.container", subjectSupplier), true);
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setEnterpriseBeanSupplier(String contextId, Supplier<Object> beanSupplier) {
        try {
            PolicyContext.registerHandler(ENTERPRISE_BEAN, new DefaultPolicyContextHandler(contextId, ENTERPRISE_BEAN, beanSupplier), true);
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getConstrainedUriRequestAttribute() {
        return this.constrainedUriRequestAttribute;
    }

    public void setConstrainedUriRequestAttribute(String constrainedUriRequestAttribute) {
        this.constrainedUriRequestAttribute = constrainedUriRequestAttribute;
    }

    public void addConstraintsToPolicy(List<SecurityConstraint> securityConstraints, Set<String> declaredRoles, boolean isDenyUncoveredHttpMethods, Map<String, List<SecurityRoleRef>> servletRoleMappings) {
        try {
            JakartaPermissions jakartaResourceDataPermissions = ConstraintsToPermissionsTransformer.createResourceAndDataPermissions(declaredRoles, isDenyUncoveredHttpMethods, securityConstraints);
            this.addPermissionsToPolicy(jakartaResourceDataPermissions);
            JakartaPermissions jakartaRoleRefPermissions = RolesToPermissionsTransformer.createWebRoleRefPermission(declaredRoles, servletRoleMappings);
            this.addPermissionsToPolicy(jakartaRoleRefPermissions);
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public void addPermissionsToPolicy(JakartaPermissions jakartaPermissions) {
        try {
            this.policyConfiguration.addToExcludedPolicy(jakartaPermissions.getExcluded());
            this.policyConfiguration.addToUncheckedPolicy(jakartaPermissions.getUnchecked());
            for (Map.Entry<String, Permissions> roleEntry : jakartaPermissions.getPerRole().entrySet()) {
                this.policyConfiguration.addToRole(roleEntry.getKey(), roleEntry.getValue());
            }
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public void removeStatementsFromPolicy(Set<String> declaredRoles) {
        try {
            boolean inService = this.policyConfigurationFactory.inService(this.contextId);
            PolicyConfiguration policyConfiguration = this.policyConfigurationFactory.getPolicyConfiguration(this.contextId, false);
            policyConfiguration.removeUncheckedPolicy();
            policyConfiguration.removeExcludedPolicy();
            if (declaredRoles != null) {
                for (String role : declaredRoles) {
                    policyConfiguration.removeRole(role);
                }
            }
            policyConfiguration.removeRole("*");
            policyConfiguration.removeRole("*");
            if (inService) {
                this.getPolicy().refresh();
            }
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean linkPolicy(String linkedContextId, boolean lastInService) {
        try {
            boolean inService = this.policyConfigurationFactory.inService(this.contextId);
            if (linkedContextId == null) {
                return inService;
            }
            if (inService != lastInService) {
                throw new IllegalStateException("Inconsistent Module State");
            }
            if (!inService) {
                PolicyConfiguration policyConfiguration = this.policyConfigurationFactory.getPolicyConfiguration(this.contextId, false);
                PolicyConfiguration linkedPolicyConfiguration = this.policyConfigurationFactory.getPolicyConfiguration(linkedContextId, false);
                policyConfiguration.linkConfiguration(linkedPolicyConfiguration);
            }
            return lastInService;
        }
        catch (PolicyContextException pce) {
            throw new IllegalStateException(pce.toString());
        }
    }

    public static boolean linkPolicy(String contextId, String linkedContextId, boolean lastInService) {
        try {
            PolicyConfigurationFactory factory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            boolean inService = factory.inService(contextId);
            if (linkedContextId == null) {
                return inService;
            }
            if (inService != lastInService) {
                throw new IllegalStateException("Inconsistent Module State");
            }
            if (!inService) {
                PolicyConfiguration policyConfiguration = factory.getPolicyConfiguration(contextId, false);
                PolicyConfiguration linkedPolicyConfiguration = factory.getPolicyConfiguration(linkedContextId, false);
                policyConfiguration.linkConfiguration(linkedPolicyConfiguration);
            }
            return lastInService;
        }
        catch (PolicyContextException | ClassNotFoundException pce) {
            throw new IllegalStateException(pce.toString());
        }
    }

    public void commitPolicy() {
        try {
            if (!this.policyConfigurationFactory.inService(this.contextId)) {
                this.policyConfiguration.commit();
                LOG.log(System.Logger.Level.DEBUG, "Committed policy for context: {0}", this.contextId);
            }
            this.getPolicy().refresh();
        }
        catch (PolicyContextException pce) {
            throw new IllegalStateException(pce);
        }
    }

    public static void commitPolicy(String contextId) {
        try {
            PolicyConfigurationFactory configurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            if (!configurationFactory.inService(contextId)) {
                configurationFactory.getPolicyConfiguration(contextId, false).commit();
                LOG.log(System.Logger.Level.DEBUG, "Committed policy for context: {0}", contextId);
            }
            PolicyFactory.getPolicyFactory().getPolicy().refresh();
        }
        catch (PolicyContextException | ClassNotFoundException pce) {
            throw new IllegalStateException(pce);
        }
    }

    public void refresh() {
        try {
            if (this.policyConfigurationFactory.inService(this.contextId)) {
                this.getPolicy().refresh();
            }
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public void destroy() {
        DefaultPolicyContextHandler.removeAllForContextId(this.contextId);
    }

    public PolicyConfiguration getPolicyConfiguration() {
        return this.policyConfiguration;
    }

    public boolean checkWebUserDataPermission(HttpServletRequest request) {
        return this.checkPermission(new WebUserDataPermission(request));
    }

    public boolean checkWebUserDataPermission(String uri, String httpMethod, boolean requestIsSecure) {
        String[] stringArray;
        if (httpMethod == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = httpMethod;
        }
        return this.checkPermission(new WebUserDataPermission(uri, stringArray, requestIsSecure ? "CONFIDENTIAL" : null));
    }

    public boolean checkWebUserDataPermission(String uri, String httpMethod, boolean requestIsSecure, Set<Principal> principals) {
        String[] stringArray;
        if (httpMethod == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = httpMethod;
        }
        return this.checkPermission((Permission)new WebUserDataPermission(uri, stringArray, requestIsSecure ? "CONFIDENTIAL" : null), principals);
    }

    public boolean checkPublicWebResourcePermission(HttpServletRequest request) {
        return this.checkPermission(new WebResourcePermission(this.getConstrainedURI(request), request.getMethod()));
    }

    public boolean checkWebResourcePermission(HttpServletRequest request) {
        try {
            Subject subject = (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
            return this.checkWebResourcePermission(request, subject);
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean checkWebResourcePermission(HttpServletRequest request, Subject subject) {
        return this.checkPermission((Permission)new WebResourcePermission(this.getConstrainedURI(request), request.getMethod()), subject);
    }

    public boolean checkWebResourcePermission(HttpServletRequest request, Set<Principal> principals) {
        return this.checkPermission((Permission)new WebResourcePermission(this.getConstrainedURI(request), request.getMethod()), principals);
    }

    public boolean checkWebRoleRefPermission(String servletName, String role) {
        try {
            Subject subject = (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
            return this.checkWebRoleRefPermission(servletName, role, subject);
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean checkWebRoleRefPermission(String servletName, String role, Subject subject) {
        return this.checkPermission((Permission)new WebRoleRefPermission(servletName, role), subject);
    }

    public boolean checkWebRoleRefPermission(String servletName, String role, Set<Principal> principals) {
        return this.checkPermission((Permission)new WebRoleRefPermission(servletName, role), principals);
    }

    public boolean checkBeanRoleRefPermission(String beanName, String role, Set<Principal> principals) {
        EJBRoleRefPermission ejbRoleRefPermission = new EJBRoleRefPermission(beanName, role);
        boolean isCallerInRole = this.checkPermissionScoped(ejbRoleRefPermission, principals);
        LOG.log(System.Logger.Level.DEBUG, "checkBeanRoleRefPermission result: {0} for EJBRoleRefPermission[Name = {1}, Actions = {2}]", isCallerInRole, ejbRoleRefPermission.getName(), ejbRoleRefPermission.getActions());
        return isCallerInRole;
    }

    public boolean checkBeanMethodPermission(String beanName, String methodInterface, Method method, Set<Principal> principals) {
        EJBMethodPermission methodPermission = new EJBMethodPermission(beanName, methodInterface, method);
        boolean authorized = this.checkPermissionScoped(methodPermission, principals);
        LOG.log(System.Logger.Level.DEBUG, "checkBeanMethodPermission result: {0} for EJBMethodPermission[Name = {1}, Actions = {2}]", authorized, methodPermission.getName(), methodPermission.getActions());
        return authorized;
    }

    public Object invokeBeanMethod(Object bean, Method beanClassMethod, Object[] methodParameters) throws Throwable {
        return this.runInScope(() -> beanClassMethod.invoke(bean, methodParameters));
    }

    public void deletePolicy() {
        try {
            boolean wasInService = this.policyConfigurationFactory.inService(this.contextId);
            this.policyConfigurationFactory.getPolicyConfiguration(this.contextId, false).delete();
            if (wasInService) {
                this.getPolicy().refresh();
            }
        }
        catch (PolicyContextException pce) {
            throw new IllegalStateException(pce);
        }
    }

    public static void deletePolicy(String contextId) {
        try {
            PolicyConfigurationFactory factory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            boolean wasInService = factory.inService(contextId);
            factory.getPolicyConfiguration(contextId, false).delete();
            if (wasInService) {
                PolicyFactory.getPolicyFactory().getPolicy().refresh();
            }
        }
        catch (PolicyContextException | ClassNotFoundException pce) {
            throw new IllegalStateException(pce);
        }
    }

    boolean checkPermission(Permission permissionToBeChecked) {
        LOG.log(System.Logger.Level.DEBUG, "checkPermission(permissionToBeChecked={0})", permissionToBeChecked);
        return this.getPolicy().implies(permissionToBeChecked);
    }

    boolean checkPermission(Permission permissionToBeChecked, Subject subject) {
        LOG.log(System.Logger.Level.DEBUG, "checkPermission(permissionToBeChecked={0}, subject={1})", permissionToBeChecked, subject);
        return this.getPolicy().implies(permissionToBeChecked, subject != null ? subject : new Subject());
    }

    boolean checkPermission(Permission permissionToBeChecked, Set<Principal> principals) {
        LOG.log(System.Logger.Level.DEBUG, "checkPermission(permissionToBeChecked={0}, principals={1})", permissionToBeChecked, principals);
        return this.getPolicy().implies(permissionToBeChecked, principals != null ? principals : Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkPermissionScoped(Permission permissionToBeChecked, Set<Principal> principals) {
        LOG.log(System.Logger.Level.DEBUG, "checkPermission(permissionToBeChecked={0}, principals={1})", permissionToBeChecked, principals);
        String oldContextId = null;
        try {
            oldContextId = AuthorizationService.setThreadContextId(this.contextId);
            boolean bl = this.getPolicy().implies(permissionToBeChecked, principals);
            return bl;
        }
        catch (Throwable t) {
            LOG.log(System.Logger.Level.ERROR, "Unexpected security exception", t);
        }
        finally {
            try {
                AuthorizationService.setPolicyContextChecked(oldContextId, this.contextId);
            }
            catch (Throwable ex) {
                LOG.log(System.Logger.Level.ERROR, "Unexpected exception manipulating policy context", ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runInScope(ThrowableSupplier<Object> supplier) throws Throwable {
        String oldContextId = AuthorizationService.setThreadContextId(this.contextId);
        try {
            Object object = supplier.get();
            return object;
        }
        finally {
            AuthorizationService.setPolicyContextChecked(oldContextId, this.contextId);
        }
    }

    public static PolicyConfigurationFactory installPolicyConfigurationFactory(Class<?> factoryClass) {
        if (factoryClass == null) {
            return null;
        }
        PolicyConfigurationFactory existingFactory = PolicyConfigurationFactory.get();
        if (existingFactory.getClass().equals(factoryClass)) {
            return existingFactory;
        }
        PolicyConfigurationFactory newFactory = null;
        try {
            newFactory = (PolicyConfigurationFactory)factoryClass.getDeclaredConstructor(PolicyConfigurationFactory.class).newInstance(existingFactory);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
            // empty catch block
        }
        if (newFactory == null) {
            try {
                newFactory = (PolicyConfigurationFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                throw new IllegalStateException(e);
            }
        }
        PolicyConfigurationFactory.setPolicyConfigurationFactory(newFactory);
        System.setProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider", factoryClass.getName());
        return PolicyConfigurationFactory.get();
    }

    public static PolicyFactory installPolicyFactory(Class<?> factoryClass) {
        if (factoryClass == null) {
            return null;
        }
        PolicyFactory existingFactory = PolicyFactory.getPolicyFactory();
        if (existingFactory.getClass().equals(factoryClass)) {
            return existingFactory;
        }
        PolicyFactory newFactory = null;
        try {
            newFactory = (PolicyFactory)factoryClass.getDeclaredConstructor(PolicyFactory.class).newInstance(existingFactory);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
            // empty catch block
        }
        if (newFactory == null) {
            try {
                newFactory = (PolicyFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                throw new IllegalStateException(e);
            }
        }
        PolicyFactory.setPolicyFactory(newFactory);
        System.setProperty("jakarta.security.jacc.PolicyFactory.provider", factoryClass.getName());
        return PolicyFactory.getPolicyFactory();
    }

    public static Policy installPolicy(Class<? extends Policy> policyClass) {
        if (policyClass == null) {
            return null;
        }
        try {
            PolicyFactory.getPolicyFactory().setPolicy(policyClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            return PolicyFactory.getPolicyFactory().getPolicy();
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private Policy getPolicy() {
        if (this.policy != null) {
            return this.policy;
        }
        return this.policyFactory.getPolicy(this.contextId);
    }

    private String getConstrainedURI(HttpServletRequest request) {
        String uri;
        if (this.constrainedUriRequestAttribute != null && (uri = (String)request.getAttribute(this.constrainedUriRequestAttribute)) != null) {
            return uri;
        }
        String relativeURI = this.getRequestRelativeURI(request);
        if (relativeURI.equals("/")) {
            return "";
        }
        return relativeURI.replaceAll(":", "%3A");
    }

    private PrincipalMapper getOrCreatePrincipalMapper(String contextId, Supplier<PrincipalMapper> principalMapperSupplier) {
        return this.principalMapper.computeIfAbsent(contextId, e -> (PrincipalMapper)principalMapperSupplier.get());
    }

    private PrincipalMapper getDefaultRoleMapper(String contextId) {
        return new DefaultPrincipalMapper(contextId, AuthorizationService.getAllDeclaredRoles());
    }

    private static Collection<String> getAllDeclaredRoles() {
        return PolicyConfigurationFactory.get().getPolicyConfiguration().getPerRolePermissions().keySet();
    }

    private String getRequestRelativeURI(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    public static String getServletContextId(ServletContext context) {
        return context.getVirtualServerName() + " " + context.getContextPath();
    }

    public static void setThreadContextId(ServletContext context) {
        PolicyContext.setContextID(AuthorizationService.getServletContextId(context));
    }

    public static String setThreadContextId(String contextId) {
        String oldContextId = PolicyContext.getContextID();
        AuthorizationService.setPolicyContextChecked(contextId, oldContextId);
        return oldContextId;
    }

    private static void setPolicyContextChecked(String newContextId, String oldContextId) {
        if (!(newContextId == null || oldContextId != null && oldContextId.equals(newContextId))) {
            LOG.log(System.Logger.Level.DEBUG, "Changing Policy Context ID: oldContextId = {0}, newContextId = {1}", oldContextId, newContextId);
            try {
                PolicyContext.setContextID(newContextId);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowableSupplier<T> {
        public T get() throws Throwable;
    }
}

