/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.servlet.sam;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.glassfish.epicyro.config.servlet.sam.Utils;

public class CookieHandler {
    public static void saveCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, Integer maxAge, boolean secureOnly, boolean HttpOnly) {
        Cookie cookie = new Cookie(name, value);
        if (maxAge != null) {
            cookie.setMaxAge(maxAge);
        }
        cookie.setSecure(secureOnly);
        cookie.setHttpOnly(HttpOnly);
        cookie.setPath(Utils.isEmpty(request.getContextPath()) ? "/" : request.getContextPath());
        response.addCookie(cookie);
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!name.equals(cookie.getName()) || CookieHandler.isEmpty(cookie)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        Cookie cookie = new Cookie(name, null);
        cookie.setMaxAge(0);
        cookie.setPath(Utils.isEmpty(request.getContextPath()) ? "/" : request.getContextPath());
        response.addCookie(cookie);
    }

    private static boolean isEmpty(Cookie cookie) {
        return cookie.getValue() == null || cookie.getValue().trim().isEmpty();
    }
}

