/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.helper;

import jakarta.security.auth.message.AuthException;
import java.io.IOException;
import org.glassfish.epicyro.config.factory.ConfigParser;

public class ObjectUtils {
    private static final Class<?>[] EMPTY_PARAMS = new Class[0];
    private static final Object[] EMPTY_ARGS = new Object[0];

    public static <T> T createObject(String className) {
        ClassLoader loader = ObjectUtils.getClassLoader();
        try {
            return (T)Class.forName(className, true, loader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static ConfigParser newConfigParser(String parserClassName) throws IOException {
        return ObjectUtils.newConfigParser(parserClassName, null);
    }

    public static ConfigParser newConfigParser(String parserClassName, Object config) throws IOException {
        if (parserClassName == null) {
            return null;
        }
        ConfigParser newParser = (ConfigParser)ObjectUtils.createObject(parserClassName);
        newParser.initialize(config);
        return newParser;
    }

    public static Object newAuthModule(String moduleClassName) throws AuthException {
        return ObjectUtils.newAuthModule(moduleClassName, EMPTY_PARAMS, EMPTY_ARGS);
    }

    public static Object newAuthModule(String moduleClassName, Class<?>[] parameterTypes, Object[] initargs) throws AuthException {
        try {
            return Class.forName(moduleClassName, true, ObjectUtils.getClassLoader()).getConstructor(parameterTypes).newInstance(initargs);
        }
        catch (Exception e) {
            throw new AuthException("Unable to load auth module for " + moduleClassName, e);
        }
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

