/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.ejb.containers.AbstractSingletonContainer;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.ejb.startup.EjbApplication;

public class SingletonLifeCycleManager {
    private Map<String, Set<String>> initialDependency = new HashMap<String, Set<String>>();
    private Map<String, Integer> name2Index = new HashMap<String, Integer>();
    private Map<Integer, String> index2Name = new HashMap<Integer, String>();
    private Set<String> leafNodes = new HashSet<String>();
    private int maxIndex = 0;
    private boolean[][] adj;
    private List<AbstractSingletonContainer> initializedSingletons = new ArrayList<AbstractSingletonContainer>();
    private Map<String, AbstractSingletonContainer> name2Container = new HashMap<String, AbstractSingletonContainer>();
    private boolean initializeInOrder;
    private Map<String, EjbApplication> name2EjbApp = new HashMap<String, EjbApplication>();
    private static final Logger _logger = LogDomains.getLogger(SingletonLifeCycleManager.class, "jakarta.enterprise.system.container.ejb");

    SingletonLifeCycleManager(boolean initializeInOrder) {
        this.initializeInOrder = initializeInOrder;
    }

    void addSingletonContainer(EjbApplication ejbApp, AbstractSingletonContainer c) {
        c.setSingletonLifeCycleManager(this);
        EjbSessionDescriptor sdesc = (EjbSessionDescriptor)c.getEjbDescriptor();
        String src = this.normalizeSingletonName(sdesc.getName(), sdesc);
        String[] depends = sdesc.getDependsOn();
        String[] newDepends = new String[depends.length];
        StringBuilder sb = new StringBuilder("Partial order of dependent(s). " + src + " => {");
        for (int i = 0; i < depends.length; ++i) {
            newDepends[i] = this.normalizeSingletonName(depends[i], sdesc);
            sb.append(newDepends[i] + " ");
        }
        sb.append("}");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, sb.toString());
        }
        this.addDependency(src, newDepends);
        this.name2Container.put(src, c);
        this.name2EjbApp.put(src, ejbApp);
    }

    private String normalizeSingletonName(String origName, EjbSessionDescriptor sessionDesc) {
        String normalizedName;
        boolean fullyQualified = origName.contains("#");
        Application app = sessionDesc.getEjbBundleDescriptor().getApplication();
        if (fullyQualified) {
            int indexOfHash = origName.indexOf("#");
            String ejbName = origName.substring(indexOfHash + 1);
            String relativeJarPath = origName.substring(0, indexOfHash);
            BundleDescriptor bundle2 = app.getRelativeBundle(sessionDesc.getEjbBundleDescriptor(), relativeJarPath);
            if (bundle2 == null) {
                throw new IllegalStateException("Invalid @DependOn value = " + origName + " for Singleton " + sessionDesc.getName());
            }
            normalizedName = bundle2.getModuleDescriptor().getArchiveUri() + "#" + ejbName;
        } else {
            normalizedName = sessionDesc.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri() + "#" + origName;
        }
        return normalizedName;
    }

    void doStartup(EjbApplication ejbApp) {
        Set<EjbDescriptor> ejbs = ejbApp.getEjbBundleDescriptor().getEjbs();
        for (EjbDescriptor desc : ejbs) {
            EjbSessionDescriptor sdesc;
            if (!(desc instanceof EjbSessionDescriptor) || !(sdesc = (EjbSessionDescriptor)desc).isSingleton() || !sdesc.getInitOnStartup()) continue;
            String normalizedSingletonName = this.normalizeSingletonName(sdesc.getName(), sdesc);
            this.initializeSingleton(this.name2Container.get(normalizedSingletonName));
        }
    }

    void doShutdown() {
        Collections.reverse(this.initializedSingletons);
        for (AbstractSingletonContainer singletonContainer : this.initializedSingletons) {
            singletonContainer.onShutdown();
        }
    }

    public synchronized void initializeSingleton(AbstractSingletonContainer c) {
        this.initializeSingleton(c, new ArrayList<String>());
    }

    private void initializeSingleton(AbstractSingletonContainer c, List<String> initList) {
        if (!this.initializedSingletons.contains(c)) {
            String normalizedSingletonName = this.normalizeSingletonName(c.getEjbDescriptor().getName(), (EjbSessionDescriptor)c.getEjbDescriptor());
            List<String> computedDeps = this.computeDependencies(normalizedSingletonName);
            int sz = computedDeps.size();
            AbstractSingletonContainer[] deps = new AbstractSingletonContainer[sz];
            initList.add(normalizedSingletonName);
            for (int i = 0; i < sz; ++i) {
                EjbApplication ejbApp;
                String nextSingletonName = computedDeps.get(i);
                deps[i] = this.name2Container.get(nextSingletonName);
                if (this.initializeInOrder && !(ejbApp = this.name2EjbApp.get(nextSingletonName)).isStarted()) {
                    String msg = "application.xml specifies module initialization ordering but " + initList.get(0) + " depends on " + nextSingletonName + " which is in a module that hasn't been started yet";
                    if (_logger.isLoggable(Level.WARNING)) {
                        StringBuilder sb = new StringBuilder(initList.get(0));
                        for (int k = 1; k < initList.size(); ++k) {
                            sb.append(" -> ").append(initList.get(k));
                        }
                        sb.append(" -> ").append(nextSingletonName);
                        _logger.log(Level.WARNING, "Partial order of singleton beans involved in this: " + sb.toString());
                    }
                    throw new RuntimeException(msg);
                }
                this.initializeSingleton(deps[i], initList);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SingletonLifeCycleManager: initializingSingleton: " + normalizedSingletonName);
            }
            c.instantiateSingletonInstance();
            this.initializedSingletons.add(c);
        }
    }

    private void addDependency(String src, String[] depends) {
        if (depends != null && depends.length > 0) {
            for (String s : depends) {
                this.addDependency(src, s);
            }
        } else {
            this.addDependency(src, "");
        }
    }

    private void addDependency(String src, String depends) {
        src = src.trim();
        Set<String> deps = this.getExistingDependecyList(src);
        if (depends != null) {
            StringTokenizer tok = new StringTokenizer(depends, " ,");
            while (tok.hasMoreTokens()) {
                String dep = tok.nextToken();
                deps.add(dep);
                this.getExistingDependecyList(dep);
            }
        }
    }

    private List<String> computeDependencies(String root) {
        if (this.adj == null) {
            this.fillAdjacencyMatrix();
        }
        Stack<String> stk = new Stack<String>();
        stk.push(root);
        ArrayList<String> dependencies = new ArrayList<String>();
        do {
            String top = (String)stk.peek();
            int topIndex = this.name2Index.get(top);
            boolean hasDep = false;
            for (int j = 0; j < this.maxIndex; ++j) {
                if (!this.adj[topIndex][j]) continue;
                String name = this.index2Name.get(j);
                if (stk.contains(name)) {
                    String str = "Cyclic dependency: " + top + " => " + name + "? ";
                    throw new IllegalArgumentException(str + this.getCyclicString(this.adj));
                }
                if (dependencies.contains(name)) continue;
                if (this.leafNodes.contains(name)) {
                    dependencies.add(name);
                    continue;
                }
                hasDep = true;
                stk.push(name);
            }
            if (hasDep) continue;
            stk.pop();
            if (dependencies.contains(top)) continue;
            dependencies.add(top);
        } while (!stk.empty());
        dependencies.remove(dependencies.size() - 1);
        return dependencies;
    }

    private Set<String> getExistingDependecyList(String src) {
        Set<String> existingDeps = this.initialDependency.get(src);
        if (existingDeps == null) {
            existingDeps = new HashSet<String>();
            this.initialDependency.put(src, existingDeps);
            this.name2Index.put(src, this.maxIndex);
            this.index2Name.put(this.maxIndex, src);
            ++this.maxIndex;
        }
        return existingDeps;
    }

    private void fillAdjacencyMatrix() {
        this.adj = new boolean[this.maxIndex][this.maxIndex];
        for (int i = 0; i < this.maxIndex; ++i) {
            String src = this.index2Name.get(i);
            for (int j = 0; j < this.maxIndex; ++j) {
                this.adj[i][j] = false;
            }
            boolean isLeaf = true;
            Set<String> deps = this.initialDependency.get(src);
            for (String d : deps) {
                int k = this.name2Index.get(d);
                this.adj[i][k] = true;
                isLeaf = false;
            }
            if (!isLeaf) continue;
            this.leafNodes.add(src);
        }
    }

    private String getCyclicString(boolean[][] a) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.maxIndex; ++i) {
            StringBuilder sb2 = new StringBuilder("");
            String delim = "";
            for (int j = 0; j < this.maxIndex; ++j) {
                if (!a[i][j]) continue;
                sb2.append(delim).append(this.index2Name.get(j));
                delim = ", ";
            }
            String dep = sb2.toString();
            if (dep.length() <= 0) continue;
            sb.append(" ").append(this.index2Name.get(i)).append(" => ").append(sb2.toString()).append("; ");
        }
        return sb.toString();
    }
}

