/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.security.application;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.logging.LogDomains;
import jakarta.security.jacc.EJBMethodPermission;
import jakarta.security.jacc.PolicyContextException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.security.application.EJBSecurityManager;
import org.glassfish.exousia.mapping.SecurityRoleRef;
import org.glassfish.exousia.permissions.JakartaPermissions;

public class GlassFishToExousiaConverter {
    private static final Logger _logger = LogDomains.getLogger(EJBSecurityManager.class, "jakarta.enterprise.system.container.ejb");

    public static JakartaPermissions convertEJBMethodPermissions(EjbDescriptor ejbDescriptor, String contextId) throws PolicyContextException {
        JakartaPermissions jakartaPermissions = new JakartaPermissions();
        String ejbName = ejbDescriptor.getName();
        Map methodPermissionsFromDD = ejbDescriptor.getMethodPermissionsFromDD();
        for (Map.Entry methodPermissionFromDD : methodPermissionsFromDD.entrySet()) {
            MethodPermission methodPermission = (MethodPermission)methodPermissionFromDD.getKey();
            for (MethodDescriptor methodDescriptor : (ArrayList)methodPermissionFromDD.getValue()) {
                String methodName = methodDescriptor.getName();
                String methodInterface = methodDescriptor.getEjbClassSymbol();
                String[] methodParameters = methodDescriptor.getStyle() == 3 ? methodDescriptor.getParameterClassNames() : null;
                EJBMethodPermission ejbMethodPermission = new EJBMethodPermission(ejbName, methodName.equals("*") ? null : methodName, methodInterface, methodParameters);
                if (methodPermission.isExcluded()) {
                    jakartaPermissions.getExcluded().add(ejbMethodPermission);
                    continue;
                }
                if (methodPermission.isUnchecked()) {
                    jakartaPermissions.getUnchecked().add(ejbMethodPermission);
                    continue;
                }
                if (!methodPermission.isRoleBased()) continue;
                jakartaPermissions.getPerRole().computeIfAbsent(methodPermission.getRole().getName(), e -> new Permissions()).add(ejbMethodPermission);
            }
        }
        for (MethodDescriptor methodDescriptor : ejbDescriptor.getMethodDescriptors()) {
            Method methodName = methodDescriptor.getMethod(ejbDescriptor);
            String methodInterface = methodDescriptor.getEjbClassSymbol();
            if (methodName == null) continue;
            if (methodInterface == null || methodInterface.isEmpty()) {
                _logger.log(Level.SEVERE, "method_descriptor_not_defined", new Object[]{ejbName, methodDescriptor.getName(), methodDescriptor.getParameterClassNames()});
                continue;
            }
            EJBMethodPermission ejbMethodPermission = new EJBMethodPermission(ejbName, methodInterface, methodName);
            Set<MethodPermission> methodPermissions = ejbDescriptor.getMethodPermissionsFor(methodDescriptor);
            _logger.log(Level.FINEST, "Descriptor: {0}, permissions: {1}", new Object[]{methodDescriptor, methodPermissions});
            for (MethodPermission methodPermission : methodPermissions) {
                if (methodPermission.isExcluded()) {
                    jakartaPermissions.getExcluded().add(ejbMethodPermission);
                    continue;
                }
                if (methodPermission.isUnchecked()) {
                    jakartaPermissions.getUnchecked().add(ejbMethodPermission);
                    continue;
                }
                if (!methodPermission.isRoleBased()) continue;
                jakartaPermissions.getPerRole().computeIfAbsent(methodPermission.getRole().getName(), e -> new Permissions()).add(ejbMethodPermission);
            }
        }
        return jakartaPermissions;
    }

    public static Map<String, List<SecurityRoleRef>> getSecurityRoleRefsFromBundle(EjbDescriptor ejbDescriptor) {
        HashMap<String, List<SecurityRoleRef>> exousiaRoleRefsPerEnterpriseBean = new HashMap<String, List<SecurityRoleRef>>();
        ArrayList<SecurityRoleRef> exousiaSecurityRoleRefs = new ArrayList<SecurityRoleRef>();
        for (RoleReference glassFishSecurityRoleRef : ejbDescriptor.getRoleReferences()) {
            exousiaSecurityRoleRefs.add(new SecurityRoleRef(glassFishSecurityRoleRef.getRoleName(), glassFishSecurityRoleRef.getSecurityRoleLink().getName()));
        }
        exousiaRoleRefsPerEnterpriseBean.put(ejbDescriptor.getName(), exousiaSecurityRoleRefs);
        return exousiaRoleRefsPerEnterpriseBean;
    }

    private static void log(JakartaPermissions jakartaPermissions) {
        for (Permission permission : Collections.list(jakartaPermissions.getExcluded().elements())) {
            _logger.log(Level.FINE, () -> "Jakarta Authorization DD conversion: EJBMethodPermission ->(" + ejbMethodPermission.getName() + " " + ejbMethodPermission.getActions() + ") is (excluded)");
        }
        for (Permission permission : Collections.list(jakartaPermissions.getUnchecked().elements())) {
            _logger.log(Level.FINE, () -> "Jakarta Authorization conversion: EJBMethodPermission ->(" + ejbMethodPermission.getName() + " " + ejbMethodPermission.getActions() + ") is (unchecked)");
        }
        for (Map.Entry entry : jakartaPermissions.getPerRole().entrySet()) {
            String role = (String)entry.getKey();
            for (Permission ejbMethodPermission : Collections.list(((Permissions)entry.getValue()).elements())) {
                _logger.log(Level.FINE, () -> "Jakarta Authorization conversion: EJBMethodPermission ->(" + ejbMethodPermission.getName() + " " + ejbMethodPermission.getActions() + ")protected by role -> " + role);
            }
        }
    }
}

