/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.descriptor;

import com.sun.enterprise.container.common.spi.CDIService;
import com.sun.enterprise.deployment.EjbBeanDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.InterceptorDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.DescriptorVisitor;
import org.glassfish.ejb.deployment.BeanMethodCalculatorImpl;
import org.glassfish.ejb.deployment.descriptor.ContainerTransaction;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.IASEjbExtraDescriptors;
import org.glassfish.ejb.deployment.util.EjbVisitor;
import org.glassfish.ejb.deployment.util.InterceptorBindingTranslator;
import org.glassfish.internal.api.Globals;

public abstract class EjbDescriptor
extends EjbBeanDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = DOLUtils.getDefaultLogger();
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(EjbDescriptor.class);
    private final Set<String> noInterfaceLocalBeanClassNames = new HashSet<String>();
    private final Set<LifecycleCallbackDescriptor> aroundInvokeDescs = new HashSet<LifecycleCallbackDescriptor>();
    private final Set<LifecycleCallbackDescriptor> aroundTimeoutDescs = new HashSet<LifecycleCallbackDescriptor>();
    private final List<InterceptorDescriptor> frameworkInterceptors = new LinkedList<InterceptorDescriptor>();
    private final IASEjbExtraDescriptors iASEjbExtraDescriptors = new IASEjbExtraDescriptors();
    private EjbBundleDescriptorImpl bundleDescriptor;
    private boolean usesDefaultTransaction;
    private String ejbObjectImplClassName;
    private String ejbLocalObjectImplClassName;
    private String localHomeImplClassName;
    private String remoteHomeImplClassName;
    private String securityIdentityDescription;
    private Hashtable<MethodDescriptor, ContainerTransaction> methodContainerTransactions = new Hashtable();

    protected EjbDescriptor() {
    }

    public EjbDescriptor(EjbDescriptor other) {
        super(other);
        this.copyEjbDescriptor(other);
    }

    public abstract String getContainerFactoryQualifier();

    public IASEjbExtraDescriptors getIASEjbExtraDescriptors() {
        return this.iASEjbExtraDescriptors;
    }

    public void copyEjbDescriptor(EjbDescriptor other) {
        this.bundleDescriptor = other.bundleDescriptor;
        EjbDescriptor.copyEjbDescriptor(other, this);
        this.methodContainerTransactions = new Hashtable<MethodDescriptor, ContainerTransaction>(other.methodContainerTransactions);
    }

    @Override
    public final EjbBundleDescriptorImpl getEjbBundleDescriptor() {
        return this.bundleDescriptor;
    }

    @Override
    public void setEjbBundleDescriptor(EjbBundleDescriptor bundleDescriptor) {
        this.bundleDescriptor = (EjbBundleDescriptorImpl)bundleDescriptor;
    }

    public String getEJBLocalObjectImplClassName() {
        return this.ejbLocalObjectImplClassName;
    }

    public void setEJBLocalObjectImplClassName(String className) {
        this.ejbLocalObjectImplClassName = className;
    }

    public String getEJBObjectImplClassName() {
        return this.ejbObjectImplClassName;
    }

    public void setEJBObjectImplClassName(String className) {
        this.ejbObjectImplClassName = className;
    }

    public String getLocalHomeImplClassName() {
        return this.localHomeImplClassName;
    }

    public void setLocalHomeImplClassName(String className) {
        this.localHomeImplClassName = className;
    }

    public String getRemoteHomeImplClassName() {
        return this.remoteHomeImplClassName;
    }

    public void setRemoteHomeImplClassName(String className) {
        this.remoteHomeImplClassName = className;
    }

    public Set<String> getNoInterfaceLocalBeanClasses() {
        return this.noInterfaceLocalBeanClassNames;
    }

    public void addNoInterfaceLocalBeanClass(String className) {
        this.noInterfaceLocalBeanClassNames.add(className);
    }

    public boolean hasAroundInvokeMethod() {
        return !this.aroundInvokeDescs.isEmpty();
    }

    public final Set<LifecycleCallbackDescriptor> getAroundInvokeDescriptors() {
        return this.aroundInvokeDescs;
    }

    public LifecycleCallbackDescriptor getAroundInvokeDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor aroundInvoke : this.aroundInvokeDescs) {
            if (!aroundInvoke.getLifecycleCallbackClass().equals(className)) continue;
            return aroundInvoke;
        }
        return null;
    }

    public List<EjbInterceptor> getAroundInvokeInterceptors(MethodDescriptor businessMethod) {
        LinkedList<EjbInterceptor> aroundInvokeInterceptors = new LinkedList<EjbInterceptor>();
        List<EjbInterceptor> classOrMethodInterceptors = this.getClassOrMethodInterceptors(businessMethod);
        for (EjbInterceptor interceptor : classOrMethodInterceptors) {
            if (interceptor.getAroundInvokeDescriptors().isEmpty()) continue;
            aroundInvokeInterceptors.add(interceptor);
        }
        if (this.hasAroundInvokeMethod()) {
            EjbInterceptor interceptorInfo = new EjbInterceptor();
            interceptorInfo.setFromBeanClass(true);
            interceptorInfo.addAroundInvokeDescriptors(this.aroundInvokeDescs);
            interceptorInfo.setInterceptorClassName(this.getEjbImplClassName());
            aroundInvokeInterceptors.add(interceptorInfo);
        }
        return aroundInvokeInterceptors;
    }

    public void addAroundInvokeDescriptor(LifecycleCallbackDescriptor aroundInvokeDesc) {
        String className = aroundInvokeDesc.getLifecycleCallbackClass();
        for (LifecycleCallbackDescriptor aroundInvoke : this.aroundInvokeDescs) {
            if (!aroundInvoke.getLifecycleCallbackClass().equals(className)) continue;
            return;
        }
        this.aroundInvokeDescs.add(aroundInvokeDesc);
    }

    public boolean hasAroundTimeoutMethod() {
        return !this.aroundTimeoutDescs.isEmpty();
    }

    public final Set<LifecycleCallbackDescriptor> getAroundTimeoutDescriptors() {
        return this.aroundTimeoutDescs;
    }

    public LifecycleCallbackDescriptor getAroundTimeoutDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor callback : this.aroundTimeoutDescs) {
            if (!callback.getLifecycleCallbackClass().equals(className)) continue;
            return callback;
        }
        return null;
    }

    public List<EjbInterceptor> getAroundTimeoutInterceptors(MethodDescriptor businessMethod) {
        LinkedList<EjbInterceptor> aroundTimeoutInterceptors = new LinkedList<EjbInterceptor>();
        List<EjbInterceptor> classOrMethodInterceptors = this.getClassOrMethodInterceptors(businessMethod);
        for (EjbInterceptor interceptor : classOrMethodInterceptors) {
            if (interceptor.getAroundTimeoutDescriptors().isEmpty()) continue;
            aroundTimeoutInterceptors.add(interceptor);
        }
        if (this.hasAroundTimeoutMethod()) {
            EjbInterceptor interceptorInfo = new EjbInterceptor();
            interceptorInfo.setFromBeanClass(true);
            interceptorInfo.addAroundTimeoutDescriptors(this.aroundTimeoutDescs);
            interceptorInfo.setInterceptorClassName(this.getEjbImplClassName());
            aroundTimeoutInterceptors.add(interceptorInfo);
        }
        return aroundTimeoutInterceptors;
    }

    public void addAroundTimeoutDescriptor(LifecycleCallbackDescriptor aroundTimeoutDesc) {
        String className = aroundTimeoutDesc.getLifecycleCallbackClass();
        for (LifecycleCallbackDescriptor callback : this.aroundTimeoutDescs) {
            if (!callback.getLifecycleCallbackClass().equals(className)) continue;
            return;
        }
        this.aroundTimeoutDescs.add(aroundTimeoutDesc);
    }

    public List<InterceptorDescriptor> getFrameworkInterceptors() {
        return this.frameworkInterceptors;
    }

    @Override
    public void addFrameworkInterceptor(InterceptorDescriptor interceptor) {
        for (InterceptorDescriptor existing : this.frameworkInterceptors) {
            if (!existing.getInterceptorClassName().equals(interceptor.getInterceptorClassName())) continue;
            return;
        }
        this.frameworkInterceptors.add(interceptor);
    }

    public String getSecurityIdentityDescription() {
        if (this.securityIdentityDescription == null) {
            this.securityIdentityDescription = "";
        }
        return this.securityIdentityDescription;
    }

    public void setSecurityIdentityDescription(String securityIdentityDescription) {
        this.securityIdentityDescription = securityIdentityDescription;
    }

    public void setUsesDefaultTransaction() {
        this.usesDefaultTransaction = true;
    }

    public void applyDefaultClassToLifecycleMethods() {
        Set<LifecycleCallbackDescriptor> lifecycleMethods = this.getLifecycleCallbackDescriptors();
        lifecycleMethods.addAll(this.aroundInvokeDescs);
        lifecycleMethods.addAll(this.aroundTimeoutDescs);
        for (LifecycleCallbackDescriptor method : lifecycleMethods) {
            if (method.getLifecycleCallbackClass() != null) continue;
            method.setLifecycleCallbackClass(this.getEjbClassName());
        }
    }

    public Set<LifecycleCallbackDescriptor> getLifecycleCallbackDescriptors() {
        HashSet<LifecycleCallbackDescriptor> lifecycleMethods = new HashSet<LifecycleCallbackDescriptor>();
        lifecycleMethods.addAll(this.getPostConstructDescriptors());
        lifecycleMethods.addAll(this.getPreDestroyDescriptors());
        if ("Session".equals(this.getType())) {
            EjbSessionDescriptor sfulDesc = (EjbSessionDescriptor)this;
            lifecycleMethods.addAll(sfulDesc.getPrePassivateDescriptors());
            lifecycleMethods.addAll(sfulDesc.getPostActivateDescriptors());
        }
        return lifecycleMethods;
    }

    public void applyInterceptors(InterceptorBindingTranslator bindingTranslator) {
        InterceptorBindingTranslator.TranslationResults results = bindingTranslator.apply(this.getName());
        this.setInterceptorClasses(results.allInterceptorClasses);
        this.setInterceptorChain(results.classInterceptorChain);
        this.setMethodInterceptorsMap(results.methodInterceptorsMap);
        for (EjbInterceptor interceptor : results.allInterceptorClasses) {
            for (EjbReferenceDescriptor ejbRefObj : interceptor.getEjbReferenceDescriptors()) {
                this.addEjbReferenceDescriptor(ejbRefObj);
            }
            for (MessageDestinationReferenceDescriptor msgDestRefObj : interceptor.getMessageDestinationReferenceDescriptors()) {
                this.addMessageDestinationReferenceDescriptor(msgDestRefObj);
            }
            for (EnvironmentProperty envPropObj : interceptor.getEnvironmentProperties()) {
                this.addOrMergeEnvironmentProperty(envPropObj);
            }
            for (ServiceReferenceDescriptor servRefObj : interceptor.getServiceReferenceDescriptors()) {
                this.addServiceReferenceDescriptor(servRefObj);
            }
            for (ResourceReferenceDescriptor resRefObj : interceptor.getResourceReferenceDescriptors()) {
                this.addResourceReferenceDescriptor(resRefObj);
            }
            for (ResourceEnvReferenceDescriptor resourceEnvRefObj : interceptor.getResourceEnvReferenceDescriptors()) {
                this.addResourceEnvReferenceDescriptor(resourceEnvRefObj);
            }
            for (EntityManagerFactoryReferenceDescriptor entMgrFacRef : interceptor.getEntityManagerFactoryReferenceDescriptors()) {
                this.addEntityManagerFactoryReferenceDescriptor(entMgrFacRef);
            }
            for (EntityManagerReferenceDescriptor entMgrRef : interceptor.getEntityManagerReferenceDescriptors()) {
                this.addEntityManagerReferenceDescriptor(entMgrRef);
            }
        }
    }

    public List<EjbInterceptor> getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType type2) {
        Set<LifecycleCallbackDescriptor> callbackDescriptors = null;
        switch (type2) {
            case AROUND_CONSTRUCT: {
                break;
            }
            case POST_CONSTRUCT: {
                callbackDescriptors = this.getPostConstructDescriptors();
                break;
            }
            case PRE_DESTROY: {
                callbackDescriptors = this.getPreDestroyDescriptors();
                break;
            }
            case PRE_PASSIVATE: {
                callbackDescriptors = ((EjbSessionDescriptor)this).getPrePassivateDescriptors();
                break;
            }
            case POST_ACTIVATE: {
                callbackDescriptors = ((EjbSessionDescriptor)this).getPostActivateDescriptors();
                break;
            }
            default: {
                throw new IllegalStateException(I18N.getLocalString("enterprise.deployment.invalidcallbacktype", "Invalid callback type: [{0}]", new Object[]{type2}));
            }
        }
        return this.getCallbackInterceptors(type2, callbackDescriptors);
    }

    private LinkedList<EjbInterceptor> getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType type2, Set<LifecycleCallbackDescriptor> callbackDescriptors) {
        LinkedList<EjbInterceptor> callbackInterceptors = new LinkedList<EjbInterceptor>();
        ClassLoader classLoader = this.getEjbBundleDescriptor().getClassLoader();
        List<EjbInterceptor> classOrMethodInterceptors = type2.equals((Object)LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT) ? this.getConstructorInterceptors(classLoader) : this.getInterceptorChain();
        for (EjbInterceptor interceptor : classOrMethodInterceptors) {
            if (interceptor.getCallbackDescriptors(type2).isEmpty()) continue;
            callbackInterceptors.add(interceptor);
        }
        if (callbackDescriptors != null && !callbackDescriptors.isEmpty()) {
            EjbInterceptor beanClassCallbackInfo = new EjbInterceptor();
            beanClassCallbackInfo.setFromBeanClass(true);
            beanClassCallbackInfo.addCallbackDescriptors(type2, callbackDescriptors);
            beanClassCallbackInfo.setInterceptorClassName(this.getEjbImplClassName());
            callbackInterceptors.add(beanClassCallbackInfo);
        }
        return callbackInterceptors;
    }

    private List<EjbInterceptor> getConstructorInterceptors(ClassLoader classLoader) {
        String ejbClassName = this.getEjbClassName();
        int i = ejbClassName.lastIndexOf(46);
        String shortClassName = i > -1 ? ejbClassName.substring(i + 1) : ejbClassName;
        List<EjbInterceptor> callbackInterceptors = null;
        CDIService cdiService = Globals.getStaticBaseServiceLocator().getService(CDIService.class, new Annotation[0]);
        if (cdiService != null && cdiService.isCDIEnabled(this.getEjbBundleDescriptor())) {
            try {
                Class<?> beanClass = classLoader.loadClass(ejbClassName);
                Constructor<?>[] ctors = beanClass.getDeclaredConstructors();
                String[] parameterClassNames = null;
                MethodDescriptor dummy2 = new MethodDescriptor();
                for (Constructor<?> ctor : ctors) {
                    if (ctor.getAnnotation(Inject.class) == null) continue;
                    Class[] ctorParamTypes = ctor.getParameterTypes();
                    parameterClassNames = dummy2.getParameterClassNamesFor(null, ctorParamTypes);
                    callbackInterceptors = this.getClassOrMethodInterceptors(new MethodDescriptor(shortClassName, null, parameterClassNames, "Bean"));
                    break;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(ejbClassName, t);
            }
        }
        if (callbackInterceptors == null) {
            callbackInterceptors = this.getClassOrMethodInterceptors(new MethodDescriptor(shortClassName, null, new String[0], "Bean"));
        }
        return callbackInterceptors;
    }

    private List<EjbInterceptor> getClassOrMethodInterceptors(MethodDescriptor businessMethod) {
        List<EjbInterceptor> classOrMethodInterceptors = null;
        for (Map.Entry<MethodDescriptor, List<EjbInterceptor>> entry : this.getMethodInterceptorsMap().entrySet()) {
            MethodDescriptor methodDesc = entry.getKey();
            if (!methodDesc.implies(businessMethod)) continue;
            classOrMethodInterceptors = entry.getValue();
        }
        if (classOrMethodInterceptors == null) {
            return this.getInterceptorChain();
        }
        return classOrMethodInterceptors;
    }

    public final Hashtable<MethodDescriptor, ContainerTransaction> getMethodContainerTransactions() {
        return this.methodContainerTransactions;
    }

    public void setMethodContainerTransactions(Hashtable<MethodDescriptor, ContainerTransaction> methodContainerTransactions) throws IllegalArgumentException {
        if (methodContainerTransactions != null) {
            for (Map.Entry<MethodDescriptor, ContainerTransaction> entry : methodContainerTransactions.entrySet()) {
                this.setContainerTransactionFor(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setContainerTransactionFor(MethodDescriptor methodDescriptor, ContainerTransaction containerTx) throws IllegalArgumentException {
        ContainerTransaction oldValue = this.getContainerTransactionFor(methodDescriptor);
        if (oldValue != null && oldValue.equals(containerTx)) {
            return;
        }
        String txType = this.getTransactionType();
        if (txType == null) {
            this.setTransactionType("Container");
        } else if ("Bean".equals(txType)) {
            throw new IllegalArgumentException(I18N.getLocalString("enterprise.deployment.exceptiontxattrbtnotspecifiedinbeanwithtxtype", "Method level transaction attributes may not be specified on a bean with transaction type {0}", "Bean"));
        }
        this.methodContainerTransactions.put(methodDescriptor, containerTx);
    }

    public ContainerTransaction getContainerTransactionFor(MethodDescriptor methodDescriptor) {
        ContainerTransaction containerTransaction;
        if (this.needToConvertMethodContainerTransactions()) {
            this.methodContainerTransactions = this.convertMethodContainerTransactions();
        }
        if ((containerTransaction = this.getMethodContainerTransactions().get(methodDescriptor)) != null) {
            return containerTransaction;
        }
        if (Descriptor.isBoundsChecking() && this.usesDefaultTransaction) {
            containerTransaction = new ContainerTransaction("Required", "");
            this.getMethodContainerTransactions().put(methodDescriptor, containerTransaction);
        }
        return containerTransaction;
    }

    private boolean needToConvertMethodContainerTransactions() {
        if (this.getEjbBundleDescriptor() != null) {
            for (MethodDescriptor method : this.getMethodContainerTransactions().keySet()) {
                if (method.isExact()) continue;
                return true;
            }
        }
        return false;
    }

    private Hashtable<MethodDescriptor, ContainerTransaction> convertMethodContainerTransactions() {
        Hashtable<MethodDescriptor, ContainerTransaction> convertedTransactions = new Hashtable<MethodDescriptor, ContainerTransaction>();
        this.convertMethodContainerTransactionsOfStyle(1, convertedTransactions);
        this.convertMethodContainerTransactionsOfStyle(2, convertedTransactions);
        this.convertMethodContainerTransactionsOfStyle(3, convertedTransactions);
        return convertedTransactions;
    }

    private void convertMethodContainerTransactionsOfStyle(int requestedStyleForConversion, Hashtable<MethodDescriptor, ContainerTransaction> convertedMethods) {
        Collection<MethodDescriptor> transactionMethods = this.getTransactionMethodDescriptors();
        for (Map.Entry<MethodDescriptor, ContainerTransaction> entry : this.methodContainerTransactions.entrySet()) {
            MethodDescriptor method = entry.getKey();
            if (method.getStyle() != requestedStyleForConversion) continue;
            for (MethodDescriptor next : method.doStyleConversion(this, transactionMethods)) {
                convertedMethods.put(next, new ContainerTransaction(entry.getValue()));
            }
        }
    }

    private void addOrMergeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        try {
            EnvironmentProperty existing = this.getEnvironmentPropertyByName(environmentProperty.getName());
            for (InjectionTarget next : environmentProperty.getInjectionTargets()) {
                existing.addInjectionTarget(next);
            }
        }
        catch (IllegalArgumentException e) {
            this.addEnvironmentProperty(environmentProperty);
        }
    }

    public Collection<MethodDescriptor> getTransactionMethodDescriptors() {
        return this.getTransactionMethods(this.getEjbBundleDescriptor().getClassLoader());
    }

    protected Collection<MethodDescriptor> getTransactionMethods(ClassLoader classLoader) {
        try {
            BeanMethodCalculatorImpl bmc = new BeanMethodCalculatorImpl();
            return bmc.getTransactionalMethodsFor(this, classLoader);
        }
        catch (Exception e) {
            throw new IllegalStateException(this.getEjbClassName(), e);
        }
    }

    public List<Method> getMethods() {
        return this.getMethods(this.getEjbBundleDescriptor().getClassLoader());
    }

    private List<Method> getMethods(ClassLoader classLoader) {
        try {
            BeanMethodCalculatorImpl bmc = new BeanMethodCalculatorImpl();
            return bmc.getMethodsFor(this, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(this.getEjbClassName(), e);
        }
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n methodContainerTransactions ").append(this.getMethodContainerTransactions());
        Iterator<MethodPermission> iterator = this.getPermissionedMethodsByPermission().keySet().iterator();
        while (iterator.hasNext()) {
            MethodPermission element;
            MethodPermission nextPermission = element = iterator.next();
            toStringBuffer.append("\n method-permission->method: ");
            nextPermission.print(toStringBuffer);
            toStringBuffer.append(" -> ").append(this.getPermissionedMethodsByPermission().get(nextPermission));
        }
    }

    @Override
    public final void visit(DescriptorVisitor aVisitor) {
        LOG.log(Level.CONFIG, "visit(aVisitor={0})", aVisitor);
        if (aVisitor instanceof EjbVisitor) {
            EjbVisitor visitor = (EjbVisitor)aVisitor;
            visitor.accept(this);
        } else {
            super.visit(aVisitor);
        }
    }
}

