/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.descriptor;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.stream.Collectors;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.deployment.BeanMethodCalculatorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.FieldDescriptor;
import org.glassfish.ejb.deployment.descriptor.PersistenceDescriptor;

public class EjbCMPEntityDescriptor
extends EjbEntityDescriptor {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_ACCESS_METHOD_PREFIX = "get";
    public static final int UNDEFINED = -1;
    public static final int CMP_1_1 = 1;
    public static final int CMP_2_x = 2;
    private int cmpVersion = -1;
    private PersistenceDescriptor pers;
    private String abstractSchemaName;
    private FieldDescriptor primaryKeyFieldDesc;
    private String stateImplClassName;
    private String ejbImplementationImplClassName;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbCMPEntityDescriptor.class);

    public EjbCMPEntityDescriptor() {
        this.setPersistenceType("Container");
    }

    public EjbCMPEntityDescriptor(EjbDescriptor other) {
        super(other);
        this.setPersistenceType("Container");
        if (other instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor entity = (EjbCMPEntityDescriptor)other;
            this.pers = entity.pers;
            this.cmpVersion = entity.cmpVersion;
            this.abstractSchemaName = entity.abstractSchemaName;
        }
    }

    public void setStateImplClassName(String name) {
        this.stateImplClassName = name;
    }

    public String getStateImplClassName() {
        return this.stateImplClassName;
    }

    private List<Field> getFields() {
        if (this.isEJB20()) {
            return Collections.emptyList();
        }
        Class<?> ejb = null;
        try {
            ClassLoader cl = this.getEjbBundleDescriptor().getClassLoader();
            ejb = cl.loadClass(this.getEjbClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class could not be loaded: " + this.getEjbClassName(), e);
        }
        return Arrays.asList(ejb.getFields());
    }

    public List<FieldDescriptor> getFieldDescriptors() {
        if (this.isEJB20()) {
            try {
                ClassLoader cl = this.getEjbBundleDescriptor().getClassLoader();
                BeanMethodCalculatorImpl bmc = new BeanMethodCalculatorImpl();
                return bmc.getPossibleCmpCmrFields(cl, this.getEjbClassName());
            }
            catch (Exception e) {
                throw new IllegalStateException("Class could not be loaded: " + this.getEjbClassName(), e);
            }
        }
        return this.getFields().stream().map(FieldDescriptor::new).collect(Collectors.toList());
    }

    public int getCMPVersion() {
        if (this.cmpVersion == -1) {
            String bundleVersion;
            this.cmpVersion = this.getEjbBundleDescriptor() != null ? ((bundleVersion = this.getEjbBundleDescriptor().getSpecVersion()).startsWith("1.") ? 1 : 2) : 2;
        }
        return this.cmpVersion;
    }

    public void setCMPVersion(int version) {
        if (version != 1 && version != 2) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.invalidcmpversion", "Invalid CMP version: {0}.", version));
        }
        this.cmpVersion = version;
    }

    public boolean isEJB20() {
        return this.getCMPVersion() == 2;
    }

    public void setPersistenceDescriptor(PersistenceDescriptor pd) {
        this.pers = pd;
        pd.setParentDescriptor(this);
    }

    public PersistenceDescriptor getPersistenceDescriptor() {
        if (this.pers == null) {
            this.pers = new PersistenceDescriptor();
            this.setPersistenceDescriptor(this.pers);
        }
        return this.pers;
    }

    private void invalidatePersistenceInfo() {
        if (this.pers != null) {
            this.pers.invalidate();
        }
    }

    public void setPrimaryKeyFieldDesc(FieldDescriptor pkf) {
        this.primaryKeyFieldDesc = pkf;
        this.invalidatePersistenceInfo();
    }

    public FieldDescriptor getPrimaryKeyFieldDesc() {
        return this.primaryKeyFieldDesc;
    }

    public void setAbstractSchemaName(String abstractSchemaName) {
        this.abstractSchemaName = abstractSchemaName;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public void setEjbImplementationImplClassName(String className) {
        this.ejbImplementationImplClassName = className;
    }

    public String getEjbImplementationImplClassName() {
        return this.ejbImplementationImplClassName;
    }

    public static Vector<FieldDescriptor> getPossibleCmpCmrFields(ClassLoader cl, String className) throws Exception {
        Method[] methods;
        Vector<FieldDescriptor> fieldDescriptors = new Vector<FieldDescriptor>();
        Class<?> theClass = cl.loadClass(className);
        for (Method next : methods = theClass.getMethods()) {
            String nextName = next.getName();
            int nextModifiers = next.getModifiers();
            if (!Modifier.isAbstract(nextModifiers) || !nextName.startsWith(FIELD_ACCESS_METHOD_PREFIX) || nextName.length() <= 3) continue;
            String field = nextName.substring(3, 4).toLowerCase(Locale.US) + nextName.substring(4);
            fieldDescriptors.add(new FieldDescriptor(field));
        }
        return fieldDescriptors;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n cmpVersion ").append(this.cmpVersion).append("\n primKeyField ");
        if (this.getPrimaryKeyFieldDesc() != null) {
            ((Descriptor)this.getPrimaryKeyFieldDesc()).print(toStringBuffer);
        }
        if (this.pers != null) {
            ((Descriptor)this.pers).print(toStringBuffer);
        }
    }
}

