/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.descriptor;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.deployment.util.ComponentPostVisitor;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.glassfish.deployment.common.DescriptorVisitor;
import org.glassfish.ejb.deployment.descriptor.DummyEjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.InterceptorBindingDescriptor;
import org.glassfish.ejb.deployment.descriptor.RelationshipDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.IASPersistenceManagerDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.PersistenceManagerInUse;
import org.glassfish.ejb.deployment.util.EjbBundleTracerVisitor;
import org.glassfish.ejb.deployment.util.EjbBundleValidator;

public final class EjbBundleDescriptorImpl
extends EjbBundleDescriptor {
    private static final long serialVersionUID = 1L;
    private static final System.Logger LOG = DOLUtils.getLogger();
    private String ejbClientJarUri;
    private ResourceReferenceDescriptor cmpResourceReference;
    private final LinkedList<InterceptorBindingDescriptor> interceptorBindings = new LinkedList();
    private String relationshipsDescription;
    private final Set<RelationshipDescriptor> relationships = new HashSet<RelationshipDescriptor>();
    private final List<SecurityRoleMapping> roleMaps = new ArrayList<SecurityRoleMapping>();
    private Set<Long> ejbIDs;

    @Override
    public String getDefaultSpecVersion() {
        return "4.0";
    }

    @Override
    public String getName() {
        if ("".equals(super.getName())) {
            super.setName("Ejb1");
        }
        return super.getName();
    }

    public String getEjbClientJarUri() {
        if (this.ejbClientJarUri == null) {
            this.ejbClientJarUri = "";
        }
        return this.ejbClientJarUri;
    }

    public void setEjbClientJarUri(String ejbClientJarUri) {
        this.ejbClientJarUri = ejbClientJarUri;
    }

    public ResourceReferenceDescriptor getCMPResourceReference() {
        return this.cmpResourceReference;
    }

    public void setCMPResourceReference(ResourceReferenceDescriptor resourceReference) {
        this.cmpResourceReference = resourceReference;
    }

    public List<InterceptorBindingDescriptor> getInterceptorBindings() {
        return this.interceptorBindings;
    }

    public void prependInterceptorBinding(InterceptorBindingDescriptor binding) {
        this.interceptorBindings.addFirst(binding);
    }

    public void appendInterceptorBinding(InterceptorBindingDescriptor binding) {
        this.interceptorBindings.addLast(binding);
    }

    public void setInterceptorBindings(List<InterceptorBindingDescriptor> bindings) {
        this.interceptorBindings.clear();
        this.interceptorBindings.addAll(bindings);
    }

    public String getRelationshipsDescription() {
        return this.relationshipsDescription;
    }

    public void setRelationshipsDescription(String relationshipsDescription) {
        this.relationshipsDescription = relationshipsDescription;
    }

    public boolean hasRelationships() {
        return !this.relationships.isEmpty();
    }

    public Set<RelationshipDescriptor> getRelationships() {
        return this.relationships;
    }

    public void addRelationship(RelationshipDescriptor relationship) {
        this.relationships.add(relationship);
    }

    public void removeRelationship(RelationshipDescriptor relationship) {
        this.relationships.remove(relationship);
    }

    public void addSecurityRoleMapping(SecurityRoleMapping roleMapping) {
        this.roleMaps.add(roleMapping);
    }

    public List<SecurityRoleMapping> getSecurityRoleMappings() {
        return this.roleMaps;
    }

    public void setupDataStructuresForRuntime() {
        HashSet<Long> ids = new HashSet<Long>();
        for (EjbDescriptor ejbDescriptor : this.getEjbs()) {
            ids.add(ejbDescriptor.getUniqueId());
        }
        this.ejbIDs = Collections.unmodifiableSet(ids);
    }

    public Collection<Long> getDescriptorIds() {
        return this.ejbIDs;
    }

    public Set<EjbDescriptor> getEjbs() {
        return super.getEjbs();
    }

    @Override
    public EjbDescriptor getEjbByName(String name) {
        return (EjbDescriptor)super.getEjbByName(name);
    }

    @Override
    public EjbDescriptor getEjbByName(String name, boolean isCreateDummy) {
        return (EjbDescriptor)super.getEjbByName(name, isCreateDummy);
    }

    @Override
    protected DummyEjbDescriptor createDummyEjbDescriptor(String ejbName) {
        LOG.log(System.Logger.Level.DEBUG, "Construct a Dummy EJB Descriptor with name {0}", ejbName);
        DummyEjbDescriptor dummyEjbDesc = new DummyEjbDescriptor();
        dummyEjbDesc.setName(ejbName);
        return dummyEjbDesc;
    }

    public boolean containsCMPEntity() {
        Set<EjbDescriptor> ejbs = this.getEjbs();
        for (EjbDescriptor ejb : ejbs) {
            if (!(ejb instanceof EjbCMPEntityDescriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAssemblyInformation() {
        return !this.getRoles().isEmpty() || this.hasPermissionedRoles() || this.hasContainerTransactions();
    }

    public boolean hasContainerTransactions() {
        for (EjbDescriptor ejb : this.getEjbs()) {
            if (ejb.getMethodContainerTransactions().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermissionedRoles() {
        for (EjbDescriptor ejb : this.getEjbs()) {
            if (ejb.getPermissionedMethodsByPermission().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof EjbBundleVisitor || aVisitor instanceof ComponentPostVisitor) {
            this.visit((ComponentVisitor)aVisitor);
        } else {
            super.visit(aVisitor);
        }
    }

    @Override
    public DescriptorVisitor getTracerVisitor() {
        return new EjbBundleTracerVisitor();
    }

    @Override
    public ComponentVisitor getBundleVisitor() {
        return new EjbBundleValidator();
    }

    @Deprecated(forRemoval=true, since="3.1")
    public void setPersistenceManagerInUse(PersistenceManagerInUse inuse) {
    }

    @Deprecated(forRemoval=true, since="3.1")
    public void addPersistenceManager(IASPersistenceManagerDescriptor pmDesc) {
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("EjbBundleDescriptor\n");
        super.print(toStringBuffer);
        if (this.cmpResourceReference != null) {
            toStringBuffer.append("\ncmp resource ");
            this.cmpResourceReference.print(toStringBuffer);
        }
        toStringBuffer.append("\nclient JAR ").append(this.getEjbClientJarUri());
        for (EjbDescriptor ejb : this.getEjbs()) {
            toStringBuffer.append("\n------------\n");
            toStringBuffer.append(ejb);
            toStringBuffer.append("\n------------");
        }
    }
}

