/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbInterceptorContext;
import jakarta.ejb.PrePassivate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=PrePassivate.class)
public class PrePassivateHandler
extends AbstractAttributeHandler {
    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        for (EjbContext next : ejbContexts) {
            EjbSessionDescriptor ejbSessionDescriptor = (EjbSessionDescriptor)next.getDescriptor();
            ejbSessionDescriptor.addPrePassivateDescriptor(this.getPrePassivateDescriptor(ainfo));
        }
        return this.getDefaultProcessedResult();
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbInterceptorContext ejbInterceptorContext) throws AnnotationProcessorException {
        EjbInterceptor ejbInterceptor = ejbInterceptorContext.getDescriptor();
        ejbInterceptor.addPrePassivateDescriptor(this.getPrePassivateDescriptor(ainfo));
        return this.getDefaultProcessedResult();
    }

    private LifecycleCallbackDescriptor getPrePassivateDescriptor(AnnotationInfo ainfo) {
        Method annotatedMethod = (Method)ainfo.getAnnotatedElement();
        LifecycleCallbackDescriptor prePassivate = new LifecycleCallbackDescriptor();
        prePassivate.setLifecycleCallbackClass(annotatedMethod.getDeclaringClass().getName());
        prePassivate.setLifecycleCallbackMethod(annotatedMethod.getName());
        return prePassivate;
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAnnotationTypes();
    }

    @Override
    protected boolean isDelegatee() {
        return true;
    }
}

