/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeployCommand;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service(name="redeploy")
@PerLookup
@I18n(value="redeploy.command")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@AccessRequired.Delegate(value=DeployCommand.class)
public class ReDeployCommand
extends DeployCommandParameters
implements AdminCommand {
    @Inject
    CommandRunner commandRunner;
    @Inject
    Deployment deployment;
    @Param(optional=false)
    String name;
    @Param(primary=true, optional=true)
    File path = null;
    @Inject
    private ConfigBeansUtilities configBeansUtilities;
    boolean skipParamValidation = true;
    private final Collection<String> excludedDeployCommandParamNames = this.initExcludedDeployCommandParamNames();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ReDeployCommand.class);

    @Override
    public void execute(AdminCommandContext context) {
        ParameterMap paramMap;
        ActionReport report = context.getActionReport();
        if (!this.validateParameters(this.name, report)) {
            return;
        }
        ParameterMapExtractor extractor = new ParameterMapExtractor(this);
        try {
            paramMap = extractor.extract(this.excludedDeployCommandParamNames);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        paramMap.set("force", String.valueOf(true));
        CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("deploy", report, context.getSubject());
        inv.parameters(paramMap).inbound(context.getInboundPayload()).outbound(context.getOutboundPayload()).execute();
    }

    boolean validateParameters(String name, ActionReport report) {
        if (!this.deployment.isRegistered(name)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", name));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.path == null && !Boolean.parseBoolean(this.configBeansUtilities.getDirectoryDeployed(name))) {
            report.setMessage(localStrings.getLocalString("redeploy.command.cannot.redeploy", "Cannot redeploy this app {0} without specify the operand.", name));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        File file = ((DeployCommandParameters)this).path = this.path == null ? new File(this.configBeansUtilities.getLocation(name)) : this.path;
        if (!((DeployCommandParameters)this).path.exists()) {
            report.setMessage(localStrings.getLocalString("redeploy.command.invalid.path", "Cannot determine the path of application."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    private Collection<String> initExcludedDeployCommandParamNames() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("force");
        return result;
    }
}

