/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Service;

@Service(name="_mt-provision")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
public class MTProvisionCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    @Param(optional=true)
    public File customizations = null;
    @Param
    public String tenant = null;
    @Param
    public String contextroot = null;
    @Param(primary=true)
    public String appname;
    @Inject
    Domain domain;
    @Inject
    Applications applications;
    @Inject
    Deployment deployment;
    @Inject
    ArchiveFactory archiveFactory;
    private Application app;
    private ApplicationRef appRef;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MTProvisionCommand.class);

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList accessChecks = new ArrayList();
        this.app = this.applications.getApplication(this.appname);
        if (this.app != null) {
            accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy(this.app), "provision"));
            this.appRef = this.domain.getApplicationRefInTarget(this.appname, "server");
            if (this.appRef != null) {
                accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy(this.appRef), "provision"));
            }
        }
        return accessChecks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        if (this.app == null) {
            report.setMessage("Application " + this.appname + " needs to be deployed first before provisioned to tenant");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Archive archive = null;
        DeployCommandParameters commandParams = this.app.getDeployParameters(this.appRef);
        commandParams.contextroot = this.contextroot;
        commandParams.target = "server";
        commandParams.name = DeploymentUtils.getInternalNameForTenant(this.appname, this.tenant);
        commandParams.enabled = Boolean.TRUE;
        commandParams.origin = OpsParams.Origin.mt_provision;
        try {
            URI uri = new URI(this.app.getLocation());
            File file = new File(uri);
            if (!file.exists()) {
                throw new Exception(localStrings.getLocalString("fnf", "File not found", file.getAbsolutePath()));
            }
            archive = this.archiveFactory.openArchive(file);
            ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(logger2, commandParams, report).source((ReadableArchive)archive).build();
            Properties appProps = deploymentContext.getAppProps();
            appProps.putAll((Map<?, ?>)this.app.getDeployProperties());
            if (this.contextroot != null) {
                appProps.setProperty("context-root", this.contextroot);
            }
            deploymentContext.setModulePropsMap(this.app.getModulePropertiesMap());
            deploymentContext.setTenant(this.tenant, this.appname);
            this.expandCustomizationJar(deploymentContext.getTenantDir());
            this.deployment.deploy(deploymentContext);
            this.deployment.registerTenantWithAppInDomainXML(this.appname, deploymentContext);
        }
        catch (Throwable e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
            report.setFailureCause(e);
        }
        finally {
            try {
                if (archive != null) {
                    archive.close();
                }
            }
            catch (IOException uri) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandCustomizationJar(File tenantDir) throws IOException {
        if (tenantDir.exists() || !tenantDir.mkdirs()) {
            // empty if block
        }
        if (this.customizations == null) {
            return;
        }
        Archive cusArchive = null;
        WritableArchive expandedArchive = null;
        try {
            expandedArchive = this.archiveFactory.createArchive(tenantDir);
            cusArchive = this.archiveFactory.openArchive(this.customizations);
            DeploymentUtils.expand((ReadableArchive)cusArchive, expandedArchive);
        }
        finally {
            try {
                if (cusArchive != null) {
                    cusArchive.close();
                }
                if (expandedArchive != null) {
                    expandedArchive.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

