/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@TargetType(value={CommandTarget.DAS, CommandTarget.CONFIG, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-admin-object")
@PerLookup
@I18n(value="delete.admin.ojbect")
public class DeleteAdminObject
implements AdminCommand {
    private static final System.Logger LOG = System.getLogger(DeleteAdminObject.class.getName());
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(DeleteAdminObject.class);
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment environment;

    @Override
    public void execute(AdminCommandContext context) {
        LOG.log(System.Logger.Level.DEBUG, "execute(context={0}); jndiName={1}, target={2}", context, this.jndiName, this.target);
        ActionReport report = context.getActionReport();
        if (this.jndiName == null) {
            report.setMessage(I18N.getLocalString("delete.admin.object.noJndiName", "No JNDI name defined for administered object."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        SimpleJndiName simpleJndiName = new SimpleJndiName(this.jndiName);
        if (!this.isResourceExists(this.domain.getResources(), simpleJndiName)) {
            report.setMessage(I18N.getLocalString("delete.admin.object.notfound", "An administered object named {0} does not exist.", this.jndiName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.environment.isDas()) {
            if (this.domain.getConfigNamed(this.target) != null) {
                if (!this.resourceUtil.getTargetsReferringResourceRef(simpleJndiName).isEmpty()) {
                    report.setMessage(I18N.getLocalString("delete.admin.object.resource-ref.exist", "admin-object [ {0} ] is referenced in an instance/cluster target, Use delete-resource-ref on appropriate target", this.jndiName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            } else {
                if (!this.resourceUtil.isResourceRefInTarget(simpleJndiName, this.target)) {
                    report.setMessage(I18N.getLocalString("delete.admin.object.no.resource-ref", "admin-object [ {0} ] is not referenced in target [ {1} ]", this.jndiName, this.target));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                if (this.resourceUtil.getTargetsReferringResourceRef(simpleJndiName).size() > 1) {
                    report.setMessage(I18N.getLocalString("delete.admin.object.multiple.resource-refs", "admin-object [ {0} ] is referenced in multiple instance/cluster targets, Use delete-resource-ref on appropriate target", this.jndiName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        try {
            SingleConfigCode<Resources> configCode;
            if (!"domain".equals(this.target)) {
                this.resourceUtil.deleteResourceRef(simpleJndiName, this.target);
            }
            if (ConfigSupport.apply(configCode = param -> {
                AdminObjectResource resource = this.domain.getResources().getResourceByName(AdminObjectResource.class, simpleJndiName);
                return param.getResources().remove(resource);
            }, this.domain.getResources()) == null) {
                report.setMessage(I18N.getLocalString("delete.admin.object.fail", "Unable to delete administered object {0}", this.jndiName));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        catch (TransactionFailure tfe) {
            report.setMessage(I18N.getLocalString("delete.admin.object.fail", "Unable to delete administered object {0}", this.jndiName) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(tfe);
        }
        report.setMessage(I18N.getLocalString("delete.admin.object.success", "Administered object {0} deleted", this.jndiName));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isResourceExists(Resources resources, SimpleJndiName simpleJndiName) {
        return resources.getResourceByName(AdminObjectResource.class, simpleJndiName) != null;
    }
}

