/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="connector-resource")
@PerLookup
@I18n(value="create.connector.resource")
public class ConnectorResourceManager
implements ResourceManager {
    private static final String DESCRIPTION = "description";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectorResourceManager.class);
    private String poolName = null;
    private String enabled = Boolean.TRUE.toString();
    private String enabledValueForTarget = Boolean.TRUE.toString();
    private String jndiName = null;
    private String description = null;
    private String objectType = "user";
    @Inject
    private Domain domain;
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private BindableResourcesHelper resourcesHelper;

    @Override
    public String getResourceType() {
        return "connector-resource";
    }

    @Override
    public ResourceStatus create(Resources resources, HashMap attributes, Properties properties, String target) throws Exception {
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources, true, target);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            SingleConfigCode<Resources> configCode = param -> this.createResource((Resources)param, properties);
            ConfigSupport.apply(configCode, resources);
            if (!"domain".equals(target)) {
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.connector.resource.fail", "Connector resource {0} create failed ", this.jndiName) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg);
        }
        String msg = localStrings.getLocalString("create.connector.resource.success", "Connector resource {0} created successfully", this.jndiName);
        return new ResourceStatus(0, msg);
    }

    private ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        if (this.jndiName == null) {
            String msg = localStrings.getLocalString("create.connector.resource.noJndiName", "No JNDI name defined for connector resource.");
            return new ResourceStatus(1, msg);
        }
        ResourceStatus status = this.resourcesHelper.validateBindableResourceForDuplicates(resources, this.jndiName, validateResourceRef, target, ConnectorResource.class);
        if (status.getStatus() == 1) {
            return status;
        }
        if (!this.isConnPoolExists(resources)) {
            String msg = localStrings.getLocalString("create.connector.resource.connPoolNotFound", "Attribute value (pool-name = {0}) is not found in list of connector connection pools.", this.poolName);
            return new ResourceStatus(1, msg);
        }
        return status;
    }

    private ConnectorResource createResource(Resources param, Properties props) throws PropertyVetoException, TransactionFailure {
        ConnectorResource newResource = this.createConfigBean(param, props);
        param.getResources().add(newResource);
        return newResource;
    }

    private ConnectorResource createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ConnectorResource newResource = param.createChild(ConnectorResource.class);
        newResource.setJndiName(this.jndiName);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        newResource.setPoolName(this.poolName);
        newResource.setEnabled(this.enabled);
        newResource.setObjectType(this.objectType);
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = newResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    private void setAttributes(HashMap attributes, String target) {
        this.poolName = (String)attributes.get("pool-name");
        this.enabled = target != null ? this.resourceUtil.computeEnabledValueForResourceBasedOnTarget((String)attributes.get("enabled"), target) : (String)attributes.get("enabled");
        this.enabledValueForTarget = (String)attributes.get("enabled");
        this.jndiName = (String)attributes.get("jndi-name");
        this.description = (String)attributes.get(DESCRIPTION);
        this.objectType = (String)attributes.get("object-type");
    }

    private boolean isConnPoolExists(Resources resources) {
        SimpleJndiName jndiPoolName = new SimpleJndiName(this.poolName);
        return resources.getResourceByName(ConnectorConnectionPool.class, jndiPoolName) != null;
    }

    @Override
    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = null;
        status = !validate ? new ResourceStatus(0, "") : this.isValid(resources, false, null);
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage());
    }
}

