/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.config.support.ConfigurationPersistence;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

public class GlassFishDocument
extends DomDocument<GlassFishConfigBean> {
    Logger logger = ConfigApiLoggerInfo.getLogger();

    public GlassFishDocument(final ServiceLocator habitat, ExecutorService executor) {
        super(habitat);
        ServiceLocatorUtilities.addOneConstant(habitat, executor, "transactions-executor", new Type[]{ExecutorService.class});
        ServiceLocatorUtilities.addOneConstant(habitat, this, null, new Type[]{DomDocument.class});
        final GlassFishDocument doc = this;
        habitat.getService(Transactions.class, new Annotation[0]).addTransactionsListener(new TransactionListener(){

            @Override
            public void transactionCommited(List<PropertyChangeEvent> changes) {
                if (!this.isGlassFishDocumentChanged(changes)) {
                    return;
                }
                for (ConfigurationPersistence pers : habitat.getAllServices(ConfigurationPersistence.class, new Annotation[0])) {
                    try {
                        if (doc.getRoot().getProxyType().equals(Domain.class)) {
                            Dom domainRoot = doc.getRoot();
                            domainRoot.attribute("version", Version.getVersionNumber());
                        }
                        pers.save(doc);
                    }
                    catch (IOException e) {
                        GlassFishDocument.this.logger.log(Level.SEVERE, "NCLS-CFGAPI-00099", e);
                    }
                    catch (XMLStreamException e) {
                        GlassFishDocument.this.logger.log(Level.SEVERE, "NCLS-CFGAPI-00100", e);
                    }
                }
            }

            private boolean isGlassFishDocumentChanged(List<PropertyChangeEvent> changes) {
                for (PropertyChangeEvent event : changes) {
                    ConfigBeanProxy source = (ConfigBeanProxy)event.getSource();
                    if (!(Dom.unwrap(source) instanceof GlassFishConfigBean)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
            }
        });
    }

    public GlassFishConfigBean make(ServiceLocator habitat, XMLStreamReader xmlStreamReader, GlassFishConfigBean dom, ConfigModel configModel) {
        return new GlassFishConfigBean(habitat, (DomDocument)this, dom, configModel, xmlStreamReader);
    }
}

