/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.launcher;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.glassfish.cluster.ssh.launcher.OperatingSystem;
import org.glassfish.cluster.ssh.launcher.RemoteSystemCapabilities;
import org.glassfish.cluster.ssh.launcher.SSHException;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.sftp.SFTPPath;

public class SSHSession
implements AutoCloseable {
    private static final System.Logger LOG = System.getLogger(SSHSession.class.getName());
    private final Session session;
    private final RemoteSystemCapabilities capabilities;

    SSHSession(Session session) {
        this.session = session;
        this.capabilities = new RemoteSystemCapabilities(null, null, OperatingSystem.GENERIC, StandardCharsets.UTF_8);
    }

    SSHSession(Session session, RemoteSystemCapabilities capabilities) {
        this.session = session;
        this.capabilities = capabilities;
    }

    public boolean isOpen() {
        return this.session.isConnected();
    }

    public Map<String, String> detectShellEnv() throws SSHException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);
        ChannelShell shell = (ChannelShell)SSHSession.openChannel(this.session, "shell");
        try {
            shell.setInputStream(SSHSession.listInputStream(List.of("env || set"), StandardCharsets.UTF_8));
            shell.setPty(false);
            InputStream in = shell.getInputStream();
            PumpThread t1 = new PumpThread(in, outputStream);
            t1.start();
            shell.connect();
            t1.join();
            String output = outputStream.toString(StandardCharsets.UTF_8);
            LOG.log(System.Logger.Level.DEBUG, () -> "Environment options - command output: \n" + output);
            Map<String, String> map = SSHSession.parseProperties(output);
            return map;
        }
        catch (Exception e) {
            throw new SSHException("Could not detect shell environment options. Output: " + outputStream.toString(StandardCharsets.UTF_8), e);
        }
        finally {
            shell.disconnect();
        }
    }

    public void unzip(SFTPPath remoteZipFile, Path remoteDir) throws SSHException {
        StringBuilder output;
        String unzipCommand = this.capabilities.getOperatingSystem() == OperatingSystem.WINDOWS ? "PowerShell.exe -Command \"Expand-Archive -LiteralPath '" + String.valueOf(remoteZipFile) + "' -DestinationPath '" + String.valueOf(remoteDir) + "'\"" : "set -x; cd \"" + String.valueOf(remoteDir) + "\"; unpack=\"$(command -v unzip)\" || unpack=\"jar -xvf\"; ${unpack} \"" + String.valueOf(remoteZipFile) + "\"";
        int status = this.exec(unzipCommand, null, output = new StringBuilder());
        if (status != 0) {
            throw new SSHException("Failed unpacking glassfish zip file. Output: " + String.valueOf(output) + ".");
        }
        LOG.log(System.Logger.Level.DEBUG, () -> "Unpacked " + String.valueOf(remoteZipFile) + " to directory " + String.valueOf(remoteDir));
    }

    public int exec(List<String> command, List<String> stdinLines, StringBuilder output) throws SSHException {
        return this.exec(command.stream().collect(Collectors.joining(" ")), SSHSession.listInputStream(stdinLines, this.capabilities.getCharset()), output);
    }

    public int exec(List<String> command, List<String> stdinLines) throws SSHException {
        return this.exec(command.stream().collect(Collectors.joining(" ")), stdinLines);
    }

    public int exec(String command, List<String> stdinLines) throws SSHException {
        return this.exec(command, SSHSession.listInputStream(stdinLines, this.capabilities.getCharset()));
    }

    public int exec(String command) throws SSHException {
        return this.exec(command, (InputStream)null);
    }

    public int exec(String command, InputStream stdin) throws SSHException {
        return this.exec(command, stdin, null);
    }

    public int exec(String command, InputStream stdin, StringBuilder output) throws SSHException {
        return this.exec(command, stdin, output, this.capabilities.getCharset());
    }

    int exec(String command, InputStream stdin, StringBuilder output, Charset charset) throws SSHException {
        LOG.log(System.Logger.Level.INFO, () -> "Executing command " + command + " on host: " + this.session.getHost());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);
        ChannelExec execChannel = (ChannelExec)SSHSession.openChannel(this.session, "exec");
        try {
            execChannel.setInputStream(stdin);
            execChannel.setCommand(command);
            InputStream in = execChannel.getInputStream();
            PumpThread t1 = new PumpThread(in, outputStream);
            t1.start();
            PumpThread t2 = new PumpThread(execChannel.getErrStream(), outputStream);
            t2.start();
            execChannel.connect();
            t1.join();
            t2.join();
            if (output != null || LOG.isLoggable(System.Logger.Level.DEBUG)) {
                String commandOutput = outputStream.toString(charset);
                LOG.log(System.Logger.Level.DEBUG, () -> "Command output: \n" + commandOutput);
                if (output != null) {
                    output.append(commandOutput);
                }
            }
            if (execChannel.isClosed()) {
                int n = execChannel.getExitStatus();
                return n;
            }
            int n = -1;
            return n;
        }
        catch (Exception e) {
            throw new SSHException("Command " + command + " failed. Output: " + outputStream.toString(charset), e);
        }
        finally {
            execChannel.disconnect();
        }
    }

    public SFTPClient createSFTPClient() throws SSHException {
        return new SFTPClient((ChannelSftp)SSHSession.openChannel(this.session, "sftp"));
    }

    @Override
    public void close() {
        if (this.session.isConnected()) {
            this.session.disconnect();
        }
    }

    private static InputStream listInputStream(List<String> stdinLines, Charset charset) {
        if (stdinLines == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (String line : stdinLines) {
                baos.write(line.getBytes(charset));
                baos.write(10);
            }
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot copy the input to UTF-8 byte array input stream.", e);
        }
    }

    private static <T extends Channel> T openChannel(Session session, String type2) throws SSHException {
        try {
            return (T)session.openChannel(type2);
        }
        catch (JSchException e) {
            throw new SSHException("Could not open the session of type=" + type2, e);
        }
    }

    private static Map<String, String> parseProperties(String output) {
        String[] lines = output.split("\\R");
        TreeMap<String, String> properties = new TreeMap<String, String>();
        for (String line : lines) {
            int equalSignPosition = line.indexOf(61);
            if (equalSignPosition <= 0) continue;
            String key = line.substring(0, equalSignPosition);
            String value = equalSignPosition == line.length() - 1 ? "" : line.substring(equalSignPosition + 1);
            properties.put(key.strip(), value.strip());
        }
        return properties;
    }

    private static final class PumpThread
    extends Thread {
        private final InputStream in;
        private final OutputStream out;

        public PumpThread(InputStream in, OutputStream out) {
            super("pump thread");
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            byte[] buf = new byte[8192];
            try {
                while (true) {
                    int len;
                    if ((len = this.in.read(buf)) < 0) {
                        this.in.close();
                        return;
                    }
                    this.out.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

