/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.connect;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.cluster.ssh.launcher.SSHException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.launcher.SSHSession;

public class NodeRunnerSsh {
    private static final System.Logger LOG = System.getLogger(NodeRunnerSsh.class.getName());
    private String lastCommandRun;
    private int commandStatus;

    public boolean isSshNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        return "SSH".equals(node.getType());
    }

    String getLastCommandRun() {
        return this.lastCommandRun;
    }

    public int runAdminCommandOnRemoteNode(Node node, StringBuilder output, List<String> args, List<String> stdinLines) throws SSHCommandExecutionException, UnsupportedOperationException {
        args.add(0, "--_auxinput");
        args.add(1, "-");
        if (!this.isSshNode(node)) {
            throw new UnsupportedOperationException("Node is not of type SSH");
        }
        String installDir = node.getInstallDirUnixStyle() + "/" + SystemPropertyConstants.getComponentName();
        ArrayList<String> fullcommand = new ArrayList<String>();
        SSHLauncher sshL = new SSHLauncher(node);
        try {
            fullcommand.add("\"" + installDir + "/lib/nadmin\"");
            fullcommand.addAll(args);
            this.lastCommandRun = fullcommand.stream().collect(Collectors.joining(" "));
            LOG.log(System.Logger.Level.DEBUG, () -> "Running command on " + node.getNodeHost() + ": " + this.lastCommandRun);
            StringBuilder commandOutput = new StringBuilder();
            try (SSHSession session = sshL.openSession();){
                this.commandStatus = session.exec(fullcommand, stdinLines, commandOutput);
            }
            output.append((CharSequence)commandOutput);
            return this.commandStatus;
        }
        catch (SSHException e) {
            LOG.log(System.Logger.Level.ERROR, "Command execution failed for " + this.lastCommandRun, (Throwable)e);
            SSHCommandExecutionException cee = new SSHCommandExecutionException(e.getMessage(), e);
            cee.setSSHSettings(sshL.toString());
            cee.setCommandRun(this.lastCommandRun);
            throw cee;
        }
    }
}

