/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.connect;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.cluster.ssh.connect.NodeRunnerSsh;
import org.glassfish.common.util.admin.AsadminInput;
import org.glassfish.common.util.admin.AuthTokenManager;

public class NodeRunner {
    private static final System.Logger LOG = System.getLogger(NodeRunner.class.getName());
    private static final String AUTH_TOKEN_STDIN_LINE_PREFIX = "option._authtoken=";
    private final AuthTokenManager authTokenManager;
    private String lastCommandRun;

    public NodeRunner(AuthTokenManager authTokenManager) {
        this.authTokenManager = authTokenManager;
    }

    public String getLastCommandRun() {
        return this.lastCommandRun;
    }

    public int runAdminCommandOnNode(Node node, StringBuilder output, List<String> args, AdminCommandContext context) throws SSHCommandExecutionException, ProcessManagerException, UnsupportedOperationException, IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        ArrayList<String> stdinLines = new ArrayList<String>();
        stdinLines.add(AsadminInput.versionSpecifier());
        stdinLines.add(AUTH_TOKEN_STDIN_LINE_PREFIX + this.authTokenManager.createToken(context.getSubject()));
        args.add(0, "--interactive=false");
        if (node.isLocal()) {
            return this.runAdminCommandOnLocalNode(node, output, args, stdinLines);
        }
        String type2 = node.getType();
        if ("SSH".equals(type2)) {
            return this.runAdminCommandOnRemoteNode(node, output, args, stdinLines);
        }
        throw new UnsupportedOperationException("Node type is not supported: " + type2);
    }

    private int runAdminCommandOnLocalNode(Node node, StringBuilder output, List<String> args, List<String> stdinLines) throws ProcessManagerException {
        args.add(0, "--_auxinput");
        args.add(1, "-");
        ArrayList<String> fullcommand = new ArrayList<String>();
        String installDir = node.getInstallDirUnixStyle() + "/" + SystemPropertyConstants.getComponentName();
        if (!StringUtils.ok(installDir)) {
            throw new IllegalArgumentException("Node does not have an installDir");
        }
        File asadmin = new File(SystemPropertyConstants.getAsAdminScriptLocation(installDir));
        fullcommand.add(asadmin.getAbsolutePath());
        fullcommand.addAll(args);
        if (!asadmin.canExecute()) {
            throw new ProcessManagerException(asadmin.getAbsolutePath() + " is not executable.");
        }
        this.lastCommandRun = this.commandListToString(fullcommand);
        LOG.log(System.Logger.Level.DEBUG, "Running command locally: {0}", this.lastCommandRun);
        ProcessManager pm = new ProcessManager(fullcommand);
        pm.setStdinLines(stdinLines);
        int exitValue = pm.execute();
        String stdout = pm.getStdout();
        String stderr = pm.getStderr();
        if (output != null) {
            if (StringUtils.ok(stdout)) {
                output.append(stdout);
            }
            if (StringUtils.ok(stderr)) {
                if (output.length() > 0) {
                    output.append(System.lineSeparator());
                }
                output.append(stderr);
            }
        }
        return exitValue;
    }

    private int runAdminCommandOnRemoteNode(Node node, StringBuilder output, List<String> args, List<String> stdinLines) throws SSHCommandExecutionException, IllegalArgumentException, UnsupportedOperationException {
        NodeRunnerSsh nrs = new NodeRunnerSsh();
        int result = nrs.runAdminCommandOnRemoteNode(node, output, args, stdinLines);
        this.lastCommandRun = nrs.getLastCommandRun();
        return result;
    }

    private String commandListToString(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        for (String s : command) {
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }
}

