/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandLockException;
import org.glassfish.api.admin.AdminCommandLockTimeoutException;
import org.glassfish.api.admin.CommandLock;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class AdminCommandLock {
    @Inject
    Logger logger;
    private static ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private SuspendCommandsLockThread suspendCommandsLockThread = null;
    private String lockOwner = null;
    private String lockMessage = null;
    private Date lockTimeOfAcquisition = null;

    public Lock getLock(CommandLock.LockType type2) {
        if (type2 == CommandLock.LockType.SHARED) {
            return rwlock.readLock();
        }
        if (type2 == CommandLock.LockType.EXCLUSIVE) {
            return rwlock.writeLock();
        }
        return null;
    }

    public void dumpState(Logger logger2, Level level) {
        if (logger2.isLoggable(level)) {
            logger2.log(level, "Current locking conditions are " + rwlock.getReadLockCount() + "/" + rwlock.getReadHoldCount() + " shared locks and " + rwlock.getWriteHoldCount() + " write lock");
        }
    }

    public Lock getLock(AdminCommand command) {
        CommandLock alock = command.getClass().getAnnotation(CommandLock.class);
        if (alock == null || alock.value() == CommandLock.LockType.SHARED) {
            return rwlock.readLock();
        }
        if (alock.value() == CommandLock.LockType.EXCLUSIVE) {
            return rwlock.writeLock();
        }
        return null;
    }

    public Lock getLock(AdminCommand command, String owner) throws AdminCommandLockTimeoutException, AdminCommandLockException {
        Lock lock = null;
        boolean exclusive = false;
        int timeout = 30;
        CommandLock alock = command.getClass().getAnnotation(CommandLock.class);
        if (alock == null || alock.value() == CommandLock.LockType.SHARED) {
            lock = rwlock.readLock();
        } else if (alock.value() == CommandLock.LockType.EXCLUSIVE) {
            lock = rwlock.writeLock();
            exclusive = true;
        }
        if (lock == null) {
            return null;
        }
        if (this.suspendCommandsLockThread != null && this.suspendCommandsLockThread.isAlive()) {
            timeout = -1;
        } else {
            boolean badTimeOutValue = false;
            String timeout_s = System.getProperty("com.sun.aas.commandLockTimeOut", "30");
            try {
                timeout = Integer.parseInt(timeout_s);
                if (timeout < 0) {
                    badTimeOutValue = true;
                }
            }
            catch (NumberFormatException e) {
                badTimeOutValue = true;
            }
            if (badTimeOutValue) {
                this.logger.log(Level.INFO, "Bad value com.sun.aas.commandLockTimeOut: " + timeout_s + ". Using 30 seconds.");
                timeout = 30;
            }
        }
        boolean lockAcquired = false;
        while (!lockAcquired) {
            try {
                if (lock.tryLock(timeout, TimeUnit.SECONDS)) {
                    lockAcquired = true;
                    continue;
                }
                if (timeout >= 0) {
                    throw new AdminCommandLockTimeoutException("timeout acquiring lock", this.getLockTimeOfAcquisition(), this.getLockOwner());
                }
                throw new AdminCommandLockException(this.getLockMessage(), this.getLockTimeOfAcquisition(), this.getLockOwner());
            }
            catch (InterruptedException e) {
                this.logger.log(Level.FINE, "Interrupted acquiring command lock. ", e);
            }
        }
        if (lockAcquired && exclusive) {
            this.setLockOwner(owner);
            this.setLockTimeOfAcquisition(new Date());
        }
        return lock;
    }

    private void setLockOwner(String owner) {
        this.lockOwner = owner;
    }

    public synchronized String getLockOwner() {
        return this.lockOwner;
    }

    private void setLockMessage(String message) {
        this.lockMessage = message;
    }

    public synchronized String getLockMessage() {
        return this.lockMessage;
    }

    private void setLockTimeOfAcquisition(Date time) {
        this.lockTimeOfAcquisition = time;
    }

    public synchronized Date getLockTimeOfAcquisition() {
        return this.lockTimeOfAcquisition;
    }

    public synchronized boolean isSuspended() {
        return this.suspendCommandsLockThread != null && this.suspendCommandsLockThread.isAlive();
    }

    public synchronized SuspendStatus suspendCommands(long timeout, String lockOwner) {
        return this.suspendCommands(timeout, lockOwner, "");
    }

    public synchronized SuspendStatus suspendCommands(long timeout, String lockOwner, String message) {
        ArrayBlockingQueue<SuspendStatus> suspendStatusQ = new ArrayBlockingQueue<SuspendStatus>(1);
        if (this.suspendCommandsLockThread != null && this.suspendCommandsLockThread.isAlive()) {
            return SuspendStatus.ILLEGALSTATE;
        }
        this.suspendCommandsLockThread = new SuspendCommandsLockThread(timeout, suspendStatusQ, lockOwner, message);
        try {
            this.suspendCommandsLockThread.setName("DAS Suspended Command Lock Thread");
            this.suspendCommandsLockThread.setDaemon(true);
        }
        catch (IllegalThreadStateException e) {
            return SuspendStatus.ERROR;
        }
        catch (SecurityException e) {
            return SuspendStatus.ERROR;
        }
        this.suspendCommandsLockThread.start();
        SuspendStatus suspendStatus = this.queueTake(suspendStatusQ);
        return suspendStatus;
    }

    public synchronized Thread resumeCommands() {
        if (this.suspendCommandsLockThread == null || !this.suspendCommandsLockThread.isAlive() || this.suspendCommandsLockThread.resumeCommandsSemaphore == null) {
            return null;
        }
        this.suspendCommandsLockThread.resumeCommandsSemaphore.release();
        return this.suspendCommandsLockThread;
    }

    private void queuePut(BlockingQueue<SuspendStatus> itmQ, SuspendStatus status) {
        boolean itemPut = false;
        while (!itemPut) {
            try {
                itmQ.put(status);
                itemPut = true;
            }
            catch (InterruptedException e) {
                this.logger.log(Level.FINE, "Interrupted putting lock status on queue", e);
            }
        }
    }

    private SuspendStatus queueTake(BlockingQueue<SuspendStatus> itmQ) {
        SuspendStatus status = SuspendStatus.SUCCESS;
        boolean itemTake = false;
        while (!itemTake) {
            try {
                status = itmQ.take();
                itemTake = true;
            }
            catch (InterruptedException e) {
                this.logger.log(Level.FINE, "Interrupted getting status from a suspend queue", e);
            }
        }
        return status;
    }

    public static void runWithSuspendedLock(Runnable r) {
        Lock lock = null;
        try {
            if (rwlock.isWriteLockedByCurrentThread()) {
                lock = rwlock.writeLock();
            } else if (rwlock.getReadHoldCount() > 0) {
                lock = rwlock.readLock();
            }
            if (lock != null) {
                lock.unlock();
            }
            r.run();
        }
        finally {
            if (lock != null) {
                lock.lock();
            }
        }
    }

    private class SuspendCommandsLockThread
    extends Thread {
        private Semaphore resumeCommandsSemaphore;
        private BlockingQueue<SuspendStatus> suspendStatusQ;
        private boolean suspendCommandsTimedOut;
        private long timeout;
        private String lockOwner;
        private String message;

        public SuspendCommandsLockThread(long timeout, BlockingQueue<SuspendStatus> suspendStatusQ, String lockOwner, String message) {
            this.suspendStatusQ = suspendStatusQ;
            this.timeout = timeout;
            this.lockOwner = lockOwner;
            this.message = message;
            this.resumeCommandsSemaphore = null;
            this.suspendCommandsTimedOut = false;
        }

        @Override
        public void run() {
            Lock lock = AdminCommandLock.this.getLock(CommandLock.LockType.EXCLUSIVE);
            boolean lockAcquired = false;
            while (!lockAcquired && !this.suspendCommandsTimedOut) {
                try {
                    if (lock.tryLock(this.timeout, TimeUnit.SECONDS)) {
                        lockAcquired = true;
                        continue;
                    }
                    this.suspendCommandsTimedOut = true;
                }
                catch (InterruptedException e) {
                    AdminCommandLock.this.logger.log(Level.FINE, "Interrupted acquiring command lock. ", e);
                }
            }
            if (lockAcquired) {
                AdminCommandLock.this.setLockOwner(this.lockOwner);
                AdminCommandLock.this.setLockMessage(this.message);
                AdminCommandLock.this.setLockTimeOfAcquisition(new Date());
                this.resumeCommandsSemaphore = new Semaphore(0, true);
            }
            if (this.suspendStatusQ != null) {
                if (this.suspendCommandsTimedOut) {
                    AdminCommandLock.this.queuePut(this.suspendStatusQ, SuspendStatus.TIMEOUT);
                } else {
                    AdminCommandLock.this.queuePut(this.suspendStatusQ, SuspendStatus.SUCCESS);
                }
            }
            if (this.suspendCommandsTimedOut) {
                return;
            }
            this.semaphoreWait(this.resumeCommandsSemaphore, "Interrupted waiting on resume semaphore");
            lock.unlock();
        }

        private void semaphoreWait(Semaphore s, String logMsg) {
            boolean semaphoreReleased = false;
            while (!semaphoreReleased) {
                try {
                    s.acquire();
                    semaphoreReleased = true;
                }
                catch (InterruptedException e) {
                    AdminCommandLock.this.logger.log(Level.FINE, logMsg, e);
                }
            }
        }
    }

    public static enum SuspendStatus {
        SUCCESS,
        TIMEOUT,
        ILLEGALSTATE,
        ERROR;

    }
}

