/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Consumes(value={"application/json"})
@Provider
public class JsonHashMapProvider
implements MessageBodyReader<HashMap<String, String>> {
    @Override
    public boolean isReadable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type2.equals(HashMap.class);
    }

    @Override
    public HashMap<String, String> readFrom(Class<HashMap<String, String>> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream in) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            JSONObject obj = new JSONObject(new String(in.readAllBytes(), StandardCharsets.UTF_8));
            Iterator iter = obj.keys();
            while (iter.hasNext()) {
                String k = (String)iter.next();
                map.put(k, String.valueOf(obj.get(k)));
            }
            return map;
        }
        catch (IOException | JSONException ex) {
            return map;
        }
    }
}

