/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.StringTokenizer;

@Consumes(value={"application/x-www-form-urlencoded", "application/octet-stream"})
@Provider
public class FormReader
implements MessageBodyReader<HashMap<String, String>> {
    @Override
    public boolean isReadable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type2.equals(HashMap.class);
    }

    @Override
    public HashMap<String, String> readFrom(Class<HashMap<String, String>> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream in) throws IOException {
        String formData = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(formData, "&");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.indexOf(61);
            if (idx < 0) {
                map.put(URLDecoder.decode(token, StandardCharsets.UTF_8), null);
                continue;
            }
            if (idx <= 0) continue;
            map.put(URLDecoder.decode(token.substring(0, idx), StandardCharsets.UTF_8), URLDecoder.decode(token.substring(idx + 1), StandardCharsets.UTF_8));
        }
        return map;
    }
}

