/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import com.sun.enterprise.v3.common.ActionReporter;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Type;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.provider.ActionReportJson2Provider;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.api.admin.AdminCommandState;

@Provider
@Produces(value={"application/json", "application/x-javascript"})
public class AdminCommandStateJsonProvider
extends BaseProvider<AdminCommandState> {
    private static final ActionReportJson2Provider actionReportJsonProvider = new ActionReportJson2Provider();

    public AdminCommandStateJsonProvider() {
        super(AdminCommandState.class, MediaType.APPLICATION_JSON_TYPE, new MediaType("application", "x-javascript"));
    }

    @Override
    protected boolean isGivenTypeWritable(Class<?> type2, Type genericType) {
        return this.desiredType.isAssignableFrom(type2);
    }

    @Override
    public String getContent(AdminCommandState proxy) {
        try {
            return this.processState(proxy).toString();
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    public JSONObject processState(AdminCommandState state) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("state", state.getState().name());
        result.put("id", state.getId());
        result.put("empty-payload", state.isOutboundPayloadEmpty());
        ActionReporter ar = (ActionReporter)state.getActionReport();
        this.addActionReporter(ar, result);
        return result;
    }

    protected void addActionReporter(ActionReporter ar, JSONObject json) throws JSONException {
        if (ar != null) {
            json.put("action-report", actionReportJsonProvider.processReport(ar));
        }
    }
}

