/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator.client;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.rest.generator.client.ClientGenerator;
import org.glassfish.admin.rest.generator.client.JavaClientGenerator;
import org.glassfish.admin.rest.generator.client.PythonClientGenerator;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;

@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="client", description="Generate REST client")})
@AccessRequired(resource={"domain/rest-client"}, action={"read"})
public class GenerateClientCommand
implements AdminCommand {
    @Inject
    ServiceLocator habitat;
    @Param
    private String outputDir;
    @Param(shortName="lang", optional=true, defaultValue="java")
    private String languages;
    private static final LocalStringManager localStrings = new LocalStringManagerImpl(GenerateClientCommand.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(AdminCommandContext context) {
        ArrayList<void> generators = new ArrayList<void>();
        for (String lang : this.languages.split(",")) {
            void var7_11;
            Object var7_12 = null;
            if ("java".equalsIgnoreCase(lang)) {
                JavaClientGenerator javaClientGenerator = new JavaClientGenerator(this.habitat);
            } else if ("python".equalsIgnoreCase(lang)) {
                PythonClientGenerator pythonClientGenerator = new PythonClientGenerator(this.habitat);
            }
            if (var7_11 == null) continue;
            generators.add(var7_11);
            var7_11.generateClasses();
        }
        Logger logger2 = context.getLogger();
        try {
            Payload.Outbound outboundPayload = context.getOutboundPayload();
            Properties props = new Properties();
            props.setProperty("file-xfer-root", this.outputDir.replace('\\', '/'));
            for (ClientGenerator clientGenerator : generators) {
                for (Map.Entry<String, URI> entry : clientGenerator.getArtifact().entrySet()) {
                    URI artifact = entry.getValue();
                    outboundPayload.attachFile("application/octet-stream", new URI(entry.getKey()), "files", props, new File(artifact));
                }
                List<String> messages = clientGenerator.getMessages();
                if (messages.isEmpty()) continue;
                ActionReport ar = context.getActionReport();
                for (String msg : messages) {
                    ar.addSubActionsReport().appendMessage(msg);
                }
            }
        }
        catch (Exception e) {
            String errorMsg = localStrings.getLocalString("download.errDownloading", "Error while downloading generated files");
            logger2.log(Level.SEVERE, errorMsg, e);
            ActionReport report = context.getActionReport();
            report = report.addSubActionsReport();
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
            report.setMessage(errorMsg);
            report.setFailureCause(e);
        }
    }
}

