/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.client;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.client.RestResponse;
import org.glassfish.admin.rest.client.utils.Util;

public abstract class RestClientBase {
    protected static final String RESPONSE_TYPE = "application/json";
    protected Map<String, Object> entityValues = new HashMap<String, Object>();
    protected List<String> children;
    protected int status;
    protected String message;
    protected Client client;
    protected RestClientBase parent;
    private boolean initialized = false;
    private boolean isNew = false;

    protected RestClientBase(Client c, RestClientBase p) {
        this.client = c;
        this.parent = p;
    }

    protected RestClientBase getParent() {
        return this.parent;
    }

    protected String getRestUrl() {
        return this.getParent().getRestUrl() + this.getSegment();
    }

    protected abstract String getSegment();

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean save() {
        Response response = this.client.target(this.getRestUrl()).request(RESPONSE_TYPE).post(this.buildMultivalueMapEntity(this.entityValues, MediaType.MULTIPART_FORM_DATA_TYPE), Response.class);
        boolean success = this.isSuccess(response);
        if (!success) {
            this.status = response.getStatus();
            this.message = response.readEntity(String.class);
        } else {
            this.isNew = false;
        }
        return success;
    }

    public boolean delete() {
        Response response = this.client.target(this.getRestUrl()).request(RESPONSE_TYPE).delete(Response.class);
        boolean success = this.isSuccess(response);
        if (!success) {
            this.status = response.getStatus();
            this.message = response.readEntity(String.class);
        }
        return success;
    }

    public RestResponse execute(Method method, String endpoint, boolean needsMultiPart) {
        return this.execute(method, endpoint, new HashMap<String, Object>(), needsMultiPart);
    }

    public RestResponse execute(Method method, String endPoint, Map<String, Object> payload) {
        return this.execute(method, endPoint, payload, false);
    }

    public RestResponse execute(Method method, String endPoint, Map<String, Object> payload, boolean needsMultiPart) {
        WebTarget target = this.client.target(this.getRestUrl() + endPoint);
        return new RestResponse(switch (method) {
            case Method.POST -> target.request(RESPONSE_TYPE).post(this.buildMultivalueMapEntity(payload, null), Response.class);
            case Method.PUT -> target.request(RESPONSE_TYPE).put(this.buildMultivalueMapEntity(payload, null), Response.class);
            case Method.DELETE -> RestClientBase.targetWithQueryParams(target, this.buildMultivalueMap(payload)).request(RESPONSE_TYPE).delete(Response.class);
            default -> RestClientBase.targetWithQueryParams(target, this.buildMultivalueMap(payload)).request(RESPONSE_TYPE).get(Response.class);
        });
    }

    private static WebTarget targetWithQueryParams(WebTarget target, MultivaluedMap<String, Object> paramMap) {
        for (Map.Entry param : paramMap.entrySet()) {
            target = target.queryParam((String)param.getKey(), param.getValue());
        }
        return target;
    }

    protected boolean isSuccess(Response response) {
        int responseStatus = response.getStatus();
        return responseStatus == 200 || responseStatus == 201;
    }

    protected boolean isNew() {
        return this.isNew;
    }

    protected void setIsNew() {
        this.isNew = true;
    }

    protected synchronized void initialize() {
        if (!this.initialized) {
            Response clientResponse = this.client.target(this.getRestUrl()).request(RESPONSE_TYPE).get(Response.class);
            Map<String, Object> responseMap = Util.processJsonMap(clientResponse.readEntity(String.class));
            this.status = clientResponse.getStatus();
            this.getEntityValues(responseMap);
            this.getChildren(responseMap);
            this.initialized = true;
        }
    }

    protected <T> T getValue(String key, Class<T> clazz) {
        this.initialize();
        Object retValue = null;
        Object value = this.entityValues.get(key);
        if (value != null && !value.equals(JSONObject.NULL)) {
            retValue = value;
        }
        return (T)retValue;
    }

    protected <T> void setValue(String key, T value) {
        this.initialize();
        this.entityValues.put(key, value);
    }

    protected Map<String, String> getEntityMetadata(Map<String, Object> extraProperties) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        List methods = (List)extraProperties.get("methods");
        for (Map entry : methods) {
            Map params;
            if (!"POST".equals(entry.get("name")) || (params = (Map)entry.get("messageParameters")) == null) continue;
            for (Map.Entry param : params.entrySet()) {
                String paramName = (String)param.getKey();
                Map md = (Map)param.getValue();
                metadata.put(paramName, (String)md.get("type"));
            }
        }
        return metadata;
    }

    protected void getEntityValues(Map<String, Object> responseMap) {
        Map entity;
        this.entityValues = new HashMap<String, Object>();
        Map extraProperties = (Map)responseMap.get("extraProperties");
        if (extraProperties != null && (entity = (Map)extraProperties.get("entity")) != null) {
            Map<String, String> metadata = this.getEntityMetadata(extraProperties);
            for (Map.Entry entry : entity.entrySet()) {
                String type2 = metadata.get(entry.getKey());
                Constable value = null;
                value = "int".equals(type2) ? (Constable)Integer.valueOf(Integer.parseInt((String)entry.getValue())) : (Constable)("boolean".equals(type2) ? Boolean.valueOf(Boolean.parseBoolean((String)entry.getValue())) : entry.getValue());
                this.entityValues.put((String)entry.getKey(), value);
            }
        }
    }

    protected void getChildren(Map<String, Object> responseMap) {
        Map childResources;
        this.children = new ArrayList<String>();
        Map extraProperties = (Map)responseMap.get("extraProperties");
        if (extraProperties != null && (childResources = (Map)extraProperties.get("childResources")) != null) {
            for (Map.Entry child : childResources.entrySet()) {
                this.children.add((String)child.getKey());
            }
        }
    }

    private Entity<MultivaluedMap<String, Object>> buildMultivalueMapEntity(Map<String, Object> payload, MediaType type2) {
        return Entity.entity(this.buildMultivalueMap(payload), type2);
    }

    private MultivaluedMap<String, Object> buildMultivalueMap(Map<String, Object> payload) {
        MultivaluedHashMap<String, Object> formData = new MultivaluedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : payload.entrySet()) {
            Object value = entry.getValue();
            if (JSONObject.NULL.equals(value)) {
                value = null;
            } else if (value != null) {
                value = value.toString();
            }
            formData.add(entry.getKey(), value);
        }
        return formData;
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        DELETE;

    }
}

