/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.annotation.Annotation;
import org.glassfish.admin.cli.resources.UniqueResourceNameConstraint;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;

public class UniqueResourceNameValidator
implements ConstraintValidator<UniqueResourceNameConstraint, Resource> {
    Domain domain = null;

    @Override
    public void initialize(UniqueResourceNameConstraint constraint) {
        ServiceLocator habitat = Globals.getDefaultHabitat();
        if (habitat == null) {
            return;
        }
        this.domain = habitat.getService(Domain.class, new Annotation[0]);
    }

    @Override
    public boolean isValid(Resource resource, ConstraintValidatorContext constraintValidatorContext) {
        if (this.domain != null && resource.getParent().getParent() instanceof Domain) {
            for (Resource res : this.domain.getResources().getResources()) {
                if (!resource.getIdentity().equals(res.getIdentity())) continue;
                Class<?>[] resourceInterfaces = resource.getClass().getInterfaces();
                Class<?>[] resInterfaces = res.getClass().getInterfaces();
                for (Class<?> resourceClass : resourceInterfaces) {
                    for (Class<?> resClass : resInterfaces) {
                        if (!resClass.getName().equals(resourceClass.getName())) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }
}

