/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.JsonbException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.yasson.internal.ComponentMatcher;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.components.SerializerBinding;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.model.customization.ClassCustomization;
import org.eclipse.yasson.internal.model.customization.ComponentBoundCustomization;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.model.customization.TypeInheritanceConfiguration;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AdapterSerializer;
import org.eclipse.yasson.internal.serializer.ArraySerializer;
import org.eclipse.yasson.internal.serializer.CollectionSerializer;
import org.eclipse.yasson.internal.serializer.CyclicReferenceSerializer;
import org.eclipse.yasson.internal.serializer.KeyWriter;
import org.eclipse.yasson.internal.serializer.MapSerializer;
import org.eclipse.yasson.internal.serializer.ModelSerializer;
import org.eclipse.yasson.internal.serializer.NullSerializer;
import org.eclipse.yasson.internal.serializer.NullVisibilitySwitcher;
import org.eclipse.yasson.internal.serializer.ObjectSerializer;
import org.eclipse.yasson.internal.serializer.OptionalSerializer;
import org.eclipse.yasson.internal.serializer.RecursionChecker;
import org.eclipse.yasson.internal.serializer.UserDefinedSerializer;
import org.eclipse.yasson.internal.serializer.ValueGetterSerializer;
import org.eclipse.yasson.internal.serializer.types.ObjectTypeSerializer;
import org.eclipse.yasson.internal.serializer.types.TypeSerializers;

public class SerializationModelCreator {
    private final Map<Type, ModelSerializer> explicitChain = new ConcurrentHashMap<Type, ModelSerializer>();
    private final Map<Type, ModelSerializer> dynamicChain = new ConcurrentHashMap<Type, ModelSerializer>();
    private final JsonbContext jsonbContext;

    public SerializationModelCreator(JsonbContext jsonbContext) {
        this.jsonbContext = jsonbContext;
    }

    public static ModelSerializer wrapInCommonSet(ModelSerializer modelSerializer, Customization customization, JsonbContext jsonbContext) {
        KeyWriter serializer = new KeyWriter(modelSerializer);
        return new NullSerializer(serializer, customization, jsonbContext);
    }

    public ModelSerializer serializerChain(Type type2, boolean rootValue, boolean resolveRootAdapter) {
        Class<?> rawType = ReflectionUtils.getRawType(type2);
        ClassModel classModel = this.jsonbContext.getMappingContext().getOrCreateClassModel(rawType);
        LinkedList<Type> chain = new LinkedList<Type>();
        return this.serializerChain(chain, type2, classModel.getClassCustomization(), rootValue, false, resolveRootAdapter);
    }

    public ModelSerializer serializerChainRuntime(LinkedList<Type> chain, Type type2, Customization propertyCustomization, boolean rootValue, boolean isKey) {
        if (chain.contains(type2)) {
            return new CyclicReferenceSerializer(type2);
        }
        Class<?> rawType = ReflectionUtils.getRawType(type2);
        Class<?> rawLast = ReflectionUtils.getRawType(chain.getLast());
        if (rawLast.equals(rawType)) {
            return this.serializerChainInternal(chain, chain.getLast(), propertyCustomization, rootValue, isKey, true);
        }
        return this.serializerChainInternal(chain, type2, propertyCustomization, rootValue, isKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelSerializer serializerChain(LinkedList<Type> chain, Type type2, Customization propertyCustomization, boolean rootValue, boolean isKey, boolean resolveRootAdapter) {
        if (chain.contains(type2)) {
            return new CyclicReferenceSerializer(type2);
        }
        try {
            chain.add(type2);
            ModelSerializer modelSerializer = this.serializerChainInternal(chain, type2, propertyCustomization, rootValue, isKey, resolveRootAdapter);
            return modelSerializer;
        }
        finally {
            chain.removeLast();
        }
    }

    private ModelSerializer serializerChainInternal(LinkedList<Type> chain, Type type2, Customization propertyCustomization, boolean rootValue, boolean isKey, boolean resolveRootAdapter) {
        Optional<AdapterBinding> maybeAdapter;
        if (this.explicitChain.containsKey(type2)) {
            return this.explicitChain.get(type2);
        }
        Class<?> rawType = ReflectionUtils.getRawType(type2);
        Optional<ModelSerializer> serializerBinding = this.userSerializer(type2, (ComponentBoundCustomization)((Object)propertyCustomization));
        if (serializerBinding.isPresent()) {
            return serializerBinding.get();
        }
        if (resolveRootAdapter && (maybeAdapter = this.adapterBinding(type2, (ComponentBoundCustomization)((Object)propertyCustomization))).isPresent()) {
            AdapterBinding adapterBinding = maybeAdapter.get();
            Type toType = adapterBinding.getToType();
            Class<?> rawToType = ReflectionUtils.getRawType(toType);
            ModelSerializer typeSerializer = TypeSerializers.getTypeSerializer(rawToType, propertyCustomization, this.jsonbContext);
            if (typeSerializer == null) {
                typeSerializer = this.serializerChain(toType, rootValue, !type2.equals(toType));
            }
            AdapterSerializer adapterSerializer = new AdapterSerializer(adapterBinding, typeSerializer);
            RecursionChecker recursionChecker = new RecursionChecker(adapterSerializer);
            NullSerializer nullSerializer = new NullSerializer(recursionChecker, propertyCustomization, this.jsonbContext);
            this.explicitChain.put(type2, nullSerializer);
            return nullSerializer;
        }
        ModelSerializer typeSerializer = null;
        if (!Object.class.equals(rawType)) {
            typeSerializer = TypeSerializers.getTypeSerializer(chain, rawType, propertyCustomization, this.jsonbContext, isKey);
        }
        if (typeSerializer != null) {
            if (this.jsonbContext.getConfigProperties().isStrictIJson() && rootValue) {
                throw new JsonbException(Messages.getMessage(MessageKeys.IJSON_ENABLED_SINGLE_VALUE, new Object[0]));
            }
            return typeSerializer;
        }
        ClassModel classModel = this.jsonbContext.getMappingContext().getOrCreateClassModel(rawType);
        if (Collection.class.isAssignableFrom(rawType)) {
            return this.createCollectionSerializer(chain, type2, propertyCustomization);
        }
        if (Map.class.isAssignableFrom(rawType)) {
            return this.createMapSerializer(chain, type2, propertyCustomization);
        }
        if (rawType.isArray()) {
            return this.createArraySerializer(chain, rawType, propertyCustomization);
        }
        if (type2 instanceof GenericArrayType) {
            return this.createGenericArraySerializer(chain, type2, propertyCustomization);
        }
        if (Optional.class.equals(rawType)) {
            return this.createOptionalSerializer(chain, type2, propertyCustomization, isKey);
        }
        return this.createObjectSerializer(chain, type2, classModel);
    }

    private ModelSerializer createObjectSerializer(LinkedList<Type> chain, Type type2, ClassModel classModel) {
        LinkedHashMap<String, ModelSerializer> propertySerializers = new LinkedHashMap<String, ModelSerializer>();
        TypeInheritanceConfiguration typeInheritanceConfiguration = classModel.getClassCustomization().getPolymorphismConfig();
        if (typeInheritanceConfiguration != null) {
            this.addPolymorphismProperty(typeInheritanceConfiguration, propertySerializers, classModel);
        }
        for (PropertyModel model : classModel.getSortedProperties()) {
            if (!model.isReadable()) continue;
            String name = model.getWriteName();
            ModelSerializer memberModel = this.memberSerializer(chain, model.getPropertySerializationType(), model.getCustomization(), false);
            propertySerializers.put(name, new ValueGetterSerializer(model.getGetValueHandle(), memberModel));
        }
        ObjectSerializer objectSerializer = new ObjectSerializer(propertySerializers);
        RecursionChecker recursionChecker = new RecursionChecker(objectSerializer);
        KeyWriter keyWriter = new KeyWriter(recursionChecker);
        NullVisibilitySwitcher nullVisibilitySwitcher = new NullVisibilitySwitcher(false, keyWriter);
        NullSerializer nullSerializer = new NullSerializer(nullVisibilitySwitcher, classModel.getClassCustomization(), this.jsonbContext);
        this.explicitChain.put(type2, nullSerializer);
        return nullSerializer;
    }

    private void addPolymorphismProperty(TypeInheritanceConfiguration typeInheritanceConfiguration, LinkedHashMap<String, ModelSerializer> propertySerializers, ClassModel classModel) {
        Class<?> rawType = classModel.getType();
        String alias = typeInheritanceConfiguration.getAliases().get(rawType);
        ModelSerializer serializer = this.createPolymorphismPropertySerializer(typeInheritanceConfiguration, alias);
        if (!(typeInheritanceConfiguration.isInherited() && alias == null || typeInheritanceConfiguration.getParentConfig() == null)) {
            this.addParentPolymorphismProperty(typeInheritanceConfiguration.getParentConfig(), propertySerializers, classModel);
        }
        if (serializer != null) {
            propertySerializers.put(typeInheritanceConfiguration.getFieldName(), serializer);
        }
        for (PropertyModel propertyModel : classModel.getSortedProperties()) {
            if (!propertySerializers.containsKey(propertyModel.getWriteName())) continue;
            throw new JsonbException("CHANGE naming conflict!");
        }
    }

    private void addParentPolymorphismProperty(TypeInheritanceConfiguration typeInheritanceConfiguration, LinkedHashMap<String, ModelSerializer> propertySerializers, ClassModel classModel) {
        Class<?> rawType = classModel.getType();
        TypeInheritanceConfiguration current = typeInheritanceConfiguration;
        LinkedHashMap<String, ModelSerializer> toBeAdded = new LinkedHashMap<String, ModelSerializer>();
        while (current != null) {
            TypeInheritanceConfiguration local = current;
            String alias = local.getAliases().entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(rawType)).map(Map.Entry::getValue).findFirst().orElse(null);
            if (alias == null) continue;
            ModelSerializer serializer = this.createPolymorphismPropertySerializer(local, alias);
            toBeAdded.put(current.getFieldName(), serializer);
            current = current.getParentConfig();
        }
        ListIterator iterator = new ArrayList(toBeAdded.entrySet()).listIterator(toBeAdded.size());
        while (iterator.hasPrevious()) {
            Map.Entry entry2 = iterator.previous();
            propertySerializers.put((String)entry2.getKey(), (ModelSerializer)entry2.getValue());
        }
    }

    private ModelSerializer createPolymorphismPropertySerializer(TypeInheritanceConfiguration configuration, String alias) {
        if (alias != null) {
            return (value, generator, context) -> generator.write(configuration.getFieldName(), alias);
        }
        return null;
    }

    private ModelSerializer createCollectionSerializer(LinkedList<Type> chain, Type type2, Customization customization) {
        Class<Object> colType = type2 instanceof ParameterizedType ? ((ParameterizedType)type2).getActualTypeArguments()[0] : Object.class;
        Type resolvedKey = ReflectionUtils.resolveType(chain, colType);
        Class<?> rawClass = ReflectionUtils.getRawType(resolvedKey);
        ClassModel classModel = this.jsonbContext.getMappingContext().getOrCreateClassModel(rawClass);
        ModelSerializer typeSerializer = this.memberSerializer(chain, (Type)((Object)colType), classModel.getClassCustomization(), false);
        CollectionSerializer collectionSerializer = new CollectionSerializer(typeSerializer);
        KeyWriter keyWriter = new KeyWriter(collectionSerializer);
        NullVisibilitySwitcher nullVisibilitySwitcher = new NullVisibilitySwitcher(true, keyWriter);
        return new NullSerializer(nullVisibilitySwitcher, customization, this.jsonbContext);
    }

    private ModelSerializer createMapSerializer(LinkedList<Type> chain, Type type2, Customization propertyCustomization) {
        Class<Object> keyType = type2 instanceof ParameterizedType ? ((ParameterizedType)type2).getActualTypeArguments()[0] : Object.class;
        Class<Object> valueType = type2 instanceof ParameterizedType ? ((ParameterizedType)type2).getActualTypeArguments()[1] : Object.class;
        Type resolvedKey = ReflectionUtils.resolveType(chain, keyType);
        Class<?> rawClass = ReflectionUtils.getRawType(resolvedKey);
        ModelSerializer keySerializer = this.memberSerializer(chain, (Type)((Object)keyType), ClassCustomization.empty(), true);
        ModelSerializer valueSerializer = this.memberSerializer(chain, (Type)((Object)valueType), propertyCustomization, false);
        MapSerializer mapSerializer = MapSerializer.create(rawClass, keySerializer, valueSerializer);
        KeyWriter keyWriter = new KeyWriter(mapSerializer);
        NullVisibilitySwitcher nullVisibilitySwitcher = new NullVisibilitySwitcher(true, keyWriter);
        return new NullSerializer(nullVisibilitySwitcher, propertyCustomization, this.jsonbContext);
    }

    private ModelSerializer createArraySerializer(LinkedList<Type> chain, Class<?> raw, Customization propertyCustomization) {
        Class<?> arrayComponent = raw.getComponentType();
        ModelSerializer modelSerializer = this.memberSerializer(chain, arrayComponent, propertyCustomization, false);
        ModelSerializer arraySerializer = ArraySerializer.create(raw, this.jsonbContext, modelSerializer);
        KeyWriter keyWriter = new KeyWriter(arraySerializer);
        NullVisibilitySwitcher nullVisibilitySwitcher = new NullVisibilitySwitcher(true, keyWriter);
        return new NullSerializer(nullVisibilitySwitcher, propertyCustomization, this.jsonbContext);
    }

    private ModelSerializer createGenericArraySerializer(LinkedList<Type> chain, Type type2, Customization propertyCustomization) {
        Class<?> raw = ReflectionUtils.getRawType(type2);
        Class<?> component = ReflectionUtils.getRawType(((GenericArrayType)type2).getGenericComponentType());
        ModelSerializer modelSerializer = this.memberSerializer(chain, component, propertyCustomization, false);
        ModelSerializer arraySerializer = ArraySerializer.create(raw, this.jsonbContext, modelSerializer);
        KeyWriter keyWriter = new KeyWriter(arraySerializer);
        NullVisibilitySwitcher nullVisibilitySwitcher = new NullVisibilitySwitcher(true, keyWriter);
        return new NullSerializer(nullVisibilitySwitcher, propertyCustomization, this.jsonbContext);
    }

    private ModelSerializer createOptionalSerializer(LinkedList<Type> chain, Type type2, Customization propertyCustomization, boolean isKey) {
        Class<Object> optType = type2 instanceof ParameterizedType ? ((ParameterizedType)type2).getActualTypeArguments()[0] : Object.class;
        ModelSerializer modelSerializer = this.memberSerializer(chain, (Type)((Object)optType), propertyCustomization, isKey);
        return new OptionalSerializer(modelSerializer);
    }

    private ModelSerializer memberSerializer(LinkedList<Type> chain, Type type2, Customization customization, boolean key) {
        Type resolved = ReflectionUtils.resolveType(chain, type2);
        Class<?> rawType = ReflectionUtils.getRawType(resolved);
        Optional<ModelSerializer> serializerBinding = this.userSerializer(resolved, (ComponentBoundCustomization)((Object)customization));
        if (serializerBinding.isPresent()) {
            return serializerBinding.get();
        }
        Optional<AdapterBinding> maybeAdapter = this.adapterBinding(resolved, (ComponentBoundCustomization)((Object)customization));
        if (maybeAdapter.isPresent()) {
            AdapterBinding adapterBinding = maybeAdapter.get();
            Type toType = adapterBinding.getToType();
            Class<?> rawToType = ReflectionUtils.getRawType(toType);
            ModelSerializer typeSerializer = TypeSerializers.getTypeSerializer(rawToType, customization, this.jsonbContext);
            if (typeSerializer == null) {
                typeSerializer = this.serializerChain(toType, false, true);
            }
            AdapterSerializer adapterSerializer = new AdapterSerializer(adapterBinding, typeSerializer);
            return new NullSerializer(adapterSerializer, customization, this.jsonbContext);
        }
        ModelSerializer typeSerializer = TypeSerializers.getTypeSerializer(chain, rawType, customization, this.jsonbContext, key);
        if (typeSerializer == null) {
            boolean isFinal = Modifier.isFinal(rawType.getModifiers());
            if (isFinal || Collection.class.isAssignableFrom(rawType) || Map.class.isAssignableFrom(rawType)) {
                return this.serializerChain(chain, resolved, customization, false, key, true);
            }
            if (this.dynamicChain.containsKey(resolved)) {
                return this.dynamicChain.get(resolved);
            }
            boolean isAbstract = Modifier.isAbstract(rawType.getModifiers());
            ModelSerializer specificTypeSerializer = null;
            if (!isAbstract && !rawType.equals(Object.class)) {
                specificTypeSerializer = this.explicitChain.containsKey(resolved) ? this.explicitChain.get(resolved) : this.serializerChain(chain, resolved, customization, false, key, true);
            }
            if (resolved instanceof Class) {
                typeSerializer = TypeSerializers.getTypeSerializer(chain, Object.class, customization, this.jsonbContext, key);
            } else {
                chain.add(resolved);
                typeSerializer = TypeSerializers.getTypeSerializer(chain, Object.class, customization, this.jsonbContext, key);
                chain.removeLast();
            }
            if (specificTypeSerializer != null && typeSerializer instanceof ObjectTypeSerializer) {
                ((ObjectTypeSerializer)typeSerializer).addSpecificSerializer(rawType, specificTypeSerializer);
            }
            if (!key) {
                typeSerializer = new NullSerializer(typeSerializer, customization, this.jsonbContext);
            }
            this.dynamicChain.put(type2, typeSerializer);
        }
        if (!key && typeSerializer instanceof ObjectTypeSerializer) {
            typeSerializer = new NullSerializer(typeSerializer, customization, this.jsonbContext);
        }
        return typeSerializer;
    }

    private Optional<ModelSerializer> userSerializer(Type type2, ComponentBoundCustomization classCustomization) {
        ComponentMatcher componentMatcher = this.jsonbContext.getComponentMatcher();
        return componentMatcher.getSerializerBinding(type2, classCustomization).map(SerializerBinding::getJsonbSerializer).map(UserDefinedSerializer::new).map(RecursionChecker::new).map(serializer -> SerializationModelCreator.wrapInCommonSet(serializer, (Customization)((Object)classCustomization), this.jsonbContext));
    }

    private Optional<AdapterBinding> adapterBinding(Type type2, ComponentBoundCustomization classCustomization) {
        return this.jsonbContext.getComponentMatcher().getSerializeAdapterBinding(type2, classCustomization);
    }
}

