/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import jakarta.json.bind.JsonbException;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ProcessingContext;
import org.eclipse.yasson.internal.deserializer.ModelDeserializer;
import org.eclipse.yasson.internal.model.customization.ClassCustomization;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

public class DeserializationContextImpl
extends ProcessingContext
implements DeserializationContext {
    private final List<Runnable> delayedSetters = new ArrayList<Runnable>();
    private JsonParser.Event lastValueEvent;
    private Customization customization = ClassCustomization.empty();
    private Object instance;

    public DeserializationContextImpl(JsonbContext jsonbContext) {
        super(jsonbContext);
    }

    public DeserializationContextImpl(DeserializationContextImpl context) {
        super(context.getJsonbContext());
        this.lastValueEvent = context.lastValueEvent;
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    public List<Runnable> getDeferredDeserializers() {
        return this.delayedSetters;
    }

    public JsonParser.Event getLastValueEvent() {
        return this.lastValueEvent;
    }

    public void setLastValueEvent(JsonParser.Event lastValueEvent) {
        this.lastValueEvent = lastValueEvent;
    }

    public Customization getCustomization() {
        return this.customization;
    }

    public void setCustomization(Customization customization) {
        this.customization = customization;
    }

    @Override
    public <T> T deserialize(Class<T> clazz, JsonParser parser) {
        return this.deserializeItem(clazz, parser);
    }

    @Override
    public <T> T deserialize(Type type2, JsonParser parser) {
        return this.deserializeItem(type2, parser);
    }

    private <T> T deserializeItem(Type type2, JsonParser parser) {
        try {
            if (this.lastValueEvent == null) {
                this.lastValueEvent = parser.next();
                this.checkState();
            }
            ModelDeserializer<JsonParser> modelDeserializer = this.getJsonbContext().getChainModelCreator().deserializerChain(type2);
            return (T)modelDeserializer.deserialize(parser, this);
        }
        catch (JsonbException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, e.getMessage()), e);
        }
    }

    private void checkState() {
        if (this.lastValueEvent == JsonParser.Event.KEY_NAME) {
            throw new JsonbException("JsonParser has incorrect position as the first event: KEY_NAME");
        }
    }
}

