/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.transaction;

import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.transaction.AbstractSynchronizationListener;
import org.eclipse.persistence.transaction.JTATransactionController;

public class JTA11TransactionController
extends JTATransactionController {
    public static final String JNDI_TRANSACTION_SYNCHRONIZATION_REGISTRY = "java:comp/TransactionSynchronizationRegistry";
    protected static TransactionSynchronizationRegistry defaultTsr;
    protected TransactionSynchronizationRegistry tsr;

    public static TransactionSynchronizationRegistry getDefaultTransactionSynchronizationRegistry() {
        return defaultTsr;
    }

    public static void setDefaultTransactionSynchronizationRegistry(TransactionSynchronizationRegistry tsr) {
        defaultTsr = tsr;
    }

    public JTA11TransactionController() {
        try {
            this.tsr = this.acquireTransactionSynchronizationRegistry();
        }
        catch (Exception ex) {
            throw TransactionException.errorObtainingTsr(ex);
        }
    }

    public JTA11TransactionController(TransactionSynchronizationRegistry supplTsr, TransactionManager supplTm) {
        super(supplTm);
        this.tsr = supplTsr;
    }

    protected TransactionSynchronizationRegistry acquireTransactionSynchronizationRegistry() {
        if (defaultTsr != null) {
            return defaultTsr;
        }
        try {
            return (TransactionSynchronizationRegistry)this.jndiLookup(JNDI_TRANSACTION_SYNCHRONIZATION_REGISTRY);
        }
        catch (TransactionException ex) {
            this.session.log(6, "transaction", "jta_tsr_lookup_failure", ex.getLocalizedMessage());
            return null;
        }
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.tsr;
    }

    public void setTransactionManager(TransactionSynchronizationRegistry supplTsr) {
        this.tsr = supplTsr;
    }

    @Override
    protected void registerSynchronization_impl(AbstractSynchronizationListener listener, Object txn) throws Exception {
        this.tsr.registerInterposedSynchronization(listener);
    }

    @Override
    protected Object getTransactionKey_impl(Object transaction) throws Exception {
        return this.tsr.getTransactionKey();
    }

    @Override
    protected Object getTransactionStatus_impl() throws Exception {
        return this.tsr.getTransactionStatus();
    }

    @Override
    protected void markTransactionForRollback_impl() throws Exception {
        this.tsr.setRollbackOnly();
    }

    @Override
    public boolean isRolledBack_impl(Object status) {
        return this.tsr.getRollbackOnly();
    }
}

