/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.json;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonValue;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.json.JsonPlatform;

public class Oracle21JsonPlatform
extends JsonPlatform {
    private static final String JSON_DEFAULT_TYPE = "JSON";
    private final OracleJsonFactory factory = new OracleJsonFactory();

    public void updateClassTypes(Map<String, Class<?>> classTypeMapping) {
        classTypeMapping.put(JSON_DEFAULT_TYPE, JsonValue.class);
    }

    public void updateFieldTypes(Hashtable<Class<?>, FieldTypeDefinition> fieldTypeMapping) {
        fieldTypeMapping.put(JsonObject.class, new FieldTypeDefinition(JSON_DEFAULT_TYPE));
        fieldTypeMapping.put(JsonArray.class, new FieldTypeDefinition(JSON_DEFAULT_TYPE));
        fieldTypeMapping.put(JsonValue.class, new FieldTypeDefinition(JSON_DEFAULT_TYPE));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T convertJsonValueToDataValue(JsonValue jsonValue) throws PersistenceException {
        if (jsonValue == null) {
            return null;
        }
        StringWriter sw = new StringWriter(128);
        try (JsonWriter jw = Json.createWriter(sw);){
            jw.write(jsonValue);
        }
        try (StringReader jr = new StringReader(sw.toString());){
            OracleJsonValue oracleJsonValue = this.factory.createJsonTextValue((Reader)jr);
            return (T)oracleJsonValue;
        }
        catch (IOException e) {
            throw new PersistenceException(ExceptionLocalization.buildMessage("json_ora21c_jsonvalue_to_oraclevalue"), e);
        }
    }

    public JsonValue convertDataValueToJsonValue(Object jdbcValue) {
        if (jdbcValue == null) {
            return null;
        }
        if (jdbcValue instanceof JsonValue) {
            return (JsonValue)jdbcValue;
        }
        if (jdbcValue instanceof OracleJsonValue) {
            try (JsonReader jr = Json.createReader(new StringReader(jdbcValue.toString()));){
                JsonValue jsonValue = jr.readValue();
                return jsonValue;
            }
        }
        throw new PersistenceException(ExceptionLocalization.buildMessage("json_ora21c_resultset_to_jsonvalue"));
    }

    public <T> T getJsonDataFromResultSet(ResultSet resultSet, int columnNumber, Class<T> type2) throws SQLException {
        return type2.cast(resultSet.getObject(columnNumber, OracleJsonValue.class));
    }
}

