/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;
import org.eclipse.persistence.internal.core.helper.CoreField;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XMLMarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.oxm.record.ContentHandlerRecord;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidatingMarshalRecord
extends MarshalRecord<Marshaller> {
    private MarshalRecord marshalRecord;
    private ContentHandlerRecord validatingRecord;

    public ValidatingMarshalRecord(MarshalRecord marshalRecord, XMLMarshaller xmlMarshaller) {
        this.marshalRecord = marshalRecord;
        Schema schema = xmlMarshaller.getSchema();
        ValidatorHandler validatorHandler = schema.newValidatorHandler();
        validatorHandler.setErrorHandler(new ValidatingMarshalRecordErrorHandler(marshalRecord, xmlMarshaller.getErrorHandler()));
        if (xmlMarshaller.isFragment()) {
            try {
                validatorHandler.startDocument();
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        this.validatingRecord = new ContentHandlerRecord();
        this.validatingRecord.setMarshaller(xmlMarshaller);
        this.validatingRecord.setContentHandler(validatorHandler);
        this.validatingRecord.setEqualNamespaceResolvers(marshalRecord.hasEqualNamespaceResolvers());
    }

    @Override
    public void startDocument(String encoding, String version) {
        this.validatingRecord.startDocument(encoding, version);
        this.marshalRecord.startDocument(encoding, version);
    }

    @Override
    public void endDocument() {
        this.validatingRecord.endDocument();
        this.marshalRecord.endDocument();
    }

    @Override
    public void element(XPathFragment frag) {
        this.validatingRecord.element(frag);
        this.marshalRecord.element(frag);
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        this.validatingRecord.attribute(xPathFragment, namespaceResolver, value);
        this.marshalRecord.attribute(xPathFragment, namespaceResolver, value);
    }

    @Override
    public void attribute(String namespaceURI, String localName, String qName, String value) {
        this.validatingRecord.attribute(namespaceURI, localName, qName, value);
        this.marshalRecord.attribute(namespaceURI, localName, qName, value);
    }

    @Override
    public void closeStartElement() {
        this.validatingRecord.closeStartElement();
        this.marshalRecord.closeStartElement();
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.validatingRecord.endElement(xPathFragment, namespaceResolver);
        this.marshalRecord.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public HashMap getPositionalNodes() {
        return this.marshalRecord.getPositionalNodes();
    }

    @Override
    public void addGroupingElement(XPathNode xPathNode) {
        this.validatingRecord.addGroupingElement(xPathNode);
        this.marshalRecord.addGroupingElement(xPathNode);
    }

    @Override
    public void removeGroupingElement(XPathNode xPathNode) {
        this.validatingRecord.removeGroupingElement(xPathNode);
        this.marshalRecord.removeGroupingElement(xPathNode);
    }

    @Override
    public void add(CoreField key, Object value) {
        this.validatingRecord.add(key, value);
        this.marshalRecord.add(key, value);
    }

    @Override
    public Object put(CoreField key, Object value) {
        this.validatingRecord.put(key, value);
        return this.marshalRecord.put(key, value);
    }

    @Override
    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
        this.validatingRecord.namespaceDeclarations(namespaceResolver);
        this.marshalRecord.namespaceDeclarations(namespaceResolver);
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) {
        this.validatingRecord.startPrefixMapping(prefix, namespaceURI);
        this.marshalRecord.startPrefixMapping(prefix, namespaceURI);
    }

    @Override
    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        this.validatingRecord.startPrefixMappings(namespaceResolver);
        this.marshalRecord.startPrefixMappings(namespaceResolver);
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.validatingRecord.endPrefixMapping(prefix);
        this.marshalRecord.endPrefixMapping(prefix);
    }

    @Override
    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
        this.validatingRecord.endPrefixMappings(namespaceResolver);
        this.marshalRecord.endPrefixMappings(namespaceResolver);
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.validatingRecord.openStartElement(xPathFragment, namespaceResolver);
        this.marshalRecord.openStartElement(xPathFragment, namespaceResolver);
    }

    @Override
    public XPathFragment openStartGroupingElements(NamespaceResolver namespaceResolver) {
        this.validatingRecord.openStartGroupingElements(namespaceResolver);
        return this.marshalRecord.openStartGroupingElements(namespaceResolver);
    }

    @Override
    public void closeStartGroupingElements(XPathFragment groupingFragment) {
        this.validatingRecord.closeStartGroupingElements(groupingFragment);
        this.marshalRecord.closeStartGroupingElements(groupingFragment);
    }

    @Override
    protected void addPositionalNodes(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.validatingRecord.addPositionalNodes(xPathFragment, namespaceResolver);
        this.marshalRecord.addPositionalNodes(xPathFragment, namespaceResolver);
    }

    @Override
    public void characters(String value) {
        this.validatingRecord.characters(value);
        this.marshalRecord.characters(value);
    }

    @Override
    public void cdata(String value) {
        this.validatingRecord.cdata(value);
        this.marshalRecord.cdata(value);
    }

    @Override
    public void node(Node node, NamespaceResolver resolver, String uri, String name) {
        this.validatingRecord.node(node, resolver, uri, name);
        this.marshalRecord.node(node, resolver, uri, name);
    }

    @Override
    public String getLocalName() {
        return this.marshalRecord.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.marshalRecord.getNamespaceURI();
    }

    @Override
    public void clear() {
        this.validatingRecord.clear();
        this.marshalRecord.clear();
    }

    @Override
    public Document getDocument() {
        return this.marshalRecord.getDocument();
    }

    @Override
    public Node getDOM() {
        return this.marshalRecord.getDOM();
    }

    @Override
    public String transformToXML() {
        return this.marshalRecord.transformToXML();
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        return this.marshalRecord.resolveNamespacePrefix(prefix);
    }

    @Override
    public Marshaller getMarshaller() {
        return this.marshalRecord.getMarshaller();
    }

    @Override
    public void setMarshaller(Marshaller marshaller) {
        super.setMarshaller(marshaller);
        this.validatingRecord.setMarshaller(marshaller);
        this.marshalRecord.setMarshaller(marshaller);
    }

    @Override
    public Object getOwningObject() {
        return this.marshalRecord.getOwningObject();
    }

    @Override
    public void setOwningObject(Object obj) {
        this.validatingRecord.setOwningObject(obj);
        this.marshalRecord.setOwningObject(obj);
    }

    @Override
    public void setLeafElementType(QName type2) {
        this.validatingRecord.setLeafElementType(type2);
        this.marshalRecord.setLeafElementType(type2);
    }

    @Override
    public void setNamespaceResolver(NamespaceResolver nr) {
        this.validatingRecord.setNamespaceResolver(nr);
        this.marshalRecord.setNamespaceResolver(nr);
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.marshalRecord.getNamespaceResolver();
    }

    @Override
    public CoreAbstractSession getSession() {
        return this.marshalRecord.getSession();
    }

    @Override
    public void setSession(CoreAbstractSession session) {
        super.setSession(session);
        this.validatingRecord.setSession(session);
        this.marshalRecord.setSession(session);
    }

    @Override
    public boolean isXOPPackage() {
        return this.marshalRecord.isXOPPackage();
    }

    @Override
    public void beforeContainmentMarshal(Object child) {
        this.marshalRecord.beforeContainmentMarshal(child);
    }

    @Override
    public void afterContainmentMarshal(Object parent, Object child) {
        this.marshalRecord.afterContainmentMarshal(parent, child);
    }

    @Override
    public void writeHeader() {
        this.marshalRecord.writeHeader();
    }

    @Override
    public List<Namespace> addExtraNamespacesToNamespaceResolver(Descriptor descriptor, CoreAbstractSession session, boolean allowOverride, boolean ignoreEqualResolvers) {
        this.validatingRecord.addExtraNamespacesToNamespaceResolver(descriptor, session, allowOverride, ignoreEqualResolvers);
        return this.marshalRecord.addExtraNamespacesToNamespaceResolver(descriptor, session, allowOverride, ignoreEqualResolvers);
    }

    @Override
    public void removeExtraNamespacesFromNamespaceResolver(List<Namespace> extraNamespaces, CoreAbstractSession session) {
        this.validatingRecord.removeExtraNamespacesFromNamespaceResolver(extraNamespaces, session);
        this.marshalRecord.removeExtraNamespacesFromNamespaceResolver(extraNamespaces, session);
    }

    @Override
    public void attributeWithoutQName(String namespaceURI, String localName, String prefix, String value) {
        this.validatingRecord.attributeWithoutQName(namespaceURI, localName, prefix, value);
        this.marshalRecord.attributeWithoutQName(namespaceURI, localName, prefix, value);
    }

    @Override
    public boolean addXsiTypeAndClassIndicatorIfRequired(Descriptor xmlDescriptor, Descriptor referenceDescriptor, Field xmlField, boolean isRootElement) {
        this.validatingRecord.addXsiTypeAndClassIndicatorIfRequired(xmlDescriptor, referenceDescriptor, xmlField, isRootElement);
        return this.marshalRecord.addXsiTypeAndClassIndicatorIfRequired(xmlDescriptor, referenceDescriptor, xmlField, isRootElement);
    }

    @Override
    public boolean addXsiTypeAndClassIndicatorIfRequired(Descriptor xmlDescriptor, Descriptor referenceDescriptor, Field xmlField, Object originalObject, Object obj, boolean wasXMLRoot, boolean isRootElement) {
        this.validatingRecord.setNamespaceResolver(new NamespaceResolver((NamespaceResolver)this.marshalRecord.getNamespaceResolver()));
        this.validatingRecord.addXsiTypeAndClassIndicatorIfRequired(xmlDescriptor, referenceDescriptor, xmlField, originalObject, obj, wasXMLRoot, isRootElement);
        return this.marshalRecord.addXsiTypeAndClassIndicatorIfRequired(xmlDescriptor, referenceDescriptor, xmlField, originalObject, obj, wasXMLRoot, isRootElement);
    }

    @Override
    public void writeXsiTypeAttribute(Descriptor descriptor, String typeUri, String typeLocal, String typePrefix, boolean addToNamespaceResolver) {
        this.validatingRecord.writeXsiTypeAttribute(descriptor, typeUri, typeLocal, typePrefix, addToNamespaceResolver);
        this.marshalRecord.writeXsiTypeAttribute(descriptor, typeUri, typeLocal, typePrefix, addToNamespaceResolver);
    }

    @Override
    public void writeXsiTypeAttribute(Descriptor xmlDescriptor, XMLSchemaReference xmlRef, boolean addToNamespaceResolver) {
        this.validatingRecord.writeXsiTypeAttribute(xmlDescriptor, xmlRef, addToNamespaceResolver);
        this.marshalRecord.writeXsiTypeAttribute(xmlDescriptor, xmlRef, addToNamespaceResolver);
    }

    @Override
    public void setXOPPackage(boolean isXOPPackage) {
        this.validatingRecord.setXOPPackage(isXOPPackage);
        this.marshalRecord.setXOPPackage(isXOPPackage);
    }

    private static class ValidatingMarshalRecordErrorHandler
    implements ErrorHandler {
        private MarshalRecord marshalRecord;
        private ErrorHandler errorHandler;

        public ValidatingMarshalRecordErrorHandler(MarshalRecord marshalRecord, ErrorHandler errorHandler) {
            this.marshalRecord = marshalRecord;
            this.errorHandler = errorHandler;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (null == this.errorHandler) {
                throw exception;
            }
            this.errorHandler.warning(this.marshalSAXParseException(exception));
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (null == this.errorHandler) {
                throw exception;
            }
            this.errorHandler.error(this.marshalSAXParseException(exception));
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            if (null == this.errorHandler) {
                throw exception;
            }
            this.errorHandler.fatalError(this.marshalSAXParseException(exception));
        }

        private MarshalSAXParseException marshalSAXParseException(SAXParseException exception) {
            return new MarshalSAXParseException(exception.getLocalizedMessage(), exception.getPublicId(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getException(), this.marshalRecord.getOwningObject());
        }
    }

    public static class MarshalSAXParseException
    extends SAXParseException {
        private Object object;

        public MarshalSAXParseException(String message, String publicId, String systemId, int lineNumber, int columnNumber, Exception e, Object object) {
            super(message, publicId, systemId, lineNumber, columnNumber, e);
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

