/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.xjc;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaClassImpl;

public class XJCJavaMethodImpl
implements JavaMethod {
    private JMethod xjcMethod;
    private JCodeModel jCodeModel;
    private DynamicClassLoader dynamicClassLoader;
    private JavaClass owningClass;

    public XJCJavaMethodImpl(JMethod javaMethod, JCodeModel codeModel, DynamicClassLoader loader, JavaClass owner) {
        this.xjcMethod = javaMethod;
        this.jCodeModel = codeModel;
        this.dynamicClassLoader = loader;
        this.owningClass = owner;
    }

    @Override
    public JavaAnnotation getAnnotation(JavaClass aClass) {
        if (aClass != null) {
            Collection annotations = this.xjcMethod.annotations();
            for (JAnnotationUse annotationUse : annotations) {
                XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
                if (!xjcAnnotation.getJavaAnnotationClass().getCanonicalName().equals(aClass.getQualifiedName())) continue;
                return xjcAnnotation;
            }
            return null;
        }
        return null;
    }

    @Override
    public Collection<JavaAnnotation> getAnnotations() {
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>();
        Collection annotations = this.xjcMethod.annotations();
        for (JAnnotationUse annotationUse : annotations) {
            XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
            annotationsList.add(xjcAnnotation);
        }
        return annotationsList;
    }

    @Override
    public String getName() {
        return this.xjcMethod.name();
    }

    @Override
    public JavaClass[] getParameterTypes() {
        JType[] params = this.xjcMethod.listParamTypes();
        JavaClass[] paramArray = new JavaClass[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramArray[i] = ((XJCJavaClassImpl)this.getOwningClass()).getJavaModel() != null ? ((XJCJavaClassImpl)this.getOwningClass()).getJavaModel().getClass(params[i].fullName()) : new XJCJavaClassImpl((JDefinedClass)params[i], this.jCodeModel, this.dynamicClassLoader);
        }
        return paramArray;
    }

    public JavaClass getResolvedType() {
        if (((XJCJavaClassImpl)this.getOwningClass()).getJavaModel() != null) {
            return ((XJCJavaClassImpl)this.getOwningClass()).getJavaModel().getClass(this.xjcMethod.type().fullName());
        }
        try {
            return new XJCJavaClassImpl(this.jCodeModel._class(this.xjcMethod.type().fullName()), this.jCodeModel, this.dynamicClassLoader);
        }
        catch (JClassAlreadyExistsException ex) {
            return new XJCJavaClassImpl(this.jCodeModel._getClass(this.xjcMethod.type().fullName()), this.jCodeModel, this.dynamicClassLoader);
        }
    }

    @Override
    public JavaClass getReturnType() {
        JClass jcl;
        JType type2 = this.xjcMethod.type();
        JavaClass returnClass = null;
        if (((XJCJavaClassImpl)this.getOwningClass()).getJavaModel() != null) {
            returnClass = ((XJCJavaClassImpl)this.getOwningClass()).getJavaModel().getClass(type2.fullName());
        } else {
            try {
                returnClass = new XJCJavaClassImpl(this.jCodeModel._class(type2.fullName()), this.jCodeModel, this.dynamicClassLoader);
            }
            catch (JClassAlreadyExistsException ex) {
                returnClass = new XJCJavaClassImpl(this.jCodeModel._getClass(type2.fullName()), this.jCodeModel, this.dynamicClassLoader);
            }
        }
        if (type2 instanceof JClass && (jcl = (JClass)type2).isParameterized()) {
            List args = jcl.getTypeParameters();
            JClass arg = (JClass)args.get(0);
            JavaClass argClass = ((XJCJavaClassImpl)this.getOwningClass()).getJavaModel().getClass(arg.fullName());
            ((XJCJavaClassImpl)returnClass).setActualTypeArgument(argClass);
        }
        return returnClass;
    }

    public boolean hasActualTypeArguments() {
        try {
            JavaClass[] allParams;
            for (JavaClass type2 : allParams = this.getParameterTypes()) {
                Class<?> paramClass = Class.forName(type2.getPackageName() + "." + type2.getName());
                if (!(paramClass.getConstructor(new Class[0]).newInstance(new Object[0]) instanceof ParameterizedType)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Collection<Object> getActualTypeArguments() {
        throw new UnsupportedOperationException("getActualTypeArguments");
    }

    @Override
    public int getModifiers() {
        return this.xjcMethod.mods().getValue();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public JavaAnnotation getDeclaredAnnotation(JavaClass arg0) {
        throw new UnsupportedOperationException("getDeclaredAnnotation");
    }

    @Override
    public Collection<JavaAnnotation> getDeclaredAnnotations() {
        throw new UnsupportedOperationException("getDeclaredAnnotations");
    }

    @Override
    public JavaClass getOwningClass() {
        return this.owningClass;
    }

    public void setOwningClass(JavaClass owningClass) {
        this.owningClass = owningClass;
    }

    @Override
    public boolean isBridge() {
        return false;
    }
}

