/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessorOrder;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttachmentRef;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementDecl;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlInlineBinaryData;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlMimeType;
import jakarta.xml.bind.annotation.XmlMixed;
import jakarta.xml.bind.annotation.XmlNs;
import jakarta.xml.bind.annotation.XmlNsForm;
import jakarta.xml.bind.annotation.XmlSchema;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSchemaTypes;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.asm.ASMFactory;
import org.eclipse.persistence.asm.AnnotationVisitor;
import org.eclipse.persistence.asm.ClassWriter;
import org.eclipse.persistence.asm.EclipseLinkASMClassWriter;
import org.eclipse.persistence.asm.FieldVisitor;
import org.eclipse.persistence.asm.Label;
import org.eclipse.persistence.asm.MethodVisitor;
import org.eclipse.persistence.asm.Opcodes;
import org.eclipse.persistence.asm.Type;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jaxb.AccessorFactoryWrapper;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.jaxb.many.ArrayValue;
import org.eclipse.persistence.internal.jaxb.many.CollectionValue;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.jaxb.many.MultiDimensionalArrayValue;
import org.eclipse.persistence.internal.jaxb.many.MultiDimensionalCollectionValue;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.MOXySystemProperties;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.JAXBMetadataLogger;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.PackageInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.jaxb.compiler.XMLProcessor;
import org.eclipse.persistence.jaxb.compiler.XmlNillableInfo;
import org.eclipse.persistence.jaxb.compiler.facets.DecimalMaxFacet;
import org.eclipse.persistence.jaxb.compiler.facets.DecimalMinFacet;
import org.eclipse.persistence.jaxb.compiler.facets.DigitsFacet;
import org.eclipse.persistence.jaxb.compiler.facets.Facet;
import org.eclipse.persistence.jaxb.compiler.facets.MaxFacet;
import org.eclipse.persistence.jaxb.compiler.facets.MinFacet;
import org.eclipse.persistence.jaxb.compiler.facets.PatternFacet;
import org.eclipse.persistence.jaxb.compiler.facets.PatternListFacet;
import org.eclipse.persistence.jaxb.compiler.facets.SizeFacet;
import org.eclipse.persistence.jaxb.javamodel.AnnotationProxy;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaConstructor;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaFieldImpl;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAccessOrder;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAccessType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlIsSetNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlMarshalNullRepresentation;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNamedSubgraph;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransformation;
import org.eclipse.persistence.jaxb.xmlmodel.XmlVirtualAccessMethodsSchema;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLNameTransformer;
import org.eclipse.persistence.oxm.annotations.XmlAccessMethods;
import org.eclipse.persistence.oxm.annotations.XmlCDATA;
import org.eclipse.persistence.oxm.annotations.XmlClassExtractor;
import org.eclipse.persistence.oxm.annotations.XmlCustomizer;
import org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode;
import org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue;
import org.eclipse.persistence.oxm.annotations.XmlElementNillable;
import org.eclipse.persistence.oxm.annotations.XmlElementsJoinNodes;
import org.eclipse.persistence.oxm.annotations.XmlIDExtension;
import org.eclipse.persistence.oxm.annotations.XmlInverseReference;
import org.eclipse.persistence.oxm.annotations.XmlIsSetNullPolicy;
import org.eclipse.persistence.oxm.annotations.XmlJoinNode;
import org.eclipse.persistence.oxm.annotations.XmlJoinNodes;
import org.eclipse.persistence.oxm.annotations.XmlKey;
import org.eclipse.persistence.oxm.annotations.XmlLocation;
import org.eclipse.persistence.oxm.annotations.XmlNameTransformer;
import org.eclipse.persistence.oxm.annotations.XmlNamedAttributeNode;
import org.eclipse.persistence.oxm.annotations.XmlNamedObjectGraph;
import org.eclipse.persistence.oxm.annotations.XmlNamedObjectGraphs;
import org.eclipse.persistence.oxm.annotations.XmlNullPolicy;
import org.eclipse.persistence.oxm.annotations.XmlParameter;
import org.eclipse.persistence.oxm.annotations.XmlPath;
import org.eclipse.persistence.oxm.annotations.XmlPaths;
import org.eclipse.persistence.oxm.annotations.XmlProperties;
import org.eclipse.persistence.oxm.annotations.XmlProperty;
import org.eclipse.persistence.oxm.annotations.XmlReadOnly;
import org.eclipse.persistence.oxm.annotations.XmlReadTransformer;
import org.eclipse.persistence.oxm.annotations.XmlValueExtension;
import org.eclipse.persistence.oxm.annotations.XmlVariableNode;
import org.eclipse.persistence.oxm.annotations.XmlVirtualAccessMethods;
import org.eclipse.persistence.oxm.annotations.XmlWriteOnly;
import org.eclipse.persistence.oxm.annotations.XmlWriteTransformer;
import org.eclipse.persistence.oxm.annotations.XmlWriteTransformers;

public final class AnnotationsProcessor {
    static final String ARRAY_PACKAGE_NAME = "jaxb.dev.java.net.array";
    static final String JAVAX_ACTIVATION_DATAHANDLER = "jakarta.activation.DataHandler";
    static final String JAVAX_MAIL_INTERNET_MIMEMULTIPART = "jakarta.mail.internet.MimeMultipart";
    private static final String AWT_IMAGE = "java.awt.Image";
    private static final String JAVAX_XML_BIND_JAXBELEMENT = "jakarta.xml.bind.JAXBElement";
    private static final String JAVAX_XML_BIND_ANNOTATION = "jakarta.xml.bind.annotation";
    private static final String OXM_ANNOTATIONS = "org.eclipse.persistence.oxm.annotations";
    private static final String TYPE_METHOD_NAME = "type";
    private static final String VALUE_METHOD_NAME = "value";
    private static final String ARRAY_NAMESPACE = "http://jaxb.dev.java.net/array";
    private static final String ARRAY_CLASS_NAME_SUFFIX = "Array";
    private static final String JAXB_DEV = "jaxb.dev.java.net";
    private static final String ORG_W3C_DOM = "org.w3c.dom";
    private static final String CREATE = "create";
    private static final String ELEMENT_DECL_GLOBAL = "jakarta.xml.bind.annotation.XmlElementDecl.GLOBAL";
    private static final String ELEMENT_DECL_DEFAULT = "\u0000";
    private static final String EMPTY_STRING = "";
    private static final String JAVA_UTIL_LIST = "java.util.List";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String SLASH = "/";
    private static final String SEMI_COLON = ";";
    private static final String L = "L";
    private static final String ITEM = "item";
    private static final String IS_STR = "is";
    private static final String GET_STR = "get";
    private static final String SET_STR = "set";
    private static final Character DOT_CHR = Character.valueOf('.');
    private static final Character DOLLAR_SIGN_CHR = Character.valueOf('$');
    private static final Character SLASH_CHR = Character.valueOf('/');
    private List<JavaClass> typeInfoClasses;
    private Map<String, PackageInfo> packageToPackageInfoMappings;
    private HashMap<String, XmlNillableInfo> packageToXmlNillableInfoMappings;
    private Map<String, MarshalCallback> marshalCallbacks;
    private Map<String, QName> userDefinedSchemaTypes;
    private Map<String, TypeInfo> typeInfos;
    private List<QName> typeQNames;
    private Map<String, UnmarshalCallback> unmarshalCallbacks;
    private Map<String, Map<QName, ElementDeclaration>> elementDeclarations;
    private Map<String, ElementDeclaration> xmlRootElements;
    private List<ElementDeclaration> localElements;
    private Map<String, JavaMethod> factoryMethods;
    private Map<String, XmlRegistry> xmlRegistries;
    private List<String> objectFactoryClassNames;
    private List<JavaClass> classesToProcessPropertyTypes;
    private Map<String, Class<?>> arrayClassesToGeneratedClasses;
    private Map<Class<?>, JavaClass> generatedClassesToArrayClasses;
    private Map<java.lang.reflect.Type, Class<?>> collectionClassesToGeneratedClasses;
    private Map<Class<?>, java.lang.reflect.Type> generatedClassesToCollectionClasses;
    private Map<JavaClass, List<TypeMappingInfo>> javaClassToTypeMappingInfos;
    private Map<TypeMappingInfo, Class<?>> typeMappingInfosToGeneratedClasses;
    private Map<TypeMappingInfo, Class<?>> typeMappingInfoToAdapterClasses;
    private Map<TypeMappingInfo, QName> typeMappingInfosToSchemaTypes;
    private Helper helper;
    private String defaultTargetNamespace;
    private JAXBMetadataLogger logger;
    private boolean isDefaultNamespaceAllowed;
    private boolean xmlAccessorFactorySupport;
    private boolean hasSwaRef;
    private List<String> referencedByTransformer;
    private boolean hasXmlBindings = false;
    private boolean facets;

    public AnnotationsProcessor(Helper helper) {
        this.helper = helper;
        this.facets = helper.isFacets();
        this.isDefaultNamespaceAllowed = true;
        this.hasSwaRef = false;
    }

    void postInitialize() {
        this.typeInfoClasses = null;
        this.packageToPackageInfoMappings = null;
        this.typeInfos = null;
        this.typeQNames = null;
        this.elementDeclarations = null;
        this.xmlRootElements = null;
        this.localElements = null;
        this.factoryMethods = null;
        this.xmlRegistries = null;
        this.objectFactoryClassNames = null;
        this.classesToProcessPropertyTypes = null;
        this.javaClassToTypeMappingInfos = null;
        this.typeMappingInfosToGeneratedClasses = null;
        this.typeMappingInfoToAdapterClasses = null;
        this.helper = null;
        this.logger = null;
        this.referencedByTransformer = null;
    }

    void processClassesAndProperties(JavaClass[] classes, TypeMappingInfo[] typeMappingInfos) {
        this.init(classes, typeMappingInfos);
        this.preBuildTypeInfo(classes);
        this.postBuildTypeInfo(classes);
        this.processPropertyTypes(this.typeInfoClasses.toArray(new JavaClass[0]));
        this.finalizeProperties();
        this.createElementsForTypeMappingInfo();
        this.checkForCallbackMethods();
    }

    public void createElementsForTypeMappingInfo() {
        if (this.javaClassToTypeMappingInfos != null && !this.javaClassToTypeMappingInfos.isEmpty()) {
            Set<JavaClass> classes = this.javaClassToTypeMappingInfos.keySet();
            for (JavaClass nextClass : classes) {
                List<TypeMappingInfo> nextInfos = this.javaClassToTypeMappingInfos.get(nextClass);
                for (TypeMappingInfo nextInfo : nextInfos) {
                    Class<?> generatedClass;
                    QName qname;
                    TypeInfo nextTypeInfo;
                    Class<?> generatedClass2;
                    if (nextInfo == null) continue;
                    boolean xmlAttachmentRef = false;
                    String xmlMimeType = null;
                    Annotation[] annotations = this.getAnnotations(nextInfo);
                    Class<?> adapterClass = this.typeMappingInfoToAdapterClasses.get(nextInfo);
                    Class<?> declJavaType = null;
                    if (adapterClass != null) {
                        declJavaType = CompilerHelper.getTypeFromAdapterClass(adapterClass);
                    }
                    if (annotations != null) {
                        for (Annotation nextAnnotation : annotations) {
                            if (nextAnnotation == null) continue;
                            if (nextAnnotation instanceof XmlMimeType) {
                                XmlMimeType javaAnnotation = (XmlMimeType)nextAnnotation;
                                xmlMimeType = javaAnnotation.value();
                                continue;
                            }
                            if (!(nextAnnotation instanceof XmlAttachmentRef)) continue;
                            xmlAttachmentRef = true;
                            if (this.hasSwaRef) continue;
                            this.hasSwaRef = true;
                        }
                    }
                    String nextClassName = nextClass.getQualifiedName();
                    if (declJavaType != null) {
                        nextClassName = declJavaType.getCanonicalName();
                    }
                    if (this.typeMappingInfosToGeneratedClasses != null && (generatedClass2 = this.typeMappingInfosToGeneratedClasses.get(nextInfo)) != null) {
                        nextClassName = generatedClass2.getCanonicalName();
                    }
                    if ((nextTypeInfo = this.typeInfos.get(nextClassName)) != null) {
                        qname = new QName(nextTypeInfo.getClassNamespace(), nextTypeInfo.getSchemaTypeName());
                    } else {
                        qname = this.getUserDefinedSchemaTypes().get(nextClassName);
                        if (qname == null) {
                            if (nextClassName.equals(ClassConstants.APBYTE.getName()) || nextClassName.equals(AWT_IMAGE) || nextClassName.equals(Source.class.getName()) || nextClassName.equals(JAVAX_ACTIVATION_DATAHANDLER)) {
                                qname = xmlAttachmentRef ? Constants.SWA_REF_QNAME : Constants.BASE_64_BINARY_QNAME;
                            } else if (nextClassName.equals(ClassConstants.OBJECT.getName())) {
                                qname = Constants.ANY_TYPE_QNAME;
                            } else if (nextClassName.equals(ClassConstants.XML_GREGORIAN_CALENDAR.getName())) {
                                qname = Constants.ANY_SIMPLE_TYPE_QNAME;
                            } else {
                                Class<?> theClass = this.helper.getClassForJavaClass(nextClass);
                                qname = XMLConversionManager.getDefaultJavaTypes().get(theClass);
                            }
                        }
                    }
                    if (qname != null) {
                        this.typeMappingInfosToSchemaTypes.put(nextInfo, qname);
                    }
                    if (nextInfo.getXmlTagName() == null) continue;
                    ElementDeclaration element = new ElementDeclaration(nextInfo.getXmlTagName(), nextClass, nextClass.getQualifiedName(), false);
                    element.setTypeMappingInfo(nextInfo);
                    element.setXmlMimeType(xmlMimeType);
                    element.setXmlAttachmentRef(xmlAttachmentRef);
                    element.setNillable(nextInfo.isNillable());
                    if (declJavaType != null) {
                        element.setJavaType(this.helper.getJavaClass(declJavaType));
                    }
                    if ((generatedClass = this.typeMappingInfosToGeneratedClasses.get(nextInfo)) != null) {
                        element.setJavaType(this.helper.getJavaClass(generatedClass));
                    }
                    if (nextInfo.getElementScope() == TypeMappingInfo.ElementScope.Global) {
                        ElementDeclaration currentElement = this.getGlobalElements().get(element.getElementName());
                        if (currentElement == null) {
                            this.addGlobalElement(element.getElementName(), element);
                        } else {
                            this.localElements.add(element);
                        }
                    } else {
                        this.localElements.add(element);
                    }
                    String rootNamespace = element.getElementName().getNamespaceURI();
                    if (rootNamespace == null) {
                        rootNamespace = EMPTY_STRING;
                    }
                    if (!rootNamespace.equals(EMPTY_STRING)) continue;
                    this.isDefaultNamespaceAllowed = false;
                }
            }
        }
    }

    private Annotation[] getAnnotations(TypeMappingInfo tmInfo) {
        if (tmInfo.getXmlElement() != null) {
            ClassLoader loader = this.helper.getClassLoader();
            ConversionManager cMgr = new ConversionManager();
            cMgr.setLoader(loader);
            org.eclipse.persistence.jaxb.xmlmodel.XmlElement xElt = CompilerHelper.getXmlElement(tmInfo.getXmlElement(), loader);
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            HashMap<String, Object> components = null;
            if (!xElt.getType().equals("jakarta.xml.bind.annotation.XmlElement.DEFAULT")) {
                components = new HashMap<String, Object>();
                components.put(TYPE_METHOD_NAME, xElt.getType());
                annotations.add(AnnotationProxy.getProxy(components, XmlElement.class, loader, cMgr));
            }
            if (xElt.isXmlList()) {
                annotations.add(AnnotationProxy.getProxy(components, XmlList.class, loader, cMgr));
            }
            if (xElt.isXmlAttachmentRef()) {
                annotations.add(AnnotationProxy.getProxy(components, XmlAttachmentRef.class, loader, cMgr));
            }
            if (xElt.getXmlMimeType() != null) {
                components = new HashMap();
                components.put(VALUE_METHOD_NAME, xElt.getXmlMimeType());
                annotations.add(AnnotationProxy.getProxy(components, XmlMimeType.class, loader, cMgr));
            }
            if (xElt.getXmlJavaTypeAdapter() != null) {
                components = new HashMap();
                components.put(TYPE_METHOD_NAME, xElt.getXmlJavaTypeAdapter().getType());
                components.put(VALUE_METHOD_NAME, xElt.getXmlJavaTypeAdapter().getValue());
                annotations.add(AnnotationProxy.getProxy(components, XmlJavaTypeAdapter.class, loader, cMgr));
            }
            return annotations.toArray(new Annotation[0]);
        }
        return tmInfo.getAnnotations();
    }

    void init(JavaClass[] classes, TypeMappingInfo[] typeMappingInfos) {
        this.typeInfoClasses = new ArrayList<JavaClass>();
        this.referencedByTransformer = new ArrayList<String>();
        this.typeInfos = new HashMap<String, TypeInfo>();
        this.typeQNames = new ArrayList<QName>();
        this.classesToProcessPropertyTypes = new ArrayList<JavaClass>();
        this.objectFactoryClassNames = new ArrayList<String>();
        this.userDefinedSchemaTypes = new HashMap<String, QName>();
        if (this.packageToPackageInfoMappings == null) {
            this.packageToPackageInfoMappings = new HashMap<String, PackageInfo>();
        }
        this.factoryMethods = new HashMap<String, JavaMethod>();
        this.xmlRegistries = new HashMap<String, XmlRegistry>();
        this.xmlRootElements = new HashMap<String, ElementDeclaration>();
        this.arrayClassesToGeneratedClasses = new HashMap();
        this.collectionClassesToGeneratedClasses = new HashMap();
        this.generatedClassesToArrayClasses = new HashMap();
        this.generatedClassesToCollectionClasses = new HashMap();
        this.typeMappingInfosToGeneratedClasses = new HashMap();
        this.typeMappingInfosToSchemaTypes = new HashMap<TypeMappingInfo, QName>();
        this.elementDeclarations = new HashMap<String, Map<QName, ElementDeclaration>>();
        HashMap globalElements = new HashMap();
        this.elementDeclarations.put(XmlElementDecl.GLOBAL.class.getName(), globalElements);
        this.localElements = new ArrayList<ElementDeclaration>();
        this.javaClassToTypeMappingInfos = new HashMap<JavaClass, List<TypeMappingInfo>>();
        this.typeMappingInfoToAdapterClasses = new HashMap();
        if (typeMappingInfos != null) {
            for (int i = 0; i < typeMappingInfos.length; ++i) {
                List<TypeMappingInfo> infos = this.javaClassToTypeMappingInfos.get(classes[i]);
                if (infos == null) {
                    infos = new ArrayList<TypeMappingInfo>();
                    this.javaClassToTypeMappingInfos.put(classes[i], infos);
                }
                infos.add(typeMappingInfos[i]);
                Annotation[] annotations = this.getAnnotations(typeMappingInfos[i]);
                if (annotations == null) continue;
                for (Annotation nextAnnotation : annotations) {
                    if (!(nextAnnotation instanceof XmlJavaTypeAdapter)) continue;
                    this.typeMappingInfoToAdapterClasses.put(typeMappingInfos[i], ((XmlJavaTypeAdapter)nextAnnotation).value());
                }
            }
        }
    }

    public Map<String, TypeInfo> preBuildTypeInfo(JavaClass[] javaClasses) {
        for (JavaClass javaClass : javaClasses) {
            String qualifiedName = javaClass.getQualifiedName();
            TypeInfo info = this.typeInfos.get(qualifiedName);
            if (javaClass.isArray() || info != null && info.isPreBuilt() || !this.shouldGenerateTypeInfo(javaClass) || this.isXmlRegistry(javaClass)) continue;
            info = javaClass.isEnum() ? new EnumTypeInfo(this.helper, javaClass) : new TypeInfo(this.helper, javaClass);
            info.setJavaClassName(qualifiedName);
            info.setPreBuilt(true);
            if (this.helper.isAnnotationPresent(javaClass, XmlTransient.class)) {
                info.setXmlTransient(true);
            }
            this.processXmlElementNillable(javaClass, info);
            this.processXmlExtensible(javaClass, info);
            if (this.helper.isAnnotationPresent(javaClass, XmlInlineBinaryData.class)) {
                info.setInlineBinaryData(true);
            }
            this.processNamedObjectGraphs(javaClass, info);
            this.processXmlRootElement(javaClass, info);
            this.processXmlSeeAlso(javaClass, info);
            PackageInfo packageInfo = this.getPackageInfoForPackage(javaClass);
            if (packageInfo != null && !packageInfo.getPackageLevelAdaptersByClass().isEmpty()) {
                for (String adapterClass : packageInfo.getPackageLevelAdaptersByClass().keySet()) {
                    JavaClass boundType = packageInfo.getPackageLevelAdaptersByClass().get(adapterClass);
                    info.getPackageLevelAdaptersByClass().put(adapterClass, boundType);
                }
            }
            NamespaceInfo namespaceInfo = packageInfo.getNamespaceInfo();
            this.preProcessXmlType(javaClass, info, namespaceInfo);
            this.preProcessXmlAccessorType(javaClass, info, namespaceInfo);
            this.preProcessXmlAccessorOrder(javaClass, info, namespaceInfo);
            this.processPackageLevelAdapters(javaClass, info);
            this.processAccessorFactory(javaClass, info);
            this.processClassLevelAdapters(javaClass, info);
            this.preProcessCustomizer(javaClass, info);
            this.processSchemaTypes(javaClass, info);
            if (this.helper.isAnnotationPresent(javaClass, XmlClassExtractor.class)) {
                XmlClassExtractor classExtractor = (XmlClassExtractor)this.helper.getAnnotation(javaClass, XmlClassExtractor.class);
                info.setClassExtractorName(classExtractor.value().getName());
            }
            if (this.helper.isAnnotationPresent(javaClass, XmlProperties.class)) {
                XmlProperties xmlProperties = (XmlProperties)this.helper.getAnnotation(javaClass, XmlProperties.class);
                propertiesMap = this.createUserPropertiesMap(xmlProperties.value());
                info.setUserProperties(propertiesMap);
            } else if (this.helper.isAnnotationPresent(javaClass, XmlProperty.class)) {
                XmlProperty xmlProperty = (XmlProperty)this.helper.getAnnotation(javaClass, XmlProperty.class);
                propertiesMap = this.createUserPropertiesMap(new XmlProperty[]{xmlProperty});
                info.setUserProperties(propertiesMap);
            }
            if (this.helper.isAnnotationPresent(javaClass, XmlDiscriminatorNode.class)) {
                XmlDiscriminatorNode xmlDiscriminatorNode = (XmlDiscriminatorNode)this.helper.getAnnotation(javaClass, XmlDiscriminatorNode.class);
                info.setXmlDiscriminatorNode(xmlDiscriminatorNode.value());
            }
            if (this.helper.isAnnotationPresent(javaClass, XmlDiscriminatorValue.class)) {
                XmlDiscriminatorValue xmlDiscriminatorValue = (XmlDiscriminatorValue)this.helper.getAnnotation(javaClass, XmlDiscriminatorValue.class);
                info.setXmlDiscriminatorValue(xmlDiscriminatorValue.value());
            }
            this.typeInfoClasses.add(javaClass);
            this.typeInfos.put(info.getJavaClassName(), info);
        }
        return this.typeInfos;
    }

    private void processXmlElementNillable(JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(javaClass, XmlElementNillable.class)) {
            XmlElementNillable xmlElementNillable = (XmlElementNillable)this.helper.getAnnotation(javaClass, XmlElementNillable.class);
            info.setXmlElementNillable(xmlElementNillable.nillable());
        } else if (this.hasExternalPackageMapping(javaClass)) {
            info.setXmlElementNillable(this.packageToXmlNillableInfoMappings.get(javaClass.getPackageName()).getXmlElementNillable().isNillable());
        } else if (this.helper.isAnnotationPresent(javaClass.getPackage(), XmlElementNillable.class)) {
            XmlElementNillable xmlElementNillable = (XmlElementNillable)this.helper.getAnnotation(javaClass.getPackage(), XmlElementNillable.class);
            info.setXmlElementNillable(xmlElementNillable.nillable());
        }
    }

    private boolean hasExternalPackageMapping(JavaClass javaClass) {
        if (null == this.packageToXmlNillableInfoMappings || !this.packageToXmlNillableInfoMappings.containsKey(javaClass.getPackageName())) {
            return false;
        }
        return null != this.packageToXmlNillableInfoMappings.get(javaClass.getPackageName()).getXmlElementNillable();
    }

    private void processNamedObjectGraphs(JavaClass javaClass, TypeInfo info) {
        ArrayList<XmlNamedObjectGraph> objectGraphs = new ArrayList<XmlNamedObjectGraph>();
        if (this.helper.isAnnotationPresent(javaClass, XmlNamedObjectGraphs.class)) {
            XmlNamedObjectGraphs graphs = (XmlNamedObjectGraphs)this.helper.getAnnotation(javaClass, XmlNamedObjectGraphs.class);
            Collections.addAll(objectGraphs, graphs.value());
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlNamedObjectGraph.class)) {
            objectGraphs.add((XmlNamedObjectGraph)this.helper.getAnnotation(javaClass, XmlNamedObjectGraph.class));
        }
        for (XmlNamedObjectGraph next : objectGraphs) {
            org.eclipse.persistence.jaxb.xmlmodel.XmlNamedAttributeNode namedNode;
            XmlNamedSubgraph namedSubGraph;
            org.eclipse.persistence.jaxb.xmlmodel.XmlNamedObjectGraph namedGraph = new org.eclipse.persistence.jaxb.xmlmodel.XmlNamedObjectGraph();
            namedGraph.setName(next.name());
            for (XmlNamedAttributeNode xmlNamedAttributeNode : next.attributeNodes()) {
                org.eclipse.persistence.jaxb.xmlmodel.XmlNamedAttributeNode namedNode2 = new org.eclipse.persistence.jaxb.xmlmodel.XmlNamedAttributeNode();
                namedNode2.setName(xmlNamedAttributeNode.value());
                namedNode2.setSubgraph(xmlNamedAttributeNode.subgraph());
                namedGraph.getXmlNamedAttributeNode().add(namedNode2);
            }
            for (Annotation annotation : next.subgraphs()) {
                namedSubGraph = new XmlNamedSubgraph();
                namedSubGraph.setName(annotation.name());
                namedSubGraph.setType(annotation.type().getName());
                for (XmlNamedAttributeNode nextNode : annotation.attributeNodes()) {
                    namedNode = new org.eclipse.persistence.jaxb.xmlmodel.XmlNamedAttributeNode();
                    namedNode.setName(nextNode.value());
                    namedNode.setSubgraph(nextNode.subgraph());
                    namedSubGraph.getXmlNamedAttributeNode().add(namedNode);
                }
                namedGraph.getXmlNamedSubgraph().add(namedSubGraph);
            }
            for (Annotation annotation : next.subclassSubgraphs()) {
                namedSubGraph = new XmlNamedSubgraph();
                namedSubGraph.setName(annotation.name());
                namedSubGraph.setType(annotation.type().getName());
                for (XmlNamedAttributeNode nextNode : annotation.attributeNodes()) {
                    namedNode = new org.eclipse.persistence.jaxb.xmlmodel.XmlNamedAttributeNode();
                    namedNode.setName(nextNode.value());
                    namedNode.setSubgraph(nextNode.subgraph());
                    namedSubGraph.getXmlNamedAttributeNode().add(namedNode);
                }
                namedGraph.getXmlNamedSubclassGraph().add(namedSubGraph);
            }
            info.getObjectGraphs().add(namedGraph);
        }
    }

    private void processAccessorFactory(JavaClass javaClass, TypeInfo info) {
        PackageInfo pInfo;
        if (!this.xmlAccessorFactorySupport) {
            return;
        }
        Annotation xmlAccessorFactory = this.helper.getAnnotation(javaClass, CompilerHelper.ACCESSOR_FACTORY_ANNOTATION_CLASS);
        Method valueMethod = null;
        if (xmlAccessorFactory != null) {
            valueMethod = CompilerHelper.ACCESSOR_FACTORY_VALUE_METHOD;
        } else {
            xmlAccessorFactory = this.helper.getAnnotation(javaClass, CompilerHelper.INTERNAL_ACCESSOR_FACTORY_ANNOTATION_CLASS);
            if (xmlAccessorFactory != null) {
                valueMethod = CompilerHelper.INTERNAL_ACCESSOR_FACTORY_VALUE_METHOD;
            }
        }
        if (xmlAccessorFactory != null) {
            Class xmlAccessorFactoryClass = null;
            try {
                xmlAccessorFactoryClass = (Class)PrivilegedAccessHelper.invokeMethod(valueMethod, xmlAccessorFactory, new Object[0]);
                info.setXmlAccessorFactory(new AccessorFactoryWrapper(PrivilegedAccessHelper.newInstanceFromClass(xmlAccessorFactoryClass)));
            }
            catch (Exception ex) {
                throw JAXBException.errorInstantiatingAccessorFactory(xmlAccessorFactoryClass, ex);
            }
        }
        if ((pInfo = this.getPackageInfoForPackage(javaClass)) != null) {
            info.setPackageLevelXmlAccessorFactory(pInfo.getAccessorFactory());
        }
    }

    public JavaClass[] postBuildTypeInfo(JavaClass[] javaClasses) {
        if (javaClasses.length == 0) {
            return javaClasses;
        }
        List<JavaClass> originalList = Arrays.asList(javaClasses);
        javaClasses = this.processAdditionalClasses(javaClasses);
        this.preBuildTypeInfo(javaClasses);
        this.buildTypeInfo(javaClasses);
        this.updateGlobalElements(javaClasses);
        if (javaClasses.length > originalList.size()) {
            ArrayList<JavaClass> newClasses = new ArrayList<JavaClass>(javaClasses.length - originalList.size());
            for (JavaClass next : javaClasses) {
                if (originalList.contains(next)) continue;
                newClasses.add(next);
            }
            this.postBuildTypeInfo(newClasses.toArray(new JavaClass[0]));
        }
        return javaClasses;
    }

    private Map<String, TypeInfo> buildTypeInfo(JavaClass[] allClasses) {
        for (JavaClass javaClass : allClasses) {
            TypeInfo info;
            if (javaClass == null || (info = this.typeInfos.get(javaClass.getQualifiedName())) == null || info.isPostBuilt()) continue;
            info.setPostBuilt(true);
            this.processFactoryMethods(javaClass, info);
            PackageInfo packageInfo = this.getPackageInfoForPackage(javaClass);
            XMLNameTransformer transformer = info.getXmlNameTransformer();
            if (transformer == TypeInfo.DEFAULT_NAME_TRANSFORMER) {
                XMLNameTransformer nsInfoXmlNameTransformer = packageInfo.getXmlNameTransformer();
                if (nsInfoXmlNameTransformer != null) {
                    info.setXmlNameTransformer(nsInfoXmlNameTransformer);
                } else {
                    Class<?> nameTransformerClass;
                    XmlNameTransformer xmlNameTransformer;
                    if (this.helper.isAnnotationPresent(javaClass, XmlNameTransformer.class)) {
                        xmlNameTransformer = (XmlNameTransformer)this.helper.getAnnotation(javaClass, XmlNameTransformer.class);
                        nameTransformerClass = xmlNameTransformer.value();
                        try {
                            info.setXmlNameTransformer((XMLNameTransformer)nameTransformerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        catch (ReflectiveOperationException ex) {
                            throw JAXBException.exceptionWithNameTransformerClass(nameTransformerClass.getName(), ex);
                        }
                    }
                    if (this.helper.isAnnotationPresent(javaClass.getPackage(), XmlNameTransformer.class)) {
                        xmlNameTransformer = (XmlNameTransformer)this.helper.getAnnotation(javaClass.getPackage(), XmlNameTransformer.class);
                        nameTransformerClass = xmlNameTransformer.value();
                        try {
                            info.setXmlNameTransformer((XMLNameTransformer)nameTransformerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        catch (ReflectiveOperationException ex) {
                            throw JAXBException.exceptionWithNameTransformerClass(nameTransformerClass.getName(), ex);
                        }
                    }
                }
            }
            this.postProcessXmlAccessorType(info, packageInfo);
            this.postProcessXmlType(javaClass, info, packageInfo);
            if (info.isEnumerationType()) {
                this.addEnumTypeInfo(javaClass, (EnumTypeInfo)info);
                continue;
            }
            this.processTypeQName(javaClass, info, packageInfo.getNamespaceInfo());
            JavaClass superClass = javaClass.getSuperclass();
            this.processPropertiesSuperClass(javaClass, info);
            this.processReferencedClass(superClass);
            info.setProperties(this.getPropertiesForClass(javaClass, info));
            this.processTypeInfoProperties(javaClass, info);
            this.postProcessXmlAccessorOrder(info, packageInfo);
            this.validatePropOrderForInfo(info);
        }
        return this.typeInfos;
    }

    private TypeInfo processReferencedClass(JavaClass referencedClass) {
        if (this.shouldGenerateTypeInfo(referencedClass)) {
            PackageInfo pInfo;
            JavaClass adapterClass;
            String qName = referencedClass.getQualifiedName();
            TypeInfo existingInfo = this.typeInfos.get(qName);
            if (existingInfo == null || !existingInfo.isPreBuilt()) {
                PackageInfo pInfo2 = this.getPackageInfoForPackage(referencedClass);
                JavaClass adapterClass2 = pInfo2.getPackageLevelAdaptersByClass().get(qName);
                if (adapterClass2 == null) {
                    CompilerHelper.addClassToClassLoader(referencedClass, this.helper.getClassLoader());
                    JavaClass[] jClassArray = new JavaClass[]{referencedClass};
                    this.buildNewTypeInfo(jClassArray);
                }
                return this.typeInfos.get(qName);
            }
            if (!existingInfo.isPostBuilt() && (adapterClass = (pInfo = this.getPackageInfoForPackage(referencedClass)).getPackageLevelAdaptersByClass().get(qName)) == null) {
                CompilerHelper.addClassToClassLoader(referencedClass, this.helper.getClassLoader());
                JavaClass[] javaClasses = new JavaClass[]{referencedClass};
                for (JavaClass next : javaClasses = this.postBuildTypeInfo(javaClasses)) {
                    this.processPropertyTypes(next);
                }
            }
            return existingInfo;
        }
        return null;
    }

    public void processPropertiesSuperClass(JavaClass cls, TypeInfo info) {
        JavaClass superClass = cls.getSuperclass();
        if (superClass == null) {
            return;
        }
        TypeInfo superClassInfo = this.typeInfos.get(superClass.getQualifiedName());
        if (superClassInfo != null) {
            this.processPropertiesSuperClass(superClass, superClassInfo);
            this.classesToProcessPropertyTypes.add(superClass);
            if (superClassInfo.getXmlVirtualAccessMethods() != null && info.getXmlVirtualAccessMethods() == null) {
                info.setXmlVirtualAccessMethods(superClassInfo.getXmlVirtualAccessMethods());
            }
            if (superClassInfo.isIDSet()) {
                info.setIDProperty(superClassInfo.getIDProperty());
            }
        }
    }

    public void finalizeProperties() {
        for (TypeInfo tInfo : this.getTypeInfos().values()) {
            JavaConstructor zeroArgConstructor;
            if (tInfo.isTransient()) continue;
            JavaClass jClass = tInfo.getJavaClass();
            String[] propOrder = tInfo.getPropOrder();
            boolean hasPropOrder = propOrder.length > 0 && (propOrder.length != 1 || !propOrder[0].equals(EMPTY_STRING));
            List<String> propOrderList = Arrays.asList(tInfo.getPropOrder());
            ArrayList<Property> propsList = tInfo.getPropertyList();
            for (Property p : propsList) {
                if (p.isTransient() && propOrderList.contains(p.getPropertyName())) {
                    throw JAXBException.transientInProporder(p.getPropertyName(), tInfo.getJavaClassName());
                }
                if (!hasPropOrder || p.isAttribute() || p.isTransient() || p.isInverseReference() || propOrderList.contains(p.getPropertyName())) continue;
                throw JAXBException.missingPropertyInPropOrder(p.getPropertyName(), tInfo.getJavaClassName());
            }
            if (!(jClass.isInterface() || tInfo.isEnumerationType() || jClass.isAbstract() || tInfo.getFactoryMethodName() != null || tInfo.getObjectFactoryClassName() != null || (zeroArgConstructor = jClass.getDeclaredConstructor(new JavaClass[0])) != null)) {
                if (tInfo.isSetXmlJavaTypeAdapter()) {
                    tInfo.setTransient(true);
                } else if (!this.referencedByTransformer.contains(jClass.getName())) {
                    throw JAXBException.factoryMethodOrConstructorRequired(jClass.getName());
                }
            }
            if (tInfo.getXmlValueProperty() != null) {
                this.validateXmlValueFieldOrProperty(jClass, tInfo.getXmlValueProperty());
            }
            ArrayList<Property> anyElementProperties = new ArrayList<Property>();
            for (Property property : tInfo.getPropertyList()) {
                Object targetInfo;
                if (property.isAttribute()) {
                    this.validateXmlAttributeFieldOrProperty(tInfo, property);
                }
                JavaClass propertyClass = property.getActualType();
                if (property.isChoice()) {
                    Collection<Property> choiceProps = property.getChoiceProperties();
                    for (Property nextChoiceProp : choiceProps) {
                        JavaClass nextChoicePropTypeClass = nextChoiceProp.getActualType();
                        TypeInfo targetInfo2 = this.typeInfos.get(nextChoicePropTypeClass.getQualifiedName());
                        this.finalizeProperty(property, targetInfo2, nextChoicePropTypeClass, jClass);
                    }
                } else {
                    targetInfo = this.typeInfos.get(propertyClass.getQualifiedName());
                    this.finalizeProperty(property, (TypeInfo)targetInfo, propertyClass, jClass);
                }
                if (tInfo.isSetXmlValueProperty()) {
                    if (property.isXmlValue() && !tInfo.getXmlValueProperty().getPropertyName().equals(property.getPropertyName())) {
                        throw JAXBException.xmlValueAlreadySet(property.getPropertyName(), tInfo.getXmlValueProperty().getPropertyName(), jClass.getName());
                    }
                    if (!(property.isXmlValue() || property.isAttribute() || property.isInverseReference() || property.isTransient())) {
                        throw JAXBException.propertyOrFieldShouldBeAnAttribute(property.getPropertyName(), jClass.getName());
                    }
                }
                if (property.isReference()) {
                    this.processReferenceProperty(property, tInfo, jClass);
                }
                if (property.isSwaAttachmentRef() && !this.hasSwaRef) {
                    this.hasSwaRef = true;
                }
                if (property.isXmlId()) {
                    if (tInfo.getIDProperty() != null && !tInfo.getIDProperty().getPropertyName().equals(property.getPropertyName())) {
                        throw JAXBException.idAlreadySet(property.getPropertyName(), tInfo.getIDProperty().getPropertyName(), jClass.getName());
                    }
                    this.validateXmlIdStringType(property);
                }
                if (property.isAnyAttribute() && tInfo.isSetAnyAttributePropertyName() && !tInfo.getAnyAttributePropertyName().equals(property.getPropertyName())) {
                    throw JAXBException.multipleAnyAttributeMapping(jClass.getName());
                }
                if (property.isAny()) {
                    if (!anyElementProperties.isEmpty()) {
                        for (Property nextAny : anyElementProperties) {
                            if (!property.isSetXmlElementWrapper() && !nextAny.isSetXmlElementWrapper()) {
                                throw JAXBException.xmlAnyElementAlreadySet(property.getPropertyName(), nextAny.getPropertyName(), jClass.getName());
                            }
                            org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper wrapper = property.getXmlElementWrapper();
                            org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper targetWrapper = nextAny.getXmlElementWrapper();
                            if (wrapper == null || targetWrapper == null || !wrapper.getName().equals(targetWrapper.getName()) || !wrapper.getNamespace().equals(targetWrapper.getNamespace())) continue;
                            throw JAXBException.xmlAnyElementAlreadySet(property.getPropertyName(), nextAny.getPropertyName(), jClass.getName());
                        }
                    }
                    anyElementProperties.add(property);
                }
                if (property.isSwaAttachmentRef() && !this.areEquals(property.getActualType(), JAVAX_ACTIVATION_DATAHANDLER)) {
                    throw JAXBException.invalidAttributeRef(property.getPropertyName(), jClass.getQualifiedName());
                }
                if (!(property.getXmlElementWrapper() == null || this.helper.isCollectionType(property.getType()) || property.getType().isArray() || this.helper.isMapType(property.getType()))) {
                    throw JAXBException.invalidElementWrapper(property.getPropertyName());
                }
                if (property.isXmlTransformation()) {
                    this.validateXmlTransformationProperty(property);
                }
                if (!property.isSetXmlJoinNodes()) continue;
                targetInfo = this.typeInfos.get(propertyClass.getQualifiedName());
                if (targetInfo == null) {
                    throw JAXBException.invalidXmlJoinNodeReferencedClass(property.getPropertyName(), propertyClass.getQualifiedName());
                }
                if (((TypeInfo)targetInfo).getIDProperty() != null || ((TypeInfo)targetInfo).getXmlKeyProperties() != null) continue;
                throw JAXBException.noKeyOrIDPropertyOnJoinTarget(jClass.getQualifiedName(), property.getPropertyName(), propertyClass.getQualifiedName());
            }
        }
    }

    private void validateXmlIdStringType(Property property) {
        if (!("java.lang.String".equals(property.getActualType().getQualifiedName()) || MOXySystemProperties.xmlIdExtension.booleanValue() || this.helper.isAnnotationPresent(property.getElement(), XmlIDExtension.class) || property.isXmlIdExtension())) {
            throw JAXBException.invalidId(property.getPropertyName());
        }
    }

    private void finalizeProperty(Property property, TypeInfo targetInfo, JavaClass typeClass, JavaClass jClass) {
        if (targetInfo != null && targetInfo.isTransient() && property.getXmlElements() == null) {
            property.setTransientType(true);
        }
        if (property.isXmlIdRef()) {
            if (targetInfo == null && !typeClass.getQualifiedName().equals(JAVA_LANG_OBJECT)) {
                throw JAXBException.invalidIDREFClass(jClass.getQualifiedName(), property.getPropertyName(), typeClass.getQualifiedName());
            }
            if (targetInfo != null && targetInfo.getIDProperty() == null && !this.preCheckXmlID(typeClass, targetInfo)) {
                throw JAXBException.invalidIdRef(property.getPropertyName(), typeClass.getQualifiedName());
            }
        }
    }

    private void processTypeInfoProperties(JavaClass javaClass, TypeInfo info) {
        ArrayList<Property> properties = info.getPropertyList();
        for (Property property : properties) {
            this.processXmlID(property, javaClass, info);
            this.processXmlIDREF(property);
            if (!property.isMap()) continue;
            this.processReferencedClass(property.getKeyType());
            this.processReferencedClass(property.getActualValueType());
        }
    }

    void processPropertyTypes(JavaClass[] classes) {
        for (JavaClass next : classes) {
            this.processPropertyTypes(next);
            this.classesToProcessPropertyTypes.remove(next);
        }
        for (int i = 0; i < this.classesToProcessPropertyTypes.size(); ++i) {
            JavaClass next = this.classesToProcessPropertyTypes.get(i);
            this.processPropertyTypes(next);
        }
    }

    private void processPropertyTypes(JavaClass next) {
        TypeInfo info = this.getTypeInfos().get(next.getQualifiedName());
        if (info != null) {
            for (Property property : info.getPropertyList()) {
                if (property.isXmlLocation()) {
                    info.setLocationAware(true);
                }
                if (property.isTransient()) continue;
                JavaClass type2 = property.getActualType();
                if (property.isReference()) {
                    this.processReferencePropertyTypes(property, info, next);
                }
                if (property.isChoice()) {
                    this.processChoiceProperty(property, info, next, type2);
                    for (Property choiceProp : property.getChoiceProperties()) {
                        type2 = choiceProp.getActualType();
                        this.processReferencedClass(type2);
                    }
                    continue;
                }
                this.processReferencedClass(type2);
            }
        }
    }

    private JavaClass[] processAdditionalClasses(JavaClass[] classes) {
        ArrayList<JavaClass> extraClasses = new ArrayList<JavaClass>();
        ArrayList<JavaClass> classesToProcess = new ArrayList<JavaClass>();
        for (JavaClass jClass : classes) {
            List<TypeMappingInfo> infos = this.javaClassToTypeMappingInfos.get(jClass);
            if (infos != null && !infos.isEmpty()) {
                for (TypeMappingInfo next : infos) {
                    this.processAdditionalClasses(jClass, next, extraClasses, classesToProcess);
                }
                continue;
            }
            this.processAdditionalClasses(jClass, null, extraClasses, classesToProcess);
        }
        for (JavaClass javaClass : extraClasses) {
            this.processClass(javaClass, classesToProcess);
        }
        return classesToProcess.toArray(new JavaClass[0]);
    }

    private void processAdditionalClasses(JavaClass cls, TypeMappingInfo tmi, ArrayList<JavaClass> extraClasses, ArrayList<JavaClass> classesToProcess) {
        Class<?> xmlElementType = null;
        Object javaClass = cls;
        if (tmi != null) {
            Annotation[] annotations;
            Class<?> adapterClass = this.typeMappingInfoToAdapterClasses.get(tmi);
            if (adapterClass != null) {
                JavaClass adapterJavaClass = this.helper.getJavaClass(adapterClass);
                Object newType = this.helper.getJavaClass(Object.class);
                for (JavaMethod nextMethod : adapterJavaClass.getDeclaredMethods()) {
                    JavaClass returnType;
                    JavaMethod method = nextMethod;
                    if (!method.getName().equals("marshal") || (returnType = method.getReturnType()).getQualifiedName().equals(newType.getQualifiedName())) continue;
                    newType = returnType;
                    break;
                }
                if (!this.helper.isBuiltInJavaType((JavaClass)javaClass)) {
                    extraClasses.add((JavaClass)javaClass);
                }
                javaClass = newType;
            }
            if ((annotations = this.getAnnotations(tmi)) != null) {
                for (Annotation nextAnnotation : annotations) {
                    XmlElement javaAnnotation;
                    if (nextAnnotation == null || !(nextAnnotation instanceof XmlElement) || (javaAnnotation = (XmlElement)nextAnnotation).type() == XmlElement.DEFAULT.class) continue;
                    xmlElementType = javaAnnotation.type();
                }
            }
        }
        if (this.areEquals((JavaClass)javaClass, byte[].class) || this.areEquals((JavaClass)javaClass, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals((JavaClass)javaClass, Source.class) || this.areEquals((JavaClass)javaClass, AWT_IMAGE) || this.areEquals((JavaClass)javaClass, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
            if (tmi == null || tmi.getXmlTagName() == null) {
                ElementDeclaration declaration = new ElementDeclaration(null, (JavaClass)javaClass, javaClass.getQualifiedName(), false, XmlElementDecl.GLOBAL.class);
                declaration.setTypeMappingInfo(tmi);
                this.localElements.add(declaration);
            }
        } else if (javaClass.isArray()) {
            Class<?> generatedClass;
            if (!this.helper.isBuiltInJavaType(javaClass.getComponentType())) {
                extraClasses.add(javaClass.getComponentType());
            }
            if ((generatedClass = null == tmi ? this.arrayClassesToGeneratedClasses.get(javaClass.getName()) : CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfosToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader())) == null) {
                generatedClass = this.generateWrapperForArrayClass((JavaClass)javaClass, tmi, xmlElementType, extraClasses);
                extraClasses.add(this.helper.getJavaClass(generatedClass));
                this.arrayClassesToGeneratedClasses.put(javaClass.getName(), generatedClass);
            }
            this.generatedClassesToArrayClasses.put(generatedClass, (JavaClass)javaClass);
            this.typeMappingInfosToGeneratedClasses.put(tmi, generatedClass);
        } else if (this.helper.isCollectionType((JavaClass)javaClass)) {
            Class<?> generatedClass;
            Collection<JavaClass> args = javaClass.getActualTypeArguments();
            if (!args.isEmpty()) {
                componentClass = args.iterator().next();
                if (!componentClass.isPrimitive()) {
                    extraClasses.add(componentClass);
                }
            } else {
                componentClass = this.helper.getJavaClass(Object.class);
            }
            if ((generatedClass = CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfosToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader())) == null) {
                generatedClass = this.generateCollectionValue((JavaClass)javaClass, tmi, xmlElementType, extraClasses);
                extraClasses.add(this.helper.getJavaClass(generatedClass));
            }
            this.typeMappingInfosToGeneratedClasses.put(tmi, generatedClass);
        } else if (this.helper.isMapType((JavaClass)javaClass)) {
            Class<?> generatedClass;
            JavaClass valueClass;
            JavaClass keyClass;
            Collection<JavaClass> args = javaClass.getActualTypeArguments();
            Iterator<JavaClass> argsIter = args.iterator();
            if (!args.isEmpty()) {
                keyClass = argsIter.next();
                if (!this.helper.isBuiltInJavaType(keyClass)) {
                    extraClasses.add(keyClass);
                }
                if (!this.helper.isBuiltInJavaType(valueClass = argsIter.next())) {
                    extraClasses.add(valueClass);
                }
            } else {
                keyClass = this.helper.getJavaClass(Object.class);
                valueClass = this.helper.getJavaClass(Object.class);
            }
            if ((generatedClass = CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfosToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader())) == null) {
                generatedClass = this.generateWrapperForMapClass((JavaClass)javaClass, keyClass, valueClass, tmi);
                extraClasses.add(this.helper.getJavaClass(generatedClass));
            }
            this.typeMappingInfosToGeneratedClasses.put(tmi, generatedClass);
        } else {
            this.processClass((JavaClass)javaClass, classesToProcess);
        }
    }

    private void processClass(JavaClass javaClass, ArrayList<JavaClass> classesToProcess) {
        if (this.shouldGenerateTypeInfo(javaClass)) {
            if (this.isXmlRegistry(javaClass)) {
                this.processObjectFactory(javaClass, classesToProcess);
            } else {
                classesToProcess.add(javaClass);
                TypeInfo info = this.typeInfos.get(javaClass.getQualifiedName());
                if (info != null && info.isSetXmlSeeAlso()) {
                    for (String jClassName : info.getXmlSeeAlso()) {
                        classesToProcess.add(this.helper.getJavaClass(jClassName));
                    }
                }
            }
        }
    }

    private void processXmlSeeAlso(JavaClass javaClass, TypeInfo info) {
        Class xmlSeeAlsoClass = null;
        Method valueMethod = null;
        try {
            xmlSeeAlsoClass = PrivilegedAccessHelper.getClassForName("jakarta.xml.bind.annotation.XmlSeeAlso", false, this.helper.getClassLoader());
            valueMethod = PrivilegedAccessHelper.getDeclaredMethod(xmlSeeAlsoClass, VALUE_METHOD_NAME, new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (xmlSeeAlsoClass != null && this.helper.isAnnotationPresent(javaClass, xmlSeeAlsoClass)) {
            Annotation seeAlso = this.helper.getAnnotation(javaClass, xmlSeeAlsoClass);
            Class[] values = null;
            try {
                values = (Class[])PrivilegedAccessHelper.invokeMethod(valueMethod, seeAlso, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (values != null) {
                ArrayList<String> seeAlsoClassNames = new ArrayList<String>();
                for (Class next : values) {
                    seeAlsoClassNames.add(next.getName());
                }
                info.setXmlSeeAlso(seeAlsoClassNames);
            }
        }
    }

    private void processFactoryMethods(JavaClass javaClass, TypeInfo info) {
        JavaMethod factoryMethod = this.factoryMethods.get(javaClass.getRawName());
        if (factoryMethod != null) {
            info.setFactoryMethodName(factoryMethod.getName());
            info.setObjectFactoryClassName(factoryMethod.getOwningClass().getQualifiedName());
            JavaClass[] paramTypes = factoryMethod.getParameterTypes();
            if (paramTypes != null && paramTypes.length > 0) {
                String[] paramTypeNames = new String[paramTypes.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    this.processReferencedClass(paramTypes[i]);
                    paramTypeNames[i] = paramTypes[i].getQualifiedName();
                }
                info.setFactoryMethodParamTypes(paramTypeNames);
            }
        }
    }

    private void processPackageLevelAdapters(JavaClass javaClass, TypeInfo info) {
        JavaPackage pack = javaClass.getPackage();
        if (this.helper.isAnnotationPresent(pack, XmlJavaTypeAdapters.class)) {
            XmlJavaTypeAdapter[] adapterArray;
            XmlJavaTypeAdapters adapters = (XmlJavaTypeAdapters)this.helper.getAnnotation(pack, XmlJavaTypeAdapters.class);
            for (XmlJavaTypeAdapter next : adapterArray = adapters.value()) {
                this.processPackageLevelAdapter(next, info);
            }
        }
        if (this.helper.isAnnotationPresent(pack, XmlJavaTypeAdapter.class)) {
            XmlJavaTypeAdapter adapter = (XmlJavaTypeAdapter)this.helper.getAnnotation(pack, XmlJavaTypeAdapter.class);
            this.processPackageLevelAdapter(adapter, info);
        }
    }

    private void processPackageLevelAdapter(XmlJavaTypeAdapter next, TypeInfo info) {
        JavaClass adapterClass = this.helper.getJavaClass(next.value());
        JavaClass boundType = this.helper.getJavaClass(next.type());
        if (boundType != null) {
            info.addPackageLevelAdapterClass(adapterClass, boundType);
        } else {
            this.getLogger().logWarning("jaxb_metadata_warning_invalid_bound_type", new Object[]{null, adapterClass});
        }
    }

    private void processClassLevelAdapters(JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(javaClass, XmlJavaTypeAdapter.class)) {
            XmlJavaTypeAdapter adapter = (XmlJavaTypeAdapter)this.helper.getAnnotation(javaClass, XmlJavaTypeAdapter.class);
            String boundType = adapter.type().getName();
            if (boundType == null || boundType.equals("jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter.DEFAULT")) {
                boundType = javaClass.getRawName();
            }
            org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter xja = new org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter();
            xja.setValue(adapter.value().getName());
            xja.setType(boundType);
            info.setXmlJavaTypeAdapter(xja);
        }
    }

    private void processSchemaTypes(JavaClass javaClass, TypeInfo info) {
        JavaPackage pack = javaClass.getPackage();
        if (this.helper.isAnnotationPresent(pack, XmlSchemaTypes.class)) {
            XmlSchemaType[] typeArray;
            XmlSchemaTypes types = (XmlSchemaTypes)this.helper.getAnnotation(pack, XmlSchemaTypes.class);
            for (XmlSchemaType next : typeArray = types.value()) {
                this.processSchemaType(next);
            }
        } else if (this.helper.isAnnotationPresent(pack, XmlSchemaType.class)) {
            this.processSchemaType((XmlSchemaType)this.helper.getAnnotation(pack, XmlSchemaType.class));
        }
    }

    private void processXmlRootElement(JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(javaClass, jakarta.xml.bind.annotation.XmlRootElement.class)) {
            jakarta.xml.bind.annotation.XmlRootElement rootElemAnnotation = (jakarta.xml.bind.annotation.XmlRootElement)this.helper.getAnnotation(javaClass, jakarta.xml.bind.annotation.XmlRootElement.class);
            XmlRootElement xmlRE = new XmlRootElement();
            xmlRE.setName(rootElemAnnotation.name());
            xmlRE.setNamespace(rootElemAnnotation.namespace());
            info.setXmlRootElement(xmlRE);
        }
    }

    private void processXmlExtensible(JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(javaClass, XmlVirtualAccessMethods.class)) {
            XmlVirtualAccessMethods extAnnotation = (XmlVirtualAccessMethods)this.helper.getAnnotation(javaClass, XmlVirtualAccessMethods.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlVirtualAccessMethods xmlExt = new org.eclipse.persistence.jaxb.xmlmodel.XmlVirtualAccessMethods();
            xmlExt.setGetMethod(extAnnotation.getMethod());
            xmlExt.setSetMethod(extAnnotation.setMethod());
            xmlExt.setSchema(XmlVirtualAccessMethodsSchema.valueOf(extAnnotation.schema().toString()));
            info.setXmlVirtualAccessMethods(xmlExt);
        }
    }

    private void preProcessXmlType(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        org.eclipse.persistence.jaxb.xmlmodel.XmlType xmlType = new org.eclipse.persistence.jaxb.xmlmodel.XmlType();
        if (this.helper.isAnnotationPresent(javaClass, XmlType.class)) {
            XmlType typeAnnotation = (XmlType)this.helper.getAnnotation(javaClass, XmlType.class);
            xmlType.setName(typeAnnotation.name());
            xmlType.setNamespace(typeAnnotation.namespace());
            String[] propOrder = typeAnnotation.propOrder();
            if (propOrder != null) {
                xmlType.getPropOrder();
            }
            for (String prop : propOrder) {
                xmlType.getPropOrder().add(prop);
            }
            Class<?> factoryClass = typeAnnotation.factoryClass();
            if (factoryClass == XmlType.DEFAULT.class) {
                xmlType.setFactoryClass("jakarta.xml.bind.annotation.XmlType.DEFAULT");
            } else {
                xmlType.setFactoryClass(factoryClass.getCanonicalName());
            }
            xmlType.setFactoryMethod(typeAnnotation.factoryMethod());
        } else {
            xmlType.setNamespace(packageNamespace.getNamespace());
        }
        info.setXmlType(xmlType);
    }

    private void postProcessXmlType(JavaClass javaClass, TypeInfo info, PackageInfo packageNamespace) {
        String typeName;
        org.eclipse.persistence.jaxb.xmlmodel.XmlType xmlType = info.getXmlType();
        String factoryClassName = xmlType.getFactoryClass();
        String factoryMethodName = xmlType.getFactoryMethod();
        if (factoryClassName.equals("jakarta.xml.bind.annotation.XmlType.DEFAULT")) {
            if (factoryMethodName != null && !factoryMethodName.equals(EMPTY_STRING)) {
                JavaMethod method = javaClass.getDeclaredMethod(factoryMethodName, new JavaClass[0]);
                if (method == null) {
                    throw JAXBException.factoryMethodNotDeclared(factoryMethodName, javaClass.getName());
                }
                info.setFactoryMethodName(factoryMethodName);
            }
        } else {
            if (factoryMethodName == null || factoryMethodName.equals(EMPTY_STRING)) {
                throw JAXBException.factoryClassWithoutFactoryMethod(javaClass.getName());
            }
            info.setObjectFactoryClassName(factoryClassName);
            info.setFactoryMethodName(factoryMethodName);
        }
        if ((typeName = xmlType.getName()).equals("##default")) {
            try {
                typeName = info.getXmlNameTransformer().transformTypeName(javaClass.getName());
            }
            catch (Exception ex) {
                throw JAXBException.exceptionDuringNameTransformation(javaClass.getName(), info.getXmlNameTransformer().getClass().getName(), ex);
            }
        }
        info.setSchemaTypeName(typeName);
        if (xmlType.isSetPropOrder()) {
            List<String> props = xmlType.getPropOrder();
            if (props.isEmpty()) {
                info.setPropOrder(new String[0]);
            } else if (props.get(0).equals(EMPTY_STRING)) {
                info.setPropOrder(new String[]{EMPTY_STRING});
            } else {
                info.setPropOrder(xmlType.getPropOrder().toArray(new String[0]));
            }
        }
        if (xmlType.getNamespace().equals("##default")) {
            info.setClassNamespace(packageNamespace.getNamespace());
        } else {
            info.setClassNamespace(xmlType.getNamespace());
        }
    }

    private void preProcessXmlAccessorType(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        if (javaClass.getDeclaredAnnotation(this.helper.getJavaClass(XmlAccessorType.class)) != null) {
            XmlAccessorType accessorType = (XmlAccessorType)this.helper.getAnnotation(javaClass, XmlAccessorType.class);
            XmlAccessType xmlAccessType = XmlAccessType.fromValue(accessorType.value().name());
            info.setXmlAccessType(xmlAccessType);
        }
    }

    private void postProcessXmlAccessorType(TypeInfo info, PackageInfo packageNamespace) {
        if (!info.isSetXmlAccessType()) {
            for (JavaClass next = this.helper.getJavaClass(info.getJavaClassName()).getSuperclass(); next != null && !next.getName().equals(JAVA_LANG_OBJECT); next = next.getSuperclass()) {
                this.processReferencedClass(next);
                TypeInfo parentInfo = this.typeInfos.get(next.getName());
                if (parentInfo == null || !parentInfo.isSetXmlAccessType()) continue;
                info.setXmlAccessType(parentInfo.getXmlAccessType());
                break;
            }
            if (!info.isSetXmlAccessType()) {
                info.setXmlAccessType(XmlAccessType.fromValue(packageNamespace.getAccessType().name()));
            }
        }
    }

    private void preProcessXmlAccessorOrder(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        XmlAccessorOrder order = null;
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorOrder.class)) {
            order = (XmlAccessorOrder)this.helper.getAnnotation(javaClass, XmlAccessorOrder.class);
            info.setXmlAccessOrder(XmlAccessOrder.fromValue(order.value().name()));
        }
    }

    private void postProcessXmlAccessorOrder(TypeInfo info, PackageInfo packageNamespace) {
        if (!info.isSetXmlAccessOrder()) {
            info.setXmlAccessOrder(XmlAccessOrder.fromValue(packageNamespace.getAccessOrder().name()));
        }
        info.orderProperties();
    }

    private void processXmlElement(Property property, TypeInfo info) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlElementNillable.class)) {
            XmlElementNillable elementNillable = (XmlElementNillable)this.helper.getAnnotation(property.getElement(), XmlElementNillable.class);
            property.setNillable(elementNillable.nillable());
        } else if (info.isXmlElementNillable()) {
            property.setNillable(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlElement.class)) {
            XmlElement element = (XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class);
            property.setIsRequired(element.required());
            property.setNillable(element.nillable());
            if (element.type() != XmlElement.DEFAULT.class && !property.isSwaAttachmentRef()) {
                property.setOriginalType(property.getType());
                if (this.helper.isCollectionType(property.getType()) || property.getType().isArray()) {
                    property.setGenericType(this.helper.getJavaClass(element.type()));
                } else {
                    JavaClass originalType = property.getType();
                    JavaClass newType = this.helper.getJavaClass(element.type());
                    if (!originalType.getName().equals(newType.getName())) {
                        property.setTyped(true);
                        property.setSchemaType(this.helper.getXMLToJavaTypeMap().get(newType.getName()));
                    }
                    property.setType(newType);
                }
                property.setHasXmlElementType(true);
            }
            if (!element.defaultValue().equals(ELEMENT_DECL_DEFAULT)) {
                property.setDefaultValue(element.defaultValue());
            }
            if (this.facets) {
                this.addFacets(property);
            }
        }
    }

    private void addFacets(Property property) {
        Facet facet;
        Annotation a;
        JavaHasAnnotations element = property.getElement();
        if (this.helper.isAnnotationPresent(element, DecimalMin.class)) {
            a = (DecimalMin)this.helper.getAnnotation(element, DecimalMin.class);
            facet = new DecimalMinFacet(a.value(), a.inclusive());
            property.addFacet(facet);
        }
        if (this.helper.isAnnotationPresent(element, DecimalMax.class)) {
            a = (DecimalMax)this.helper.getAnnotation(element, DecimalMax.class);
            facet = new DecimalMaxFacet(a.value(), a.inclusive());
            property.addFacet(facet);
        }
        if (this.helper.isAnnotationPresent(element, Digits.class)) {
            a = (Digits)this.helper.getAnnotation(element, Digits.class);
            facet = new DigitsFacet(a.integer(), a.fraction());
            property.addFacet(facet);
        }
        if (this.helper.isAnnotationPresent(element, Max.class)) {
            a = (Max)this.helper.getAnnotation(element, Max.class);
            facet = new MaxFacet(a.value());
            property.addFacet(facet);
        }
        if (this.helper.isAnnotationPresent(element, Min.class)) {
            a = (Min)this.helper.getAnnotation(element, Min.class);
            facet = new MinFacet(a.value());
            property.addFacet(facet);
        }
        if (this.helper.isAnnotationPresent(element, NotNull.class)) {
            property.setNotNullAnnotated(true);
        }
        if (this.helper.isAnnotationPresent(element, Pattern.class)) {
            a = (Pattern)this.helper.getAnnotation(element, Pattern.class);
            facet = new PatternFacet(a.regexp(), a.flags());
            property.addFacet(facet);
        }
        if (this.helper.isAnnotationPresent(element, Pattern.List.class)) {
            a = (Pattern.List)this.helper.getAnnotation(element, Pattern.List.class);
            facet = new PatternListFacet(new ArrayList<PatternFacet>());
            for (Pattern pat : a.value()) {
                PatternFacet pf = new PatternFacet(pat.regexp(), pat.flags());
                ((PatternListFacet)facet).addPattern(pf);
            }
            property.addFacet(facet);
        }
        if (this.helper.isAnnotationPresent(element, Size.class)) {
            a = (Size)this.helper.getAnnotation(element, Size.class);
            int min = a.min();
            int max = a.max();
            if (min != 0 || max != Integer.MAX_VALUE) {
                if ("java.lang.String".equals(property.getType().getName())) {
                    SizeFacet facet2 = new SizeFacet(min, max);
                    property.addFacet(facet2);
                } else {
                    if (min > 0) {
                        property.setMinOccurs(min);
                    }
                    if (max < Integer.MAX_VALUE) {
                        property.setMaxOccurs(max);
                    }
                }
            }
        }
    }

    private void processXmlID(Property property, JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
            property.setIsXmlId(true);
            info.setIDProperty(property);
        }
    }

    private void processXmlIDREF(Property property) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
            property.setIsXmlIdRef(true);
        }
    }

    private void processXmlJavaTypeAdapter(Property property, TypeInfo info, JavaClass javaClass) {
        JavaClass adapterClass = null;
        JavaClass ptype = property.getActualType();
        if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
            XmlJavaTypeAdapter adapter = (XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter xja = new org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter();
            xja.setValue(adapter.value().getName());
            xja.setType(adapter.type().getName());
            property.setXmlJavaTypeAdapter(xja);
        } else {
            org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter xmlJavaTypeAdapter;
            TypeInfo ptypeInfo = this.typeInfos.get(ptype.getQualifiedName());
            if (ptypeInfo == null && this.shouldGenerateTypeInfo(ptype) && this.helper.isAnnotationPresent(ptype, XmlJavaTypeAdapter.class)) {
                XmlJavaTypeAdapter adapter = (XmlJavaTypeAdapter)this.helper.getAnnotation(ptype, XmlJavaTypeAdapter.class);
                org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter xja = new org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter();
                xja.setValue(adapter.value().getName());
                xja.setType(adapter.type().getName());
                property.setXmlJavaTypeAdapter(xja);
            }
            if (ptypeInfo != null && null != (xmlJavaTypeAdapter = ptypeInfo.getXmlJavaTypeAdapter())) {
                try {
                    property.setXmlJavaTypeAdapter(xmlJavaTypeAdapter);
                }
                catch (JAXBException e) {
                    throw JAXBException.invalidTypeAdapterClass(xmlJavaTypeAdapter.getValue(), javaClass.getName());
                }
            }
            if (info.hasPackageLevelAdaptersByClass() && info.getPackageLevelAdaptersByClass().get(ptype.getQualifiedName()) != null && !property.isSetXmlJavaTypeAdapter()) {
                adapterClass = info.getPackageLevelAdapterClass(ptype);
                org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter xja = new org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter();
                xja.setValue(adapterClass.getQualifiedName());
                xja.setType(ptype.getQualifiedName());
                property.setXmlJavaTypeAdapter(xja);
            }
        }
    }

    private void processTypeQName(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        if (info.isTransient()) {
            return;
        }
        String typeName = info.getSchemaTypeName();
        if (typeName != null && !EMPTY_STRING.equals(typeName)) {
            QName typeQName = new QName(info.getClassNamespace(), typeName);
            boolean containsQName = this.typeQNames.contains(typeQName);
            if (containsQName) {
                throw JAXBException.nameCollision(typeQName.getNamespaceURI(), typeQName.getLocalPart());
            }
            this.typeQNames.add(typeQName);
        }
    }

    public boolean shouldGenerateTypeInfo(JavaClass javaClass) {
        String javaClassName;
        if (javaClass == null || javaClass.isPrimitive() || javaClass.isAnnotation() || ORG_W3C_DOM.equals(javaClass.getPackageName())) {
            return false;
        }
        if (this.userDefinedSchemaTypes.get(javaClass.getQualifiedName()) != null) {
            return false;
        }
        if (javaClass.isArray() && !(javaClassName = javaClass.getName()).equals(CoreClassConstants.APBYTE.getName()) && !javaClassName.equals(CoreClassConstants.ABYTE.getName())) {
            return true;
        }
        if (this.helper.isBuiltInJavaType(javaClass) && !javaClass.isEnum()) {
            return false;
        }
        return !this.helper.isCollectionType(javaClass) && !this.helper.isMapType(javaClass);
    }

    public ArrayList<Property> getPropertiesForClass(JavaClass cls, TypeInfo info) {
        JavaClass superClass;
        ArrayList<Property> returnList = new ArrayList<Property>();
        if (!info.isTransient() && null != (superClass = cls.getSuperclass())) {
            TypeInfo superClassInfo = this.typeInfos.get(superClass.getQualifiedName());
            while (superClassInfo != null && superClassInfo.isTransient()) {
                ArrayList<Property> superClassProperties = info.getXmlAccessType() == XmlAccessType.FIELD ? this.getFieldPropertiesForClass(superClass, superClassInfo, false) : (info.getXmlAccessType() == XmlAccessType.PROPERTY ? this.getPropertyPropertiesForClass(superClass, superClassInfo, false) : (info.getXmlAccessType() == XmlAccessType.PUBLIC_MEMBER ? this.getPublicMemberPropertiesForClass(superClass, superClassInfo) : this.getNoAccessTypePropertiesForClass(superClass, superClassInfo)));
                superClass = superClass.getSuperclass();
                superClassInfo = this.typeInfos.get(superClass.getQualifiedName());
                for (Property next : superClassProperties) {
                    next.setIsSuperClassProperty(true);
                }
                returnList.addAll(0, (Collection<Property>)superClassProperties);
            }
        }
        if (info.isTransient()) {
            returnList.addAll(this.getNoAccessTypePropertiesForClass(cls, info));
        } else if (info.getXmlAccessType() == XmlAccessType.FIELD) {
            returnList.addAll(this.getFieldPropertiesForClass(cls, info, false));
            returnList.addAll(this.getPropertyPropertiesForClass(cls, info, false, true));
        } else if (info.getXmlAccessType() == XmlAccessType.PROPERTY) {
            returnList.addAll(this.getFieldPropertiesForClass(cls, info, false, true));
            returnList.addAll(this.getPropertyPropertiesForClass(cls, info, false));
        } else if (info.getXmlAccessType() == XmlAccessType.PUBLIC_MEMBER) {
            returnList.addAll(this.getPublicMemberPropertiesForClass(cls, info));
        } else {
            returnList.addAll(this.getNoAccessTypePropertiesForClass(cls, info));
        }
        return returnList;
    }

    public ArrayList<Property> getFieldPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        return this.getFieldPropertiesForClass(cls, info, onlyPublic, false);
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList<Property> getFieldPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic, boolean onlyExplicit) {
        properties = new ArrayList<Property>();
        if (cls == null) {
            return properties;
        }
        for (JavaField javaField : cls.getDeclaredFields()) {
            block13: {
                property = null;
                modifiers = javaField.getModifiers();
                if (!Modifier.isTransient(modifiers) && (Modifier.isPublic(javaField.getModifiers()) && onlyPublic || !onlyPublic || this.hasJAXBAnnotations(javaField))) {
                    if (!Modifier.isStatic(modifiers)) {
                        if (onlyExplicit && this.hasJAXBAnnotations(javaField) || !onlyExplicit) {
                            try {
                                property = this.buildNewProperty(info, cls, javaField, javaField.getName(), javaField.getResolvedType());
                                properties.add(property);
                            }
                            catch (JAXBException ex) {
                                if (ex.getErrorCode() == 50089 && this.helper.isAnnotationPresent(javaField, XmlTransient.class)) ** GOTO lbl35
                                throw ex;
                            }
                        }
                    } else {
                        try {
                            property = this.buildNewProperty(info, cls, javaField, javaField.getName(), javaField.getResolvedType());
                            if (this.helper.isAnnotationPresent(javaField, XmlAttribute.class) && (value = ((JavaFieldImpl)javaField).get(null)) != null) {
                                stringValue = XMLConversionManager.getDefaultXMLManager().convertObject(value, String.class, property.getSchemaType());
                                property.setFixedValue(stringValue);
                            }
                            property.setWriteOnly(true);
                            if (!this.hasJAXBAnnotations(javaField)) {
                                property.setTransient(true);
                            }
                            properties.add(property);
                        }
                        catch (ClassCastException | IllegalAccessException value) {
                        }
                        catch (JAXBException ex) {
                            if (ex.getErrorCode() == 50089 && this.helper.isAnnotationPresent(javaField, XmlTransient.class)) break block13;
                            throw ex;
                        }
                    }
                }
            }
            if (!this.helper.isAnnotationPresent(javaField, XmlTransient.class) || property == null) continue;
            property.setTransient(true);
        }
        return properties;
    }

    Property buildNewProperty(TypeInfo info, JavaClass cls, JavaHasAnnotations javaHasAnnotations, String propertyName, JavaClass ptype) {
        TypeInfo refClassInfo;
        Property property = null;
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlElements.class)) {
            property = this.buildChoiceProperty(javaHasAnnotations);
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementRef.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementRefs.class)) {
            this.findAndProcessObjectFactory(cls);
            property = this.buildReferenceProperty(info, javaHasAnnotations, propertyName, ptype);
            if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyElement.class)) {
                anyElement = (XmlAnyElement)this.helper.getAnnotation(javaHasAnnotations, XmlAnyElement.class);
                property.setIsAny(true);
                if (anyElement.value() != null) {
                    property.setDomHandlerClassName(anyElement.value().getName());
                }
                property.setLax(anyElement.lax());
                info.setAnyElementPropertyName(propertyName);
            }
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyElement.class)) {
            this.findAndProcessObjectFactory(cls);
            anyElement = (XmlAnyElement)this.helper.getAnnotation(javaHasAnnotations, XmlAnyElement.class);
            property = new Property(this.helper);
            property.setIsAny(true);
            if (anyElement.value() != null) {
                property.setDomHandlerClassName(anyElement.value().getName());
            }
            property.setLax(anyElement.lax());
            info.setAnyElementPropertyName(propertyName);
        } else {
            property = this.helper.isAnnotationPresent(javaHasAnnotations, org.eclipse.persistence.oxm.annotations.XmlTransformation.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlReadTransformer.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlWriteTransformer.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlWriteTransformers.class) ? this.buildTransformationProperty(javaHasAnnotations, cls) : new Property(this.helper);
        }
        property.setPropertyName(propertyName);
        property.setElement(javaHasAnnotations);
        if (this.helper.isCollectionType(ptype)) {
            JavaClass componentType = this.helper.getJavaClass(Object.class);
            Collection<JavaClass> typeArgs = ptype.getActualTypeArguments();
            if (!typeArgs.isEmpty()) {
                componentType = typeArgs.iterator().next();
            }
            this.updatePropertyType(property, ptype, componentType);
        } else {
            this.updatePropertyType(property, ptype, ptype);
        }
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlVariableNode.class)) {
            XmlVariableNode variableNode = (XmlVariableNode)this.helper.getAnnotation(javaHasAnnotations, XmlVariableNode.class);
            if (variableNode.type() != XmlVariableNode.DEFAULT.class) {
                property.setVariableClassName(variableNode.type().getName());
                JavaClass componentType = this.helper.getJavaClass(variableNode.type());
                if (this.helper.isCollectionType(ptype)) {
                    property.setGenericType(componentType);
                } else {
                    property.setType(componentType);
                }
            }
            if (!variableNode.value().equals("##default")) {
                property.setVariableAttributeName(variableNode.value());
            }
            property.setVariableNodeAttribute(variableNode.attribute());
        }
        if (ptype.isArray() && !this.areEquals(ptype, byte[].class) || this.helper.isCollectionType(ptype) && !this.helper.isAnnotationPresent(javaHasAnnotations, XmlList.class)) {
            property.setNillable(true);
        }
        this.processPropertyAnnotations(info, cls, javaHasAnnotations, property);
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlPath.class)) {
            XmlPath xmlPath = (XmlPath)this.helper.getAnnotation(javaHasAnnotations, XmlPath.class);
            property.setXmlPath(xmlPath.value());
            XMLField tempField = new XMLField(xmlPath.value());
            boolean isAttribute = tempField.getLastXPathFragment().isAttribute();
            property.setIsAttribute(isAttribute);
            String schemaName = XMLProcessor.getNameFromXPath(xmlPath.value(), property.getPropertyName(), isAttribute);
            NamespaceInfo nsInfo = this.getPackageInfoForPackage(cls).getNamespaceInfo();
            QName qName = isAttribute ? (nsInfo.isAttributeFormQualified() ? new QName(nsInfo.getNamespace(), schemaName) : new QName(schemaName)) : (nsInfo.isElementFormQualified() ? new QName(nsInfo.getNamespace(), schemaName) : new QName(schemaName));
            property.setSchemaName(qName);
            Object currentPath = EMPTY_STRING;
            for (XPathFragment fragment = tempField.getXPathFragment(); fragment != null && !fragment.nameIsText() && !fragment.isAttribute(); fragment = fragment.getNextFragment()) {
                if (fragment.getPredicate() != null) {
                    Object fragmentPath = fragment.getLocalName();
                    if (fragment.getPrefix() != null && !EMPTY_STRING.equals(fragment.getPrefix())) {
                        fragmentPath = fragment.getPrefix() + ":" + (String)fragmentPath;
                    }
                    Object predicatePath = currentPath = (String)currentPath + (String)fragmentPath;
                    TypeInfo targetInfo = info;
                    if (fragment.getNextFragment() == null) {
                        this.processReferencedClass(ptype);
                        TypeInfo predicateTypeInfo = this.typeInfos.get(ptype.getQualifiedName());
                        if (predicateTypeInfo != null) {
                            targetInfo = predicateTypeInfo;
                            predicatePath = EMPTY_STRING;
                        }
                    }
                    Property predicateProperty = new Property(this.helper);
                    predicateProperty.setType(this.helper.getJavaClass("java.lang.String"));
                    if (!((String)predicatePath).isEmpty()) {
                        predicatePath = (String)predicatePath + SLASH;
                    }
                    predicatePath = (String)predicatePath + fragment.getPredicate().getXPathFragment().getXPath();
                    predicateProperty.setXmlPath((String)predicatePath);
                    predicateProperty.setIsAttribute(true);
                    String predschemaName = XMLProcessor.getNameFromXPath((String)predicatePath, property.getPropertyName(), true);
                    QName predQname = nsInfo.isAttributeFormQualified() ? new QName(nsInfo.getNamespace(), predschemaName) : new QName(predschemaName);
                    predicateProperty.setSchemaName(predQname);
                    if (!targetInfo.hasPredicateProperty(predicateProperty)) {
                        targetInfo.getPredicateProperties().add(predicateProperty);
                    }
                } else {
                    currentPath = (String)currentPath + fragment.getXPath();
                }
                currentPath = (String)currentPath + SLASH;
            }
        } else {
            property.setSchemaName(this.getQNameForProperty(property, propertyName, javaHasAnnotations, this.getPackageInfoForPackage(cls).getNamespaceInfo(), info));
        }
        ptype = property.getActualType();
        if (ptype.isPrimitive()) {
            if (property.getType().isArray() && this.helper.isAnnotationPresent(javaHasAnnotations, XmlElement.class)) {
                XmlElement elemAnno = (XmlElement)this.helper.getAnnotation(javaHasAnnotations, XmlElement.class);
                property.setIsRequired(elemAnno.required());
            } else {
                property.setIsRequired(true);
            }
        }
        if (!property.isSetXmlJavaTypeAdapter() && (refClassInfo = this.getTypeInfos().get(ptype.getQualifiedName())) != null && refClassInfo.isSetXmlJavaTypeAdapter()) {
            org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter xmlJavaTypeAdapter = null;
            try {
                xmlJavaTypeAdapter = refClassInfo.getXmlJavaTypeAdapter();
                property.setXmlJavaTypeAdapter(refClassInfo.getXmlJavaTypeAdapter());
            }
            catch (JAXBException e) {
                throw JAXBException.invalidTypeAdapterClass(xmlJavaTypeAdapter.getValue(), cls.getName());
            }
        }
        if (property.isXmlTransformation()) {
            this.referencedByTransformer.add(property.getType().getName());
        }
        return property;
    }

    private void updatePropertyType(Property property, JavaClass ptype, JavaClass componentType) {
        TypeInfo componentTypeInfo = this.typeInfos.get(componentType.getQualifiedName());
        if (componentTypeInfo != null && !componentTypeInfo.isTransient() || !this.helper.isAnnotationPresent(componentType, XmlTransient.class)) {
            property.setType(ptype);
        } else {
            for (JavaClass parent = componentType.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
                if (parent.getName().equals(JAVA_LANG_OBJECT)) {
                    property.setTransientType(true);
                    property.setType(ptype);
                    break;
                }
                TypeInfo parentTypeInfo = this.typeInfos.get(parent.getQualifiedName());
                if ((parentTypeInfo == null || parentTypeInfo.isTransient()) && this.helper.isAnnotationPresent(parent, XmlTransient.class)) continue;
                property.setType(parent);
                break;
            }
        }
    }

    private Property buildChoiceProperty(JavaHasAnnotations javaHasAnnotations) {
        XmlElement[] elements;
        Property choiceProperty = new Property(this.helper);
        choiceProperty.setChoice(true);
        boolean isIdRef = this.helper.isAnnotationPresent(javaHasAnnotations, XmlIDREF.class);
        choiceProperty.setIsXmlIdRef(isIdRef);
        org.eclipse.persistence.jaxb.xmlmodel.XmlElements xmlElements = new org.eclipse.persistence.jaxb.xmlmodel.XmlElements();
        for (XmlElement next : elements = ((XmlElements)this.helper.getAnnotation(javaHasAnnotations, XmlElements.class)).value()) {
            org.eclipse.persistence.jaxb.xmlmodel.XmlElement xmlElement = new org.eclipse.persistence.jaxb.xmlmodel.XmlElement();
            xmlElement.setDefaultValue(next.defaultValue());
            xmlElement.setName(next.name());
            xmlElement.setNamespace(next.namespace());
            xmlElement.setNillable(next.nillable());
            xmlElement.setRequired(next.required());
            xmlElement.setType(next.type().getName());
            xmlElements.getXmlElement().add(xmlElement);
        }
        choiceProperty.setXmlElements(xmlElements);
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementsJoinNodes.class)) {
            ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes> xmlJoinNodesList = new ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes>();
            ArrayList<XmlJoinNodes.XmlJoinNode> xmlJoinNodeList = null;
            for (XmlJoinNodes xmlJNs : ((XmlElementsJoinNodes)this.helper.getAnnotation(javaHasAnnotations, XmlElementsJoinNodes.class)).value()) {
                xmlJoinNodeList = new ArrayList<XmlJoinNodes.XmlJoinNode>();
                for (XmlJoinNode xmlJN : xmlJNs.value()) {
                    XmlJoinNodes.XmlJoinNode xmlJoinNode = new XmlJoinNodes.XmlJoinNode();
                    xmlJoinNode.setXmlPath(xmlJN.xmlPath());
                    xmlJoinNode.setReferencedXmlPath(xmlJN.referencedXmlPath());
                    xmlJoinNodeList.add(xmlJoinNode);
                }
                if (xmlJoinNodeList.isEmpty()) continue;
                org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes xmlJoinNodes = new org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes();
                xmlJoinNodes.setXmlJoinNode(xmlJoinNodeList);
                xmlJoinNodesList.add(xmlJoinNodes);
            }
            choiceProperty.setXmlJoinNodesList(xmlJoinNodesList);
        }
        return choiceProperty;
    }

    private Property buildTransformationProperty(JavaHasAnnotations javaHasAnnotations, JavaClass cls) {
        XmlReadTransformer readTransformer;
        Property property = new Property(this.helper);
        org.eclipse.persistence.oxm.annotations.XmlTransformation transformationAnnotation = (org.eclipse.persistence.oxm.annotations.XmlTransformation)this.helper.getAnnotation(javaHasAnnotations, org.eclipse.persistence.oxm.annotations.XmlTransformation.class);
        XmlTransformation transformation = new XmlTransformation();
        if (transformationAnnotation != null) {
            transformation.setOptional(transformationAnnotation.optional());
        }
        if ((readTransformer = (XmlReadTransformer)this.helper.getAnnotation(javaHasAnnotations, XmlReadTransformer.class)) != null) {
            XmlTransformation.XmlReadTransformer xmlReadTransformer = new XmlTransformation.XmlReadTransformer();
            if (readTransformer.transformerClass() != Void.TYPE) {
                xmlReadTransformer.setTransformerClass(readTransformer.transformerClass().getName());
            } else if (!readTransformer.method().equals(EMPTY_STRING)) {
                xmlReadTransformer.setMethod(readTransformer.method());
            }
            transformation.setXmlReadTransformer(xmlReadTransformer);
        }
        XmlWriteTransformer[] transformers = null;
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlWriteTransformer.class)) {
            XmlWriteTransformer writeTransformer = (XmlWriteTransformer)this.helper.getAnnotation(javaHasAnnotations, XmlWriteTransformer.class);
            transformers = new XmlWriteTransformer[]{writeTransformer};
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlWriteTransformers.class)) {
            XmlWriteTransformers writeTransformers = (XmlWriteTransformers)this.helper.getAnnotation(javaHasAnnotations, XmlWriteTransformers.class);
            transformers = writeTransformers.value();
        }
        if (transformers != null) {
            for (XmlWriteTransformer next : transformers) {
                XmlTransformation.XmlWriteTransformer xmlWriteTransformer = new XmlTransformation.XmlWriteTransformer();
                if (next.transformerClass() != Void.TYPE) {
                    xmlWriteTransformer.setTransformerClass(next.transformerClass().getName());
                } else if (!next.method().equals(EMPTY_STRING)) {
                    xmlWriteTransformer.setMethod(next.method());
                }
                xmlWriteTransformer.setXmlPath(next.xmlPath());
                transformation.getXmlWriteTransformer().add(xmlWriteTransformer);
            }
        }
        property.setXmlTransformation(transformation);
        property.setIsXmlTransformation(true);
        return property;
    }

    private void processChoiceProperty(Property choiceProperty, TypeInfo info, JavaClass cls, JavaClass propertyType) {
        String propertyName = choiceProperty.getPropertyName();
        if (choiceProperty.isSetXmlJoinNodesList() && choiceProperty.getXmlElements().getXmlElement().size() != choiceProperty.getXmlJoinNodesList().size()) {
            throw JAXBException.incorrectNumberOfXmlJoinNodesOnXmlElements(propertyName, cls.getQualifiedName());
        }
        XmlPath[] paths = null;
        if (this.helper.isAnnotationPresent(choiceProperty.getElement(), XmlPaths.class)) {
            XmlPaths pathAnnotation = (XmlPaths)this.helper.getAnnotation(choiceProperty.getElement(), XmlPaths.class);
            paths = pathAnnotation.value();
        }
        ArrayList<Property> choiceProperties = new ArrayList<Property>();
        for (int i = 0; i < choiceProperty.getXmlElements().getXmlElement().size(); ++i) {
            org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes xmlJoinNodes;
            NamespaceInfo namespaceInfo;
            String namespace;
            String name;
            org.eclipse.persistence.jaxb.xmlmodel.XmlElement next = choiceProperty.getXmlElements().getXmlElement().get(i);
            Property choiceProp = new Property(this.helper);
            choiceProp.setNillable(next.isNillable());
            choiceProp.setIsRequired(next.isRequired());
            if (paths != null && next.getXmlPath() == null) {
                XmlPath nextPath = paths[i];
                next.setXmlPath(nextPath.value());
            }
            if (next.getXmlPath() != null) {
                choiceProp.setXmlPath(next.getXmlPath());
                boolean isAttribute = new XMLField(next.getXmlPath()).getLastXPathFragment().isAttribute();
                if (isAttribute && !next.getXmlPath().contains(SLASH)) {
                    throw JAXBException.invalidXmlPathWithAttribute(propertyName, cls.getQualifiedName(), next.getXmlPath());
                }
                choiceProp.setIsAttribute(isAttribute);
                name = XMLProcessor.getNameFromXPath(next.getXmlPath(), propertyName, isAttribute);
                namespace = "##default";
            } else {
                name = next.getName();
                namespace = next.getNamespace();
            }
            if (name == null || name.equals("##default")) {
                name = next.getJavaAttribute() != null ? next.getJavaAttribute() : propertyName;
            }
            if (choiceProperty.isXmlIdRef()) {
                JavaClass nextCls = this.helper.getJavaClass(next.getType());
                this.processReferencedClass(nextCls);
                TypeInfo tInfo = this.typeInfos.get(next.getType());
                if (tInfo == null || !tInfo.isIDSet() && !this.preCheckXmlID(nextCls, tInfo)) {
                    throw JAXBException.invalidXmlElementInXmlElementsList(propertyName, name);
                }
            }
            QName qName = null;
            qName = !namespace.equals("##default") ? new QName(namespace, name) : ((namespaceInfo = this.getPackageInfoForPackage(cls).getNamespaceInfo()).isElementFormQualified() ? new QName(namespaceInfo.getNamespace(), name) : new QName(name));
            choiceProp.setPropertyName(name);
            if (next.getType().equals("jakarta.xml.bind.annotation.XmlElement.DEFAULT") || next.getType().equals("jakarta.xml.bind.annotation.XmlElement$DEFAULT")) {
                choiceProp.setType(propertyType);
            } else {
                choiceProp.setType(this.helper.getJavaClass(next.getType()));
            }
            if (choiceProperty.isSetXmlJoinNodesList() && (xmlJoinNodes = choiceProperty.getXmlJoinNodesList().get(i)) != null) {
                choiceProp.setXmlJoinNodes(xmlJoinNodes);
                if (!xmlJoinNodes.getType().equals("##default")) {
                    JavaClass pType = this.helper.getJavaClass(xmlJoinNodes.getType());
                    if (this.helper.isCollectionType(choiceProp.getType())) {
                        choiceProp.setGenericType(pType);
                    } else {
                        choiceProp.setType(pType);
                    }
                }
            }
            choiceProp.setSchemaName(qName);
            choiceProp.setSchemaType(this.getSchemaTypeFor(choiceProp.getType()));
            choiceProp.setIsXmlIdRef(choiceProperty.isXmlIdRef());
            choiceProp.setXmlElementWrapper(choiceProperty.getXmlElementWrapper());
            choiceProperties.add(choiceProp);
            this.processReferencedClass(choiceProp.getType());
            TypeInfo newInfo = this.typeInfos.get(choiceProp.getType().getQualifiedName());
            if (newInfo == null || !newInfo.isTransient()) continue;
            throw JAXBException.invalidReferenceToTransientClass(info.getJavaClassName(), choiceProperty.getPropertyName(), newInfo.getJavaClassName());
        }
        choiceProperty.setChoiceProperties(choiceProperties);
    }

    private boolean preCheckXmlID(JavaClass javaClass, TypeInfo typeInfo) {
        ArrayList<Property> properties = this.getPropertiesForClass(javaClass, typeInfo);
        for (Property property : properties) {
            if (!this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) continue;
            return true;
        }
        if (this.typeInfos.get(javaClass.getSuperclass().getQualifiedName()).isIDSet()) {
            if (typeInfo.getIDProperty() == null) {
                typeInfo.setIDProperty(this.typeInfos.get(javaClass.getSuperclass().getQualifiedName()).getIDProperty());
            }
            return true;
        }
        return false;
    }

    private Property buildReferenceProperty(TypeInfo info, JavaHasAnnotations javaHasAnnotations, String propertyName, JavaClass ptype) {
        XmlElementRef[] elementRefs;
        Property property = new Property(this.helper);
        property.setType(ptype);
        XmlElementRef ref = (XmlElementRef)this.helper.getAnnotation(javaHasAnnotations, XmlElementRef.class);
        if (ref != null) {
            elementRefs = new XmlElementRef[]{ref};
        } else {
            XmlElementRefs refs = (XmlElementRefs)this.helper.getAnnotation(javaHasAnnotations, XmlElementRefs.class);
            elementRefs = refs.value();
            info.setElementRefsPropertyName(propertyName);
        }
        ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef> eltRefs = new ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef>();
        for (XmlElementRef nextRef : elementRefs) {
            org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef eltRef = new org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef();
            eltRef.setName(nextRef.name());
            eltRef.setNamespace(nextRef.namespace());
            eltRef.setType(nextRef.type().getName());
            property.setIsRequired(true);
            try {
                Method requireMethod = PrivilegedAccessHelper.getMethod(XmlElementRef.class, "required", new Class[0], true);
                if (requireMethod != null) {
                    Boolean val = (Boolean)PrivilegedAccessHelper.invokeMethod(requireMethod, nextRef);
                    property.setIsRequired(val);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            eltRefs.add(eltRef);
        }
        property.setIsReference(true);
        property.setXmlElementRefs(eltRefs);
        return property;
    }

    private Property processReferenceProperty(Property property, TypeInfo info, JavaClass cls) {
        for (org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef nextRef : property.getXmlElementRefs()) {
            JavaClass type2 = property.getType();
            if (this.helper.isCollectionType(property.getType()) && type2.hasActualTypeArguments()) {
                type2 = property.getGenericType();
                String string = type2.getQualifiedName();
            }
            if (!nextRef.getType().equals("jakarta.xml.bind.annotation.XmlElementRef.DEFAULT") && !nextRef.getType().equals("jakarta.xml.bind.annotation.XmlElementRef$DEFAULT")) {
                String typeName = nextRef.getType();
                type2 = this.helper.getJavaClass(typeName);
            }
            boolean missingReference = true;
            for (Map.Entry<String, ElementDeclaration> entry : this.xmlRootElements.entrySet()) {
                ElementDeclaration entryValue = entry.getValue();
                if (this.areEquals(type2, Object.class) || !type2.isAssignableFrom(entryValue.getJavaType())) continue;
                this.addReferencedElement(property, entryValue);
                missingReference = false;
            }
            if (!missingReference) continue;
            String name = nextRef.getName();
            String namespace = nextRef.getNamespace();
            if (namespace.equals("##default")) {
                namespace = EMPTY_STRING;
            }
            QName qname = new QName(namespace, name);
            JavaClass scopeClass = cls;
            ElementDeclaration referencedElement = null;
            while (!scopeClass.getName().equals(JAVA_LANG_OBJECT)) {
                Map<QName, ElementDeclaration> elements = this.getElementDeclarationsForScope(scopeClass.getName());
                if (elements != null) {
                    referencedElement = elements.get(qname);
                }
                if (referencedElement != null) break;
                scopeClass = scopeClass.getSuperclass();
            }
            if (referencedElement == null) {
                referencedElement = this.getGlobalElements().get(qname);
            }
            if (referencedElement != null) {
                this.addReferencedElement(property, referencedElement);
                continue;
            }
            throw JAXBException.invalidElementRef(property.getPropertyName(), cls.getName());
        }
        return property;
    }

    private void processReferencePropertyTypes(Property property, TypeInfo info, JavaClass theClass) {
        for (org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef nextRef : property.getXmlElementRefs()) {
            Collection<JavaClass> args;
            JavaClass type2 = property.getType();
            String typeName = type2.getQualifiedName();
            if (this.helper.isCollectionType(property.getType()) && type2.hasActualTypeArguments()) {
                type2 = property.getGenericType();
                typeName = type2.getQualifiedName();
            }
            if (JAVAX_XML_BIND_JAXBELEMENT.equals(typeName) && !(args = type2.getActualTypeArguments()).isEmpty()) {
                JavaClass theType = args.iterator().next();
                this.processReferencedClass(theType);
            }
            if (!nextRef.getType().equals("jakarta.xml.bind.annotation.XmlElementRef.DEFAULT") && !nextRef.getType().equals("jakarta.xml.bind.annotation.XmlElementRef$DEFAULT")) {
                typeName = nextRef.getType();
                type2 = this.helper.getJavaClass(typeName);
            }
            this.processReferencedClass(type2);
        }
    }

    private void processPropertyAnnotations(TypeInfo info, JavaClass cls, JavaHasAnnotations propertyElement, Property property) {
        if (this.helper.isAnnotationPresent(propertyElement, XmlMixed.class)) {
            info.setMixed(true);
            property.setMixedContent(true);
            this.findAndProcessObjectFactory(cls);
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlInverseReference.class)) {
            XmlInverseReference inverseReference = (XmlInverseReference)this.helper.getAnnotation(propertyElement, XmlInverseReference.class);
            property.setInverseReferencePropertyName(inverseReference.mappedBy());
            TypeInfo targetInfo = this.getTypeInfos().get(property.getActualType().getName());
            if (targetInfo != null && targetInfo.getXmlAccessType() == XmlAccessType.PROPERTY) {
                Object propName = property.getPropertyName();
                propName = Character.toUpperCase(((String)propName).charAt(0)) + ((String)propName).substring(1);
                property.setInverseReferencePropertyGetMethodName(GET_STR + (String)propName);
                property.setInverseReferencePropertySetMethodName(SET_STR + (String)propName);
            }
            property.setInverseReference(true, this.helper.isAnnotationPresent(propertyElement, XmlElement.class));
        }
        this.processXmlJavaTypeAdapter(property, info, cls);
        if (this.helper.isAnnotationPresent(propertyElement, XmlAttachmentRef.class) && this.areEquals(property.getActualType(), JAVAX_ACTIVATION_DATAHANDLER)) {
            property.setIsSwaAttachmentRef(true);
            property.setSchemaType(Constants.SWA_REF_QNAME);
        }
        this.processXmlElement(property, info);
        if (!property.isSwaAttachmentRef() && this.isMtomAttachment(property)) {
            property.setIsMtomAttachment(true);
            property.setSchemaType(Constants.BASE_64_BINARY_QNAME);
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlMimeType.class)) {
            property.setMimeType(((XmlMimeType)this.helper.getAnnotation(propertyElement, XmlMimeType.class)).value());
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlInlineBinaryData.class) || info.isBinaryDataToBeInlined()) {
            property.setisInlineBinaryData(true);
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlSchemaType.class)) {
            XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(propertyElement, XmlSchemaType.class);
            QName schemaTypeQname = new QName(schemaType.namespace(), schemaType.name());
            property.setSchemaType(schemaTypeQname);
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlAttribute.class)) {
            property.setIsAttribute(true);
            property.setIsRequired(((XmlAttribute)this.helper.getAnnotation(propertyElement, XmlAttribute.class)).required());
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlAnyAttribute.class)) {
            if (info.isSetAnyAttributePropertyName() && !info.getAnyAttributePropertyName().equals(property.getPropertyName())) {
                throw JAXBException.multipleAnyAttributeMapping(cls.getName());
            }
            if (!this.helper.isMapType(property.getType())) {
                throw JAXBException.anyAttributeOnNonMap(property.getPropertyName());
            }
            property.setIsAnyAttribute(true);
            info.setAnyAttributePropertyName(property.getPropertyName());
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlElementWrapper.class)) {
            XmlElementWrapper wrapper = (XmlElementWrapper)this.helper.getAnnotation(propertyElement, XmlElementWrapper.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper xmlEltWrapper = new org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper();
            String wrapperName = wrapper.name();
            if (wrapperName.equals("##default")) {
                wrapperName = info.getXmlNameTransformer().transformElementName(property.getPropertyName());
            }
            xmlEltWrapper.setName(wrapperName);
            xmlEltWrapper.setNamespace(wrapper.namespace());
            xmlEltWrapper.setNillable(wrapper.nillable());
            xmlEltWrapper.setRequired(wrapper.required());
            property.setXmlElementWrapper(xmlEltWrapper);
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlList.class)) {
            if (!this.helper.isCollectionType(property.getType()) && !property.getType().isArray()) {
                throw JAXBException.invalidList(property.getPropertyName());
            }
            property.setIsXmlList(true);
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlValue.class)) {
            property.setIsXmlValue(true);
            info.setXmlValueProperty(property);
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlReadOnly.class)) {
            property.setReadOnly(true);
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlWriteOnly.class)) {
            property.setWriteOnly(true);
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlCDATA.class)) {
            property.setCdata(true);
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlAccessMethods.class)) {
            XmlAccessMethods accessMethods = (XmlAccessMethods)this.helper.getAnnotation(propertyElement, XmlAccessMethods.class);
            if (!accessMethods.getMethodName().equals(EMPTY_STRING)) {
                property.setGetMethodName(accessMethods.getMethodName());
            }
            if (!accessMethods.setMethodName().equals(EMPTY_STRING)) {
                property.setSetMethodName(accessMethods.setMethodName());
            }
            if (!property.isMethodProperty()) {
                property.setMethodProperty(true);
            }
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlProperties.class)) {
            XmlProperties xmlProperties = (XmlProperties)this.helper.getAnnotation(propertyElement, XmlProperties.class);
            propertiesMap = this.createUserPropertiesMap(xmlProperties.value());
            property.setUserProperties(propertiesMap);
        } else if (this.helper.isAnnotationPresent(propertyElement, XmlProperty.class)) {
            XmlProperty xmlProperty = (XmlProperty)this.helper.getAnnotation(propertyElement, XmlProperty.class);
            propertiesMap = this.createUserPropertiesMap(new XmlProperty[]{xmlProperty});
            property.setUserProperties(propertiesMap);
        }
        if (this.helper.isAnnotationPresent(propertyElement, XmlKey.class)) {
            info.addXmlKeyProperty(property);
        }
        this.processXmlJoinNodes(property);
        this.processXmlNullPolicy(property, cls, info);
        JavaHasAnnotations elem = propertyElement;
        if (this.helper.isAnnotationPresent(elem, XmlLocation.class) || this.helper.isAnnotationPresent(elem, CompilerHelper.XML_LOCATION_ANNOTATION_CLASS) || this.helper.isAnnotationPresent(elem, CompilerHelper.OLD_XML_LOCATION_ANNOTATION_CLASS) || this.helper.isAnnotationPresent(elem, CompilerHelper.INTERNAL_XML_LOCATION_ANNOTATION_CLASS)) {
            if (!this.helper.getJavaClass(Constants.LOCATOR_CLASS).isAssignableFrom(property.getType())) {
                throw JAXBException.invalidXmlLocation(property.getPropertyName(), property.getType().getName());
            }
            property.setXmlLocation(true);
        }
    }

    private void processXmlJoinNodes(Property property) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlJoinNodes.class)) {
            ArrayList<XmlJoinNodes.XmlJoinNode> xmlJoinNodeList = new ArrayList<XmlJoinNodes.XmlJoinNode>();
            for (XmlJoinNode xmlJN : ((XmlJoinNodes)this.helper.getAnnotation(property.getElement(), XmlJoinNodes.class)).value()) {
                XmlJoinNodes.XmlJoinNode xmlJoinNode = new XmlJoinNodes.XmlJoinNode();
                xmlJoinNode.setXmlPath(xmlJN.xmlPath());
                xmlJoinNode.setReferencedXmlPath(xmlJN.referencedXmlPath());
                xmlJoinNodeList.add(xmlJoinNode);
            }
            org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes xmlJoinNodes = new org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes();
            xmlJoinNodes.setXmlJoinNode(xmlJoinNodeList);
            property.setXmlJoinNodes(xmlJoinNodes);
        } else if (this.helper.isAnnotationPresent(property.getElement(), XmlJoinNode.class)) {
            XmlJoinNode xmlJN = (XmlJoinNode)this.helper.getAnnotation(property.getElement(), XmlJoinNode.class);
            XmlJoinNodes.XmlJoinNode xmlJoinNode = new XmlJoinNodes.XmlJoinNode();
            xmlJoinNode.setXmlPath(xmlJN.xmlPath());
            xmlJoinNode.setReferencedXmlPath(xmlJN.referencedXmlPath());
            ArrayList<XmlJoinNodes.XmlJoinNode> xmlJoinNodeList = new ArrayList<XmlJoinNodes.XmlJoinNode>();
            xmlJoinNodeList.add(xmlJoinNode);
            org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes xmlJoinNodes = new org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes();
            xmlJoinNodes.setXmlJoinNode(xmlJoinNodeList);
            property.setXmlJoinNodes(xmlJoinNodes);
        }
    }

    private void validateXmlTransformationProperty(Property property) {
        if (property.isSetXmlTransformation()) {
            XmlTransformation xmlTransformation = property.getXmlTransformation();
            if (xmlTransformation.isSetXmlReadTransformer()) {
                XmlTransformation.XmlReadTransformer readTransformer = xmlTransformation.getXmlReadTransformer();
                if (readTransformer.isSetTransformerClass()) {
                    if (readTransformer.isSetMethod()) {
                        throw JAXBException.readTransformerHasBothClassAndMethod(property.getPropertyName());
                    }
                } else if (!readTransformer.isSetMethod()) {
                    throw JAXBException.readTransformerHasNeitherClassNorMethod(property.getPropertyName());
                }
            }
            if (xmlTransformation.isSetXmlWriteTransformers()) {
                for (XmlTransformation.XmlWriteTransformer writeTransformer : xmlTransformation.getXmlWriteTransformer()) {
                    if (!writeTransformer.isSetXmlPath()) {
                        throw JAXBException.writeTransformerHasNoXmlPath(property.getPropertyName());
                    }
                    if (writeTransformer.isSetTransformerClass()) {
                        if (!writeTransformer.isSetMethod()) continue;
                        throw JAXBException.writeTransformerHasBothClassAndMethod(property.getPropertyName(), writeTransformer.getXmlPath());
                    }
                    if (writeTransformer.isSetMethod()) continue;
                    throw JAXBException.writeTransformerHasNeitherClassNorMethod(property.getPropertyName(), writeTransformer.getXmlPath());
                }
            }
        }
    }

    protected boolean areEquals(JavaClass src, Class<?> tgt) {
        if (src == null || tgt == null) {
            return false;
        }
        return src.getRawName().equals(tgt.getCanonicalName());
    }

    private void processXmlNullPolicy(Property property, JavaClass cls, TypeInfo info) {
        if (this.propertyHasXmlNullPolicyAnnotation(property)) {
            this.setNullPolicyOnProperty(property, this.helper.getAnnotation(property.getElement(), XmlNullPolicy.class));
        } else if (this.existsExternalMappingWithJavaTypeXmlNullPolicy(info)) {
            property.setNullPolicy(info.getXmlNullPolicy());
        } else if (this.javaTypeHasXmlNullPolicyAnnotation(cls)) {
            this.setNullPolicyOnProperty(property, this.helper.getAnnotation(cls, XmlNullPolicy.class));
        } else if (this.existsExternaMappingWithPackageXmlNullPolicy(cls)) {
            property.setNullPolicy(this.packageToXmlNillableInfoMappings.get(cls.getPackageName()).getXmlNullPolicy());
        } else if (this.helper.isAnnotationPresent(cls.getPackage(), XmlNullPolicy.class)) {
            this.setNullPolicyOnProperty(property, this.helper.getAnnotation(cls.getPackage(), XmlNullPolicy.class));
        } else if (this.helper.isAnnotationPresent(property.getElement(), XmlIsSetNullPolicy.class)) {
            XmlIsSetNullPolicy nullPolicy = (XmlIsSetNullPolicy)this.helper.getAnnotation(property.getElement(), XmlIsSetNullPolicy.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlIsSetNullPolicy policy = new org.eclipse.persistence.jaxb.xmlmodel.XmlIsSetNullPolicy();
            policy.setEmptyNodeRepresentsNull(nullPolicy.emptyNodeRepresentsNull());
            policy.setXsiNilRepresentsNull(nullPolicy.xsiNilRepresentsNull());
            policy.setNullRepresentationForXml(XmlMarshalNullRepresentation.valueOf(nullPolicy.nullRepresentationForXml().toString()));
            policy.setIsSetMethodName(nullPolicy.isSetMethodName());
            for (XmlParameter next : nullPolicy.isSetParameters()) {
                XmlIsSetNullPolicy.IsSetParameter param = new XmlIsSetNullPolicy.IsSetParameter();
                param.setValue(next.value());
                param.setType(next.type().getName());
                policy.getIsSetParameter().add(param);
            }
            property.setNullPolicy(policy);
        }
    }

    private boolean existsExternaMappingWithPackageXmlNullPolicy(JavaClass cls) {
        if (null == this.packageToXmlNillableInfoMappings || !this.packageToXmlNillableInfoMappings.containsKey(cls.getPackageName())) {
            return false;
        }
        return null != this.packageToXmlNillableInfoMappings.get(cls.getPackageName()).getXmlNullPolicy();
    }

    private boolean javaTypeHasXmlNullPolicyAnnotation(JavaClass cls) {
        return this.helper.isAnnotationPresent(cls, XmlNullPolicy.class);
    }

    private boolean existsExternalMappingWithJavaTypeXmlNullPolicy(TypeInfo info) {
        return null != info.getXmlNullPolicy();
    }

    private boolean propertyHasXmlNullPolicyAnnotation(Property property) {
        return this.helper.isAnnotationPresent(property.getElement(), XmlNullPolicy.class);
    }

    private void setNullPolicyOnProperty(Property property, Annotation nullPolicyAnnotation) {
        XmlNullPolicy nullPolicy = (XmlNullPolicy)nullPolicyAnnotation;
        org.eclipse.persistence.jaxb.xmlmodel.XmlNullPolicy policy = new org.eclipse.persistence.jaxb.xmlmodel.XmlNullPolicy();
        policy.setEmptyNodeRepresentsNull(nullPolicy.emptyNodeRepresentsNull());
        policy.setIsSetPerformedForAbsentNode(nullPolicy.isSetPerformedForAbsentNode());
        policy.setXsiNilRepresentsNull(nullPolicy.xsiNilRepresentsNull());
        policy.setNullRepresentationForXml(XmlMarshalNullRepresentation.valueOf(nullPolicy.nullRepresentationForXml().toString()));
        property.setNullPolicy(policy);
    }

    protected boolean areEquals(JavaClass src, String tgtCanonicalName) {
        if (src == null || tgtCanonicalName == null) {
            return false;
        }
        return src.getRawName().equals(tgtCanonicalName);
    }

    public ArrayList<Property> getPropertyPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        return this.getPropertyPropertiesForClass(cls, info, onlyPublic, false);
    }

    public ArrayList<Property> getPropertyPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic, boolean onlyExplicit) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (cls == null) {
            return properties;
        }
        ArrayList<JavaMethod> propertyMethods = new ArrayList<JavaMethod>();
        for (JavaMethod next : new ArrayList<JavaMethod>(cls.getDeclaredMethods())) {
            int modifiers;
            if (next.isSynthetic()) continue;
            if ((next.getName().startsWith(GET_STR) && next.getName().length() > 3 || next.getName().startsWith(IS_STR) && next.getName().length() > 2) && next.getParameterTypes().length == 0 && next.getReturnType() != this.helper.getJavaClass(Void.class)) {
                modifiers = next.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || (!onlyPublic || !Modifier.isPublic(next.getModifiers())) && onlyPublic && !this.hasJAXBAnnotations(next)) continue;
                propertyMethods.add(next);
                continue;
            }
            if (!next.getName().startsWith(SET_STR) || next.getName().length() <= 3 || next.getParameterTypes().length != 1 || Modifier.isStatic(modifiers = next.getModifiers()) || Modifier.isTransient(modifiers) || (!onlyPublic || !Modifier.isPublic(next.getModifiers())) && onlyPublic && !this.hasJAXBAnnotations(next)) continue;
            propertyMethods.add(next);
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (JavaMethod propertyMethod1 : propertyMethods) {
            JavaMethod setMethod;
            JavaMethod getMethod;
            boolean isPropertyTransient = false;
            JavaMethod nextMethod = propertyMethod1;
            String propertyName = EMPTY_STRING;
            JavaMethod propertyMethod = null;
            if (!nextMethod.getName().startsWith(SET_STR)) {
                if (nextMethod.getName().startsWith(GET_STR)) {
                    propertyName = nextMethod.getName().substring(3);
                } else if (nextMethod.getName().startsWith(IS_STR)) {
                    propertyName = nextMethod.getName().substring(2);
                }
                getMethod = nextMethod;
                String setMethodName = SET_STR + propertyName;
                propertyName = org.eclipse.persistence.internal.helper.Helper.decapitalize(propertyName);
                JavaClass[] paramTypes = new JavaClass[]{getMethod.getReturnType()};
                setMethod = cls.getDeclaredMethod(setMethodName, paramTypes);
                if (setMethod == null) {
                    setMethod = cls.getMethod(setMethodName, paramTypes);
                }
                if (setMethod == null && !this.hasJAXBAnnotations(getMethod)) {
                    isPropertyTransient = true;
                }
                if (setMethod != null && this.hasJAXBAnnotations(setMethod)) {
                    isTransient = this.helper.isAnnotationPresent(setMethod, XmlTransient.class);
                    isLocation = this.helper.isAnnotationPresent(setMethod, XmlLocation.class) || this.helper.isAnnotationPresent(setMethod, CompilerHelper.XML_LOCATION_ANNOTATION_CLASS) || this.helper.isAnnotationPresent(setMethod, CompilerHelper.INTERNAL_XML_LOCATION_ANNOTATION_CLASS);
                    propertyMethod = setMethod;
                    if (isTransient) {
                        isPropertyTransient = true;
                        if (isLocation) {
                            info.setLocationAware(true);
                        }
                    }
                } else if (onlyExplicit && this.hasJAXBAnnotations(getMethod) || !onlyExplicit) {
                    isTransient = this.helper.isAnnotationPresent(getMethod, XmlTransient.class);
                    isLocation = this.helper.isAnnotationPresent(getMethod, XmlLocation.class) || this.helper.isAnnotationPresent(setMethod, CompilerHelper.XML_LOCATION_ANNOTATION_CLASS) || this.helper.isAnnotationPresent(setMethod, CompilerHelper.INTERNAL_XML_LOCATION_ANNOTATION_CLASS);
                    propertyMethod = getMethod;
                    if (isTransient) {
                        isPropertyTransient = true;
                        if (isLocation) {
                            info.setLocationAware(true);
                        }
                    }
                } else if (onlyExplicit) {
                    continue;
                }
            } else {
                propertyName = nextMethod.getName().substring(3);
                setMethod = nextMethod;
                String getMethodName = GET_STR + propertyName;
                getMethod = cls.getDeclaredMethod(getMethodName, new JavaClass[0]);
                if (getMethod == null) {
                    getMethodName = IS_STR + propertyName;
                    getMethod = cls.getDeclaredMethod(getMethodName, new JavaClass[0]);
                }
                if (getMethod == null && (getMethod = cls.getMethod(GET_STR + propertyName, new JavaClass[0])) == null) {
                    getMethod = cls.getMethod(IS_STR + propertyName, new JavaClass[0]);
                }
                if (getMethod == null && !this.hasJAXBAnnotations(setMethod)) {
                    isPropertyTransient = true;
                }
                if (getMethod != null && this.hasJAXBAnnotations(getMethod)) {
                    boolean isTransient = this.helper.isAnnotationPresent(getMethod, XmlTransient.class);
                    isLocation = this.helper.isAnnotationPresent(getMethod, XmlLocation.class) || this.helper.isAnnotationPresent(getMethod, CompilerHelper.XML_LOCATION_ANNOTATION_CLASS) || this.helper.isAnnotationPresent(getMethod, CompilerHelper.INTERNAL_XML_LOCATION_ANNOTATION_CLASS);
                    propertyMethod = getMethod;
                    if (isTransient) {
                        isPropertyTransient = true;
                        if (isLocation) {
                            info.setLocationAware(true);
                        }
                    }
                } else if (onlyExplicit && this.hasJAXBAnnotations(setMethod) || !onlyExplicit) {
                    boolean isTransient = this.helper.isAnnotationPresent(setMethod, XmlTransient.class);
                    isLocation = this.helper.isAnnotationPresent(setMethod, XmlLocation.class) || this.helper.isAnnotationPresent(getMethod, CompilerHelper.XML_LOCATION_ANNOTATION_CLASS) || this.helper.isAnnotationPresent(getMethod, CompilerHelper.INTERNAL_XML_LOCATION_ANNOTATION_CLASS);
                    propertyMethod = setMethod;
                    if (isTransient) {
                        isPropertyTransient = true;
                        if (isLocation) {
                            info.setLocationAware(true);
                        }
                    }
                } else if (onlyExplicit) continue;
                propertyName = org.eclipse.persistence.internal.helper.Helper.decapitalize(propertyName);
            }
            JavaClass ptype = null;
            ptype = getMethod != null ? getMethod.getReturnType() : setMethod.getParameterTypes()[0];
            if (propertyNames.contains(propertyName)) continue;
            try {
                Property property = this.buildNewProperty(info, cls, propertyMethod, propertyName, ptype);
                propertyNames.add(propertyName);
                property.setTransient(isPropertyTransient);
                if (getMethod != null) {
                    property.setOriginalGetMethodName(getMethod.getName());
                    if (property.getGetMethodName() == null) {
                        property.setGetMethodName(getMethod.getName());
                    }
                }
                if (setMethod != null) {
                    property.setOriginalSetMethodName(setMethod.getName());
                    if (property.getSetMethodName() == null) {
                        property.setSetMethodName(setMethod.getName());
                    }
                }
                property.setMethodProperty(true);
                properties.add(property);
            }
            catch (JAXBException ex) {
                if (ex.getErrorCode() == 50089 && isPropertyTransient) continue;
                throw ex;
            }
        }
        properties = this.removeSuperclassProperties(cls, properties);
        properties.sort(new PropertyComparitor());
        return properties;
    }

    private ArrayList<Property> removeSuperclassProperties(JavaClass cls, ArrayList<Property> properties) {
        TypeInfo superClassInfo;
        ArrayList<Property> revisedProperties = new ArrayList<Property>();
        revisedProperties.addAll(properties);
        JavaClass superClass = cls.getSuperclass();
        if (null != superClass && (superClassInfo = this.typeInfos.get(superClass.getQualifiedName())) != null && !superClassInfo.isTransient()) {
            for (Property prop : properties) {
                for (Property superProp : superClassInfo.getProperties().values()) {
                    if (superProp.getGetMethodName() == null || !superProp.getGetMethodName().equals(prop.getGetMethodName()) || superProp.isTransient()) continue;
                    revisedProperties.remove(prop);
                }
            }
        }
        return revisedProperties;
    }

    public ArrayList getPublicMemberPropertiesForClass(JavaClass cls, TypeInfo info) {
        ArrayList<Property> fieldProperties = this.getFieldPropertiesForClass(cls, info, !this.hasXmlBindings());
        ArrayList<Property> methodProperties = this.getPropertyPropertiesForClass(cls, info, !this.hasXmlBindings());
        ArrayList<Property> publicFieldProperties = new ArrayList<Property>();
        ArrayList<Property> publicMethodProperties = new ArrayList<Property>();
        for (Property next : fieldProperties) {
            if (Modifier.isPublic(((JavaField)next.getElement()).getModifiers())) {
                publicFieldProperties.add(next);
                continue;
            }
            if (!this.hasJAXBAnnotations(next.getElement())) continue;
            publicFieldProperties.add(next);
        }
        for (Property next : methodProperties) {
            if (next.getElement() == null) continue;
            if (Modifier.isPublic(((JavaMethod)next.getElement()).getModifiers())) {
                publicMethodProperties.add(next);
                continue;
            }
            if (!this.hasJAXBAnnotations(next.getElement())) continue;
            publicMethodProperties.add(next);
        }
        if (!publicFieldProperties.isEmpty() && publicMethodProperties.isEmpty()) {
            return publicFieldProperties;
        }
        if (!publicMethodProperties.isEmpty() && publicFieldProperties.isEmpty()) {
            return publicMethodProperties;
        }
        HashMap<String, Property> fieldPropertyMap = this.getPropertyMapFromArrayList(publicFieldProperties);
        for (Property publicMethodProperty : publicMethodProperties) {
            Property next = publicMethodProperty;
            Property fieldProp = fieldPropertyMap.get(next.getPropertyName());
            if (fieldProp == null) {
                publicFieldProperties.add(next);
                continue;
            }
            if (!fieldProp.isTransient()) continue;
            publicFieldProperties.remove(fieldProp);
            publicFieldProperties.add(next);
        }
        return publicFieldProperties;
    }

    public HashMap<String, Property> getPropertyMapFromArrayList(ArrayList<Property> props) {
        HashMap<String, Property> propMap = new HashMap<String, Property>(props.size());
        for (Property next : props) {
            propMap.put(next.getPropertyName(), next);
        }
        return propMap;
    }

    public ArrayList getNoAccessTypePropertiesForClass(JavaClass cls, TypeInfo info) {
        ArrayList<Property> list = new ArrayList<Property>();
        if (cls == null) {
            return list;
        }
        ArrayList<Property> fieldProperties = this.getFieldPropertiesForClass(cls, info, false);
        HashMap<String, Property> fields = new HashMap<String, Property>(fieldProperties.size());
        for (Property next : fieldProperties) {
            JavaHasAnnotations elem = next.getElement();
            if (!this.hasJAXBAnnotations(elem)) {
                next.setTransient(true);
            }
            list.add(next);
            fields.put(next.getPropertyName(), next);
        }
        ArrayList<Property> methodProperties = this.getPropertyPropertiesForClass(cls, info, false);
        for (Property next : methodProperties) {
            JavaHasAnnotations elem = next.getElement();
            if (this.hasJAXBAnnotations(elem)) {
                Property fieldProperty = (Property)fields.get(next.getPropertyName());
                list.remove(fieldProperty);
                list.add(next);
                continue;
            }
            next.setTransient(true);
            if (fields.get(next.getPropertyName()) != null) continue;
            list.add(next);
        }
        return list;
    }

    public void processSchemaType(String name, String namespace, String jClassQualifiedName) {
        this.userDefinedSchemaTypes.put(jClassQualifiedName, new QName(namespace, name));
    }

    public void processSchemaType(XmlSchemaType type2) {
        JavaClass jClass = this.helper.getJavaClass(type2.type());
        if (jClass == null) {
            return;
        }
        this.processSchemaType(type2.name(), type2.namespace(), jClass.getQualifiedName());
    }

    public void addEnumTypeInfo(JavaClass javaClass, EnumTypeInfo info) {
        QName restrictionBase;
        Class restrictionClass;
        block11: {
            boolean restrictionIsEnum;
            JavaClass restrictionJavaClass;
            Object xmlEnum;
            block12: {
                block13: {
                    if (javaClass == null) {
                        return;
                    }
                    info.setClassName(javaClass.getQualifiedName());
                    restrictionClass = String.class;
                    restrictionBase = this.getSchemaTypeFor(this.helper.getJavaClass(restrictionClass));
                    if (!this.helper.isAnnotationPresent(javaClass, XmlEnum.class)) break block11;
                    xmlEnum = (XmlEnum)this.helper.getAnnotation(javaClass, XmlEnum.class);
                    restrictionClass = xmlEnum.value();
                    restrictionJavaClass = this.helper.getJavaClass(restrictionClass);
                    restrictionIsEnum = this.helper.isAnnotationPresent(restrictionJavaClass, XmlEnum.class);
                    if (restrictionIsEnum) break block12;
                    if (!this.helper.isBuiltInJavaType(restrictionJavaClass)) break block13;
                    restrictionBase = this.getSchemaTypeFor(this.helper.getJavaClass(restrictionClass));
                    break block11;
                }
                TypeInfo restrictionInfo = this.typeInfos.get(restrictionJavaClass.getQualifiedName());
                if (restrictionInfo == null) {
                    JavaClass[] jClasses = new JavaClass[]{restrictionJavaClass};
                    this.buildNewTypeInfo(jClasses);
                    restrictionInfo = this.typeInfos.get(restrictionJavaClass.getQualifiedName());
                } else if (!restrictionInfo.isPostBuilt()) {
                    this.postBuildTypeInfo(new JavaClass[]{restrictionJavaClass});
                }
                Property xmlValueProp = restrictionInfo.getXmlValueProperty();
                if (xmlValueProp == null) break block11;
                restrictionJavaClass = xmlValueProp.getActualType();
                restrictionBase = this.getSchemaTypeFor(restrictionJavaClass);
                restrictionClass = this.helper.getClassForJavaClass(restrictionJavaClass);
                break block11;
            }
            while (restrictionIsEnum) {
                TypeInfo restrictionTypeInfo = this.processReferencedClass(restrictionJavaClass);
                restrictionBase = new QName(restrictionTypeInfo.getClassNamespace(), restrictionTypeInfo.getSchemaTypeName());
                xmlEnum = (XmlEnum)this.helper.getAnnotation(restrictionJavaClass, XmlEnum.class);
                restrictionClass = xmlEnum.value();
                restrictionJavaClass = this.helper.getJavaClass(restrictionClass);
                restrictionIsEnum = this.helper.isAnnotationPresent(restrictionJavaClass, XmlEnum.class);
            }
        }
        info.setRestrictionBase(restrictionBase);
        for (JavaField field : javaClass.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            String enumValue = field.getName();
            if (this.helper.isAnnotationPresent(field, XmlEnumValue.class)) {
                enumValue = ((XmlEnumValue)this.helper.getAnnotation(field, XmlEnumValue.class)).value();
            }
            if (restrictionClass != null) {
                try {
                    enumValue = XMLConversionManager.getDefaultXMLManager().convertObject(enumValue, restrictionClass);
                }
                catch (ConversionException e) {
                    throw JAXBException.invalidEnumValue(enumValue, restrictionClass.getName(), e);
                }
            }
            info.addJavaFieldToXmlEnumValuePair(field.getName(), enumValue);
        }
        if (info.getXmlRootElement() == null) {
            ElementDeclaration elem = new ElementDeclaration(null, javaClass, javaClass.getQualifiedName(), false);
            this.getLocalElements().add(elem);
        }
    }

    public QName getSchemaTypeOrNullFor(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        QName schemaType = this.userDefinedSchemaTypes.get(javaClass.getQualifiedName());
        if (schemaType == null) {
            schemaType = this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        return schemaType;
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        QName schemaType = this.getSchemaTypeOrNullFor(javaClass);
        if (schemaType == null) {
            return Constants.ANY_SIMPLE_TYPE_QNAME;
        }
        return schemaType;
    }

    public NamespaceInfo processNamespaceInformation(XmlSchema xmlSchema) {
        NamespaceInfo info = new NamespaceInfo();
        info.setNamespaceResolver(new NamespaceResolver());
        String packageNamespace = null;
        if (xmlSchema != null) {
            XmlNs[] xmlns;
            String namespaceMapping = xmlSchema.namespace();
            if (!namespaceMapping.equals(EMPTY_STRING) && !namespaceMapping.equals("##default")) {
                packageNamespace = namespaceMapping;
            } else if (namespaceMapping.equals("##default")) {
                packageNamespace = this.defaultTargetNamespace;
            }
            info.setNamespace(packageNamespace);
            for (XmlNs next : xmlns = xmlSchema.xmlns()) {
                info.getNamespaceResolver().put(next.prefix(), next.namespaceURI());
            }
            info.setAttributeFormQualified(xmlSchema.attributeFormDefault() == XmlNsForm.QUALIFIED);
            info.setElementFormQualified(xmlSchema.elementFormDefault() == XmlNsForm.QUALIFIED);
            try {
                Method locationMethod = PrivilegedAccessHelper.getDeclaredMethod(XmlSchema.class, "location", new Class[0]);
                String location = (String)PrivilegedAccessHelper.invokeMethod(locationMethod, xmlSchema, new Object[0]);
                if (location != null) {
                    if (location.equals("##generate")) {
                        location = null;
                    } else if (location.equals(EMPTY_STRING)) {
                        location = null;
                    }
                }
                info.setLocation(location);
            }
            catch (Exception exception) {}
        } else {
            info.setNamespace(this.defaultTargetNamespace);
        }
        if (!info.isElementFormQualified()) {
            this.isDefaultNamespaceAllowed = false;
        }
        return info;
    }

    public Map<String, TypeInfo> getTypeInfos() {
        return this.typeInfos;
    }

    public List<JavaClass> getTypeInfoClasses() {
        return this.typeInfoClasses;
    }

    public Map<String, QName> getUserDefinedSchemaTypes() {
        return this.userDefinedSchemaTypes;
    }

    public QName getQNameForProperty(Property property, String defaultName, JavaHasAnnotations element, NamespaceInfo namespaceInfo, TypeInfo info) {
        String uri = info.getClassNamespace();
        String name = "##default";
        String namespace = "##default";
        QName qName = null;
        if (property.isMap()) {
            this.isDefaultNamespaceAllowed = false;
        }
        if (this.helper.isAnnotationPresent(element, XmlAttribute.class)) {
            XmlAttribute xmlAttribute = (XmlAttribute)this.helper.getAnnotation(element, XmlAttribute.class);
            name = xmlAttribute.name();
            namespace = xmlAttribute.namespace();
            if (name.equals("##default")) {
                name = defaultName;
                try {
                    name = info.getXmlNameTransformer().transformAttributeName(name);
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation(name, info.getXmlNameTransformer().getClass().getName(), ex);
                }
            }
            if (!namespace.equals("##default")) {
                qName = new QName(namespace, name);
                this.isDefaultNamespaceAllowed = false;
            } else if (namespaceInfo.isAttributeFormQualified()) {
                qName = new QName(uri, name);
                this.isDefaultNamespaceAllowed = false;
            } else {
                qName = new QName(name);
            }
        } else {
            if (this.helper.isAnnotationPresent(element, XmlElement.class)) {
                XmlElement xmlElement = (XmlElement)this.helper.getAnnotation(element, XmlElement.class);
                name = xmlElement.name();
                namespace = xmlElement.namespace();
            }
            if (property.isMap() && this.helper.isAnnotationPresent(element, XmlElementWrapper.class)) {
                XmlElementWrapper xmlElementWrapper = (XmlElementWrapper)this.helper.getAnnotation(element, XmlElementWrapper.class);
                name = xmlElementWrapper.name();
                namespace = xmlElementWrapper.namespace();
            }
            if (name.equals("##default")) {
                name = defaultName;
                try {
                    name = info.getXmlNameTransformer().transformElementName(name);
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation(name, info.getXmlNameTransformer().getClass().getName(), ex);
                }
            }
            if (!namespace.equals("##default")) {
                qName = new QName(namespace, name);
                if (namespace.equals(EMPTY_STRING)) {
                    this.isDefaultNamespaceAllowed = false;
                }
            } else {
                qName = namespaceInfo.isElementFormQualified() ? new QName(uri, name) : new QName(name);
            }
        }
        return qName;
    }

    public Map<String, PackageInfo> getPackageToPackageInfoMappings() {
        return this.packageToPackageInfoMappings;
    }

    public void addPackageToNamespaceMapping(String packageName, NamespaceInfo nsInfo) {
        PackageInfo info = this.getPackageInfoWithLazyInit(packageName);
        info.setNamespaceInfo(nsInfo);
    }

    public void addPackageToXmlElementNillable(String packageName, org.eclipse.persistence.jaxb.xmlmodel.XmlElementNillable xmlElementNillable) {
        XmlNillableInfo info = this.getXmlNillableInfoWithLazyInit(packageName);
        info.setXmlElementNillable(xmlElementNillable);
    }

    public void addPackageToXmlNullPolicy(String packageName, org.eclipse.persistence.jaxb.xmlmodel.XmlNullPolicy xmlNullPolicy) {
        XmlNillableInfo info = this.getXmlNillableInfoWithLazyInit(packageName);
        info.setXmlNullPolicy(xmlNullPolicy);
    }

    private XmlNillableInfo getXmlNillableInfoWithLazyInit(String packageName) {
        XmlNillableInfo info;
        if (this.packageToXmlNillableInfoMappings == null) {
            this.packageToXmlNillableInfoMappings = new HashMap();
        }
        if ((info = this.packageToXmlNillableInfoMappings.get(packageName)) == null) {
            info = new XmlNillableInfo();
            this.packageToXmlNillableInfoMappings.put(packageName, info);
        }
        return info;
    }

    private PackageInfo getPackageInfoWithLazyInit(String packageName) {
        PackageInfo info;
        if (this.packageToPackageInfoMappings == null) {
            this.packageToPackageInfoMappings = new HashMap<String, PackageInfo>();
        }
        if ((info = this.packageToPackageInfoMappings.get(packageName)) == null) {
            info = new PackageInfo();
            this.packageToPackageInfoMappings.put(packageName, info);
        }
        return info;
    }

    public void addPackageToPackageInfoMapping(String packageName, PackageInfo packageInfo) {
        if (this.packageToPackageInfoMappings == null) {
            this.packageToPackageInfoMappings = new HashMap<String, PackageInfo>();
        }
        this.packageToPackageInfoMappings.put(packageName, packageInfo);
    }

    public PackageInfo getPackageInfoForPackage(JavaClass javaClass) {
        String packageName = javaClass.getPackageName();
        PackageInfo packageInfo = this.packageToPackageInfoMappings.get(packageName);
        if (packageInfo == null) {
            packageInfo = this.getPackageInfoForPackage(javaClass.getPackage(), packageName);
        }
        return packageInfo;
    }

    public PackageInfo getPackageInfoForPackage(JavaPackage pack, String packageName) {
        PackageInfo packageInfo = this.packageToPackageInfoMappings.get(packageName);
        if (packageInfo == null) {
            Annotation xmlAccessorFactory;
            XmlSchema xmlSchema = (XmlSchema)this.helper.getAnnotation(pack, XmlSchema.class);
            packageInfo = new PackageInfo();
            NamespaceInfo namespaceInfo = this.processNamespaceInformation(xmlSchema);
            packageInfo.setNamespaceInfo(namespaceInfo);
            if (namespaceInfo.getNamespace() == null) {
                namespaceInfo.setNamespace(EMPTY_STRING);
            }
            if (this.helper.isAnnotationPresent(pack, XmlAccessorType.class)) {
                XmlAccessorType xmlAccessorType = (XmlAccessorType)this.helper.getAnnotation(pack, XmlAccessorType.class);
                packageInfo.setAccessType(XmlAccessType.fromValue(xmlAccessorType.value().name()));
            }
            if (this.helper.isAnnotationPresent(pack, XmlAccessorOrder.class)) {
                XmlAccessorOrder xmlAccessorOrder = (XmlAccessorOrder)this.helper.getAnnotation(pack, XmlAccessorOrder.class);
                packageInfo.setAccessOrder(XmlAccessOrder.fromValue(xmlAccessorOrder.value().name()));
            }
            if (CompilerHelper.ACCESSOR_FACTORY_ANNOTATION_CLASS != null && this.helper.isAnnotationPresent(pack, CompilerHelper.ACCESSOR_FACTORY_ANNOTATION_CLASS)) {
                xmlAccessorFactory = this.helper.getAnnotation(pack, CompilerHelper.ACCESSOR_FACTORY_ANNOTATION_CLASS);
                Class xmlAccessorFactoryClass = null;
                try {
                    xmlAccessorFactoryClass = (Class)PrivilegedAccessHelper.invokeMethod(CompilerHelper.ACCESSOR_FACTORY_VALUE_METHOD, xmlAccessorFactory, new Object[0]);
                    packageInfo.setAccessorFactory(new AccessorFactoryWrapper(PrivilegedAccessHelper.newInstanceFromClass(xmlAccessorFactoryClass)));
                }
                catch (Exception ex) {
                    throw JAXBException.errorInstantiatingAccessorFactory(xmlAccessorFactoryClass, ex);
                }
            }
            if (CompilerHelper.OLD_ACCESSOR_FACTORY_ANNOTATION_CLASS != null && this.helper.isAnnotationPresent(pack, CompilerHelper.OLD_ACCESSOR_FACTORY_ANNOTATION_CLASS)) {
                xmlAccessorFactory = this.helper.getAnnotation(pack, CompilerHelper.OLD_ACCESSOR_FACTORY_ANNOTATION_CLASS);
                Class xmlAccessorFactoryClass = null;
                try {
                    xmlAccessorFactoryClass = (Class)PrivilegedAccessHelper.invokeMethod(CompilerHelper.OLD_ACCESSOR_FACTORY_VALUE_METHOD, xmlAccessorFactory, new Object[0]);
                    packageInfo.setAccessorFactory(new AccessorFactoryWrapper(PrivilegedAccessHelper.newInstanceFromClass(xmlAccessorFactoryClass)));
                }
                catch (Exception ex) {
                    throw JAXBException.errorInstantiatingAccessorFactory(xmlAccessorFactoryClass, ex);
                }
            }
            if (CompilerHelper.INTERNAL_ACCESSOR_FACTORY_ANNOTATION_CLASS != null && this.helper.isAnnotationPresent(pack, CompilerHelper.INTERNAL_ACCESSOR_FACTORY_ANNOTATION_CLASS)) {
                xmlAccessorFactory = this.helper.getAnnotation(pack, CompilerHelper.INTERNAL_ACCESSOR_FACTORY_ANNOTATION_CLASS);
                Class xmlAccessorFactoryClass = null;
                try {
                    xmlAccessorFactoryClass = (Class)PrivilegedAccessHelper.invokeMethod(CompilerHelper.INTERNAL_ACCESSOR_FACTORY_VALUE_METHOD, xmlAccessorFactory, new Object[0]);
                    packageInfo.setAccessorFactory(new AccessorFactoryWrapper(PrivilegedAccessHelper.newInstanceFromClass(xmlAccessorFactoryClass)));
                }
                catch (Exception ex) {
                    throw JAXBException.errorInstantiatingAccessorFactory(xmlAccessorFactoryClass, ex);
                }
            }
            this.packageToPackageInfoMappings.put(packageName, packageInfo);
        }
        return packageInfo;
    }

    public NamespaceInfo findInfoForNamespace(String namespace) {
        for (PackageInfo next : this.packageToPackageInfoMappings.values()) {
            String nextUri = next.getNamespace();
            if (nextUri == null) {
                nextUri = EMPTY_STRING;
            }
            if (namespace == null) {
                namespace = EMPTY_STRING;
            }
            if (!nextUri.equals(namespace)) continue;
            return next.getNamespaceInfo();
        }
        return null;
    }

    void checkForCallbackMethods() {
        JavaClass unmarshallerCls = this.helper.getJavaClass(Unmarshaller.class);
        JavaClass marshallerCls = this.helper.getJavaClass(Marshaller.class);
        JavaClass objectCls = this.helper.getJavaClass(Object.class);
        JavaClass[] unmarshalParams = new JavaClass[]{unmarshallerCls, objectCls};
        JavaClass[] marshalParams = new JavaClass[]{marshallerCls};
        for (JavaClass next : this.typeInfoClasses) {
            if (next == null) continue;
            UnmarshalCallback unmarshalCallback = null;
            MarshalCallback marshalCallback = null;
            if (next.getMethod("beforeUnmarshal", unmarshalParams) != null) {
                unmarshalCallback = new UnmarshalCallback();
                unmarshalCallback.setDomainClassName(next.getQualifiedName());
                unmarshalCallback.setHasBeforeUnmarshalCallback();
            }
            if (next.getMethod("afterUnmarshal", unmarshalParams) != null) {
                if (unmarshalCallback == null) {
                    unmarshalCallback = new UnmarshalCallback();
                    unmarshalCallback.setDomainClassName(next.getQualifiedName());
                }
                unmarshalCallback.setHasAfterUnmarshalCallback();
            }
            if (unmarshalCallback != null) {
                if (this.unmarshalCallbacks == null) {
                    this.unmarshalCallbacks = new HashMap<String, UnmarshalCallback>();
                }
                this.unmarshalCallbacks.put(next.getQualifiedName(), unmarshalCallback);
            }
            if (next.getMethod("beforeMarshal", marshalParams) != null) {
                marshalCallback = new MarshalCallback();
                marshalCallback.setDomainClassName(next.getQualifiedName());
                marshalCallback.setHasBeforeMarshalCallback();
            }
            if (next.getMethod("afterMarshal", marshalParams) != null) {
                if (marshalCallback == null) {
                    marshalCallback = new MarshalCallback();
                    marshalCallback.setDomainClassName(next.getQualifiedName());
                }
                marshalCallback.setHasAfterMarshalCallback();
            }
            if (marshalCallback == null) continue;
            if (this.marshalCallbacks == null) {
                this.marshalCallbacks = new HashMap<String, MarshalCallback>();
            }
            this.marshalCallbacks.put(next.getQualifiedName(), marshalCallback);
        }
    }

    public Map<String, MarshalCallback> getMarshalCallbacks() {
        return this.marshalCallbacks;
    }

    public Map<String, UnmarshalCallback> getUnmarshalCallbacks() {
        return this.unmarshalCallbacks;
    }

    private void findAndProcessObjectFactory(JavaClass cls) {
        try {
            String className = cls.getPackageName() + ".ObjectFactory";
            this.findAndProcessObjectFactory(className);
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    void findAndProcessObjectFactory(String objectFactoryClassName) {
        try {
            if (this.objectFactoryClassNames.contains(objectFactoryClassName)) {
                return;
            }
            JavaClass javaClass = this.helper.getJavaClass(objectFactoryClassName);
            if (this.isXmlRegistry(javaClass)) {
                JavaClass[] processed = this.processObjectFactory(javaClass, new ArrayList<JavaClass>());
                this.preBuildTypeInfo(processed);
                this.buildTypeInfo(processed);
                this.updateGlobalElements(processed);
            }
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    public JavaClass[] processObjectFactory(JavaClass objectFactoryClass, List<JavaClass> classes) {
        String className = objectFactoryClass.getName();
        if (this.objectFactoryClassNames.contains(className)) {
            return new JavaClass[0];
        }
        this.objectFactoryClassNames.add(className);
        HashMap<String, XmlRegistry.XmlElementDecl> elemDecls = new HashMap<String, XmlRegistry.XmlElementDecl>();
        XmlRegistry xmlReg = this.xmlRegistries.get(objectFactoryClass.getQualifiedName());
        if (xmlReg != null) {
            for (XmlRegistry.XmlElementDecl xmlElementDecl : xmlReg.getXmlElementDecl()) {
                elemDecls.put(xmlElementDecl.getJavaMethod(), xmlElementDecl);
            }
        }
        Collection<JavaMethod> methods = objectFactoryClass.getDeclaredMethods();
        Iterator<JavaMethod> methodsIter = methods.iterator();
        PackageInfo packageInfo = this.getPackageInfoForPackage(objectFactoryClass);
        while (methodsIter.hasNext()) {
            JavaMethod next = methodsIter.next();
            if (!next.getName().startsWith(CREATE)) continue;
            JavaClass type2 = next.getReturnType();
            if (JAVAX_XML_BIND_JAXBELEMENT.equals(type2.getName())) {
                Object[] actualTypeArguments = type2.getActualTypeArguments().toArray();
                type2 = actualTypeArguments.length == 0 ? this.helper.getObjectClass() : (JavaClass)actualTypeArguments[0];
                type2 = this.processXmlElementDecl(type2, next, packageInfo, elemDecls);
            } else if (this.helper.getJaxbElementClass().isAssignableFrom(type2)) {
                this.factoryMethods.put(type2.getRawName(), next);
                type2 = this.processXmlElementDecl(type2, next, packageInfo, elemDecls);
            } else {
                this.factoryMethods.put(type2.getRawName(), next);
            }
            if (this.helper.isBuiltInJavaType(type2) || this.helper.classExistsInArray(type2, classes)) continue;
            classes.add(type2);
        }
        if (!classes.isEmpty()) {
            this.classesToProcessPropertyTypes.addAll(classes);
            return classes.toArray(new JavaClass[0]);
        }
        return new JavaClass[0];
    }

    private JavaClass processXmlElementDecl(JavaClass type2, JavaMethod next, PackageInfo packageInfo, Map<String, XmlRegistry.XmlElementDecl> elemDecls) {
        JavaClass returnType = type2;
        XmlRegistry.XmlElementDecl xmlEltDecl = elemDecls.get(next.getName());
        if (xmlEltDecl != null || this.helper.isAnnotationPresent(next, XmlElementDecl.class)) {
            Map<QName, ElementDeclaration> elements;
            QName qname;
            String localName;
            String url;
            QName substitutionHead = null;
            String defaultValue = null;
            Class scopeClass = XmlElementDecl.GLOBAL.class;
            if (xmlEltDecl != null) {
                JavaClass jScopeClass;
                url = xmlEltDecl.getNamespace();
                localName = xmlEltDecl.getName();
                String scopeClassName = xmlEltDecl.getScope();
                if (!scopeClassName.equals(ELEMENT_DECL_GLOBAL) && (jScopeClass = this.helper.getJavaClass(scopeClassName)) != null && (scopeClass = this.helper.getClassForJavaClass(jScopeClass)) == null) {
                    scopeClass = XmlElementDecl.GLOBAL.class;
                }
                if (!xmlEltDecl.getSubstitutionHeadName().equals(EMPTY_STRING)) {
                    subHeadLocal = xmlEltDecl.getSubstitutionHeadName();
                    subHeadNamespace = xmlEltDecl.getSubstitutionHeadNamespace();
                    if (subHeadNamespace.equals("##default")) {
                        subHeadNamespace = packageInfo.getNamespace();
                    }
                    substitutionHead = new QName(subHeadNamespace, subHeadLocal);
                }
                if (xmlEltDecl.getDefaultValue().length() != 1 || !xmlEltDecl.getDefaultValue().startsWith(ELEMENT_DECL_DEFAULT)) {
                    defaultValue = xmlEltDecl.getDefaultValue();
                }
            } else {
                XmlElementDecl elementDecl = (XmlElementDecl)this.helper.getAnnotation(next, XmlElementDecl.class);
                url = elementDecl.namespace();
                localName = elementDecl.name();
                scopeClass = elementDecl.scope();
                if (!elementDecl.substitutionHeadName().equals(EMPTY_STRING)) {
                    subHeadLocal = elementDecl.substitutionHeadName();
                    subHeadNamespace = elementDecl.substitutionHeadNamespace();
                    if (subHeadNamespace.equals("##default")) {
                        subHeadNamespace = packageInfo.getNamespace();
                    }
                    substitutionHead = new QName(subHeadNamespace, subHeadLocal);
                }
                if (elementDecl.defaultValue().length() != 1 || !elementDecl.defaultValue().startsWith(ELEMENT_DECL_DEFAULT)) {
                    defaultValue = elementDecl.defaultValue();
                }
            }
            if ("##default".equals(url)) {
                url = packageInfo.getNamespace();
            }
            if (EMPTY_STRING.equals(url)) {
                this.isDefaultNamespaceAllowed = false;
                qname = new QName(localName);
            } else {
                qname = new QName(url, localName);
            }
            boolean isList = false;
            if (JAVA_UTIL_LIST.equals(type2.getName())) {
                isList = true;
                Collection<JavaClass> args = type2.getActualTypeArguments();
                if (!args.isEmpty()) {
                    type2 = args.iterator().next();
                }
            }
            ElementDeclaration declaration = new ElementDeclaration(qname, type2, type2.getQualifiedName(), isList, scopeClass);
            if (substitutionHead != null) {
                declaration.setSubstitutionHead(substitutionHead);
            }
            if (defaultValue != null) {
                declaration.setDefaultValue(defaultValue);
            }
            if (this.helper.isAnnotationPresent(next, XmlJavaTypeAdapter.class)) {
                XmlJavaTypeAdapter typeAdapter = (XmlJavaTypeAdapter)this.helper.getAnnotation(next, XmlJavaTypeAdapter.class);
                Class<? extends XmlAdapter> typeAdapterClass = typeAdapter.value();
                declaration.setJavaTypeAdapterClass(typeAdapterClass);
                Class<?> declJavaType = CompilerHelper.getTypeFromAdapterClass(typeAdapterClass);
                JavaClass adaptedType = this.helper.getJavaClass(declJavaType);
                declaration.setJavaType(adaptedType);
                declaration.setAdaptedJavaType(type2);
                returnType = adaptedType;
            }
            if (this.helper.isAnnotationPresent(next, XmlMimeType.class)) {
                XmlMimeType mimeType = (XmlMimeType)this.helper.getAnnotation(next, XmlMimeType.class);
                declaration.setXmlMimeType(mimeType.value());
            }
            if (this.helper.isAnnotationPresent(next, XmlAttachmentRef.class)) {
                declaration.setXmlAttachmentRef(true);
            }
            if ((elements = this.getElementDeclarationsForScope(scopeClass.getName())) == null) {
                elements = new HashMap<QName, ElementDeclaration>();
                this.elementDeclarations.put(scopeClass.getName(), elements);
            }
            if (elements.containsKey(qname)) {
                throw JAXBException.duplicateElementName(qname);
            }
            elements.put(qname, declaration);
        }
        return returnType;
    }

    public Map<QName, ElementDeclaration> getGlobalElements() {
        return this.elementDeclarations.get(XmlElementDecl.GLOBAL.class.getName());
    }

    public void updateGlobalElements(JavaClass[] classesToProcess) {
        for (JavaClass javaClass : classesToProcess) {
            TypeInfo info = this.typeInfos.get(javaClass.getQualifiedName());
            if (info == null || info.isTransient() || !info.isSetXmlRootElement()) continue;
            XmlRootElement xmlRE = info.getXmlRootElement();
            NamespaceInfo namespaceInfo = this.getPackageInfoForPackage(javaClass).getNamespaceInfo();
            String elementName = xmlRE.getName();
            if (elementName.equals("##default") || elementName.equals(EMPTY_STRING)) {
                XMLNameTransformer transformer = info.getXmlNameTransformer();
                try {
                    elementName = transformer.transformRootElementName(javaClass.getName());
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation(javaClass.getName(), info.getXmlNameTransformer().getClass().getName(), ex);
                }
            }
            String rootNamespace = xmlRE.getNamespace();
            QName rootElemName = null;
            if (rootNamespace.equals("##default")) {
                if (namespaceInfo == null) {
                    rootElemName = new QName(elementName);
                } else {
                    String rootNS = namespaceInfo.getNamespace();
                    rootElemName = new QName(rootNS, elementName);
                    if (rootNS.equals(EMPTY_STRING)) {
                        this.isDefaultNamespaceAllowed = false;
                    }
                }
            } else {
                rootElemName = new QName(rootNamespace, elementName);
                if (rootNamespace.equals(EMPTY_STRING)) {
                    this.isDefaultNamespaceAllowed = false;
                }
            }
            ElementDeclaration declaration = new ElementDeclaration(rootElemName, javaClass, javaClass.getQualifiedName(), false);
            declaration.setIsXmlRootElement(true);
            this.addGlobalElement(rootElemName, declaration);
            this.xmlRootElements.put(javaClass.getQualifiedName(), declaration);
        }
        for (QName next : this.getGlobalElements().keySet()) {
            ElementDeclaration nextDeclaration = this.getGlobalElements().get(next);
            QName substitutionHead = nextDeclaration.getSubstitutionHead();
            while (substitutionHead != null) {
                ElementDeclaration rootDeclaration = this.getGlobalElements().get(substitutionHead);
                rootDeclaration.addSubstitutableElement(nextDeclaration);
                if (rootDeclaration.getSubstitutionHead() != null && rootDeclaration.getSubstitutionHead().equals(substitutionHead)) {
                    substitutionHead = null;
                    continue;
                }
                substitutionHead = rootDeclaration.getSubstitutionHead();
            }
        }
    }

    private void addReferencedElement(Property property, ElementDeclaration referencedElement) {
        property.addReferencedElement(referencedElement);
        if (referencedElement.getSubstitutableElements() != null && !referencedElement.getSubstitutableElements().isEmpty()) {
            for (ElementDeclaration substitutable : referencedElement.getSubstitutableElements()) {
                if (substitutable == referencedElement) continue;
                this.addReferencedElement(property, substitutable);
            }
        }
    }

    private boolean hasJAXBAnnotations(JavaHasAnnotations elem) {
        if (elem == null) {
            return false;
        }
        List annotations = (List)elem.getAnnotations();
        if (annotations == null || annotations.isEmpty()) {
            return false;
        }
        for (JavaAnnotation annotation : annotations) {
            String nextName = annotation.getName();
            if (!nextName.startsWith(JAVAX_XML_BIND_ANNOTATION) && !nextName.startsWith(OXM_ANNOTATIONS) && !nextName.equals("org.glassfish.jaxb.core.annotation.XmlLocation") && !nextName.equals("com.sun.xml.internal.bind.annotation.XmlLocation")) continue;
            return true;
        }
        return false;
    }

    private void validatePropOrderForInfo(TypeInfo info) {
        if (info.isTransient()) {
            return;
        }
        if (info.getXmlVirtualAccessMethods() != null) {
            return;
        }
        String[] propOrder = info.getPropOrder();
        int propOrderLength = propOrder.length;
        if (propOrderLength > 0) {
            for (int i = 1; i < propOrderLength; ++i) {
                String nextPropName = propOrder[i];
                if (nextPropName.equals(EMPTY_STRING) || info.getPropertyNames().contains(nextPropName)) continue;
                throw JAXBException.nonExistentPropertyInPropOrder(nextPropName, info.getJavaClassName());
            }
        }
    }

    private void validateXmlValueFieldOrProperty(JavaClass cls, Property property) {
        TypeInfo refInfo;
        JavaClass ptype = property.getActualType();
        String propName = property.getPropertyName();
        for (JavaClass parent = cls.getSuperclass(); parent != null && !parent.getQualifiedName().equals(JAVA_LANG_OBJECT); parent = parent.getSuperclass()) {
            if (!this.useXmlValueExtension(property)) {
                throw JAXBException.propertyOrFieldCannotBeXmlValue(propName, cls.getQualifiedName());
            }
            TypeInfo parentTypeInfo = this.typeInfos.get(parent.getQualifiedName());
            if (!this.hasElementMappedProperties(parentTypeInfo)) continue;
            throw JAXBException.propertyOrFieldCannotBeXmlValue(propName, cls.getQualifiedName());
        }
        QName schemaQName = this.getSchemaTypeOrNullFor(ptype);
        if (schemaQName == null && (refInfo = this.processReferencedClass(ptype)) != null && !refInfo.isEnumerationType() && refInfo.getXmlValueProperty() == null) {
            throw JAXBException.invalidTypeForXmlValueField(propName, cls.getQualifiedName());
        }
    }

    private boolean useXmlValueExtension(Property property) {
        return MOXySystemProperties.xmlValueExtension != false || this.helper.isAnnotationPresent(property.getElement(), XmlValueExtension.class) || property.isXmlValueExtension();
    }

    private boolean hasElementMappedProperties(TypeInfo typeInfo) {
        for (Property property : typeInfo.getPropertyList()) {
            if (property.isTransient() || property.isAttribute() || property.isAnyAttribute()) continue;
            return true;
        }
        return false;
    }

    private void validateXmlAttributeFieldOrProperty(TypeInfo tInfo, Property property) {
        JavaClass ptype = property.getActualType();
        TypeInfo refInfo = this.typeInfos.get(ptype.getQualifiedName());
        if (refInfo != null) {
            if (!refInfo.isPostBuilt()) {
                this.postBuildTypeInfo(new JavaClass[]{ptype});
            }
            if (!refInfo.isEnumerationType()) {
                boolean hasMapped = false;
                for (JavaClass parent = ptype.getSuperclass(); parent != null && !(hasMapped = this.hasTextMapping(refInfo)) && !parent.getQualifiedName().equals(JAVA_LANG_OBJECT); parent = parent.getSuperclass()) {
                    refInfo = this.typeInfos.get(parent.getQualifiedName());
                }
                if (!hasMapped) {
                    String propName = property.getPropertyName();
                    String typeName = tInfo.getJavaClassName();
                    String refTypeName = refInfo.getJavaClassName();
                    throw JAXBException.mustMapToText(propName, typeName, refTypeName);
                }
            }
        }
    }

    private boolean hasTextMapping(TypeInfo tInfo) {
        boolean hasXmlValue;
        Collection<Property> props = tInfo.getProperties().values();
        for (Property property : props) {
            JavaClass ptype;
            TypeInfo refInfo;
            if (!property.isAttribute() || (refInfo = this.typeInfos.get((ptype = property.getActualType()).getQualifiedName())) == null || refInfo == tInfo) continue;
            return this.hasTextMapping(refInfo);
        }
        boolean hasXmlId = tInfo.getIDProperty() != null && !tInfo.getIDProperty().isTransient();
        boolean bl = hasXmlValue = tInfo.getXmlValueProperty() != null && !tInfo.getXmlValueProperty().isTransient();
        if (hasXmlValue) {
            hasXmlValue = CompilerHelper.isSimpleType(tInfo);
        }
        return hasXmlValue || hasXmlId;
    }

    private Class<?> generateWrapperForMapClass(JavaClass mapClass, JavaClass keyClass, JavaClass valueClass, TypeMappingInfo typeMappingInfo) {
        Annotation[] annotations;
        PackageInfo packageInfo;
        String namespace;
        Vector<Namespace> namespaces;
        Object packageName = JAXB_DEV;
        NamespaceResolver combinedNamespaceResolver = new NamespaceResolver();
        if (!this.helper.isBuiltInJavaType(keyClass)) {
            String keyPackageName = keyClass.getPackageName();
            packageName = (String)packageName + DOT_CHR + keyPackageName;
            NamespaceInfo keyNamespaceInfo = this.getPackageInfoForPackage(keyClass).getNamespaceInfo();
            if (keyNamespaceInfo != null) {
                namespaces = keyNamespaceInfo.getNamespaceResolver().getNamespaces();
                for (Namespace n : namespaces) {
                    combinedNamespaceResolver.put(n.getPrefix(), n.getNamespaceURI());
                }
            }
        }
        if (!this.helper.isBuiltInJavaType(valueClass)) {
            String valuePackageName = valueClass.getPackageName();
            packageName = (String)packageName + DOT_CHR + valuePackageName;
            NamespaceInfo valueNamespaceInfo = this.getPackageInfoForPackage(valueClass).getNamespaceInfo();
            if (valueNamespaceInfo != null) {
                namespaces = valueNamespaceInfo.getNamespaceResolver().getNamespaces();
                for (Namespace n : namespaces) {
                    combinedNamespaceResolver.put(n.getPrefix(), n.getNamespaceURI());
                }
            }
        }
        if ((namespace = this.defaultTargetNamespace) == null) {
            namespace = EMPTY_STRING;
        }
        if ((packageInfo = this.packageToPackageInfoMappings.get(mapClass.getPackageName())) == null) {
            packageInfo = this.getPackageToPackageInfoMappings().get(packageName);
        } else {
            if (packageInfo.getNamespace() != null) {
                namespace = packageInfo.getNamespace();
            }
            this.getPackageToPackageInfoMappings().put((String)packageName, packageInfo);
        }
        if (packageInfo == null) {
            packageInfo = new PackageInfo();
            packageInfo.setNamespaceInfo(new NamespaceInfo());
            packageInfo.setNamespace(namespace);
            packageInfo.setNamespaceResolver(combinedNamespaceResolver);
            this.getPackageToPackageInfoMappings().put((String)packageName, packageInfo);
        }
        int beginIndex = keyClass.getName().lastIndexOf(DOT_CHR.charValue()) + 1;
        String keyName = keyClass.getName().substring(beginIndex);
        int dollarIndex = keyName.indexOf(DOLLAR_SIGN_CHR.charValue());
        if (dollarIndex > -1) {
            keyName = keyName.substring(dollarIndex + 1);
        }
        beginIndex = valueClass.getName().lastIndexOf(DOT_CHR.charValue()) + 1;
        String valueName = valueClass.getName().substring(beginIndex);
        dollarIndex = valueName.indexOf(DOLLAR_SIGN_CHR.charValue());
        if (dollarIndex > -1) {
            valueName = valueName.substring(dollarIndex + 1);
        }
        String collectionClassShortName = mapClass.getRawName().substring(mapClass.getRawName().lastIndexOf(DOT_CHR.charValue()) + 1);
        String suggestedClassName = keyName + valueName + collectionClassShortName;
        Object qualifiedClassName = (String)packageName + DOT_CHR + suggestedClassName;
        qualifiedClassName = this.getNextAvailableClassName((String)qualifiedClassName);
        String qualifiedInternalClassName = ((String)qualifiedClassName).replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        String internalKeyName = keyClass.getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        String internalValueName = valueClass.getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        Type mapType = Type.getType(L + mapClass.getRawName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON);
        EclipseLinkASMClassWriter cw = new EclipseLinkASMClassWriter();
        String sig = "Lorg/eclipse/persistence/internal/jaxb/many/MapValue<L" + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;>;";
        ((ClassWriter)cw).visit(Opcodes.ACC_PUBLIC + Opcodes.ACC_SUPER, qualifiedInternalClassName, sig, "org/eclipse/persistence/internal/jaxb/many/MapValue", null);
        String fieldSig = L + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;";
        FieldVisitor fv = ((ClassWriter)cw).visitField(Opcodes.ACC_PUBLIC, "entry", L + mapType.getInternalName() + SEMI_COLON, fieldSig, null);
        fv.visitAnnotation(Type.getDescriptor(XmlElement.class), true);
        if (typeMappingInfo != null && (annotations = typeMappingInfo.getAnnotations()) != null) {
            for (Annotation nextAnnotation : annotations) {
                if (nextAnnotation == null || nextAnnotation instanceof XmlElement || nextAnnotation instanceof XmlJavaTypeAdapter) continue;
                String annotationClassName = nextAnnotation.annotationType().getName();
                AnnotationVisitor av = fv.visitAnnotation(L + annotationClassName.replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON, true);
                for (Method next : nextAnnotation.annotationType().getDeclaredMethods()) {
                    try {
                        Object nextValue = next.invoke((Object)nextAnnotation, new Object[0]);
                        if (nextValue instanceof Class) {
                            Type nextType = Type.getType(L + ((Class)nextValue).getName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON);
                            nextValue = nextType;
                        }
                        av.visit(next.getName(), nextValue);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                av.visitEnd();
            }
        }
        fv.visitEnd();
        MethodVisitor mv = ((ClassWriter)cw).visitMethod(Opcodes.ACC_PUBLIC, "<init>", "()V", null, null);
        mv.visitVarInsn(Opcodes.ALOAD, 0);
        mv.visitMethodInsn(Opcodes.INVOKESPECIAL, "org/eclipse/persistence/internal/jaxb/many/MapValue", "<init>", "()V", false);
        mv.visitInsn(Opcodes.RETURN);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        String methodSig = "(L" + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;)V";
        mv = ((ClassWriter)cw).visitMethod(Opcodes.ACC_PUBLIC, "setItem", "(L" + mapType.getInternalName() + ";)V", methodSig, null);
        mv.visitAnnotation("Ljakarta/xml/bind/annotation/XmlTransient;", true);
        Label l0 = ASMFactory.createLabel();
        mv.visitLabel(l0);
        mv.visitVarInsn(Opcodes.ALOAD, 0);
        mv.visitVarInsn(Opcodes.ALOAD, 1);
        mv.visitFieldInsn(Opcodes.PUTFIELD, qualifiedInternalClassName, "entry", L + mapType.getInternalName() + SEMI_COLON);
        mv.visitInsn(Opcodes.RETURN);
        Label l1 = ASMFactory.createLabel();
        mv.visitLabel(l1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        methodSig = "()L" + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;";
        mv = ((ClassWriter)cw).visitMethod(Opcodes.ACC_PUBLIC, "getItem", "()L" + mapType.getInternalName() + SEMI_COLON, methodSig, null);
        mv.visitAnnotation("Ljakarta/xml/bind/annotation/XmlTransient;", true);
        mv.visitVarInsn(Opcodes.ALOAD, 0);
        mv.visitFieldInsn(Opcodes.GETFIELD, qualifiedInternalClassName, "entry", L + mapType.getInternalName() + SEMI_COLON);
        mv.visitInsn(Opcodes.ARETURN);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = ((ClassWriter)cw).visitMethod(Opcodes.ACC_PUBLIC + Opcodes.ACC_BRIDGE + Opcodes.ACC_SYNTHETIC, "getItem", "()Ljava/lang/Object;", null, null);
        mv.visitVarInsn(Opcodes.ALOAD, 0);
        mv.visitMethodInsn(Opcodes.INVOKEVIRTUAL, qualifiedInternalClassName, "getItem", "()L" + mapType.getInternalName() + SEMI_COLON, false);
        mv.visitInsn(Opcodes.ARETURN);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = ((ClassWriter)cw).visitMethod(Opcodes.ACC_PUBLIC + Opcodes.ACC_BRIDGE + Opcodes.ACC_SYNTHETIC, "setItem", "(Ljava/lang/Object;)V", null, null);
        mv.visitVarInsn(Opcodes.ALOAD, 0);
        mv.visitVarInsn(Opcodes.ALOAD, 1);
        mv.visitTypeInsn(Opcodes.CHECKCAST, mapType.getInternalName());
        mv.visitMethodInsn(Opcodes.INVOKEVIRTUAL, qualifiedInternalClassName, "setItem", "(L" + mapType.getInternalName() + ";)V", false);
        mv.visitInsn(Opcodes.RETURN);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        AnnotationVisitor av = ((ClassWriter)cw).visitAnnotation("Ljakarta/xml/bind/annotation/XmlType;", true);
        av.visit("namespace", namespace);
        ((ClassWriter)cw).visitEnd();
        byte[] classBytes = ((ClassWriter)cw).toByteArray();
        return this.generateClassFromBytes((String)qualifiedClassName, classBytes);
    }

    private Class<?> generateWrapperForArrayClass(JavaClass arrayClass, TypeMappingInfo typeMappingInfo, Class<?> xmlElementType, List<JavaClass> classesToProcess) {
        JavaClass componentClass = null;
        componentClass = typeMappingInfo != null && xmlElementType != null ? this.helper.getJavaClass(xmlElementType) : arrayClass.getComponentType();
        if (componentClass.isArray()) {
            Class<?> nestedArrayClass = this.arrayClassesToGeneratedClasses.get(componentClass.getName());
            if (nestedArrayClass == null) {
                nestedArrayClass = this.generateWrapperForArrayClass(componentClass, typeMappingInfo, xmlElementType, classesToProcess);
                this.arrayClassesToGeneratedClasses.put(componentClass.getName(), nestedArrayClass);
                classesToProcess.add(this.helper.getJavaClass(nestedArrayClass));
            }
            return this.generateArrayValue(arrayClass, this.helper.getJavaClass(nestedArrayClass), this.helper.getJavaClass(nestedArrayClass), typeMappingInfo);
        }
        return this.generateArrayValue(arrayClass, componentClass, componentClass, typeMappingInfo);
    }

    private Class<?> generateArrayValue(JavaClass arrayClass, JavaClass componentClass, JavaClass nestedClass, TypeMappingInfo typeMappingInfo) {
        Object qualifiedClassName;
        QName qName = null;
        if (this.helper.getJavaClass(ManyValue.class).isAssignableFrom(componentClass)) {
            String packageName = componentClass.getPackageName();
            qualifiedClassName = nestedClass.getQualifiedName() + ARRAY_CLASS_NAME_SUFFIX;
        } else {
            Object packageName;
            if (componentClass.isPrimitive()) {
                packageName = ARRAY_PACKAGE_NAME;
                qualifiedClassName = (String)packageName + DOT_CHR + componentClass.getName() + ARRAY_CLASS_NAME_SUFFIX;
            } else {
                packageName = ARRAY_PACKAGE_NAME + DOT_CHR + componentClass.getPackageName();
                if (componentClass.isMemberClass()) {
                    qualifiedClassName = componentClass.getName();
                    qualifiedClassName = ((String)qualifiedClassName).substring(((String)qualifiedClassName).indexOf(DOLLAR_SIGN_CHR.charValue()) + 1);
                    qualifiedClassName = ARRAY_PACKAGE_NAME + DOT_CHR + componentClass.getPackageName() + DOT_CHR + (String)qualifiedClassName + ARRAY_CLASS_NAME_SUFFIX;
                } else {
                    qualifiedClassName = ARRAY_PACKAGE_NAME + DOT_CHR + componentClass.getQualifiedName() + ARRAY_CLASS_NAME_SUFFIX;
                }
            }
            if (componentClass.isPrimitive() || this.helper.isBuiltInJavaType(componentClass)) {
                qName = this.helper.getXMLToJavaTypeMap().get(componentClass.getQualifiedName());
                if (null != qName) {
                    packageName = ARRAY_PACKAGE_NAME;
                    qualifiedClassName = ARRAY_PACKAGE_NAME + DOT_CHR + qName.getLocalPart() + ARRAY_CLASS_NAME_SUFFIX;
                }
                if ((namespaceInfo = this.getPackageToPackageInfoMappings().get(packageName)) == null) {
                    namespaceInfo = new PackageInfo();
                    namespaceInfo.setNamespaceInfo(new NamespaceInfo());
                    namespaceInfo.setNamespace(ARRAY_NAMESPACE);
                    namespaceInfo.setNamespaceResolver(new NamespaceResolver());
                    this.getPackageToPackageInfoMappings().put((String)packageName, namespaceInfo);
                }
            } else {
                namespaceInfo = this.getPackageInfoForPackage(componentClass.getPackage(), componentClass.getPackageName());
                this.getPackageToPackageInfoMappings().put((String)packageName, namespaceInfo);
            }
        }
        try {
            String qualifiedInternalClassName = ((String)qualifiedClassName).replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
            if (this.helper.getJavaClass(ManyValue.class).isAssignableFrom(componentClass)) {
                return this.generateClassFromBytes((String)qualifiedClassName, this.generateMultiDimensionalManyValueClass(typeMappingInfo, null, MultiDimensionalArrayValue.class, qualifiedInternalClassName, componentClass, arrayClass.getComponentType()));
            }
            return this.generateClassFromBytes((String)qualifiedClassName, this.generateManyValue(typeMappingInfo, null, ArrayValue.class, qualifiedInternalClassName, componentClass, componentClass));
        }
        catch (LinkageError e) {
            if (null != qName) {
                throw JAXBException.nameCollision(qName.getNamespaceURI(), qName.getLocalPart());
            }
            throw e;
        }
    }

    private JavaClass getObjectType(JavaClass javaClass) {
        if (javaClass.isPrimitive()) {
            String primitiveClassName = javaClass.getRawName();
            Class<?> primitiveClass = this.getPrimitiveClass(primitiveClassName);
            return this.helper.getJavaClass(this.getObjectClass(primitiveClass));
        }
        return javaClass;
    }

    private Class<?> generateCollectionValue(JavaClass collectionClass, TypeMappingInfo typeMappingInfo, Class<?> xmlElementType, List<JavaClass> classesToProcess) {
        int beginIndex;
        int dollarIndex;
        String name;
        Collection<JavaClass> args;
        JavaClass componentClass = typeMappingInfo != null && xmlElementType != null ? this.helper.getJavaClass(xmlElementType) : (!(args = collectionClass.getActualTypeArguments()).isEmpty() ? (JavaClass)args.toArray()[0] : this.helper.getJavaClass(Object.class));
        boolean multiDimensional = false;
        if (componentClass.isPrimitive()) {
            Class<?> primitiveClass = this.getPrimitiveClass(componentClass.getRawName());
            componentClass = this.helper.getJavaClass(this.getObjectClass(primitiveClass));
        } else if (this.helper.getJavaClass(Collection.class).isAssignableFrom(componentClass)) {
            multiDimensional = true;
            java.lang.reflect.Type nestedCollectionType = this.getNestedCollectionType(typeMappingInfo);
            Class<?> nestedCollectionClass = this.collectionClassesToGeneratedClasses.get(nestedCollectionType);
            if (nestedCollectionClass == null) {
                nestedCollectionClass = this.generateCollectionValue(componentClass, typeMappingInfo, xmlElementType, classesToProcess);
                this.collectionClassesToGeneratedClasses.put(nestedCollectionType, nestedCollectionClass);
                classesToProcess.add(this.helper.getJavaClass(nestedCollectionClass));
            }
            componentClass = this.helper.getJavaClass(nestedCollectionClass);
        } else if (componentClass.isArray()) {
            if (componentClass.getName().equals("[B")) {
                multiDimensional = false;
            } else {
                multiDimensional = true;
                Class<?> nestedArrayClass = this.arrayClassesToGeneratedClasses.get(componentClass.getName());
                if (nestedArrayClass == null) {
                    nestedArrayClass = this.generateWrapperForArrayClass(componentClass, typeMappingInfo, xmlElementType, classesToProcess);
                    this.arrayClassesToGeneratedClasses.put(componentClass.getName(), nestedArrayClass);
                }
                componentClass = this.helper.getJavaClass(nestedArrayClass);
            }
        }
        PackageInfo packageInfo = this.packageToPackageInfoMappings.get(collectionClass.getPackageName());
        String namespace = EMPTY_STRING;
        if (this.defaultTargetNamespace != null) {
            namespace = this.defaultTargetNamespace;
        }
        PackageInfo componentNamespaceInfo = this.getPackageInfoForPackage(componentClass);
        Object packageName = componentClass.getPackageName();
        packageName = "jaxb.dev.java.net." + (String)packageName;
        if (packageInfo == null) {
            packageInfo = this.getPackageToPackageInfoMappings().get(packageName);
        } else {
            this.getPackageToPackageInfoMappings().put((String)packageName, packageInfo);
            if (packageInfo.getNamespace() != null) {
                namespace = packageInfo.getNamespace();
            }
        }
        if (packageInfo == null) {
            if (componentNamespaceInfo != null) {
                packageInfo = componentNamespaceInfo;
            } else {
                packageInfo = new PackageInfo();
                packageInfo.setNamespaceInfo(new NamespaceInfo());
                packageInfo.setNamespaceResolver(new NamespaceResolver());
            }
            this.getPackageToPackageInfoMappings().put((String)packageName, packageInfo);
        }
        if ("[B".equals(name = componentClass.getName())) {
            name = "byteArray";
        }
        if ((dollarIndex = (name = name.substring(beginIndex = name.lastIndexOf(DOT_CHR.charValue()) + 1)).indexOf(DOLLAR_SIGN_CHR.charValue())) > -1) {
            name = name.substring(dollarIndex + 1);
        }
        String collectionClassRawName = collectionClass.getRawName();
        String collectionClassShortName = collectionClassRawName.substring(collectionClassRawName.lastIndexOf(DOT_CHR.charValue()) + 1);
        String suggestedClassName = collectionClassShortName + "Of" + name;
        Object qualifiedClassName = (String)packageName + DOT_CHR + suggestedClassName;
        qualifiedClassName = this.getNextAvailableClassName((String)qualifiedClassName);
        String qualifiedInternalClassName = ((String)qualifiedClassName).replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        byte[] classBytes = multiDimensional ? this.generateMultiDimensionalManyValueClass(typeMappingInfo, namespace, MultiDimensionalCollectionValue.class, qualifiedInternalClassName, componentClass, collectionClass) : this.generateManyValue(typeMappingInfo, namespace, CollectionValue.class, qualifiedInternalClassName, componentClass, collectionClass);
        return this.generateClassFromBytes((String)qualifiedClassName, classBytes);
    }

    private java.lang.reflect.Type getNestedCollectionType(TypeMappingInfo mappingInfo) {
        java.lang.reflect.Type result = null;
        if (mappingInfo != null && mappingInfo.getType() != null) {
            ParameterizedType pType = (ParameterizedType)mappingInfo.getType();
            java.lang.reflect.Type[] actualTypeArguments = pType.getActualTypeArguments();
            java.lang.reflect.Type type2 = result = actualTypeArguments != null && actualTypeArguments.length > 0 ? actualTypeArguments[0] : null;
        }
        if (result == null) {
            this.getLogger().logWarning("cant_get_nested_collection_type", new Object[0]);
        }
        return result;
    }

    private byte[] generateManyValue(TypeMappingInfo typeMappingInfo, String namespace, Class<?> superType, String classNameSeparatedBySlash, JavaClass componentType, JavaClass containerType) {
        EclipseLinkASMClassWriter cw = new EclipseLinkASMClassWriter();
        this.generateManyValueClass(cw, typeMappingInfo, namespace, superType, classNameSeparatedBySlash, componentType, containerType);
        ((ClassWriter)cw).visitEnd();
        return ((ClassWriter)cw).toByteArray();
    }

    private void generateManyValueClass(ClassWriter cw, TypeMappingInfo typeMappingInfo, String namespace, Class<?> superType, String classNameSeparatedBySlash, JavaClass componentType, JavaClass containerType) {
        Annotation[] annotations;
        String componentClassNameSeparatedBySlash = this.getObjectType(componentType).getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        String containerClassNameSeperatedBySlash = containerType.getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        if ("[B".equals(componentClassNameSeparatedBySlash)) {
            cw.visit(Opcodes.ACC_PUBLIC + Opcodes.ACC_SUPER, classNameSeparatedBySlash, L + Type.getInternalName(superType) + "<" + componentClassNameSeparatedBySlash + ">;", Type.getInternalName(superType), null);
        } else {
            cw.visit(Opcodes.ACC_PUBLIC + Opcodes.ACC_SUPER, classNameSeparatedBySlash, L + Type.getInternalName(superType) + "<L" + componentClassNameSeparatedBySlash + ";>;", Type.getInternalName(superType), null);
        }
        AnnotationVisitor av = cw.visitAnnotation("Ljakarta/xml/bind/annotation/XmlType;", true);
        if (null != namespace) {
            av.visit("namespace", namespace);
        }
        if (classNameSeparatedBySlash.startsWith(ARRAY_PACKAGE_NAME.replace('.', '/')) && classNameSeparatedBySlash.contains("QName")) {
            av.visit("name", classNameSeparatedBySlash.substring(classNameSeparatedBySlash.lastIndexOf(47) + 1));
        }
        av.visitEnd();
        MethodVisitor mv = cw.visitMethod(Opcodes.ACC_PUBLIC, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(Opcodes.ALOAD, 0);
        mv.visitMethodInsn(Opcodes.INVOKESPECIAL, Type.getInternalName(superType), "<init>", "()V", false);
        mv.visitInsn(Opcodes.RETURN);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        if (!componentType.isPrimitive() && ArrayValue.class.isAssignableFrom(superType)) {
            mv = cw.visitMethod(Opcodes.ACC_PUBLIC, "getItem", "()Ljava/lang/Object;", null, null);
            mv.visitCode();
            mv.visitVarInsn(Opcodes.ALOAD, 0);
            mv.visitFieldInsn(Opcodes.GETFIELD, classNameSeparatedBySlash, "adaptedValue", "Ljava/util/Collection;");
            Label l0 = ASMFactory.createLabel();
            mv.visitJumpInsn(Opcodes.IFNONNULL, l0);
            mv.visitInsn(Opcodes.ACONST_NULL);
            mv.visitInsn(Opcodes.ARETURN);
            mv.visitLabel(l0);
            mv.visitFrame(Opcodes.F_SAME, 0, null, 0, null);
            mv.visitVarInsn(Opcodes.ALOAD, 0);
            mv.visitFieldInsn(Opcodes.GETFIELD, classNameSeparatedBySlash, "adaptedValue", "Ljava/util/Collection;");
            mv.visitMethodInsn(Opcodes.INVOKEINTERFACE, "java/util/Collection", "size", "()I", true);
            mv.visitVarInsn(Opcodes.ISTORE, 1);
            mv.visitVarInsn(Opcodes.ILOAD, 1);
            mv.visitTypeInsn(Opcodes.ANEWARRAY, componentClassNameSeparatedBySlash);
            mv.visitVarInsn(Opcodes.ASTORE, 2);
            mv.visitVarInsn(Opcodes.ALOAD, 0);
            mv.visitFieldInsn(Opcodes.GETFIELD, classNameSeparatedBySlash, "adaptedValue", "Ljava/util/Collection;");
            mv.visitVarInsn(Opcodes.ALOAD, 2);
            mv.visitMethodInsn(Opcodes.INVOKEINTERFACE, "java/util/Collection", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", true);
            mv.visitInsn(Opcodes.POP);
            mv.visitVarInsn(Opcodes.ALOAD, 2);
            mv.visitInsn(Opcodes.ARETURN);
            mv.visitMaxs(2, 3);
            mv.visitEnd();
            mv = cw.visitMethod(Opcodes.ACC_PUBLIC, "setItem", "(Ljava/lang/Object;)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(Opcodes.ALOAD, 1);
            mv.visitTypeInsn(Opcodes.CHECKCAST, "[L" + componentClassNameSeparatedBySlash + SEMI_COLON);
            mv.visitVarInsn(Opcodes.ASTORE, 2);
            mv.visitVarInsn(Opcodes.ALOAD, 0);
            mv.visitVarInsn(Opcodes.ALOAD, 2);
            mv.visitMethodInsn(Opcodes.INVOKESTATIC, "java/util/Arrays", "asList", "([Ljava/lang/Object;)Ljava/util/List;", false);
            mv.visitFieldInsn(Opcodes.PUTFIELD, classNameSeparatedBySlash, "adaptedValue", "Ljava/util/Collection;");
            mv.visitInsn(Opcodes.RETURN);
            mv.visitMaxs(2, 3);
            mv.visitEnd();
        }
        mv = "[B".equals(componentClassNameSeparatedBySlash) ? cw.visitMethod(Opcodes.ACC_PUBLIC, "getAdaptedValue", "()Ljava/util/Collection;", "()Ljava/util/Collection<" + componentClassNameSeparatedBySlash + ">;", null) : cw.visitMethod(Opcodes.ACC_PUBLIC, "getAdaptedValue", "()Ljava/util/Collection;", "()Ljava/util/Collection<L" + componentClassNameSeparatedBySlash + ";>;", null);
        boolean hasXmlList = false;
        if (typeMappingInfo != null && (annotations = this.getAnnotations(typeMappingInfo)) != null) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof XmlElement || annotation instanceof XmlJavaTypeAdapter) continue;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotation instanceof XmlList) {
                    hasXmlList = true;
                }
                av = mv.visitAnnotation(L + annotationType.getName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON, true);
                for (Method next : annotation.annotationType().getDeclaredMethods()) {
                    try {
                        Object nextValue = next.invoke((Object)annotation, new Object[0]);
                        if (nextValue instanceof Class) {
                            nextValue = Type.getType(L + ((Class)nextValue).getName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()) + SEMI_COLON);
                        }
                        av.visit(next.getName(), nextValue);
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                av.visitEnd();
            }
        }
        if (hasXmlList) {
            av = mv.visitAnnotation("Ljakarta/xml/bind/annotation/XmlValue;", true);
            av = mv.visitAnnotation("Lorg/eclipse/persistence/oxm/annotations/XmlValueExtension;", true);
            av.visitEnd();
        } else {
            av = mv.visitAnnotation("Ljakarta/xml/bind/annotation/XmlElement;", true);
            av.visit("name", ITEM);
            av.visit("nillable", true);
            av.visitEnd();
        }
        mv.visitCode();
        mv.visitVarInsn(Opcodes.ALOAD, 0);
        mv.visitMethodInsn(Opcodes.INVOKESPECIAL, Type.getInternalName(superType), "getAdaptedValue", "()Ljava/util/Collection;", false);
        mv.visitInsn(Opcodes.ARETURN);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(Opcodes.ACC_PUBLIC, "setAdaptedValue", "(Ljava/util/Collection;)V", "(Ljava/util/Collection<L" + componentClassNameSeparatedBySlash + ";>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(Opcodes.ALOAD, 0);
        mv.visitVarInsn(Opcodes.ALOAD, 1);
        mv.visitMethodInsn(Opcodes.INVOKESPECIAL, Type.getInternalName(superType), "setAdaptedValue", "(Ljava/util/Collection;)V", false);
        mv.visitInsn(Opcodes.RETURN);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(Opcodes.ACC_PROTECTED, "containerClass", "()Ljava/lang/Class;", "()Ljava/lang/Class<*>;", null);
        mv.visitCode();
        if (componentType.isPrimitive()) {
            mv.visitFieldInsn(Opcodes.GETSTATIC, this.getObjectType(componentType).getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue()), "TYPE", "Ljava/lang/Class;");
        } else if (containerClassNameSeperatedBySlash.contains(SEMI_COLON)) {
            mv.visitLdcInsn(Type.getType(containerClassNameSeperatedBySlash).unwrap());
        } else {
            mv.visitLdcInsn(Type.getType(L + containerClassNameSeperatedBySlash + SEMI_COLON).unwrap());
        }
        mv.visitInsn(Opcodes.ARETURN);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private byte[] generateMultiDimensionalManyValueClass(TypeMappingInfo typeMappingInfo, String namespace, Class<?> superType, String classNameSeparatedBySlash, JavaClass componentType, JavaClass containerType) {
        EclipseLinkASMClassWriter cw = new EclipseLinkASMClassWriter();
        this.generateManyValueClass(cw, typeMappingInfo, namespace, superType, classNameSeparatedBySlash, componentType, containerType);
        this.generateMultiDimensionalManyValueClass(cw, componentType);
        ((ClassWriter)cw).visitEnd();
        return ((ClassWriter)cw).toByteArray();
    }

    private void generateMultiDimensionalManyValueClass(ClassWriter cw, JavaClass componentType) {
        String componentClassNameSeparatedBySlash = componentType.getQualifiedName().replace(DOT_CHR.charValue(), SLASH_CHR.charValue());
        MethodVisitor mv = cw.visitMethod(Opcodes.ACC_PROTECTED, "componentClass", "()Ljava/lang/Class;", "()Ljava/lang/Class<L" + componentClassNameSeparatedBySlash + ";>;", null);
        mv.visitCode();
        mv.visitLdcInsn(Type.getType(L + componentClassNameSeparatedBySlash + SEMI_COLON).unwrap());
        mv.visitInsn(Opcodes.ARETURN);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private Class<?> generateClassFromBytes(String className, byte[] classBytes) {
        JaxbClassLoader loader = (JaxbClassLoader)this.helper.getClassLoader();
        Class<?> generatedClass = loader.generateClass(className, classBytes);
        return generatedClass;
    }

    private String getNextAvailableClassName(String suggestedName) {
        int counter = 1;
        return this.getNextAvailableClassName(suggestedName, suggestedName, counter);
    }

    private String getNextAvailableClassName(String suggestedBaseName, String suggestedName, int counter) {
        for (Class<?> nextClass : this.typeMappingInfosToGeneratedClasses.values()) {
            if (!nextClass.getName().equals(suggestedName)) continue;
            return this.getNextAvailableClassName(suggestedBaseName, suggestedBaseName + ++counter, counter);
        }
        return suggestedName;
    }

    private Class<?> getPrimitiveClass(String primitiveClassName) {
        return ConversionManager.getDefaultManager().convertClassNameToClass(primitiveClassName);
    }

    private Class<?> getObjectClass(Class<?> primitiveClass) {
        return ConversionManager.getObjectClass(primitiveClass);
    }

    public Map<java.lang.reflect.Type, Class<?>> getCollectionClassesToGeneratedClasses() {
        return this.collectionClassesToGeneratedClasses;
    }

    public Map<String, Class<?>> getArrayClassesToGeneratedClasses() {
        return this.arrayClassesToGeneratedClasses;
    }

    public Map<Class<?>, java.lang.reflect.Type> getGeneratedClassesToCollectionClasses() {
        return this.generatedClassesToCollectionClasses;
    }

    public Map<Class<?>, JavaClass> getGeneratedClassesToArrayClasses() {
        return this.generatedClassesToArrayClasses;
    }

    public Map<String, TypeInfo> getTypeInfosForPackage(String packageName) {
        HashMap<String, TypeInfo> typeInfos = new HashMap<String, TypeInfo>();
        List<JavaClass> jClasses = this.getTypeInfoClasses();
        for (JavaClass jClass : jClasses) {
            if (!jClass.getPackageName().equals(packageName)) continue;
            String key = jClass.getQualifiedName();
            typeInfos.put(key, this.typeInfos.get(key));
        }
        return typeInfos;
    }

    public void setPackageToNamespaceMappings(HashMap<String, NamespaceInfo> packageToNamespaceMappings) {
    }

    public void setPackageToPackageInfoMappings(HashMap<String, PackageInfo> packageToPackageInfoMappings) {
        this.packageToPackageInfoMappings = packageToPackageInfoMappings;
    }

    public SchemaTypeInfo addClass(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlTransient.class)) {
            return null;
        }
        if (this.typeInfos == null) {
            this.typeInfoClasses = new ArrayList<JavaClass>();
            this.typeInfos = new HashMap<String, TypeInfo>();
            this.typeQNames = new ArrayList<QName>();
            this.userDefinedSchemaTypes = new HashMap<String, QName>();
            this.packageToPackageInfoMappings = new HashMap<String, PackageInfo>();
        }
        JavaClass[] jClasses = new JavaClass[]{javaClass};
        this.buildNewTypeInfo(jClasses);
        TypeInfo info = this.typeInfos.get(javaClass.getQualifiedName());
        String packageName = javaClass.getPackageName();
        PackageInfo packageInfo = this.packageToPackageInfoMappings.get(packageName);
        SchemaTypeInfo schemaInfo = new SchemaTypeInfo();
        schemaInfo.setSchemaTypeName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
        if (info.isSetXmlRootElement()) {
            XmlRootElement xmlRE = info.getXmlRootElement();
            String elementName = xmlRE.getName();
            if (elementName.equals("##default") || elementName.equals(EMPTY_STRING)) {
                try {
                    elementName = info.getXmlNameTransformer().transformRootElementName(javaClass.getName());
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation(javaClass.getName(), info.getXmlNameTransformer().getClass().getName(), ex);
                }
            }
            String rootNamespace = xmlRE.getNamespace();
            QName rootElemName = null;
            rootElemName = rootNamespace.equals("##default") ? new QName(packageInfo.getNamespace(), elementName) : new QName(rootNamespace, elementName);
            schemaInfo.getGlobalElementDeclarations().add(rootElemName);
            ElementDeclaration declaration = new ElementDeclaration(rootElemName, javaClass, javaClass.getRawName(), false);
            this.addGlobalElement(rootElemName, declaration);
        }
        return schemaInfo;
    }

    public void buildNewTypeInfo(JavaClass[] javaClasses) {
        this.preBuildTypeInfo(javaClasses);
        for (JavaClass next : javaClasses = this.postBuildTypeInfo(javaClasses)) {
            this.processPropertyTypes(next);
        }
    }

    private void preProcessCustomizer(JavaClass jClass, TypeInfo tInfo) {
        XmlCustomizer xmlCustomizer = (XmlCustomizer)this.helper.getAnnotation(jClass, XmlCustomizer.class);
        if (xmlCustomizer != null) {
            tInfo.setXmlCustomizer(xmlCustomizer.value().getName());
        }
    }

    private JAXBMetadataLogger getLogger() {
        if (this.logger == null) {
            this.logger = new JAXBMetadataLogger();
        }
        return this.logger;
    }

    Helper getHelper() {
        return this.helper;
    }

    public boolean isDefaultNamespaceAllowed() {
        return this.isDefaultNamespaceAllowed;
    }

    public List<ElementDeclaration> getLocalElements() {
        return this.localElements;
    }

    public Map<TypeMappingInfo, Class<?>> getTypeMappingInfosToGeneratedClasses() {
        return this.typeMappingInfosToGeneratedClasses;
    }

    public Map<TypeMappingInfo, Class<?>> getTypeMappingInfoToAdapterClasses() {
        return this.typeMappingInfoToAdapterClasses;
    }

    public void addXmlRegistry(String factoryClassName, XmlRegistry xmlReg) {
        this.xmlRegistries.put(factoryClassName, xmlReg);
    }

    private boolean isXmlRegistry(JavaClass javaClass) {
        if (javaClass == null) {
            return false;
        }
        return this.helper.isAnnotationPresent(javaClass, jakarta.xml.bind.annotation.XmlRegistry.class) || this.xmlRegistries.get(javaClass.getQualifiedName()) != null;
    }

    public Map<TypeMappingInfo, QName> getTypeMappingInfosToSchemaTypes() {
        return this.typeMappingInfosToSchemaTypes;
    }

    String getDefaultTargetNamespace() {
        return this.defaultTargetNamespace;
    }

    void setDefaultTargetNamespace(String defaultTargetNamespace) {
        this.defaultTargetNamespace = defaultTargetNamespace;
    }

    public void setDefaultNamespaceAllowed(boolean isDefaultNamespaceAllowed) {
        this.isDefaultNamespaceAllowed = isDefaultNamespaceAllowed;
    }

    Map<QName, ElementDeclaration> getElementDeclarationsForScope(String scopeClassName) {
        return this.elementDeclarations.get(scopeClassName);
    }

    private void addGlobalElement(QName key, ElementDeclaration declaration) {
        this.getGlobalElements().put(key, declaration);
        this.classesToProcessPropertyTypes.add(declaration.getJavaType());
    }

    private Map<Object, Object> createUserPropertiesMap(XmlProperty[] properties) {
        HashMap<Object, Object> propMap = new HashMap<Object, Object>();
        for (XmlProperty prop : properties) {
            String pvalue = prop.value();
            if (prop.valueType() != String.class) {
                pvalue = XMLConversionManager.getDefaultXMLManager().convertObject(prop.value(), prop.valueType());
            }
            propMap.put(prop.name(), pvalue);
        }
        return propMap;
    }

    public boolean isMtomAttachment(Property property) {
        JavaClass ptype = property.getActualType();
        return this.areEquals(ptype, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(ptype, byte[].class) || this.areEquals(ptype, AWT_IMAGE) || this.areEquals(ptype, Source.class) || this.areEquals(ptype, JAVAX_MAIL_INTERNET_MIMEMULTIPART);
    }

    public boolean hasSwaRef() {
        return this.hasSwaRef;
    }

    public void setHasSwaRef(boolean swaRef) {
        this.hasSwaRef = swaRef;
    }

    public List getReferencedByTransformer() {
        return this.referencedByTransformer;
    }

    public boolean isXmlAccessorFactorySupport() {
        return this.xmlAccessorFactorySupport;
    }

    public void setXmlAccessorFactorySupport(boolean value) {
        this.xmlAccessorFactorySupport = value;
    }

    public void setHasXmlBindings(boolean b) {
        this.hasXmlBindings = true;
    }

    public boolean hasXmlBindings() {
        return this.hasXmlBindings;
    }

    private static final class PropertyComparitor
    implements Comparator<Property> {
        private PropertyComparitor() {
        }

        @Override
        public int compare(Property p1, Property p2) {
            return p1.getPropertyName().compareTo(p2.getPropertyName());
        }
    }
}

