/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContextFactory;

public class XMLBindingContextFactory
implements jakarta.xml.bind.JAXBContextFactory {
    @Override
    public JAXBContext createContext(Class<?>[] types, Map<String, ?> map) throws JAXBException {
        Map<String, Object> opts = map != null ? map : Collections.emptyMap();
        String factory = opts.getOrDefault("eclipselink.moxy.factory", "default");
        if (factory instanceof String) {
            return switch (factory) {
                case "default" -> JAXBContextFactory.createContext(types, opts);
                case "dynamic" -> DynamicJAXBContextFactory.createContext(types, opts);
                default -> throw new JAXBException(ExceptionLocalization.buildMessage("jaxb_context_factory_property_invalid", new Object[]{factory}));
            };
        }
        throw new JAXBException(ExceptionLocalization.buildMessage("jaxb_context_factory_property_invalid", new Object[]{factory}));
    }

    @Override
    public JAXBContext createContext(String string, ClassLoader cl, Map<String, ?> map) throws JAXBException {
        Map<String, Object> opts = map != null ? map : Collections.emptyMap();
        String factory = opts.getOrDefault("eclipselink.moxy.factory", "default");
        if (factory instanceof String) {
            return switch (factory) {
                case "default" -> JAXBContextFactory.createContext(string, cl, opts);
                case "dynamic" -> DynamicJAXBContextFactory.createContext(string, cl, opts);
                default -> throw new JAXBException(ExceptionLocalization.buildMessage("jaxb_context_factory_property_invalid", new Object[]{factory}));
            };
        }
        throw new JAXBException(ExceptionLocalization.buildMessage("jaxb_context_factory_property_invalid", new Object[]{factory}));
    }
}

