/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.MarshalException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.attachment.AttachmentMarshaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.validation.Schema;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.BeanValidationException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.ObjectGraphImpl;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.record.namespaces.MapNamespacePrefixMapper;
import org.eclipse.persistence.internal.oxm.record.namespaces.NamespacePrefixMapperWrapper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.BeanValidationChecker;
import org.eclipse.persistence.jaxb.BeanValidationMode;
import org.eclipse.persistence.jaxb.ConstraintViolationWrapper;
import org.eclipse.persistence.jaxb.JAXBBeanValidator;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.jaxb.JAXBMarshalListener;
import org.eclipse.persistence.jaxb.JAXBTypeElement;
import org.eclipse.persistence.jaxb.MOXySystemProperties;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.attachment.AttachmentMarshallerAdapter;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.LogLevel;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.oxm.CharacterEscapeHandler;
import org.eclipse.persistence.oxm.JSONWithPadding;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.XMLEventWriterRecord;
import org.eclipse.persistence.oxm.record.XMLStreamWriterRecord;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class JAXBMarshaller
implements Marshaller {
    private JAXBBeanValidator beanValidator;
    private BeanValidationMode beanValidationMode;
    private Object prefValidatorFactory;
    private boolean bvNoOptimisation = false;
    private Class<?>[] beanValidationGroups;
    private final XMLMarshaller xmlMarshaller;
    private final JAXBContext jaxbContext;
    private ValidationEventHandler validationEventHandler;
    public static final String XML_JAVATYPE_ADAPTERS = "xml-javatype-adapters";
    private static final String SUN_NAMESPACE_PREFIX_MAPPER = "org.glassfish.jaxb.namespacePrefixMapper";
    private static final String SUN_JSE_NAMESPACE_PREFIX_MAPPER = "com.sun.xml.internal.bind.namespacePrefixMapper";
    private static final String SUN_INDENT_STRING = "org.glassfish.jaxb.indentString";
    private static final String SUN_JSE_INDENT_STRING = "com.sun.xml.internal.bind.indentString";
    private static final String SUN_CHARACTER_ESCAPE_HANDLER_MARSHALLER = "org.glassfish.jaxb.marshaller.CharacterEscapeHandler";
    private static final String SUN_JSE_CHARACTER_ESCAPE_HANDLER_MARSHALLER = "com.sun.xml.internal.bind.marshaller.CharacterEscapeHandler";
    private static final String SUN_CHARACTER_ESCAPE_HANDLER = "org.glassfish.jaxb.characterEscapeHandler";
    private static final String SUN_JSE_CHARACTER_ESCAPE_HANDLER = "com.sun.xml.internal.bind.characterEscapeHandler";
    private static final String XML_DECLARATION = "org.glassfish.jaxb.xmlDeclaration";
    private static final String XML_HEADERS = "org.glassfish.jaxb.xmlHeaders";
    private static final String OBJECT_IDENTITY_CYCLE_DETECTION = "org.glassfish.jaxb.objectIdentitityCycleDetection";

    public JAXBMarshaller(XMLMarshaller newXMLMarshaller, JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
        this.validationEventHandler = JAXBContext.DEFAULT_VALIDATION_EVENT_HANDLER;
        this.beanValidationMode = BeanValidationMode.AUTO;
        if (BeanValidationChecker.isBeanValidationPresent()) {
            this.beanValidator = JAXBBeanValidator.getMarshallingBeanValidator(jaxbContext);
        }
        this.xmlMarshaller = newXMLMarshaller;
        this.xmlMarshaller.setErrorHandler(new JAXBErrorHandler(this.validationEventHandler));
        this.xmlMarshaller.setEncoding("UTF-8");
        this.xmlMarshaller.setFormattedOutput(false);
        this.xmlMarshaller.getProperties().put("jaxb.marshaller", this);
    }

    private Root createXMLRootFromJAXBElement(JAXBElement elt) {
        Class<?> theClass;
        Root xmlroot = new Root();
        Object objectValue = elt.getValue();
        xmlroot.setObject(objectValue);
        QName qname = elt.getName();
        xmlroot.setLocalName(qname.getLocalPart());
        xmlroot.setNamespaceURI(qname.getNamespaceURI());
        xmlroot.setDeclaredType(elt.getDeclaredType());
        xmlroot.setNil(elt.isNil());
        if (elt.getDeclaredType() == CoreClassConstants.ABYTE || elt.getDeclaredType() == CoreClassConstants.APBYTE || elt.getDeclaredType().getCanonicalName().equals("jakarta.activation.DataHandler") || elt.getDeclaredType().isEnum()) {
            Class<?> generatedClass = this.getClassToGeneratedClasses().get(elt.getDeclaredType().getCanonicalName());
            if (!elt.getDeclaredType().isEnum()) {
                xmlroot.setSchemaType(Constants.BASE_64_BINARY_QNAME);
            }
            if (generatedClass != null && WrappedValue.class.isAssignableFrom(generatedClass)) {
                CoreDescriptor desc = ((AbstractSession)this.xmlMarshaller.getXMLContext().getSession((Class)generatedClass)).getDescriptor((Class)generatedClass);
                Object newObject = ((ClassDescriptor)desc).getInstantiationPolicy().buildNewInstance();
                ((WrappedValue)newObject).setValue(objectValue);
                xmlroot.setObject(newObject);
                return xmlroot;
            }
        } else {
            xmlroot.setSchemaType(XMLConversionManager.getDefaultJavaTypes().get(elt.getDeclaredType()));
        }
        if (elt instanceof WrappedValue) {
            xmlroot.setObject(elt);
            return xmlroot;
        }
        Map<QName, Class<?>> qNameToGeneratedClasses = this.jaxbContext.getQNameToGeneratedClasses();
        if (qNameToGeneratedClasses != null && (theClass = qNameToGeneratedClasses.get(qname)) != null && WrappedValue.class.isAssignableFrom(theClass)) {
            CoreDescriptor desc = ((AbstractSession)this.xmlMarshaller.getXMLContext().getSession((Class)theClass)).getDescriptor((Class)theClass);
            Object newObject = ((ClassDescriptor)desc).getInstantiationPolicy().buildNewInstance();
            ((WrappedValue)newObject).setValue(objectValue);
            xmlroot.setObject(newObject);
            return xmlroot;
        }
        Class<?> generatedClass = null;
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() != null) {
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null) {
                if (elt.getDeclaredType() != null && elt.getDeclaredType().isArray()) {
                    TypeMappingInfo tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(elt.getDeclaredType());
                    generatedClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(tmi);
                } else if (elt instanceof JAXBTypeElement) {
                    objectType = ((JAXBTypeElement)elt).getType();
                    TypeMappingInfo tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(objectType);
                    generatedClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(tmi);
                }
            }
        } else if (elt.getDeclaredType() != null && elt.getDeclaredType().isArray()) {
            if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null) {
                generatedClass = this.jaxbContext.getArrayClassesToGeneratedClasses().get(elt.getDeclaredType().getCanonicalName());
            }
        } else if (elt instanceof JAXBTypeElement) {
            objectType = ((JAXBTypeElement)elt).getType();
            generatedClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(objectType);
        }
        if (generatedClass != null) {
            CoreDescriptor desc = ((AbstractSession)this.xmlMarshaller.getXMLContext().getSession((Class)generatedClass)).getDescriptor((Class)generatedClass);
            Object newObject = ((ClassDescriptor)desc).getInstantiationPolicy().buildNewInstance();
            ((ManyValue)newObject).setItem(objectValue);
            xmlroot.setObject(newObject);
        }
        return xmlroot;
    }

    public XmlAdapter getAdapter(Class javaClass) {
        HashMap result = (HashMap)this.xmlMarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            return null;
        }
        return (XmlAdapter)result.get(javaClass);
    }

    @Override
    public AttachmentMarshaller getAttachmentMarshaller() {
        if (this.xmlMarshaller.getAttachmentMarshaller() == null) {
            return null;
        }
        return ((AttachmentMarshallerAdapter)this.xmlMarshaller.getAttachmentMarshaller()).getAttachmentMarshaller();
    }

    @Override
    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    @Override
    public Marshaller.Listener getListener() {
        XMLMarshalListener xmlMarshalListener = this.xmlMarshaller.getMarshalListener();
        if (null != xmlMarshalListener) {
            return ((JAXBMarshalListener)xmlMarshalListener).getListener();
        }
        return null;
    }

    @Override
    public Node getNode(Object object) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getProperty(String key) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if ("jaxb.formatted.output".equals(key)) {
            return this.xmlMarshaller.isFormattedOutput();
        }
        if ("jaxb.encoding".equals(key)) {
            return this.xmlMarshaller.getEncoding();
        }
        if ("jaxb.schemaLocation".equals(key)) {
            return this.xmlMarshaller.getSchemaLocation();
        }
        if ("jaxb.noNamespaceSchemaLocation".equals(key)) {
            return this.xmlMarshaller.getNoNamespaceSchemaLocation();
        }
        if ("jaxb.fragment".equals(key)) {
            return this.xmlMarshaller.isFragment();
        }
        if ("eclipselink.media-type".equals(key)) {
            return this.xmlMarshaller.getMediaType();
        }
        if ("eclipselink.namespace-prefix-mapper".equals(key)) {
            return this.xmlMarshaller.getNamespacePrefixMapper();
        }
        if ("eclipselink.indent-string".equals(key) || SUN_INDENT_STRING.equals(key) || SUN_JSE_INDENT_STRING.equals(key)) {
            return this.xmlMarshaller.getIndentString();
        }
        if ("eclipselink.character-escape-handler".equals(key)) {
            return this.xmlMarshaller.getCharacterEscapeHandler();
        }
        if (XML_DECLARATION.equals(key)) {
            return !this.xmlMarshaller.isFragment();
        }
        if (XML_HEADERS.equals(key)) {
            return this.xmlMarshaller.getXmlHeader();
        }
        if (OBJECT_IDENTITY_CYCLE_DETECTION.equals(key)) {
            return this.xmlMarshaller.isEqualUsingIdenity();
        }
        if ("eclipselink.json.attribute-prefix".equals(key)) {
            return this.xmlMarshaller.getAttributePrefix();
        }
        if ("eclipselink.json.include-root".equals(key)) {
            return this.xmlMarshaller.isIncludeRoot();
        }
        if ("eclipselink.json.value-wrapper".equals(key)) {
            return this.xmlMarshaller.getValueWrapper();
        }
        if ("eclipselink.json.namespace-separator".equals(key)) {
            return Character.valueOf(this.xmlMarshaller.getNamespaceSeparator());
        }
        if ("eclipselink.json.wrapper-as-array-name".equals(key)) {
            return this.xmlMarshaller.isWrapperAsCollectionName();
        }
        if ("eclipselink.json.use-xsd-types-with-prefix".equals(key)) {
            return this.xmlMarshaller.getJsonTypeConfiguration().isUseXsdTypesWithPrefix();
        }
        if ("eclipselink.json.type-compatibility".equals(key)) {
            return this.xmlMarshaller.getJsonTypeConfiguration().isJsonTypeCompatibility();
        }
        if ("eclipselink.json.type-attribute-name".equals(key)) {
            return this.xmlMarshaller.getJsonTypeConfiguration().getJsonTypeAttributeName();
        }
        if ("eclipselink.json.disable-nested-array-name".equals(key)) {
            return this.xmlMarshaller.getJsonTypeConfiguration().isJsonDisableNestedArrayName();
        }
        if (SUN_CHARACTER_ESCAPE_HANDLER.equals(key) || SUN_JSE_CHARACTER_ESCAPE_HANDLER.equals(key) || SUN_CHARACTER_ESCAPE_HANDLER_MARSHALLER.equals(key) || SUN_JSE_CHARACTER_ESCAPE_HANDLER_MARSHALLER.equals(key)) {
            CharacterEscapeHandler characterEscapeHandler = this.xmlMarshaller.getCharacterEscapeHandler();
            if (characterEscapeHandler instanceof CharacterEscapeHandlerWrapper) {
                CharacterEscapeHandlerWrapper wrapper = (CharacterEscapeHandlerWrapper)characterEscapeHandler;
                return wrapper.getHandler();
            }
            return this.xmlMarshaller.getCharacterEscapeHandler();
        }
        if (SUN_NAMESPACE_PREFIX_MAPPER.equals(key) || SUN_JSE_NAMESPACE_PREFIX_MAPPER.equals(key)) {
            NamespacePrefixMapperWrapper wrapper = (NamespacePrefixMapperWrapper)this.xmlMarshaller.getNamespacePrefixMapper();
            if (wrapper == null) {
                return null;
            }
            return wrapper.getPrefixMapper();
        }
        if ("eclipselink.object-graph".equals(key)) {
            Object graph = this.xmlMarshaller.getMarshalAttributeGroup();
            if (graph instanceof CoreAttributeGroup) {
                return new ObjectGraphImpl((CoreAttributeGroup)graph);
            }
            return graph;
        }
        if ("eclipselink.beanvalidation.mode".equals(key)) {
            return this.beanValidationMode;
        }
        if ("eclipselink.beanvalidation.factory".equals(key)) {
            return this.prefValidatorFactory;
        }
        if ("eclipselink.beanvalidation.groups".equals(key)) {
            return this.beanValidationGroups;
        }
        if ("eclipselink.beanvalidation.no-optimisation".equals(key)) {
            return this.bvNoOptimisation;
        }
        if ("eclipselink.logging.payload.moxy".equals(key)) {
            return this.xmlMarshaller.isLogPayload();
        }
        throw new PropertyException(key);
    }

    @Override
    public Schema getSchema() {
        return this.xmlMarshaller.getSchema();
    }

    @Override
    public void marshal(Object object, ContentHandler contentHandler) throws JAXBException {
        if (object == null || contentHandler == null) {
            throw new IllegalArgumentException();
        }
        Marshaller.Listener listener = this.getListener();
        if (listener != null && object instanceof JAXBElement) {
            listener.beforeMarshal(object);
        }
        Object oxmObject = this.validateAndTransformIfNeeded(object);
        try {
            this.xmlMarshaller.marshal(oxmObject, contentHandler);
        }
        catch (BeanValidationException bve) {
            throw new MarshalException(bve.getMessage(), String.valueOf(bve.getErrorCode()), bve);
        }
        catch (Exception e) {
            throw new MarshalException(e);
        }
        if (listener != null && object instanceof JAXBElement) {
            listener.afterMarshal(object);
        }
    }

    private Object wrapEnumeration(Object object, Class<?> enumerationClass) {
        Class<?> generatedClass = this.getClassToGeneratedClasses().get(enumerationClass.getName());
        if (generatedClass != null && WrappedValue.class.isAssignableFrom(generatedClass)) {
            CoreDescriptor desc = ((AbstractSession)this.xmlMarshaller.getXMLContext().getSession((Class)generatedClass)).getDescriptor((Class)generatedClass);
            Object newObject = ((ClassDescriptor)desc).getInstantiationPolicy().buildNewInstance();
            ((WrappedValue)newObject).setValue(object);
            object = newObject;
        }
        return object;
    }

    @Override
    public void marshal(Object object, XMLEventWriter eventWriter) throws JAXBException {
        if (object == null || eventWriter == null) {
            throw new IllegalArgumentException();
        }
        Marshaller.Listener listener = this.getListener();
        if (listener != null && object instanceof JAXBElement) {
            listener.beforeMarshal(object);
        }
        Object oxmObject = this.validateAndTransformIfNeeded(object);
        try {
            XMLEventWriterRecord record = new XMLEventWriterRecord(eventWriter);
            record.setMarshaller(this.xmlMarshaller);
            this.xmlMarshaller.marshal(oxmObject, record);
        }
        catch (BeanValidationException bve) {
            throw new MarshalException(bve.getMessage(), String.valueOf(bve.getErrorCode()), bve);
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
        if (listener != null && object instanceof JAXBElement) {
            listener.afterMarshal(object);
        }
    }

    public void marshal(Object object, XMLEventWriter eventWriter, TypeMappingInfo type2) throws JAXBException {
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
            this.marshal(object, eventWriter);
        } else {
            JAXBContext.RootLevelXmlAdapter adapter;
            JAXBElement element = null;
            Object value = object;
            if (object instanceof JAXBElement) {
                element = (JAXBElement)object;
                value = element.getValue();
            }
            if ((adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type2)) != null) {
                try {
                    value = adapter.getXmlAdapter().marshal(value);
                }
                catch (Exception ex) {
                    throw new JAXBException(XMLMarshalException.marshalException(ex));
                }
            }
            value = this.wrapObject(value, element, type2);
            this.marshal(value, eventWriter);
        }
    }

    @Override
    public void marshal(Object object, Node node) throws JAXBException {
        if (object == null || node == null) {
            throw new IllegalArgumentException();
        }
        Marshaller.Listener listener = this.getListener();
        if (listener != null && object instanceof JAXBElement) {
            listener.beforeMarshal(object);
        }
        Object oxmObject = this.validateAndTransformIfNeeded(object);
        try {
            this.xmlMarshaller.marshal(oxmObject, node);
        }
        catch (BeanValidationException bve) {
            throw new MarshalException(bve.getMessage(), String.valueOf(bve.getErrorCode()), bve);
        }
        catch (Exception e) {
            throw new MarshalException(e);
        }
        if (listener != null && object instanceof JAXBElement) {
            listener.afterMarshal(object);
        }
    }

    @Override
    public void marshal(Object object, OutputStream outputStream) throws JAXBException {
        if (object == null || outputStream == null) {
            throw new IllegalArgumentException();
        }
        Marshaller.Listener listener = this.getListener();
        if (listener != null && object instanceof JAXBElement) {
            listener.beforeMarshal(object);
        }
        Object oxmObject = this.validateAndTransformIfNeeded(object);
        try {
            this.xmlMarshaller.marshal(oxmObject, outputStream);
        }
        catch (BeanValidationException bve) {
            throw new MarshalException(bve.getMessage(), String.valueOf(bve.getErrorCode()), bve);
        }
        catch (Exception e) {
            throw new MarshalException(e);
        }
        if (listener != null && object instanceof JAXBElement) {
            listener.afterMarshal(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Object object, File file) throws JAXBException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            this.marshal(object, outputStream);
        }
        catch (BeanValidationException bve) {
            throw new MarshalException(bve.getMessage(), String.valueOf(bve.getErrorCode()), bve);
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
    }

    @Override
    public void marshal(Object object, Result result) throws JAXBException {
        if (object == null || result == null) {
            throw new IllegalArgumentException();
        }
        object = this.validateAndTransformIfNeeded(object);
        try {
            this.xmlMarshaller.marshal(object, result);
        }
        catch (BeanValidationException bve) {
            throw new MarshalException(bve.getMessage(), String.valueOf(bve.getErrorCode()), bve);
        }
        catch (Exception e) {
            throw new MarshalException(e);
        }
    }

    public void marshal(Object object, Result result, TypeMappingInfo type2) throws JAXBException {
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
            this.marshal(object, result);
        } else {
            JAXBContext.RootLevelXmlAdapter adapter;
            JAXBElement element = null;
            Object value = object;
            if (object instanceof JAXBElement) {
                element = (JAXBElement)object;
                value = element.getValue();
            }
            if (!this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().isEmpty() && (adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type2)) != null) {
                try {
                    value = adapter.getXmlAdapter().marshal(value);
                }
                catch (Exception ex) {
                    throw new JAXBException(XMLMarshalException.marshalException(ex));
                }
            }
            value = this.wrapObject(value, element, type2);
            this.marshal(value, result);
        }
    }

    @Override
    public void marshal(Object object, XMLStreamWriter streamWriter) throws JAXBException {
        if (object == null || streamWriter == null) {
            throw new IllegalArgumentException();
        }
        Marshaller.Listener listener = this.getListener();
        if (listener != null && object instanceof JAXBElement) {
            listener.beforeMarshal(object);
        }
        Object oxmObject = this.validateAndTransformIfNeeded(object);
        try {
            XMLStreamWriterRecord record = new XMLStreamWriterRecord(streamWriter);
            record.setMarshaller(this.xmlMarshaller);
            this.xmlMarshaller.marshal(oxmObject, record);
        }
        catch (BeanValidationException bve) {
            throw new MarshalException(bve.getMessage(), String.valueOf(bve.getErrorCode()), bve);
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
        if (listener != null && object instanceof JAXBElement) {
            listener.afterMarshal(object);
        }
    }

    private Object validateAndTransformIfNeeded(Object obj) throws BeanValidationException {
        Object result = this.modifyObjectIfNeeded(obj);
        if (this.beanValidator != null && this.beanValidator.shouldValidate(obj, this.beanValidationMode, this.prefValidatorFactory, this.bvNoOptimisation)) {
            this.beanValidator.validate(result, this.beanValidationGroups);
        }
        return result;
    }

    private Object modifyObjectIfNeeded(Object obj) {
        if (obj instanceof Collection) {
            Collection objectList = (Collection)obj;
            ArrayList<Object> newList = new ArrayList<Object>(objectList.size());
            for (Object o : objectList) {
                newList.add(this.modifySingleObjectIfNeeded(o));
            }
            return newList;
        }
        if (obj.getClass().isArray()) {
            int arraySize = Array.getLength(obj);
            ArrayList<Object> newList = new ArrayList<Object>(arraySize);
            for (int x = 0; x < arraySize; ++x) {
                newList.add(this.modifySingleObjectIfNeeded(Array.get(obj, x)));
            }
            return newList;
        }
        return this.modifySingleObjectIfNeeded(obj);
    }

    private Object modifySingleObjectIfNeeded(Object obj) {
        Object newNestedObject;
        Object nestedObject;
        if (obj instanceof JAXBElement) {
            return this.createXMLRootFromJAXBElement((JAXBElement)obj);
        }
        if (obj != null && obj.getClass().isEnum()) {
            return this.wrapEnumeration(obj, obj.getClass());
        }
        if (obj instanceof JSONWithPadding && (nestedObject = ((JSONWithPadding)obj).getObject()) != null && nestedObject != (newNestedObject = this.modifyObjectIfNeeded(nestedObject))) {
            return new JSONWithPadding<Object>(newNestedObject, ((JSONWithPadding)obj).getCallbackName());
        }
        return obj;
    }

    public void marshal(Object object, XMLStreamWriter streamWriter, TypeMappingInfo type2) throws JAXBException {
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
            this.marshal(object, streamWriter);
        } else {
            JAXBContext.RootLevelXmlAdapter adapter;
            JAXBElement element = null;
            Object value = object;
            if (object instanceof JAXBElement) {
                element = (JAXBElement)object;
                value = element.getValue();
            }
            if (!this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().isEmpty() && (adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type2)) != null) {
                try {
                    value = adapter.getXmlAdapter().marshal(value);
                }
                catch (Exception ex) {
                    throw new JAXBException(XMLMarshalException.marshalException(ex));
                }
            }
            value = this.wrapObject(value, element, type2);
            this.marshal(value, streamWriter);
        }
    }

    private Object wrapObject(Object object, JAXBElement wrapperElement, TypeMappingInfo typeMappingInfo) {
        if (!this.jaxbContext.getTypeMappingInfoToGeneratedType().isEmpty()) {
            Class<?> generatedClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(typeMappingInfo);
            if (generatedClass != null && object == null && wrapperElement != null) {
                return this.wrapObjectInXMLRoot(wrapperElement, null, typeMappingInfo);
            }
            if (generatedClass != null && WrappedValue.class.isAssignableFrom(generatedClass)) {
                desc = ((AbstractSession)this.xmlMarshaller.getXMLContext().getSession((Class)generatedClass)).getDescriptor((Class)generatedClass);
                Object newObject = ((ClassDescriptor)desc).getInstantiationPolicy().buildNewInstance();
                ((WrappedValue)newObject).setValue(object);
                object = newObject;
            } else if (generatedClass != null) {
                desc = ((AbstractSession)this.xmlMarshaller.getXMLContext().getSession((Class)generatedClass)).getDescriptor((Class)generatedClass);
                Object newObject = ((ClassDescriptor)desc).getInstantiationPolicy().buildNewInstance();
                ((ManyValue)newObject).setItem(object);
                object = newObject;
            }
        }
        if (null == wrapperElement) {
            Root xmlRoot = new Root();
            QName xmlTagName = typeMappingInfo.getXmlTagName();
            if (null == xmlTagName) {
                return object;
            }
            xmlRoot.setNamespaceURI(typeMappingInfo.getXmlTagName().getNamespaceURI());
            xmlRoot.setLocalName(typeMappingInfo.getXmlTagName().getLocalPart());
            xmlRoot.setObject(object);
            return xmlRoot;
        }
        return this.wrapObjectInXMLRoot(wrapperElement, object, typeMappingInfo);
    }

    private Root wrapObjectInXMLRoot(JAXBElement wrapperElement, Object value, TypeMappingInfo typeMappingInfo) {
        Root xmlroot = new Root();
        Object objectValue = value;
        xmlroot.setObject(objectValue);
        QName qname = wrapperElement.getName();
        xmlroot.setLocalName(qname.getLocalPart());
        xmlroot.setNamespaceURI(qname.getNamespaceURI());
        xmlroot.setDeclaredType(wrapperElement.getDeclaredType());
        if (typeMappingInfo != null) {
            xmlroot.setSchemaType(typeMappingInfo.getSchemaType());
        } else if (value != null && (value.getClass() == CoreClassConstants.ABYTE || value.getClass() == CoreClassConstants.APBYTE || value.getClass().getCanonicalName().equals("jakarta.activation.DataHandler"))) {
            xmlroot.setSchemaType(Constants.BASE_64_BINARY_QNAME);
        }
        return xmlroot;
    }

    @Override
    public void marshal(Object object, Writer writer) throws JAXBException {
        if (object == null || writer == null) {
            throw new IllegalArgumentException();
        }
        Marshaller.Listener listener = this.getListener();
        if (listener != null && object instanceof JAXBElement) {
            listener.beforeMarshal(object);
        }
        Object oxmObject = this.validateAndTransformIfNeeded(object);
        try {
            this.xmlMarshaller.marshal(oxmObject, writer);
        }
        catch (BeanValidationException bve) {
            throw new MarshalException(bve.getMessage(), String.valueOf(bve.getErrorCode()), bve);
        }
        catch (Exception e) {
            throw new MarshalException(e);
        }
        if (listener != null && object instanceof JAXBElement) {
            listener.afterMarshal(object);
        }
    }

    public void marshal(Object object, MarshalRecord record) throws JAXBException {
        if (object == null || record == null) {
            throw new IllegalArgumentException();
        }
        object = this.validateAndTransformIfNeeded(object);
        try {
            record.setMarshaller(this.xmlMarshaller);
            this.xmlMarshaller.marshal(object, record);
        }
        catch (BeanValidationException bve) {
            throw new MarshalException(bve.getMessage(), String.valueOf(bve.getErrorCode()), bve);
        }
        catch (Exception e) {
            throw new MarshalException(e);
        }
    }

    public void marshal(Object object, MarshalRecord record, TypeMappingInfo type2) throws JAXBException {
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
            this.marshal(object, record);
        } else {
            JAXBContext.RootLevelXmlAdapter adapter;
            JAXBElement element = null;
            Object value = object;
            if (object instanceof JAXBElement) {
                element = (JAXBElement)object;
                value = element.getValue();
            }
            if ((adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type2)) != null) {
                try {
                    value = adapter.getXmlAdapter().marshal(value);
                }
                catch (Exception ex) {
                    throw new JAXBException(XMLMarshalException.marshalException(ex));
                }
            }
            value = this.wrapObject(value, element, type2);
            this.marshal(value, record);
        }
    }

    public void setAdapter(Class javaClass, XmlAdapter adapter) {
        HashMap<Class, XmlAdapter> result = (HashMap<Class, XmlAdapter>)this.xmlMarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            result = new HashMap<Class, XmlAdapter>();
            this.xmlMarshaller.getProperties().put(XML_JAVATYPE_ADAPTERS, result);
        }
        result.put(javaClass, adapter);
    }

    public void setAdapter(XmlAdapter adapter) {
        this.setAdapter(adapter.getClass(), adapter);
    }

    @Override
    public void setAttachmentMarshaller(AttachmentMarshaller attachmentMarshaller) {
        if (attachmentMarshaller == null) {
            this.xmlMarshaller.setAttachmentMarshaller(null);
        } else {
            this.xmlMarshaller.setAttachmentMarshaller(new AttachmentMarshallerAdapter(attachmentMarshaller));
        }
    }

    @Override
    public void setEventHandler(ValidationEventHandler newValidationEventHandler) throws JAXBException {
        this.validationEventHandler = null == newValidationEventHandler ? JAXBContext.DEFAULT_VALIDATION_EVENT_HANDLER : newValidationEventHandler;
        this.xmlMarshaller.setErrorHandler(new JAXBErrorHandler(this.validationEventHandler));
    }

    @Override
    public void setListener(Marshaller.Listener listener) {
        if (this.xmlMarshaller.getMarshalListener() == null) {
            this.xmlMarshaller.setMarshalListener(new JAXBMarshalListener(this.jaxbContext, this));
        }
        ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).setListener(listener);
    }

    public void setMarshalCallbacks(Map callbacks) {
        if (callbacks == null || callbacks.isEmpty()) {
            return;
        }
        if (this.xmlMarshaller.getMarshalListener() == null) {
            this.xmlMarshaller.setMarshalListener(new JAXBMarshalListener(this.jaxbContext, this));
        }
        ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).setClassBasedMarshalEvents(callbacks);
    }

    @Override
    public void setProperty(String key, Object value) throws PropertyException {
        try {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            SessionLog logger2 = AbstractSessionLog.getLog();
            if (logger2.shouldLog(3, "moxy")) {
                logger2.log(3, "moxy", "moxy_set_marshaller_property", new Object[]{key, value});
            }
            if (MOXySystemProperties.moxyLogPayload != null && this.xmlMarshaller.isLogPayload() == null) {
                this.xmlMarshaller.setLogPayload(MOXySystemProperties.moxyLogPayload);
            }
            switch (key) {
                case "jaxb.fragment": {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    Boolean fragment = (Boolean)value;
                    this.xmlMarshaller.setFragment(fragment);
                    break;
                }
                case "jaxb.formatted.output": {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    Boolean formattedOutput = (Boolean)value;
                    this.xmlMarshaller.setFormattedOutput(formattedOutput);
                    break;
                }
                case "jaxb.encoding": {
                    this.xmlMarshaller.setEncoding((String)value);
                    break;
                }
                case "jaxb.schemaLocation": {
                    this.xmlMarshaller.setSchemaLocation((String)value);
                    break;
                }
                case "jaxb.noNamespaceSchemaLocation": {
                    this.xmlMarshaller.setNoNamespaceSchemaLocation((String)value);
                    break;
                }
                case "eclipselink.namespace-prefix-mapper": {
                    if (value == null) {
                        this.xmlMarshaller.setNamespacePrefixMapper((NamespacePrefixMapper)null);
                        break;
                    }
                    if (value instanceof Map) {
                        MapNamespacePrefixMapper namespacePrefixMapper = new MapNamespacePrefixMapper((Map)value);
                        this.xmlMarshaller.setNamespacePrefixMapper(namespacePrefixMapper);
                        break;
                    }
                    this.xmlMarshaller.setNamespacePrefixMapper((NamespacePrefixMapper)value);
                    break;
                }
                case "org.glassfish.jaxb.namespacePrefixMapper": 
                case "com.sun.xml.internal.bind.namespacePrefixMapper": {
                    if (value == null) {
                        this.xmlMarshaller.setNamespacePrefixMapper((NamespacePrefixMapper)null);
                        break;
                    }
                    this.xmlMarshaller.setNamespacePrefixMapper(new NamespacePrefixMapperWrapper(value));
                    break;
                }
                case "eclipselink.indent-string": 
                case "org.glassfish.jaxb.indentString": 
                case "com.sun.xml.internal.bind.indentString": {
                    this.xmlMarshaller.setIndentString((String)value);
                    break;
                }
                case "eclipselink.json.marshal-empty-collections": {
                    this.xmlMarshaller.setMarshalEmptyCollections((Boolean)value);
                    break;
                }
                case "eclipselink.json.reduce-any-arrays": {
                    this.xmlMarshaller.setReduceAnyArrays((Boolean)value);
                    break;
                }
                case "eclipselink.json.wrapper-as-array-name": {
                    this.xmlMarshaller.setWrapperAsCollectionName((Boolean)value);
                    break;
                }
                case "eclipselink.json.use-xsd-types-with-prefix": {
                    this.xmlMarshaller.getJsonTypeConfiguration().setUseXsdTypesWithPrefix((Boolean)value);
                    break;
                }
                case "eclipselink.json.type-compatibility": {
                    this.xmlMarshaller.getJsonTypeConfiguration().setJsonTypeCompatibility((Boolean)value);
                    break;
                }
                case "eclipselink.json.type-attribute-name": {
                    this.xmlMarshaller.getJsonTypeConfiguration().setJsonTypeAttributeName((String)value);
                    break;
                }
                case "eclipselink.json.disable-nested-array-name": {
                    this.xmlMarshaller.getJsonTypeConfiguration().setJsonDisableNestedArrayName((Boolean)value);
                    break;
                }
                case "eclipselink.character-escape-handler": {
                    this.xmlMarshaller.setCharacterEscapeHandler((CharacterEscapeHandler)value);
                    break;
                }
                case "eclipselink.logging.payload.moxy": {
                    this.xmlMarshaller.setLogPayload((Boolean)value);
                    break;
                }
                case "eclipselink.logging.level.moxy": {
                    if (value instanceof String) {
                        AbstractSessionLog.getLog().setLevel(LogLevel.toValue((String)value).getId(), "moxy");
                        break;
                    }
                    AbstractSessionLog.getLog().setLevel(((LogLevel)((Object)value)).getId(), "moxy");
                    break;
                }
                case "org.glassfish.jaxb.characterEscapeHandler": 
                case "com.sun.xml.internal.bind.characterEscapeHandler": 
                case "org.glassfish.jaxb.marshaller.CharacterEscapeHandler": 
                case "com.sun.xml.internal.bind.marshaller.CharacterEscapeHandler": {
                    if (value == null) {
                        this.xmlMarshaller.setCharacterEscapeHandler((CharacterEscapeHandler)null);
                        break;
                    }
                    this.xmlMarshaller.setCharacterEscapeHandler(new CharacterEscapeHandlerWrapper(value));
                    break;
                }
                case "org.glassfish.jaxb.xmlDeclaration": {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    Boolean fragment = (Boolean)value == false;
                    this.xmlMarshaller.setFragment(fragment);
                    break;
                }
                case "org.glassfish.jaxb.xmlHeaders": {
                    this.xmlMarshaller.setXmlHeader((String)value);
                    break;
                }
                case "org.glassfish.jaxb.objectIdentitityCycleDetection": {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    this.xmlMarshaller.setEqualUsingIdenity((Boolean)value);
                    break;
                }
                case "eclipselink.media-type": {
                    MediaType mType = null;
                    if (value instanceof MediaType) {
                        mType = (MediaType)value;
                    } else if (value instanceof String) {
                        mType = MediaType.getMediaType((String)value);
                    }
                    if (mType == null) {
                        throw new PropertyException(key, "");
                    }
                    this.xmlMarshaller.setMediaType(mType);
                    break;
                }
                case "eclipselink.json.attribute-prefix": {
                    this.xmlMarshaller.setAttributePrefix((String)value);
                    break;
                }
                case "eclipselink.json.include-root": {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    this.xmlMarshaller.setIncludeRoot((Boolean)value);
                    break;
                }
                case "eclipselink.json.value-wrapper": {
                    if (value == null || ((String)value).isEmpty()) {
                        throw new PropertyException(key, "");
                    }
                    this.xmlMarshaller.setValueWrapper((String)value);
                    break;
                }
                case "eclipselink.json.namespace-separator": {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    this.xmlMarshaller.setNamespaceSeparator(((Character)value).charValue());
                    break;
                }
                case "eclipselink.object-graph": {
                    if (value == null) {
                        this.xmlMarshaller.setMarshalAttributeGroup(null);
                        break;
                    }
                    if (value instanceof ObjectGraphImpl) {
                        this.xmlMarshaller.setMarshalAttributeGroup(((ObjectGraphImpl)value).getAttributeGroup());
                        break;
                    }
                    if (value.getClass() == ClassConstants.STRING) {
                        this.xmlMarshaller.setMarshalAttributeGroup(value);
                        break;
                    }
                    throw org.eclipse.persistence.exceptions.JAXBException.invalidValueForObjectGraph(value);
                }
                case "eclipselink.beanvalidation.mode": {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    this.beanValidationMode = (BeanValidationMode)((Object)value);
                    break;
                }
                case "eclipselink.beanvalidation.factory": {
                    if (value == null) {
                        // empty if block
                    }
                    this.prefValidatorFactory = value;
                    break;
                }
                case "eclipselink.beanvalidation.groups": {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    this.beanValidationGroups = (Class[])value;
                    break;
                }
                case "eclipselink.beanvalidation.no-optimisation": {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    this.bvNoOptimisation = (Boolean)value;
                    break;
                }
                default: {
                    throw new PropertyException(key, value);
                }
            }
        }
        catch (ClassCastException exception) {
            throw new PropertyException(key, exception);
        }
    }

    @Override
    public void setSchema(Schema schema) {
        this.xmlMarshaller.setSchema(schema);
    }

    private Map<String, Class<?>> getClassToGeneratedClasses() {
        return this.jaxbContext.getClassToGeneratedClasses();
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public XMLMarshaller getXMLMarshaller() {
        return this.xmlMarshaller;
    }

    public Set<ConstraintViolationWrapper<Object>> getConstraintViolations() {
        if (this.beanValidator != null) {
            return this.beanValidator.getConstraintViolations();
        }
        return Collections.emptySet();
    }

    private static class CharacterEscapeHandlerWrapper
    extends org.eclipse.persistence.internal.oxm.record.CharacterEscapeHandlerWrapper
    implements CharacterEscapeHandler {
        public CharacterEscapeHandlerWrapper(Object sunHandler) {
            super(sunHandler);
        }
    }
}

