/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.descriptors.CoreInheritancePolicy;
import org.eclipse.persistence.internal.core.helper.CoreField;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractRecord;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.AbstractMarshalRecord;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.w3c.dom.Node;

public class AbstractMarshalRecordImpl<ABSTRACT_SESSION extends CoreAbstractSession, FIELD extends CoreField, MARSHALLER extends Marshaller, NAMESPACE_RESOLVER extends NamespaceResolver>
extends CoreAbstractRecord
implements AbstractMarshalRecord<ABSTRACT_SESSION, FIELD, MARSHALLER, NAMESPACE_RESOLVER> {
    private ConversionManager conversionManager;
    protected boolean equalNamespaceResolvers;
    protected boolean hasCustomNamespaceMapper;
    private boolean isXOPPackage;
    private XPathQName leafElementType;
    protected MARSHALLER marshaller;
    protected boolean namespaceAware = true;
    protected NAMESPACE_RESOLVER namespaceResolver;
    private Object owningObject;
    private AbstractMarshalRecord<ABSTRACT_SESSION, FIELD, MARSHALLER, NAMESPACE_RESOLVER> realRecord;
    protected ABSTRACT_SESSION session;

    public AbstractMarshalRecordImpl(AbstractMarshalRecord realRecord) {
        this.realRecord = realRecord;
    }

    @Override
    public List addExtraNamespacesToNamespaceResolver(Descriptor descriptor, CoreAbstractSession session, boolean allowOverride, boolean ignoreEqualResolvers) {
        if (this.equalNamespaceResolvers && !ignoreEqualResolvers) {
            return null;
        }
        Object descriptorNamespaceResolver = descriptor.getNamespaceResolver();
        if (null == descriptorNamespaceResolver || !((NamespaceResolver)descriptorNamespaceResolver).hasPrefixesToNamespaces()) {
            return null;
        }
        Map<String, String> prefixesToNamespaces = ((NamespaceResolver)descriptorNamespaceResolver).getPrefixesToNamespaces();
        if (prefixesToNamespaces.isEmpty()) {
            return null;
        }
        ArrayList<Namespace> returnList = new ArrayList<Namespace>(prefixesToNamespaces.size());
        NAMESPACE_RESOLVER marshalRecordNamespaceResolver = this.namespaceResolver;
        for (Map.Entry<String, String> entry : prefixesToNamespaces.entrySet()) {
            String prefix = ((NamespaceResolver)marshalRecordNamespaceResolver).resolveNamespaceURI(entry.getValue());
            if (prefix == null || prefix.isEmpty()) {
                String newPrefix;
                prefix = entry.getKey();
                if (this.hasCustomNamespaceMapper && (newPrefix = ((NamespacePrefixMapper)((Marshaller)this.getMarshaller()).getNamespacePrefixMapper()).getPreferredPrefix(entry.getValue(), prefix, true)) != null && !newPrefix.isEmpty()) {
                    prefix = newPrefix;
                }
                String uri = ((NamespaceResolver)marshalRecordNamespaceResolver).resolveNamespacePrefix(prefix);
                if (!this.hasCustomNamespaceMapper && !allowOverride && uri != null && !uri.isEmpty()) continue;
                ((NamespaceResolver)marshalRecordNamespaceResolver).put(entry.getKey(), entry.getValue());
                returnList.add(new Namespace(prefix, entry.getValue()));
                continue;
            }
            if (!allowOverride || prefix.equals(entry.getKey()) || this.hasCustomNamespaceMapper) continue;
            ((NamespaceResolver)marshalRecordNamespaceResolver).put(entry.getKey(), entry.getValue());
            returnList.add(new Namespace(entry.getKey(), entry.getValue()));
        }
        return returnList;
    }

    @Override
    public boolean addXsiTypeAndClassIndicatorIfRequired(Descriptor descriptor, Descriptor referenceDescriptor, Field xmlField, boolean isRootElement) {
        Object inheritancePolicy;
        Field indicatorField;
        ObjectBuilder objectBuilder = (ObjectBuilder)descriptor.getObjectBuilder();
        boolean xsiTypeIndicatorField = objectBuilder.isXsiTypeIndicatorField();
        if (objectBuilder.addClassIndicatorFieldToRow(this)) {
            return true;
        }
        QName leafType = null;
        if (xmlField != null) {
            leafType = xmlField.getLeafElementType();
            XMLSchemaReference xmlRef = descriptor.getSchemaReference();
            if (xmlRef != null) {
                QName ctxQName;
                if (leafType == null) {
                    if (xmlRef.getType() == 3) {
                        return false;
                    }
                    if (referenceDescriptor == null) {
                        this.writeXsiTypeAttribute(descriptor, xmlRef, isRootElement);
                        return true;
                    }
                } else if ((xmlRef.getType() == 1 || xmlRef.getType() == 2) && xmlRef.getSchemaContext() != null && xmlRef.isGlobalDefinition() && !(ctxQName = xmlRef.getSchemaContextAsQName((NamespaceResolver)descriptor.getNamespaceResolver())).equals(leafType)) {
                    this.writeXsiTypeAttribute(descriptor, xmlRef, isRootElement);
                    return true;
                }
            }
        }
        if (referenceDescriptor != null && referenceDescriptor == descriptor) {
            return false;
        }
        if (descriptor.hasInheritance() && !((CoreInheritancePolicy)descriptor.getInheritancePolicy()).isRootParentDescriptor() && (indicatorField = (Field)((CoreInheritancePolicy)(inheritancePolicy = descriptor.getInheritancePolicy())).getClassIndicatorField()) != null && xsiTypeIndicatorField) {
            Object classIndicatorValueObject = ((CoreInheritancePolicy)inheritancePolicy).getClassIndicatorMapping().get(descriptor.getJavaClass());
            String classIndicatorUri = null;
            String classIndicatorLocal = null;
            String classIndicatorPrefix = null;
            if (classIndicatorValueObject instanceof QName) {
                QName classIndicatorQName = (QName)classIndicatorValueObject;
                classIndicatorUri = classIndicatorQName.getNamespaceURI();
                classIndicatorLocal = classIndicatorQName.getLocalPart();
                classIndicatorPrefix = classIndicatorQName.getPrefix();
            } else {
                String classIndicatorValue = (String)((CoreInheritancePolicy)inheritancePolicy).getClassIndicatorMapping().get(descriptor.getJavaClass());
                int nsindex = classIndicatorValue.indexOf(58);
                String prefix = null;
                if (nsindex != -1) {
                    classIndicatorLocal = classIndicatorValue.substring(nsindex + 1);
                    prefix = classIndicatorValue.substring(0, nsindex);
                } else {
                    classIndicatorLocal = classIndicatorValue;
                }
                classIndicatorUri = ((NamespaceResolver)descriptor.getNonNullNamespaceResolver()).resolveNamespacePrefix(prefix);
            }
            if (leafType == null || isRootElement && ((Marshaller)this.marshaller).isApplicationJSON() && !((Marshaller)this.marshaller).isIncludeRoot() || !leafType.getLocalPart().equals(classIndicatorLocal) || classIndicatorUri == null && leafType.getNamespaceURI() != null && !leafType.getNamespaceURI().isEmpty() || classIndicatorUri != null && !classIndicatorUri.equals(leafType.getNamespaceURI())) {
                if (((CoreInheritancePolicy)inheritancePolicy).hasClassExtractor()) {
                    objectBuilder.addClassIndicatorFieldToRow(this);
                } else {
                    this.writeXsiTypeAttribute(descriptor, classIndicatorUri, classIndicatorLocal, classIndicatorPrefix, isRootElement);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean addXsiTypeAndClassIndicatorIfRequired(Descriptor descriptor, Descriptor referenceDescriptor, Field xmlField, Object originalObject, Object obj, boolean wasXMLRoot, boolean isRootElement) {
        if (wasXMLRoot) {
            XMLSchemaReference xmlRef = descriptor.getSchemaReference();
            if (descriptor != null) {
                Root xr = (Root)originalObject;
                if (xmlRef == null) {
                    return false;
                }
                if (xr.getDeclaredType() != null && xr.getDeclaredType() == xr.getObject().getClass()) {
                    return false;
                }
                String xmlRootLocalName = xr.getLocalName();
                String xmlRootUri = xr.getNamespaceURI();
                XPathQName qName = new XPathQName(xmlRootUri, xmlRootLocalName, this.namespaceAware);
                Object xdesc = ((Context)((Marshaller)this.marshaller).getContext()).getDescriptor(qName);
                if (xdesc != null) {
                    boolean writeTypeAttribute;
                    boolean bl = writeTypeAttribute = xdesc.getJavaClass() != descriptor.getJavaClass();
                    if (writeTypeAttribute) {
                        this.writeXsiTypeAttribute(descriptor, xmlRef, isRootElement);
                        return true;
                    }
                    return false;
                }
                boolean writeTypeAttribute = true;
                int tableSize = descriptor.getTableNames().size();
                for (int i = 0; i < tableSize; ++i) {
                    if (!writeTypeAttribute) {
                        return false;
                    }
                    String defaultRootQualifiedName = descriptor.getTableNames().get(i);
                    if (defaultRootQualifiedName != null) {
                        String defaultRootLocalName = null;
                        String defaultRootUri = null;
                        int colonIndex = defaultRootQualifiedName.indexOf(58);
                        if (colonIndex > 0) {
                            String defaultRootPrefix = defaultRootQualifiedName.substring(0, colonIndex);
                            defaultRootLocalName = defaultRootQualifiedName.substring(colonIndex + 1);
                            if (descriptor.getNamespaceResolver() != null) {
                                defaultRootUri = ((NamespaceResolver)descriptor.getNamespaceResolver()).resolveNamespacePrefix(defaultRootPrefix);
                            }
                        } else {
                            defaultRootLocalName = defaultRootQualifiedName;
                        }
                        if (xmlRootLocalName == null || (defaultRootLocalName != null || xmlRootLocalName != null) && !defaultRootLocalName.equals(xmlRootLocalName) || (defaultRootUri != null || xmlRootUri != null) && (xmlRootUri == null || defaultRootUri == null || !defaultRootUri.equals(xmlRootUri))) continue;
                        return false;
                    }
                    if (xmlRootLocalName != null) continue;
                    return false;
                }
                if (writeTypeAttribute && xmlRef != null) {
                    this.writeXsiTypeAttribute(descriptor, xmlRef, isRootElement);
                    return true;
                }
            }
            return false;
        }
        return this.addXsiTypeAndClassIndicatorIfRequired(descriptor, referenceDescriptor, xmlField, isRootElement);
    }

    @Override
    public void attribute(String namespaceURI, String localName, String qualifiedName, String value) {
        if (null != this.realRecord) {
            this.realRecord.attribute(namespaceURI, localName, qualifiedName, value);
        }
    }

    @Override
    public void attributeWithoutQName(String namespaceURI, String localName, String prefix, String value) {
        Object qualifiedName = localName;
        if (prefix != null && !prefix.isEmpty()) {
            qualifiedName = prefix + this.getNamespaceSeparator() + (String)qualifiedName;
        }
        this.attribute(namespaceURI, localName, (String)qualifiedName, value);
    }

    @Override
    public ConversionManager getConversionManager() {
        if (null == this.conversionManager) {
            this.conversionManager = (ConversionManager)((CoreAbstractSession)this.session).getDatasourcePlatform().getConversionManager();
        }
        return this.conversionManager;
    }

    @Override
    public Node getDOM() {
        throw new UnsupportedOperationException();
    }

    @Override
    public XPathQName getLeafElementType() {
        return this.leafElementType;
    }

    @Override
    public MARSHALLER getMarshaller() {
        return this.marshaller;
    }

    @Override
    public NAMESPACE_RESOLVER getNamespaceResolver() {
        return this.namespaceResolver;
    }

    @Override
    public char getNamespaceSeparator() {
        return ':';
    }

    @Override
    public Object getOwningObject() {
        return this.owningObject;
    }

    @Override
    public ABSTRACT_SESSION getSession() {
        return this.session;
    }

    @Override
    public boolean hasCustomNamespaceMapper() {
        return this.hasCustomNamespaceMapper;
    }

    @Override
    public boolean hasEqualNamespaceResolvers() {
        return this.equalNamespaceResolvers;
    }

    @Override
    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    @Override
    public boolean isXOPPackage() {
        return this.isXOPPackage;
    }

    @Override
    public void namespaceDeclaration(String prefix, String typeUri) {
        if (this.realRecord != null) {
            this.realRecord.namespaceDeclaration(prefix, typeUri);
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(FIELD field, Object object) {
        if (null != this.realRecord) {
            return this.realRecord.put(field, object);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeExtraNamespacesFromNamespaceResolver(List<Namespace> extraNamespaces, CoreAbstractSession session) {
        if (extraNamespaces == null) {
            return;
        }
        for (int i = 0; i < extraNamespaces.size(); ++i) {
            Namespace nextExtraNamespace = extraNamespaces.get(i);
            String uri = ((NamespaceResolver)this.namespaceResolver).resolveNamespacePrefix(nextExtraNamespace.getPrefix());
            if (uri == null || !uri.equals(nextExtraNamespace.getNamespaceURI())) continue;
            ((NamespaceResolver)this.namespaceResolver).removeNamespace(nextExtraNamespace.getPrefix());
        }
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        return null;
    }

    @Override
    public void setCustomNamespaceMapper(boolean customNamespaceMapper) {
        this.hasCustomNamespaceMapper = customNamespaceMapper;
    }

    @Override
    public void setEqualNamespaceResolvers(boolean equalNRs) {
        this.equalNamespaceResolvers = equalNRs;
    }

    @Override
    public void setLeafElementType(QName type2) {
        if (type2 != null) {
            this.setLeafElementType(new XPathQName(type2, this.isNamespaceAware()));
        }
    }

    @Override
    public void setLeafElementType(XPathQName type2) {
        this.leafElementType = type2;
    }

    @Override
    public void setMarshaller(MARSHALLER marshaller) {
        this.marshaller = marshaller;
        if (marshaller != null) {
            this.namespaceAware = ((Marshaller)marshaller).getNamespacePrefixMapper() != null ? true : ((Marshaller)marshaller).isApplicationXML();
        }
    }

    @Override
    public void setNamespaceResolver(NAMESPACE_RESOLVER namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    @Override
    public void setOwningObject(Object owningObject) {
        this.owningObject = owningObject;
    }

    @Override
    public void setSession(ABSTRACT_SESSION session) {
        this.session = session;
    }

    @Override
    public void setXOPPackage(boolean isXOPPackage) {
        this.isXOPPackage = isXOPPackage;
    }

    @Override
    public void writeXsiTypeAttribute(Descriptor descriptor, String typeUri, String typeLocal, String typePrefix, boolean addToNamespaceResolver) {
        if (typeLocal == null) {
            return;
        }
        Object typeValue = typeLocal;
        if (this.isNamespaceAware() && typeUri != null && !typeUri.equals("") && !typeUri.equals(((NamespaceResolver)this.namespaceResolver).getDefaultNamespaceURI())) {
            String prefix = ((NamespaceResolver)this.namespaceResolver).resolveNamespaceURI(typeUri);
            if (prefix != null && !prefix.equals("")) {
                typeValue = prefix + this.getNamespaceSeparator() + (String)typeValue;
            } else if (typeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                prefix = ((NamespaceResolver)this.namespaceResolver).generatePrefix("xsd");
                typeValue = prefix + this.getNamespaceSeparator() + (String)typeValue;
                this.namespaceDeclaration(prefix, typeUri);
            } else if (typePrefix != null && !typePrefix.equals("")) {
                String existingUri = ((NamespaceResolver)this.namespaceResolver).resolveNamespacePrefix(typePrefix);
                prefix = existingUri != null ? ((NamespaceResolver)this.namespaceResolver).generatePrefix() : typePrefix;
                typeValue = prefix + this.getNamespaceSeparator() + (String)typeValue;
                this.namespaceDeclaration(prefix, typeUri);
            } else {
                prefix = ((NamespaceResolver)this.namespaceResolver).generatePrefix();
                typeValue = prefix + this.getNamespaceSeparator() + (String)typeValue;
                this.namespaceDeclaration(prefix, typeUri);
            }
        }
        String xsiPrefix = null;
        if (this.isNamespaceAware() && (xsiPrefix = ((NamespaceResolver)this.namespaceResolver).resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance")) == null) {
            xsiPrefix = ((NamespaceResolver)this.namespaceResolver).generatePrefix("xsi");
            this.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            if (addToNamespaceResolver) {
                ((NamespaceResolver)this.namespaceResolver).put(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        if (((Marshaller)this.marshaller).isApplicationJSON() && descriptor != null && descriptor.getInheritancePolicyOrNull() != null && ((CoreInheritancePolicy)descriptor.getInheritancePolicyOrNull()).getClassIndicatorFieldName() != null) {
            if (XMLConstants.DEFAULT_XML_TYPE_ATTRIBUTE == ((CoreInheritancePolicy)descriptor.getInheritancePolicyOrNull()).getClassIndicatorField() && ((Marshaller)this.marshaller).getJsonTypeConfiguration().getJsonTypeAttributeName() != null) {
                this.attributeWithoutQName("http://www.w3.org/2001/XMLSchema-instance", ((Marshaller)this.marshaller).getJsonTypeConfiguration().getJsonTypeAttributeName(), xsiPrefix, (String)typeValue);
            } else {
                this.attributeWithoutQName("http://www.w3.org/2001/XMLSchema-instance", ((XMLField)((CoreInheritancePolicy)descriptor.getInheritancePolicyOrNull()).getClassIndicatorField()).getXPathFragment().getLocalName(), xsiPrefix, (String)typeValue);
            }
        } else {
            this.attributeWithoutQName("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix, (String)typeValue);
        }
    }

    @Override
    public void writeXsiTypeAttribute(Descriptor xmlDescriptor, XMLSchemaReference xmlRef, boolean addToNamespaceResolver) {
        QName contextAsQName = xmlRef.getSchemaContextAsQName();
        if (contextAsQName == null) {
            contextAsQName = xmlRef.getSchemaContextAsQName((NamespaceResolver)this.namespaceResolver);
        }
        if (contextAsQName != null) {
            this.writeXsiTypeAttribute(xmlDescriptor, contextAsQName.getNamespaceURI(), contextAsQName.getLocalPart(), null, addToNamespaceResolver);
        }
    }
}

