/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.BinaryOperatorNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class EqualsAssignmentNode
extends BinaryOperatorNode {
    @Override
    public void validate(ParseTreeContext context) {
        super.validate(context);
        this.validateTarget(this.left, context);
    }

    private void validateTarget(Node node, ParseTreeContext context) {
        if (node.isDotNode()) {
            AttributeNode attributeNode;
            String attribute;
            Node path;
            Object type2;
            TypeHelper typeHelper = context.getTypeHelper();
            if (typeHelper.isSingleValuedRelationship(type2 = (path = node.getLeft()).getType(), attribute = (attributeNode = (AttributeNode)node.getRight()).getAttributeName()) || typeHelper.isSimpleStateAttribute(type2, attribute)) {
                this.validateNavigation(path, context);
            } else {
                throw JPQLException.invalidSetClauseTarget(context.getQueryInfo(), attributeNode.getLine(), attributeNode.getColumn(), path.getAsString(), attribute);
            }
        }
    }

    private void validateNavigation(Node qualifier, ParseTreeContext context) {
        if (qualifier.isDotNode()) {
            TypeHelper typeHelper = context.getTypeHelper();
            Node left = qualifier.getLeft();
            AttributeNode attributeNode = (AttributeNode)qualifier.getRight();
            String attribute = attributeNode.getAttributeName();
            Object type2 = left.getType();
            if (!typeHelper.isEmbeddedAttribute(type2, attribute)) {
                throw JPQLException.invalidSetClauseNavigation(context.getQueryInfo(), attributeNode.getLine(), attributeNode.getColumn(), qualifier.getAsString(), attribute);
            }
            this.validateNavigation(left, context);
        }
    }
}

