/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.persistence.annotations.CacheIsolationType;
import org.eclipse.persistence.annotations.ExistenceType;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.descriptors.SingleTableMultitenantPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.descriptors.VirtualAttributeMethodInfo;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedIdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.IdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.TenantDiscriminatorColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConvertMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListener;
import org.eclipse.persistence.internal.jpa.metadata.mappings.AccessMethodsMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class MetadataDescriptor {
    private boolean m_isCascadePersist = false;
    private boolean m_hasCache = false;
    private boolean m_hasCacheInterceptor = false;
    private boolean m_hasDefaultRedirectors = false;
    private boolean m_hasChangeTracking = false;
    private boolean m_hasCustomizer = false;
    private boolean m_hasReadOnly = false;
    private boolean m_hasCopyPolicy = false;
    private boolean m_hasPrimaryKey = false;
    private boolean m_hasSerializedObjectPolicy = false;
    private AccessMethodsMetadata m_defaultAccessMethods = new AccessMethodsMetadata();
    private Boolean m_cacheable;
    private Boolean m_usesCascadedOptimisticLocking;
    private ClassAccessor m_classAccessor;
    private DatabaseTable m_primaryTable;
    private EmbeddedIdAccessor m_embeddedIdAccessor;
    private List<String> m_idAttributeNames = new ArrayList<String>();
    private List<String> m_orderByAttributeNames = new ArrayList<String>();
    private List<String> m_idOrderByAttributeNames = new ArrayList<String>();
    private List<MetadataDescriptor> m_embeddableDescriptors = new ArrayList<MetadataDescriptor>();
    private List<TenantDiscriminatorColumnMetadata> m_defaultTenantDiscriminatorColumns;
    private List<ObjectAccessor> m_derivedIdAccessors = new ArrayList<ObjectAccessor>();
    private Map<String, String> m_pkClassIDs;
    private Map<String, String> m_genericTypes;
    private Map<String, IdAccessor> m_idAccessors;
    private Map<String, DatabaseField> m_fields;
    private Map<String, MappingAccessor> m_mappingAccessors;
    private Map<DatabaseField, MappingAccessor> m_primaryKeyAccessors;
    private Map<String, PropertyMetadata> m_properties;
    private Map<DatabaseField, DatabaseField> m_pkJoinColumnAssociations;
    private Map<String, AttributeOverrideMetadata> m_attributeOverrides;
    private Map<String, AssociationOverrideMetadata> m_associationOverrides;
    private Map<String, Map<String, MetadataAccessor>> m_biDirectionalManyToManyAccessors;
    private Map<String, List<ConvertMetadata>> m_converts;
    private Map<String, List<ConvertMetadata>> m_mapKeyConverts;
    private MetadataClass m_pkClass;
    private MetadataClass m_javaClass;
    private MetadataDescriptor m_inheritanceRootDescriptor = null;
    private MetadataDescriptor m_inheritanceParentDescriptor = null;
    private MetadataDescriptor m_metamodelMappedSuperclassChildDescriptor;
    private ClassDescriptor m_descriptor;
    private String m_defaultAccess = null;
    private String m_defaultSchema = null;
    private String m_defaultCatalog = null;
    private String m_existenceChecking;

    public MetadataDescriptor(MetadataClass javaClass) {
        this.m_defaultTenantDiscriminatorColumns = new ArrayList<TenantDiscriminatorColumnMetadata>();
        this.m_pkClassIDs = new HashMap<String, String>();
        this.m_genericTypes = new HashMap<String, String>();
        this.m_mappingAccessors = new HashMap<String, MappingAccessor>();
        this.m_idAccessors = new HashMap<String, IdAccessor>();
        this.m_fields = new HashMap<String, DatabaseField>();
        this.m_primaryKeyAccessors = new HashMap<DatabaseField, MappingAccessor>();
        this.m_properties = new HashMap<String, PropertyMetadata>();
        this.m_pkJoinColumnAssociations = new HashMap<DatabaseField, DatabaseField>();
        this.m_attributeOverrides = new HashMap<String, AttributeOverrideMetadata>();
        this.m_associationOverrides = new HashMap<String, AssociationOverrideMetadata>();
        this.m_biDirectionalManyToManyAccessors = new HashMap<String, Map<String, MetadataAccessor>>();
        this.m_converts = new HashMap<String, List<ConvertMetadata>>();
        this.m_mapKeyConverts = new HashMap<String, List<ConvertMetadata>>();
        this.m_descriptor = new RelationalDescriptor();
        this.m_descriptor.setAlias("");
        this.m_descriptor.getQueryManager().checkDatabaseForDoesExist();
        this.setJavaClass(javaClass);
    }

    public MetadataDescriptor(MetadataClass javaClass, ClassAccessor classAccessor) {
        this(javaClass);
        this.m_classAccessor = classAccessor;
    }

    public void addAssociationOverride(AssociationOverrideMetadata associationOverride) {
        this.m_associationOverrides.put(associationOverride.getName(), associationOverride);
    }

    public void addAttributeOverride(AttributeOverrideMetadata attributeOverride) {
        this.m_attributeOverrides.put(attributeOverride.getName(), attributeOverride);
    }

    public void addConvert(String attributeName, ConvertMetadata convert) {
        if (convert.isForMapKey()) {
            this.addMapKeyConvert(attributeName, convert);
        } else {
            if (!this.m_converts.containsKey(attributeName)) {
                this.m_converts.put(attributeName, new ArrayList());
            }
            this.m_converts.get(attributeName).add(convert);
        }
    }

    public void addDefaultEventListener(DescriptorEventListener listener) {
        this.m_descriptor.getEventManager().addDefaultEventListener(listener);
    }

    public void addEmbeddableDescriptor(MetadataDescriptor embeddableDescriptor) {
        this.m_embeddableDescriptors.add(embeddableDescriptor);
    }

    public void addEntityListenerEventListener(DescriptorEventListener listener) {
        this.m_descriptor.getEventManager().addEntityListenerEventListener(listener);
    }

    public void addField(DatabaseField field) {
        this.m_fields.put(field.getNameForComparisons(), field);
    }

    public void addFieldForInsert(DatabaseField field) {
        this.getReturningPolicy().addFieldForInsert(field);
    }

    public void addFieldForInsertReturnOnly(DatabaseField field) {
        this.getReturningPolicy().addFieldForInsertReturnOnly(field);
    }

    public void addFieldForUpdate(DatabaseField field) {
        this.getReturningPolicy().addFieldForUpdate(field);
    }

    public void addForeignKeyFieldForMultipleTable(DatabaseField fkField, DatabaseField pkField) {
        this.m_descriptor.addForeignKeyFieldForMultipleTable(fkField, pkField);
        this.m_pkJoinColumnAssociations.put(fkField, pkField);
    }

    public void addGenericType(String genericName, String type2) {
        this.m_genericTypes.put(genericName, type2);
    }

    public void addIdAttributeName(String idAttributeName) {
        this.m_idAttributeNames.add(idAttributeName);
    }

    public void addMapKeyConvert(String attributeName, ConvertMetadata convert) {
        if (!this.m_mapKeyConverts.containsKey(attributeName)) {
            this.m_mapKeyConverts.put(attributeName, new ArrayList());
        }
        this.m_mapKeyConverts.get(attributeName).add(convert);
    }

    public void addMappingAccessor(MappingAccessor accessor) {
        if (accessor.isRelationship() && ((RelationshipAccessor)accessor).isValueHolderInterface()) {
            return;
        }
        if (this.m_mappingAccessors.containsKey(accessor.getAttributeName())) {
            MappingAccessor existingAccessor = this.m_mappingAccessors.get(accessor.getAttributeName());
            String existingAccessType = existingAccessor.usesPropertyAccess() ? "PROPERTY" : "FIELD";
            String accessType = accessor.usesPropertyAccess() ? "PROPERTY" : "FIELD";
            this.getLogger().logWarningMessage("metadata_warning_inverse_access_type_mapping_override", accessor.getJavaClass().getName(), existingAccessor.getAnnotatedElementName(), existingAccessType, accessor.getAnnotatedElementName(), accessType);
        }
        this.m_mappingAccessors.put(accessor.getAttributeName(), accessor);
        if (accessor.isId()) {
            this.m_idAccessors.put(accessor.getAttributeName(), (IdAccessor)accessor);
        }
        if (accessor.isEmbeddedId() && this.hasEmbeddedId()) {
            throw ValidationException.multipleEmbeddedIdAnnotationsFound(this.getJavaClass(), accessor.getAttributeName(), this.getEmbeddedIdAttributeName());
        }
        if (accessor.isEmbeddedId()) {
            this.setEmbeddedIdAccessor((EmbeddedIdAccessor)accessor);
        }
    }

    public void addPKClassId(String attributeName, String type2) {
        this.m_pkClassIDs.put(attributeName, type2);
    }

    public void addProperty(PropertyMetadata property) {
        if (property.shouldOverride(this.m_properties.get(property.getName()))) {
            this.m_properties.put(property.getName(), property);
            this.m_descriptor.addUnconvertedProperty(property.getName(), property.getValue(), property.getJavaClassName(property.getValueType()));
        }
    }

    public void addPrimaryKeyField(DatabaseField field) {
        if (!field.hasTableName()) {
            field.setTable(this.getPrimaryTable());
        }
        this.m_descriptor.addPrimaryKeyField(field);
        this.addField(field);
    }

    public void addPrimaryKeyField(DatabaseField field, MappingAccessor accessor) {
        this.addPrimaryKeyField(field);
        this.m_primaryKeyAccessors.put(field, accessor);
    }

    public void addRelationshipAccessor(RelationshipAccessor accessor) {
        this.getProject().addRelationshipAccessor(accessor);
        if (accessor.isManyToMany() && accessor.hasMappedBy()) {
            String referenceClassName = accessor.getReferenceClassName();
            if (!this.m_biDirectionalManyToManyAccessors.containsKey(referenceClassName)) {
                this.m_biDirectionalManyToManyAccessors.put(referenceClassName, new HashMap());
            }
            this.m_biDirectionalManyToManyAccessors.get(referenceClassName).put(accessor.getMappedBy(), accessor);
        }
    }

    public void addTable(DatabaseTable table) {
        this.m_descriptor.addTable(table);
    }

    public void clearMappingAccessors() {
        this.m_mappingAccessors.clear();
        this.m_embeddedIdAccessor = null;
    }

    public boolean excludeSuperclassListeners() {
        return this.m_descriptor.getEventManager().excludeSuperclassListeners();
    }

    public String getAlias() {
        return this.m_descriptor.getAlias();
    }

    public AssociationOverrideMetadata getAssociationOverrideFor(String attributeName) {
        return this.m_associationOverrides.get(attributeName);
    }

    public Collection<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides.values();
    }

    public AttributeOverrideMetadata getAttributeOverrideFor(String attributeName) {
        return this.m_attributeOverrides.get(attributeName);
    }

    public Collection<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides.values();
    }

    public ClassAccessor getClassAccessor() {
        return this.m_classAccessor;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.m_descriptor;
    }

    public CMPPolicy getCMPPolicy() {
        return this.m_descriptor.getCMPPolicy();
    }

    public List<ConvertMetadata> getConverts(String attributeName) {
        return this.m_converts.get(attributeName);
    }

    public String getDefaultAccess() {
        return this.m_defaultAccess;
    }

    public AccessMethodsMetadata getDefaultAccessMethods() {
        return this.m_defaultAccessMethods;
    }

    public String getDefaultCatalog() {
        return this.m_defaultCatalog;
    }

    public String getDefaultSchema() {
        return this.m_defaultSchema;
    }

    public List<TenantDiscriminatorColumnMetadata> getDefaultTenantDiscriminatorColumns() {
        return this.m_defaultTenantDiscriminatorColumns;
    }

    public String getDefaultTableName() {
        String defaultTableName;
        String string = defaultTableName = this.getProject().useDelimitedIdentifier() ? this.getAlias() : this.getAlias().toUpperCase(Locale.ROOT);
        if (this.isInheritanceSubclass() && this.getInheritanceRootDescriptor().usesSingleTableInheritanceStrategy()) {
            defaultTableName = this.getInheritanceRootDescriptor().getPrimaryTableName();
        }
        return defaultTableName;
    }

    public List<ObjectAccessor> getDerivedIdAccessors() {
        return this.m_derivedIdAccessors;
    }

    public EmbeddedIdAccessor getEmbeddedIdAccessor() {
        return this.m_embeddedIdAccessor;
    }

    public String getEmbeddedIdAttributeName() {
        return this.m_embeddedIdAccessor.getAttributeName();
    }

    public EntityAccessor getEntityAccessor() {
        return (EntityAccessor)this.m_classAccessor;
    }

    public DatabaseField getField(String fieldName) {
        if (!this.m_fields.containsKey(fieldName) && this.isInheritanceSubclass()) {
            return this.getInheritanceRootDescriptor().getField(fieldName);
        }
        return this.m_fields.get(fieldName);
    }

    public String getGenericType(String genericName) {
        return this.m_genericTypes.get(genericName);
    }

    public Map getGenericTypes() {
        return this.m_genericTypes;
    }

    public Map<String, IdAccessor> getIdAccessors() {
        return this.m_idAccessors;
    }

    public String getIdAttributeName() {
        if (this.getIdAttributeNames().isEmpty()) {
            if (this.isInheritanceSubclass()) {
                return this.getInheritanceRootDescriptor().getIdAttributeName();
            }
            return "";
        }
        return this.getIdAttributeNames().get(0);
    }

    public List<String> getIdAttributeNames() {
        return this.m_idAttributeNames;
    }

    public List<String> getIdOrderByAttributeNames() {
        if (this.m_idOrderByAttributeNames.isEmpty()) {
            this.m_idOrderByAttributeNames = this.m_idAttributeNames.isEmpty() ? (this.isInheritanceSubclass() ? this.getInheritanceRootDescriptor().getIdAttributeNames() : this.getMappingAccessor(this.getEmbeddedIdAttributeName()).getReferenceDescriptor().getOrderByAttributeNames()) : this.m_idAttributeNames;
        }
        return this.m_idOrderByAttributeNames;
    }

    public MetadataAccessor getBiDirectionalManyToManyAccessor(String className, String attributeName) {
        return this.m_biDirectionalManyToManyAccessors.get(className).get(attributeName);
    }

    public MetadataDescriptor getInheritanceParentDescriptor() {
        return this.m_inheritanceParentDescriptor;
    }

    public MetadataDescriptor getInheritanceRootDescriptor() {
        return this.m_inheritanceRootDescriptor;
    }

    public MetadataClass getJavaClass() {
        return this.m_javaClass;
    }

    public String getJavaClassName() {
        return this.m_descriptor.getJavaClassName();
    }

    public MetadataLogger getLogger() {
        return this.getProject().getLogger();
    }

    public List<ConvertMetadata> getMapKeyConverts(String attributeName) {
        return this.m_mapKeyConverts.get(attributeName);
    }

    public MappingAccessor getMappingAccessor(String fieldOrPropertyName) {
        return this.getMappingAccessor(fieldOrPropertyName, true);
    }

    protected MappingAccessor getMappingAccessor(String fieldOrPropertyName, boolean checkForMethodName) {
        MappingAccessor accessor = this.m_mappingAccessors.get(fieldOrPropertyName);
        if (accessor == null) {
            if (checkForMethodName) {
                accessor = this.m_mappingAccessors.get(Helper.getAttributeNameFromMethodName(fieldOrPropertyName));
            }
            if (accessor == null && this.isInheritanceSubclass() && !this.usesTablePerClassInheritanceStrategy()) {
                accessor = this.getInheritanceParentDescriptor().getMappingAccessor(fieldOrPropertyName, checkForMethodName);
            }
        }
        if (accessor == null) {
            int idx = fieldOrPropertyName.indexOf(46);
            if (idx > -1) {
                String attributeName = fieldOrPropertyName.substring(0, idx);
                String subAttributeName = fieldOrPropertyName.substring(idx + 1);
                MappingAccessor embeddedAccessor = this.m_mappingAccessors.get(attributeName);
                if (embeddedAccessor != null) {
                    accessor = embeddedAccessor.getReferenceDescriptor().getMappingAccessor(subAttributeName, checkForMethodName);
                }
            }
            if (accessor == null) {
                for (MetadataDescriptor embeddableDescriptor : this.m_embeddableDescriptors) {
                    String subAttributeName = fieldOrPropertyName;
                    if (subAttributeName.contains(".")) {
                        subAttributeName = subAttributeName.substring(fieldOrPropertyName.indexOf(46) + 1);
                    }
                    if ((accessor = embeddableDescriptor.getMappingAccessor(fieldOrPropertyName, checkForMethodName)) == null) continue;
                    break;
                }
            }
        }
        return accessor;
    }

    public Collection<MappingAccessor> getMappingAccessors() {
        return this.m_mappingAccessors.values();
    }

    public DatabaseMapping getMappingForAttributeName(String attributeName) {
        return this.getMappingAccessor(attributeName).getMapping();
    }

    public List<DatabaseMapping> getMappings() {
        return this.m_descriptor.getMappings();
    }

    public MetadataDescriptor getMetamodelMappedSuperclassChildDescriptor() {
        return this.m_metamodelMappedSuperclassChildDescriptor;
    }

    public List<String> getOrderByAttributeNames() {
        if (this.m_orderByAttributeNames.isEmpty()) {
            for (DatabaseMapping mapping : this.getMappings()) {
                if (!mapping.isDirectToFieldMapping()) continue;
                this.m_orderByAttributeNames.add(mapping.getAttributeName());
            }
        }
        return this.m_orderByAttributeNames;
    }

    public MetadataClass getPKClass() {
        return this.m_pkClass;
    }

    public Map<String, String> getPKClassIDs() {
        return this.m_pkClassIDs;
    }

    public String getPKClassName() {
        String pkClassName = null;
        if (this.m_descriptor.hasCMPPolicy()) {
            pkClassName = ((CMP3Policy)this.m_descriptor.getCMPPolicy()).getPKClassName();
        }
        return pkClassName;
    }

    public MappingAccessor getPrimaryKeyAccessorForField(DatabaseField field) {
        return this.m_primaryKeyAccessors.get(field);
    }

    public DatabaseField getPrimaryKeyField() {
        return this.getPrimaryKeyFields().iterator().next();
    }

    public String getPrimaryKeyFieldName() {
        return this.getPrimaryKeyField().getName();
    }

    public List<DatabaseField> getPrimaryKeyFields() {
        List<DatabaseField> primaryKeyFields = this.m_descriptor.getPrimaryKeyFields();
        if (primaryKeyFields.isEmpty() && this.isInheritanceSubclass() && !this.usesTablePerClassInheritanceStrategy()) {
            primaryKeyFields = this.getInheritanceRootDescriptor().getPrimaryKeyFields();
        }
        return primaryKeyFields;
    }

    public DatabaseField getPrimaryKeyJoinColumnAssociation(DatabaseField foreignKey) {
        DatabaseField primaryKey = this.m_pkJoinColumnAssociations.get(foreignKey);
        if (primaryKey == null || primaryKey.getName() == null || !this.isInheritanceSubclass()) {
            return foreignKey;
        }
        return this.getInheritanceParentDescriptor().getPrimaryKeyJoinColumnAssociation(primaryKey);
    }

    public DatabaseField getPrimaryKeyJoinColumnAssociationField(DatabaseField primaryKeyField) {
        if (!this.m_pkJoinColumnAssociations.isEmpty()) {
            return this.m_pkJoinColumnAssociations.keySet().iterator().next();
        }
        return primaryKeyField;
    }

    public DatabaseTable getPrimaryKeyTable() {
        return this.getPrimaryKeyField().getTable();
    }

    public DatabaseTable getPrimaryTable() {
        if (this.m_primaryTable == null && this.isInheritanceSubclass()) {
            return this.getInheritanceRootDescriptor().getPrimaryTable();
        }
        if (this.m_descriptor.isAggregateDescriptor()) {
            return new DatabaseTable();
        }
        return this.m_primaryTable;
    }

    public String getPrimaryTableName() {
        return this.getPrimaryTable().getName();
    }

    public MetadataProject getProject() {
        return this.getClassAccessor().getProject();
    }

    protected ReturningPolicy getReturningPolicy() {
        if (!this.m_descriptor.hasReturningPolicy()) {
            this.m_descriptor.setReturningPolicy(new ReturningPolicy());
        }
        return this.m_descriptor.getReturningPolicy();
    }

    public DatabaseField getSequenceNumberField() {
        return this.m_descriptor.getSequenceNumberField();
    }

    public Map<String, List<DatabaseField>> getSingleTableMultitenantFields() {
        return ((SingleTableMultitenantPolicy)this.m_descriptor.getMultitenantPolicy()).getTenantDiscriminatorFieldsKeyedOnContext();
    }

    public boolean hasAdditionalCriteria() {
        return this.m_descriptor.getQueryManager().hasAdditionalCriteria();
    }

    public boolean hasAssociationOverrideFor(String attributeName) {
        return this.m_associationOverrides.containsKey(attributeName);
    }

    public boolean hasAttributeOverrideFor(String attributeName) {
        return this.m_attributeOverrides.containsKey(attributeName);
    }

    public boolean hasCompositePrimaryKey() {
        return this.getPrimaryKeyFields().size() > 1 || this.getPKClass() != null;
    }

    public boolean hasEmbeddedId() {
        return this.m_embeddedIdAccessor != null;
    }

    public boolean hasExistenceChecking() {
        return this.m_existenceChecking != null;
    }

    public boolean hasBiDirectionalManyToManyAccessorFor(String className, String attributeName) {
        if (this.m_biDirectionalManyToManyAccessors.containsKey(className)) {
            return this.m_biDirectionalManyToManyAccessors.get(className).containsKey(attributeName);
        }
        return false;
    }

    public boolean hasCache() {
        return this.m_hasCache;
    }

    public boolean hasCacheable() {
        return this.m_cacheable != null;
    }

    public boolean hasCacheInterceptor() {
        return this.m_hasCacheInterceptor;
    }

    public boolean hasDefaultRedirectors() {
        return this.m_hasDefaultRedirectors;
    }

    public boolean hasChangeTracking() {
        return this.m_hasChangeTracking;
    }

    public boolean hasCopyPolicy() {
        return this.m_hasCopyPolicy;
    }

    public boolean hasConverts(String attributeName) {
        return this.m_converts.containsKey(attributeName);
    }

    public boolean hasCustomizer() {
        return this.m_hasCustomizer;
    }

    public boolean hasIdAccessor() {
        return !this.m_idAccessors.isEmpty();
    }

    public boolean hasMapKeyConverts(String attributeName) {
        return this.m_mapKeyConverts.containsKey(attributeName);
    }

    public boolean hasMappingAccessor(String attributeName) {
        return this.getMappingAccessor(attributeName, false) != null;
    }

    public boolean hasMappingForAttributeName(String attributeName) {
        return this.m_descriptor.getMappingForAttributeName(attributeName) != null;
    }

    public boolean hasMultitenant() {
        return this.m_descriptor.hasMultitenantPolicy();
    }

    public boolean hasPKClass() {
        return this.m_pkClass != null;
    }

    public boolean hasPrimaryKey() {
        return this.m_hasPrimaryKey;
    }

    public boolean hasPrimaryKeyFields() {
        return !this.m_descriptor.getPrimaryKeyFields().isEmpty();
    }

    public boolean hasReadOnly() {
        return this.m_hasReadOnly;
    }

    public boolean hasSingleTableMultitenant() {
        return this.hasMultitenant() && this.m_descriptor.getMultitenantPolicy().isSingleTableMultitenantPolicy();
    }

    public boolean m_hasSerializedObjectPolicy() {
        return this.m_hasSerializedObjectPolicy;
    }

    public boolean isCacheableTrue() {
        if (this.m_cacheable != null) {
            return this.m_cacheable;
        }
        if (this.isInheritanceSubclass()) {
            return this.getInheritanceParentDescriptor().isCacheableTrue();
        }
        return false;
    }

    public boolean isCacheableFalse() {
        if (this.m_cacheable != null) {
            return this.m_cacheable == false;
        }
        if (this.isInheritanceSubclass()) {
            return this.getInheritanceParentDescriptor().isCacheableFalse();
        }
        return false;
    }

    public boolean isCascadePersist() {
        return this.m_isCascadePersist;
    }

    public boolean isEmbeddable() {
        return this.m_descriptor.isAggregateDescriptor();
    }

    public boolean isEmbeddableCollection() {
        return this.m_descriptor.isAggregateCollectionDescriptor();
    }

    public boolean isInheritanceSubclass() {
        return this.m_inheritanceParentDescriptor != null;
    }

    public boolean isMappedSuperclass() {
        return this.getClassAccessor().isMappedSuperclass();
    }

    public boolean pkClassWasNotValidated() {
        return !this.m_pkClassIDs.isEmpty();
    }

    public void processMappingAccessors() {
        for (MappingAccessor accessor : this.m_mappingAccessors.values()) {
            if (accessor.isProcessed()) continue;
            if (accessor.isMappedKeyMapAccessor()) {
                MappedKeyMapAccessor mapAccessor = (MappedKeyMapAccessor)((Object)accessor);
                EmbeddableAccessor mapKeyEmbeddableAccessor = this.getProject().getEmbeddableAccessor(mapAccessor.getMapKeyClass());
                if (mapKeyEmbeddableAccessor != null && !mapKeyEmbeddableAccessor.isProcessed()) {
                    mapKeyEmbeddableAccessor.process();
                }
            }
            if (accessor.isDirectEmbeddableCollection() || accessor.isEmbedded()) {
                EmbeddableAccessor embeddableAccessor = this.getProject().getEmbeddableAccessor(accessor.getReferenceClass());
                if (embeddableAccessor == null) {
                    throw ValidationException.invalidEmbeddedAttribute(this.getJavaClass(), accessor.getAttributeName(), accessor.getReferenceClass());
                }
                if (!embeddableAccessor.isProcessed()) {
                    embeddableAccessor.process();
                }
                this.addEmbeddableDescriptor(embeddableAccessor.getDescriptor());
                if (accessor.isEmbeddedId() || accessor.isDerivedIdClass()) {
                    accessor.process();
                    continue;
                }
                this.getProject().addEmbeddableMappingAccessor(accessor);
                continue;
            }
            if (accessor.isDirectCollection()) {
                this.getProject().addDirectCollectionAccessor(accessor);
                continue;
            }
            if (accessor.isRelationship()) {
                if (accessor.derivesId()) {
                    this.m_derivedIdAccessors.add((ObjectAccessor)accessor);
                    this.getProject().addAccessorWithDerivedId(this.m_classAccessor);
                    continue;
                }
                this.addRelationshipAccessor((RelationshipAccessor)accessor);
                continue;
            }
            accessor.process();
        }
    }

    public void removePrimaryKeyField(DatabaseField field) {
        this.m_descriptor.getPrimaryKeyFields().remove(field);
        this.m_primaryKeyAccessors.remove(field);
    }

    public void setAccessTypeOnClassDescriptor(String accessType) {
        if (accessType.equals("PROPERTY")) {
            this.m_descriptor.usePropertyAccessForWeaving();
        }
    }

    public void setAlias(String alias) {
        this.m_descriptor.setAlias(alias);
    }

    public Boolean getCacheable() {
        return this.m_cacheable;
    }

    public void setCacheable(Boolean cacheable) {
        this.m_cacheable = cacheable;
    }

    public void setCacheableInDescriptor() {
        this.m_descriptor.setCacheable(this.m_cacheable);
    }

    public void setClassAccessor(ClassAccessor accessor) {
        this.m_classAccessor = accessor;
    }

    public void setDefaultAccess(String defaultAccess) {
        this.m_defaultAccess = defaultAccess;
    }

    public void setDefaultAccessMethods(AccessMethodsMetadata accessMethods) {
        this.m_defaultAccessMethods = accessMethods;
        this.getClassDescriptor().getVirtualAttributeMethods().add(new VirtualAttributeMethodInfo(accessMethods.getGetMethodName(), accessMethods.getSetMethodName()));
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.m_defaultCatalog = defaultCatalog;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.m_defaultSchema = defaultSchema;
    }

    public void setDefaultTenantDiscriminatorColumns(List<TenantDiscriminatorColumnMetadata> defaultTenantDiscriminatorColumns) {
        this.m_defaultTenantDiscriminatorColumns = defaultTenantDiscriminatorColumns;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.m_descriptor = descriptor;
    }

    public void setEmbeddedIdAccessor(EmbeddedIdAccessor embeddedIdAccessor) {
        this.m_embeddedIdAccessor = embeddedIdAccessor;
    }

    public void setEntityEventListener(EntityListener listener) {
        this.m_descriptor.getEventManager().setEntityEventListener(listener);
    }

    public void setExcludeDefaultListeners(boolean excludeDefaultListeners) {
        this.m_descriptor.getEventManager().setExcludeDefaultListeners(excludeDefaultListeners);
    }

    public void setExcludeSuperclassListeners(boolean excludeSuperclassListeners) {
        this.m_descriptor.getEventManager().setExcludeSuperclassListeners(excludeSuperclassListeners);
    }

    public void setExistenceChecking(String existenceChecking) {
        this.m_existenceChecking = existenceChecking;
        if (existenceChecking.equals(ExistenceType.CHECK_CACHE.name())) {
            this.m_descriptor.getQueryManager().checkCacheForDoesExist();
        } else if (existenceChecking.equals(ExistenceType.CHECK_DATABASE.name())) {
            this.m_descriptor.getQueryManager().checkDatabaseForDoesExist();
        } else if (existenceChecking.equals(ExistenceType.ASSUME_EXISTENCE.name())) {
            this.m_descriptor.getQueryManager().assumeExistenceForDoesExist();
        } else if (existenceChecking.equals(ExistenceType.ASSUME_NON_EXISTENCE.name())) {
            this.m_descriptor.getQueryManager().assumeNonExistenceForDoesExist();
        }
    }

    public void setHasCache() {
        this.m_hasCache = true;
    }

    public void setHasCacheInterceptor() {
        this.m_hasCacheInterceptor = true;
    }

    public void setHasCustomizer() {
        this.m_hasCustomizer = true;
    }

    public void setHasDefaultRedirectors() {
        this.m_hasDefaultRedirectors = true;
    }

    public void setHasPrimaryKey() {
        this.m_hasPrimaryKey = true;
    }

    public void setHasChangeTracking() {
        this.m_hasChangeTracking = true;
    }

    public void setHasCopyPolicy() {
        this.m_hasCopyPolicy = true;
    }

    public void setHasSerializedObjectPolicy() {
        this.m_hasSerializedObjectPolicy = true;
    }

    public void setInheritanceParentDescriptor(MetadataDescriptor inheritanceParentDescriptor) {
        this.m_inheritanceParentDescriptor = inheritanceParentDescriptor;
    }

    public void setInheritanceRootDescriptor(MetadataDescriptor inheritanceRootDescriptor) {
        this.m_inheritanceRootDescriptor = inheritanceRootDescriptor;
    }

    public void setIsCascadePersist(boolean isCascadePersist) {
        this.m_isCascadePersist = isCascadePersist;
    }

    public void setIsEmbeddable() {
        this.m_descriptor.descriptorIsAggregate();
    }

    public void setJavaClass(MetadataClass javaClass) {
        this.m_javaClass = javaClass;
        this.m_descriptor.setJavaClassName(javaClass.getName());
        if (javaClass.isInterface()) {
            this.m_descriptor.setJavaInterfaceName(javaClass.getName());
        }
    }

    public void setMetamodelMappedSuperclassChildDescriptor(MetadataDescriptor childDescriptor) {
        this.m_metamodelMappedSuperclassChildDescriptor = childDescriptor;
    }

    public void setOptimisticLockingPolicy(OptimisticLockingPolicy policy) {
        this.m_descriptor.setOptimisticLockingPolicy(policy);
    }

    public void setPKClass(MetadataClass pkClass) {
        this.m_pkClass = pkClass;
        CMP3Policy policy = new CMP3Policy();
        policy.setPrimaryKeyClassName(pkClass.getName());
        this.m_descriptor.setCMPPolicy(policy);
    }

    public void setPrimaryTable(DatabaseTable primaryTable) {
        this.addTable(primaryTable);
        this.m_primaryTable = primaryTable;
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.m_descriptor.setReadOnly();
        }
        this.m_hasReadOnly = true;
    }

    public void setSequenceNumberField(DatabaseField field) {
        this.m_descriptor.setSequenceNumberField(field);
    }

    public void setSequenceNumberName(String name) {
        this.m_descriptor.setSequenceNumberName(name);
    }

    public void setUsesCascadedOptimisticLocking(Boolean usesCascadedOptimisticLocking) {
        this.m_usesCascadedOptimisticLocking = usesCascadedOptimisticLocking;
    }

    public String toString() {
        return this.getJavaClassName();
    }

    public void useNoCache() {
        this.m_descriptor.setCacheIsolation(CacheIsolationType.ISOLATED);
    }

    public boolean usesCascadedOptimisticLocking() {
        return this.m_usesCascadedOptimisticLocking != null && this.m_usesCascadedOptimisticLocking != false;
    }

    public boolean usesDefaultPropertyAccess() {
        return this.m_defaultAccess.equals("PROPERTY");
    }

    public boolean usesOptimisticLocking() {
        return this.m_descriptor.usesOptimisticLocking();
    }

    public boolean usesSingleTableInheritanceStrategy() {
        return ((EntityAccessor)this.m_classAccessor).getInheritance().usesSingleTableStrategy();
    }

    public boolean usesTablePerClassInheritanceStrategy() {
        return this.m_descriptor.hasTablePerClassPolicy();
    }

    public boolean usesVersionColumnOptimisticLocking() {
        return this.m_usesCascadedOptimisticLocking != null;
    }

    public void validateDerivedPKClassId(String attributeName, String expectedType, String referenceClassName) {
        if (this.m_pkClassIDs.containsKey(attributeName)) {
            String actualType = this.m_pkClassIDs.get(attributeName);
            if (actualType.equals(expectedType)) {
                this.m_pkClassIDs.remove(attributeName);
            } else {
                throw ValidationException.invalidDerivedCompositePKAttribute(referenceClassName, this.getPKClassName(), attributeName, expectedType, actualType);
            }
        }
    }

    public void validatePKClassId(String attributeName, String actualType) {
        if (this.m_pkClassIDs.containsKey(attributeName)) {
            String expectedType = this.m_pkClassIDs.get(attributeName);
            if (expectedType.equals(actualType)) {
                this.m_pkClassIDs.remove(attributeName);
            } else {
                throw ValidationException.invalidCompositePKAttribute(this.getJavaClassName(), this.getPKClassName(), attributeName, expectedType, actualType);
            }
        }
    }
}

