/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import jakarta.persistence.PersistenceConfiguration;
import jakarta.persistence.PersistenceUnitTransactionType;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitProperty;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;

public class SEPersistenceUnitInfo
implements PersistenceUnitInfo {
    private String schemaVersion;
    protected SharedCacheMode cacheMode;
    protected ValidationMode validationMode;
    protected String persistenceUnitName;
    protected String persistenceProviderClassName;
    protected DataSource jtaDataSource;
    protected DataSource nonJtaDataSource;
    protected PersistenceUnitTransactionType persistenceUnitTransactionType;
    protected List<String> mappingFiles;
    private List<String> qualifierAnnNames;
    private String scopeAnnName;
    private final Collection<String> jarFiles = new ArrayList<String>();
    protected List<URL> jarFileUrls;
    protected List<String> managedClassNames;
    protected URL persistenceUnitRootUrl;
    private String configHash;
    protected boolean excludeUnlistedClasses = true;
    protected List<SEPersistenceUnitProperty> persistenceUnitProperties = new ArrayList<SEPersistenceUnitProperty>();
    protected Properties properties;
    protected ClassLoader tempClassLoader;
    protected ClassLoader realClassLoader;

    public SEPersistenceUnitInfo() {
        this.mappingFiles = new ArrayList<String>();
        this.managedClassNames = new ArrayList<String>();
        this.properties = new Properties();
        this.persistenceUnitTransactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        this.cacheMode = SharedCacheMode.DISABLE_SELECTIVE;
        this.validationMode = ValidationMode.AUTO;
        this.qualifierAnnNames = new ArrayList<String>();
    }

    public SEPersistenceUnitInfo(PersistenceConfiguration configuration, URL rootURL) {
        this.persistenceUnitName = configuration.name();
        this.persistenceProviderClassName = configuration.provider();
        if (configuration.jtaDataSource() != null && !configuration.jtaDataSource().isEmpty()) {
            this.jtaDataSource = new DataSourceImpl(configuration.jtaDataSource(), null, null, null);
        }
        if (configuration.nonJtaDataSource() != null && !configuration.nonJtaDataSource().isEmpty()) {
            this.nonJtaDataSource = new DataSourceImpl(configuration.nonJtaDataSource(), null, null, null);
        }
        this.cacheMode = configuration.sharedCacheMode();
        this.validationMode = configuration.validationMode();
        this.persistenceUnitTransactionType = configuration.transactionType();
        this.mappingFiles = configuration.mappingFiles();
        this.managedClassNames = configuration.managedClasses().stream().map(Class::getName).toList();
        this.properties = new Properties();
        this.properties.putAll(configuration.properties());
        this.realClassLoader = this.properties.contains("eclipselink.classloader") ? (ClassLoader)this.properties.get("eclipselink.classloader") : Thread.currentThread().getContextClassLoader();
        this.persistenceUnitRootUrl = rootURL;
        this.configHash = Integer.toString(SEPersistenceUnitInfo.persistenceConfigurationHashCode(configuration));
    }

    private static int persistenceConfigurationHashCode(PersistenceConfiguration configuration) {
        return Objects.hash(new Object[]{configuration.name(), configuration.provider(), configuration.jtaDataSource(), configuration.nonJtaDataSource(), configuration.sharedCacheMode(), configuration.validationMode(), configuration.transactionType(), configuration.managedClasses(), configuration.mappingFiles(), configuration.properties()});
    }

    @Override
    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public List<SEPersistenceUnitProperty> getPersistenceUnitProperties() {
        return this.persistenceUnitProperties;
    }

    public void setPersistenceUnitProperties(List<SEPersistenceUnitProperty> persistenceUnitProperties) {
        this.persistenceUnitProperties = persistenceUnitProperties;
    }

    @Override
    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public void setScopeAnnotationName(String scopeAnnName) {
        this.scopeAnnName = scopeAnnName;
    }

    @Override
    public String getScopeAnnotationName() {
        return this.scopeAnnName;
    }

    public void setQualifierAnnotationNames(List<String> qualifierAnnNames) {
        this.qualifierAnnNames = qualifierAnnNames;
    }

    @Override
    public List<String> getQualifierAnnotationNames() {
        return this.qualifierAnnNames;
    }

    public void setPersistenceProviderClassName(String persistenceProviderClassName) {
        this.persistenceProviderClassName = persistenceProviderClassName;
    }

    @Override
    @Deprecated
    public jakarta.persistence.spi.PersistenceUnitTransactionType getTransactionType() {
        return switch (this.persistenceUnitTransactionType) {
            default -> throw new IncompatibleClassChangeError();
            case PersistenceUnitTransactionType.JTA -> jakarta.persistence.spi.PersistenceUnitTransactionType.JTA;
            case PersistenceUnitTransactionType.RESOURCE_LOCAL -> jakarta.persistence.spi.PersistenceUnitTransactionType.RESOURCE_LOCAL;
        };
    }

    @Deprecated
    public void setTransactionType(jakarta.persistence.spi.PersistenceUnitTransactionType transactionType) {
        this.persistenceUnitTransactionType = switch (transactionType) {
            default -> throw new IncompatibleClassChangeError();
            case jakarta.persistence.spi.PersistenceUnitTransactionType.JTA -> PersistenceUnitTransactionType.JTA;
            case jakarta.persistence.spi.PersistenceUnitTransactionType.RESOURCE_LOCAL -> PersistenceUnitTransactionType.RESOURCE_LOCAL;
        };
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.persistenceUnitTransactionType = transactionType;
    }

    @Override
    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public void setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
    }

    @Override
    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public void setNonJtaDataSource(DataSource nonJtaDataSource) {
        this.nonJtaDataSource = nonJtaDataSource;
    }

    @Override
    public List<String> getMappingFileNames() {
        return this.mappingFiles;
    }

    public void setMappingFileNames(List<String> mappingFiles) {
        this.mappingFiles = mappingFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<URL> getJarFileUrls() {
        if (this.jarFileUrls == null) {
            ArrayList<URL> jarFileUrls = new ArrayList<URL>(this.jarFiles.size());
            for (String jarFile : this.jarFiles) {
                try {
                    URL jarFileURL = new URL(this.persistenceUnitRootUrl, jarFile);
                    jarFileUrls.add(jarFileURL);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            SEPersistenceUnitInfo sEPersistenceUnitInfo = this;
            synchronized (sEPersistenceUnitInfo) {
                this.jarFileUrls = jarFileUrls;
            }
        }
        return Collections.unmodifiableList(this.jarFileUrls);
    }

    public void setJarFileUrls(List<URL> jarFileUrls) {
        this.jarFileUrls = jarFileUrls;
    }

    @Override
    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public void setPersistenceUnitRootUrl(URL persistenceUnitRootUrl) {
        this.persistenceUnitRootUrl = persistenceUnitRootUrl;
    }

    String getConfigHash() {
        return this.configHash;
    }

    @Override
    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public void setManagedClassNames(List<String> managedClassNames) {
        this.managedClassNames = managedClassNames;
    }

    @Override
    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.realClassLoader;
    }

    @Override
    public void addTransformer(ClassTransformer transformer) {
    }

    @Override
    public ClassLoader getNewTempClassLoader() {
        return this.tempClassLoader;
    }

    public void setNewTempClassLoader(ClassLoader loader) {
        this.tempClassLoader = loader;
    }

    public void setSharedCacheMode(String sharedCacheMode) {
        this.cacheMode = SharedCacheMode.valueOf(sharedCacheMode);
    }

    public void setValidationMode(String validationMode) {
        this.validationMode = ValidationMode.valueOf(validationMode);
    }

    public void setClassLoader(ClassLoader loader) {
        this.realClassLoader = loader;
    }

    public Collection<String> getJarFiles() {
        return this.jarFiles;
    }

    @Override
    public String getPersistenceXMLSchemaVersion() {
        return this.schemaVersion;
    }

    public void setPersistenceXMLSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    @Override
    public SharedCacheMode getSharedCacheMode() {
        return this.cacheMode;
    }

    @Override
    public ValidationMode getValidationMode() {
        return this.validationMode;
    }
}

