/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.RefreshOption;
import jakarta.persistence.Timeout;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.eclipse.persistence.internal.jpa.OptionUtils;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

class RefreshOptionUtils
extends OptionUtils {
    RefreshOptionUtils() {
    }

    static OptionUtils.Options parse(RefreshOption ... options) {
        return OptionsBuilder.build(null, options);
    }

    private static final class OptionsBuilder
    extends OptionUtils.OptionsBuilder {
        private static final Map<Class<? extends RefreshOption>, BiConsumer<OptionsBuilder, RefreshOption>> ACTIONS = OptionsBuilder.initActions();

        private static Map<Class<? extends RefreshOption>, BiConsumer<OptionsBuilder, RefreshOption>> initActions() {
            HashMap<Class<? extends RefreshOption>, BiConsumer<OptionsBuilder, RefreshOption>> actions2 = new HashMap<Class<? extends RefreshOption>, BiConsumer<OptionsBuilder, RefreshOption>>(8);
            actions2.put(LockModeType.class, OptionsBuilder::lockModeType);
            actions2.put(CacheStoreMode.class, OptionsBuilder::cacheStoreMode);
            actions2.put(PessimisticLockScope.class, OptionsBuilder::pessimisticLockScope);
            actions2.put(Timeout.class, OptionsBuilder::timeout);
            return actions2;
        }

        private OptionsBuilder(Map<String, Object> properties) {
            super(properties);
        }

        private static void lockModeType(OptionsBuilder builder, RefreshOption lockModeType) {
            builder.setLockModeType((LockModeType)lockModeType);
        }

        private static void cacheStoreMode(OptionsBuilder builder, RefreshOption cacheStoreMode) {
            builder.putProperty("jakarta.persistence.cache.storeMode", cacheStoreMode);
        }

        private static void pessimisticLockScope(OptionsBuilder builder, RefreshOption cacheStoreMode) {
            builder.putProperty("jakarta.persistence.lock.scope", cacheStoreMode);
        }

        private static void timeout(OptionsBuilder builder, RefreshOption timeout) {
            builder.putProperty("eclipselink.query.timeout.unit", (Object)TimeUnit.MILLISECONDS);
            builder.putProperty("jakarta.persistence.query.timeout", ((Timeout)timeout).milliseconds());
        }

        private static OptionUtils.Options build(Map<String, Object> properties, RefreshOption ... options) {
            OptionsBuilder builder = new OptionsBuilder(properties);
            for (RefreshOption option : options) {
                BiConsumer<OptionsBuilder, RefreshOption> action = ACTIONS.get(option.getClass());
                if (action != null) {
                    action.accept(builder, option);
                    continue;
                }
                if (option instanceof Timeout) {
                    OptionsBuilder.timeout(builder, option);
                    continue;
                }
                throw new PersistenceException(ExceptionLocalization.buildMessage("refresh_option_class_unknown", new String[]{option.getClass().getName()}));
            }
            return new OptionUtils.Options(builder.getLockModeType(), Collections.unmodifiableMap(builder.getProperties()));
        }
    }
}

