/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.json.schema.model;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.jaxb.json.schema.model.JsonType;
import org.eclipse.persistence.internal.jaxb.json.schema.model.Property;
import org.eclipse.persistence.oxm.annotations.XmlVariableNode;

public class JsonSchema {
    @XmlElement(name="$schema")
    private String schemaVersion = "http://json-schema.org/draft-04/schema#";
    @XmlElement(name="title")
    private String title;
    @XmlElement(name="type")
    private JsonType type;
    @XmlElement(name="anyOf")
    private Property[] anyOf;
    @XmlElement(name="enumeration")
    private List<String> enumeration;
    @XmlVariableNode(value="name")
    @XmlElementWrapper(name="properties")
    private Map<String, Property> properties;
    @XmlElement(name="items")
    private Property items;
    @XmlElement(name="additionalProperties")
    private Boolean additionalProperties = null;
    @XmlVariableNode(value="name")
    @XmlElementWrapper(name="definitions")
    private Map<String, Property> definitions;
    private List<String> required;

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(JsonType type2) {
        this.type = type2;
    }

    public void addProperty(Property property) {
        this.getProperties().put(property.getName(), property);
    }

    public Map<String, Property> getProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Property>();
        }
        return this.properties;
    }

    public void setProperties(Map<String, Property> props) {
        this.properties = props;
    }

    public Map<String, Property> getDefinitions() {
        if (this.definitions == null) {
            this.definitions = new LinkedHashMap<String, Property>();
        }
        return this.definitions;
    }

    public Property getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public Property getItems() {
        return this.items;
    }

    public void setItems(Property items) {
        this.items = items;
    }

    public Boolean isAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Boolean additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public void setAnyOf(Property[] anyOf) {
        this.anyOf = anyOf;
    }

    public Property[] getAnyOf() {
        return this.anyOf;
    }

    public List<String> getEnumeration() {
        return this.enumeration;
    }

    public void setEnumeration(List<String> enumeration) {
        this.enumeration = enumeration;
    }
}

