/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import jakarta.resource.ResourceException;
import jakarta.resource.cci.IndexedRecord;
import jakarta.resource.cci.MappedRecord;
import jakarta.resource.cci.Record;
import java.util.Vector;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISMappedRecord;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class MappedInteraction
extends EISInteraction {
    protected String inputResultPath = "";
    protected Vector<String> argumentNames;

    public void addArgument(String parameterAndArgumentFieldName) {
        this.addArgument(parameterAndArgumentFieldName, parameterAndArgumentFieldName);
    }

    public void addArgument(String parameterName, String argumentFieldName) {
        this.getArgumentNames().add(parameterName);
        this.getArguments().add(new DatabaseField(argumentFieldName));
    }

    public void addArgumentValue(String parameterName, Object argumentValue) {
        this.getArgumentNames().add(parameterName);
        this.getArguments().add(argumentValue);
    }

    public String getInputResultPath() {
        return this.inputResultPath;
    }

    public void setInputResultPath(String inputResultPath) {
        this.inputResultPath = inputResultPath;
    }

    public Vector<String> getArgumentNames() {
        if (this.argumentNames == null) {
            this.argumentNames = new Vector();
        }
        return this.argumentNames;
    }

    public void setArgumentNames(Vector<String> argumentNames) {
        this.argumentNames = argumentNames;
    }

    @Override
    public Record createInputRecord(EISAccessor accessor) {
        try {
            MappedRecord record = null;
            if (this.getInputRow() != null && !this.hasArguments()) {
                if (this.getInputResultPath().isEmpty()) {
                    record = (MappedRecord)this.createRecordElement(this.getInputRecordName(), this.getInputRow(), accessor);
                } else {
                    record = accessor.getRecordFactory().createMappedRecord(this.getInputRecordName());
                    Object nestedRecord = this.createRecordElement(this.getInputResultPath(), this.getInputRow(), accessor);
                    accessor.getEISPlatform().setValueInRecord(this.getInputResultPath(), nestedRecord, record, accessor);
                }
            } else {
                record = accessor.getRecordFactory().createMappedRecord(this.getInputRecordName());
                for (int index = 0; index < this.getArgumentNames().size(); ++index) {
                    String parameterName = this.getArgumentNames().get(index);
                    Object parameter = this.getParameters().get(index);
                    if (parameter == null && this.getInputRow() != null) {
                        parameter = this.getInputRow().get(parameterName);
                    }
                    parameter = this.createRecordElement(parameterName, parameter, accessor);
                    accessor.getEISPlatform().setValueInRecord(parameterName, parameter, record, accessor);
                }
            }
            return record;
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, accessor, null);
        }
    }

    public Record createTranslationRecord(AbstractRecord transaltionRow, EISAccessor accessor) {
        return (MappedRecord)this.createRecordElement(this.getInputRecordName(), transaltionRow, accessor);
    }

    @Override
    public AbstractRecord buildRow(Record record, EISAccessor accessor) {
        if (record == null) {
            return null;
        }
        AbstractRecord row = null;
        if (record instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record;
            if (indexedRecord.isEmpty()) {
                return null;
            }
            if (indexedRecord.get(0) instanceof Record) {
                return this.buildRow((Record)indexedRecord.get(0), accessor);
            }
        }
        if (!(record instanceof MappedRecord)) {
            row = new DatabaseRecord(1);
            row.put(this.getOutputResultPath(), (Object)record);
            return row;
        }
        MappedRecord mappedRecord = (MappedRecord)record;
        if (this.hasOutputArguments()) {
            row = new DatabaseRecord(this.getOutputArgumentNames().size());
            for (int index = 0; index < this.getOutputArgumentNames().size(); ++index) {
                DatabaseField field = this.getOutputArguments().get(index);
                row.put(field, mappedRecord.get(this.getOutputArgumentNames().get(index)));
            }
            return row;
        }
        if (!this.getOutputResultPath().isEmpty()) {
            mappedRecord = (MappedRecord)mappedRecord.get(this.getOutputResultPath());
        }
        row = new EISMappedRecord(mappedRecord, accessor);
        return row;
    }
}

