/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.asm;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.asm.ASMFactory;
import org.eclipse.persistence.asm.internal.Util;
import org.eclipse.persistence.asm.internal.platform.eclipselink.TypeImpl;

public abstract class Type {
    private static final String ASM_TYPE_ECLIPSELINK = "org.eclipse.persistence.internal.libraries.asm.Type";
    private static final String ASM_TYPE_OW2 = "org.objectweb.asm.Type";
    private static final Map<String, String> ASM_TYPE_MAP = new HashMap<String, String>();
    public static final int BOOLEAN;
    public static final int BYTE;
    public static final int CHAR;
    public static final int DOUBLE;
    public static final int FLOAT;
    public static final int INT;
    public static final int LONG;
    public static final int SHORT;
    public static final Type VOID_TYPE;

    private static int valueInt(String fieldName) {
        return (Integer)Util.getFieldValue(ASM_TYPE_MAP, fieldName, Integer.TYPE);
    }

    public static Type getType(String typeDescriptor) {
        return ASMFactory.createType(typeDescriptor);
    }

    public static Type getType(Class<?> clazz) {
        return ASMFactory.createType(clazz);
    }

    public static String getMethodDescriptor(Method method) {
        return ASMFactory.createType(Object.class).getMethodDescriptorInternal(method);
    }

    public static String getMethodDescriptor(Type returnType, Type ... argumentTypes) {
        return ASMFactory.createType(Object.class).getMethodDescriptorInternal(returnType, argumentTypes);
    }

    public static String getDescriptor(Class<?> clazz) {
        Type type2 = ASMFactory.createType(clazz);
        if (type2 instanceof TypeImpl) {
            org.eclipse.persistence.internal.libraries.asm.Type cfr_ignored_0 = (org.eclipse.persistence.internal.libraries.asm.Type)ASMFactory.createType(clazz).unwrap();
            return org.eclipse.persistence.internal.libraries.asm.Type.getDescriptor(clazz);
        }
        if (type2 instanceof org.eclipse.persistence.asm.internal.platform.ow2.TypeImpl) {
            org.objectweb.asm.Type cfr_ignored_1 = (org.objectweb.asm.Type)ASMFactory.createType(clazz).unwrap();
            return org.objectweb.asm.Type.getDescriptor(clazz);
        }
        return null;
    }

    public static String getInternalName(Class<?> clazz) {
        Type type2 = ASMFactory.createType(clazz);
        if (type2 instanceof TypeImpl) {
            org.eclipse.persistence.internal.libraries.asm.Type cfr_ignored_0 = (org.eclipse.persistence.internal.libraries.asm.Type)ASMFactory.createType(clazz).unwrap();
            return org.eclipse.persistence.internal.libraries.asm.Type.getInternalName(clazz);
        }
        if (type2 instanceof org.eclipse.persistence.asm.internal.platform.ow2.TypeImpl) {
            org.objectweb.asm.Type cfr_ignored_1 = (org.objectweb.asm.Type)ASMFactory.createType(clazz).unwrap();
            return org.objectweb.asm.Type.getInternalName(clazz);
        }
        return null;
    }

    public static Object getTypeClassName(Object value) {
        try {
            if (Class.forName(ASM_TYPE_ECLIPSELINK).isInstance(value)) {
                return ((org.eclipse.persistence.internal.libraries.asm.Type)value).getClassName();
            }
            if (Class.forName(ASM_TYPE_OW2).isInstance(value)) {
                return ((org.objectweb.asm.Type)value).getClassName();
            }
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public abstract String getDescriptor();

    public abstract String getInternalName();

    public abstract int getSort();

    public abstract int getOpcode(int var1);

    protected abstract String getMethodDescriptorInternal(Method var1);

    protected abstract String getMethodDescriptorInternal(Type var1, Type ... var2);

    public abstract String getClassName();

    public abstract <T> T unwrap();

    static {
        ASM_TYPE_MAP.put("ow2", ASM_TYPE_OW2);
        ASM_TYPE_MAP.put("eclipselink", ASM_TYPE_ECLIPSELINK);
        BOOLEAN = Type.valueInt("BOOLEAN");
        BYTE = Type.valueInt("BYTE");
        CHAR = Type.valueInt("CHAR");
        DOUBLE = Type.valueInt("DOUBLE");
        FLOAT = Type.valueInt("FLOAT");
        INT = Type.valueInt("INT");
        LONG = Type.valueInt("LONG");
        SHORT = Type.valueInt("SHORT");
        VOID_TYPE = ASMFactory.createVoidType();
    }
}

