/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Wrapper;

public final class InstanceSupport {
    private ReadWriteLock listenersLock = new ReentrantReadWriteLock();
    private Lock listenersReadLock = this.listenersLock.readLock();
    private Lock listenersWriteLock = this.listenersLock.writeLock();
    private InstanceListener[] listeners = new InstanceListener[0];
    private Wrapper wrapper = null;

    public InstanceSupport(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(InstanceListener listener) {
        this.listenersWriteLock.lock();
        try {
            InstanceListener[] results = new InstanceListener[this.listeners.length + 1];
            for (int i = 0; i < this.listeners.length; ++i) {
                results[i] = this.listeners[i];
            }
            results[this.listeners.length] = listener;
            this.listeners = results;
        }
        finally {
            this.listenersWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(InstanceEvent.EventType type2, Filter filter) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, filter, type2);
        Object interested = null;
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
        }
        finally {
            this.listenersReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(InstanceEvent.EventType type2, Filter filter, Throwable exception) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, filter, type2, exception);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
        }
        finally {
            this.listenersReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(InstanceEvent.EventType type2, Filter filter, ServletRequest request, ServletResponse response) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, filter, type2, request, response);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
        }
        finally {
            this.listenersReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(InstanceEvent.EventType type2, Filter filter, ServletRequest request, ServletResponse response, Throwable exception) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, filter, type2, request, response, exception);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
        }
        finally {
            this.listenersReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(InstanceEvent.EventType type2, Servlet servlet) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, servlet, type2);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
        }
        finally {
            this.listenersReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(InstanceEvent.EventType type2, Servlet servlet, Throwable exception) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, servlet, type2, exception);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
        }
        finally {
            this.listenersReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(InstanceEvent.EventType type2, Servlet servlet, ServletRequest request, ServletResponse response) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, servlet, type2, request, response);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
        }
        finally {
            this.listenersReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(InstanceEvent.EventType type2, Servlet servlet, ServletRequest request, ServletResponse response, Throwable exception) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, servlet, type2, request, response, exception);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
        }
        finally {
            this.listenersReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(InstanceListener listener) {
        this.listenersWriteLock.lock();
        try {
            int n = -1;
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != listener) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            InstanceListener[] results = new InstanceListener[this.listeners.length - 1];
            int j = 0;
            for (int i = 0; i < this.listeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.listeners[i];
            }
            this.listeners = results;
        }
        finally {
            this.listenersWriteLock.unlock();
        }
    }
}

