/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardEngine;

public final class EngineConfig
implements LifecycleListener {
    private static final java.util.logging.Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private int debug = 0;
    private Engine engine = null;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            int engineDebug;
            this.engine = (Engine)((Object)event.getLifecycle());
            if (this.engine instanceof StandardEngine && (engineDebug = ((StandardEngine)this.engine).getDebug()) > this.debug) {
                this.debug = engineDebug;
            }
        }
        catch (ClassCastException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00440"), event.getLifecycle());
            this.log(msg, e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    private void log(String message) {
        Logger logger2 = null;
        if (this.engine != null) {
            logger2 = this.engine.getLogger();
        }
        if (logger2 != null) {
            logger2.log("EngineConfig: " + message);
        } else if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "AS-WEB-CORE-00441", message);
        }
    }

    private void log(String message, Throwable t) {
        Logger logger2 = null;
        if (this.engine != null) {
            logger2 = this.engine.getLogger();
        }
        if (logger2 != null) {
            logger2.log("EngineConfig: " + message, t, 2);
        } else {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00441"), message);
            log.log(Level.WARNING, msg, t);
        }
    }

    private void start() {
        if (this.debug > 0) {
            this.log(rb.getString("AS-WEB-CORE-00442"));
        }
    }

    private void stop() {
        if (this.debug > 0) {
            this.log(rb.getString("AS-WEB-CORE-00443"));
        }
    }
}

