/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.PrintWriter;
import org.apache.catalina.ssi.SSICommand;
import org.apache.catalina.ssi.SSIMediator;
import org.apache.catalina.ssi.SSIStopProcessingException;
import org.glassfish.web.util.HtmlEntityEncoder;

public class SSISet
implements SSICommand {
    @Override
    public long process(SSIMediator ssiMediator, String commandName, String[] paramNames, String[] paramValues, PrintWriter writer) throws SSIStopProcessingException {
        long lastModified = 0L;
        String variableName = null;
        for (int i = 0; i < paramNames.length; ++i) {
            String errorMessage;
            String paramName = paramNames[i];
            String paramValue = paramValues[i];
            if (paramName.equalsIgnoreCase("var")) {
                variableName = paramValue;
                continue;
            }
            if (paramName.equalsIgnoreCase("value")) {
                if (variableName != null) {
                    String substitutedValue = ssiMediator.substituteVariables(paramValue);
                    ssiMediator.setVariableValue(variableName, substitutedValue);
                    lastModified = System.currentTimeMillis();
                    continue;
                }
                ssiMediator.log("#set--no variable specified");
                errorMessage = this.getEncodedConfigErrorMessage(ssiMediator);
                writer.write(errorMessage);
                throw new SSIStopProcessingException();
            }
            ssiMediator.log("#set--Invalid attribute: " + paramName);
            errorMessage = this.getEncodedConfigErrorMessage(ssiMediator);
            writer.write(errorMessage);
            throw new SSIStopProcessingException();
        }
        return lastModified;
    }

    private String getEncodedConfigErrorMessage(SSIMediator ssiMediator) {
        String errorMessage = ssiMediator.getConfigErrMsg();
        return HtmlEntityEncoder.encodeXSS(errorMessage);
    }
}

