/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import com.sun.enterprise.security.GroupPrincipal;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.catalina.Container;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.JAASCallbackHandler;
import org.apache.catalina.realm.RealmBase;

public final class JAASRealm
extends RealmBase {
    protected String appName;
    protected static final String info = "org.apache.catalina.realm.JAASRealm/1.0";
    protected static final String name = "JAASRealm";
    protected ArrayList<String> roleClasses = new ArrayList();
    protected ArrayList<String> userClasses = new ArrayList();
    protected String roleClassNames = null;
    protected String userClassNames = null;

    @Deprecated
    public void setAppName(String name) {
        this.appName = name;
    }

    public String getAppName() {
        return this.appName;
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        String name = container.getName();
        if (this.appName == null) {
            this.appName = name;
            log.log(Level.INFO, "AS-WEB-CORE-00306", this.appName);
        }
    }

    @Override
    @Deprecated
    public Principal authenticate(HttpServletRequest hreq) {
        throw new UnsupportedOperationException();
    }

    public String getRoleClassNames() {
        return this.roleClassNames;
    }

    public void setRoleClassNames(String roleClassNames) {
        int comma;
        this.roleClassNames = roleClassNames;
        this.roleClasses.clear();
        String temp = this.roleClassNames;
        if (temp == null) {
            return;
        }
        while ((comma = temp.indexOf(44)) >= 0) {
            this.roleClasses.add(temp.substring(0, comma).trim());
            temp = temp.substring(comma + 1);
        }
        temp = temp.trim();
        if (temp.length() > 0) {
            this.roleClasses.add(temp);
        }
    }

    public String getUserClassNames() {
        return this.userClassNames;
    }

    public void setUserClassNames(String userClassNames) {
        int comma;
        this.userClassNames = userClassNames;
        this.userClasses.clear();
        String temp = this.userClassNames;
        if (temp == null) {
            return;
        }
        while ((comma = temp.indexOf(44)) >= 0) {
            this.userClasses.add(temp.substring(0, comma).trim());
            temp = temp.substring(comma + 1);
        }
        temp = temp.trim();
        if (temp.length() > 0) {
            this.userClasses.add(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Principal authenticate(String username, char[] credentials) {
        try {
            LoginContext loginContext = null;
            if (this.appName == null) {
                this.appName = "Tomcat";
            }
            log.log(Level.FINE, "Authenticating {0} to application {1}", new Object[]{username, this.appName});
            ClassLoader ocl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                loginContext = new LoginContext(this.appName, new JAASCallbackHandler(this, username, credentials));
            }
            catch (Throwable e) {
                String msg;
                if (log.isLoggable(Level.FINE)) {
                    msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00307"), username);
                    log.log(Level.FINE, msg, e);
                }
                msg = null;
                return msg;
            }
            finally {
                Thread.currentThread().setContextClassLoader(ocl);
            }
            log.log(Level.FINE, "Login context created {0}", username);
            Subject subject = null;
            try {
                loginContext.login();
                subject = loginContext.getSubject();
                if (subject == null) {
                    log.log(Level.FINE, "AS-WEB-CORE-00308", username);
                    return null;
                }
            }
            catch (AccountExpiredException e) {
                log.log(Level.FINE, "AS-WEB-CORE-00309", username);
                return null;
            }
            catch (CredentialExpiredException e) {
                log.log(Level.FINE, "AS-WEB-CORE-00310", username);
                return null;
            }
            catch (FailedLoginException e) {
                log.log(Level.FINE, "AS-WEB-CORE-00308", username);
                return null;
            }
            catch (LoginException e) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00307"), username);
                log.log(Level.FINE, msg, e);
                return null;
            }
            catch (Throwable e) {
                log.log(Level.FINE, "Unexpected error", e);
                return null;
            }
            log.log(Level.FINE, "Getting principal {0}", subject);
            Principal principal = this.createPrincipal(username, subject);
            if (principal == null) {
                log.log(Level.FINE, "Failed to authenticate username {0}", username);
                return null;
            }
            log.log(Level.FINE, "Successful to authenticate username {0}", username);
            return principal;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00311", t);
            return null;
        }
    }

    @Override
    protected String getName() {
        return name;
    }

    @Override
    protected char[] getPassword(String username) {
        return null;
    }

    @Override
    protected Principal getPrincipal(String username) {
        return null;
    }

    protected Principal createPrincipal(String username, Subject subject) {
        ArrayList<String> roles = new ArrayList<String>();
        for (Principal principal : subject.getPrincipals()) {
            if (principal instanceof GenericPrincipal) {
                log.log(Level.FINE, "Found old GenericPrincipal {0}", principal);
                return principal;
            }
            String principalClass = principal.getClass().getName();
            log.log(Level.FINE, "Principal: {0} {1}", new Object[]{principalClass, principal});
            if (this.userClasses.contains(principalClass)) {
                username = principal.getName();
            }
            if (this.roleClasses.contains(principalClass)) {
                roles.add(principal.getName());
            }
            if (!(principal instanceof GroupPrincipal) || !"Roles".equals(principal.getName())) continue;
            GroupPrincipal grp = (GroupPrincipal)principal;
            Enumeration<? extends Principal> en = grp.members();
            while (en.hasMoreElements()) {
                Principal roleP = en.nextElement();
                roles.add(roleP.getName());
            }
        }
        if (username != null) {
            return new GenericPrincipal(this, username, null, roles);
        }
        return null;
    }
}

