/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.logging.LogCleanerUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.naming.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.util.LifecycleSupport;

public final class StandardServer
implements Lifecycle,
Server {
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private static String[][] exceptions = new String[][]{{"org.apache.catalina.core.StandardEngine", "domain"}, {"org.apache.catalina.core.StandardHost", "domain"}, {"org.apache.catalina.core.StandardContext", "available"}, {"org.apache.catalina.core.StandardContext", "configFile"}, {"org.apache.catalina.core.StandardContext", "configured"}, {"org.apache.catalina.core.StandardContext", "distributable"}, {"org.apache.catalina.core.StandardContext", "domain"}, {"org.apache.catalina.core.StandardContext", "engineName"}, {"org.apache.catalina.core.StandardContext", "name"}, {"org.apache.catalina.core.StandardContext", "override"}, {"org.apache.catalina.core.StandardContext", "publicId"}, {"org.apache.catalina.core.StandardContext", "replaceWelcomeFiles"}, {"org.apache.catalina.core.StandardContext", "sessionTimeout"}, {"org.apache.catalina.core.StandardContext", "startupTime"}, {"org.apache.catalina.core.StandardContext", "tldScanTime"}, {"org.apache.catalina.core.StandardContext", "workDir"}, {"org.apache.catalina.session.StandardManager", "distributable"}, {"org.apache.catalina.session.StandardManager", "entropy"}};
    private static Class[] persistables = new Class[]{String.class, Integer.class, Integer.TYPE, Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE};
    private static String[] skippables = new String[]{"org.apache.catalina.authenticator.BasicAuthenticator", "org.apache.catalina.authenticator.DigestAuthenticator", "org.apache.catalina.authenticator.FormAuthenticator", "org.apache.catalina.authenticator.NonLoginAuthenticator", "org.apache.catalina.authenticator.SSLAuthenticator", "org.apache.catalina.core.NamingContextListener", "org.apache.catalina.core.StandardContextValve", "org.apache.catalina.core.StandardEngineValve", "org.apache.catalina.core.StandardHostValve", "org.apache.catalina.startup.ContextConfig", "org.apache.catalina.startup.EngineConfig", "org.apache.catalina.startup.HostConfig", "org.apache.catalina.valves.CertificatesValve", "org.apache.catalina.valves.ErrorReportValve", "org.apache.catalina.valves.RequestListenerValve"};
    private static String[] standardImplementations = new String[]{"org.apache.catalina.core.StandardServer", "org.apache.catalina.core.StandardService", "org.apache.catalina.connector.CoyoteConnector", "org.apache.catalina.core.StandardEngine", "org.apache.catalina.core.StandardHost", "org.apache.catalina.core.StandardContext"};
    private int debug = 0;
    private Context globalNamingContext = null;
    private NamingResources globalNamingResources = null;
    private static final String info = "org.apache.catalina.core.StandardServer/1.0";
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private NamingContextListener namingContextListener = null;
    private int port = 8005;
    private SecureRandom random = null;
    private Service[] services = new Service[0];
    private final Object servicesMonitor = new Object();
    private String shutdown = "SHUTDOWN";
    private boolean started = false;
    private boolean initialized = false;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String type;
    private String domain;
    private String suffix;
    private ObjectName oname;

    public StandardServer() {
        ServerFactory.setServer(this);
        this.globalNamingResources = new NamingResources();
        this.globalNamingResources.setContainer(this);
        if (this.isUseNaming()) {
            this.namingContextListener = new NamingContextListener();
            this.namingContextListener.setDebug(this.getDebug());
            this.addLifecycleListener(this.namingContextListener);
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public Context getGlobalNamingContext() {
        return this.globalNamingContext;
    }

    public void setGlobalNamingContext(Context globalNamingContext) {
        this.globalNamingContext = globalNamingContext;
    }

    @Override
    public NamingResources getGlobalNamingResources() {
        return this.globalNamingResources;
    }

    @Override
    public void setGlobalNamingResources(NamingResources globalNamingResources) {
        NamingResources oldGlobalNamingResources = this.globalNamingResources;
        this.globalNamingResources = globalNamingResources;
        this.globalNamingResources.setContainer(this);
        this.support.firePropertyChange("globalNamingResources", oldGlobalNamingResources, this.globalNamingResources);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getShutdown() {
        return this.shutdown;
    }

    @Override
    public void setShutdown(String shutdown) {
        this.shutdown = shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addService(Service service) {
        service.setServer(this);
        Object object = this.servicesMonitor;
        synchronized (object) {
            Service[] results = new Service[this.services.length + 1];
            System.arraycopy(this.services, 0, results, 0, this.services.length);
            results[this.services.length] = service;
            this.services = results;
            if (this.initialized) {
                try {
                    service.initialize();
                }
                catch (LifecycleException e) {
                    String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00243"), e.toString());
                    log.log(Level.SEVERE, msg, e);
                }
            }
            if (this.started && service instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)service)).start();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("service", null, service);
        }
    }

    @Override
    public void await() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port, 1, InetAddress.getByName("127.0.0.1"));
        }
        catch (IOException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00244"), this.port);
            log.log(Level.SEVERE, msg, e);
            System.exit(1);
        }
        while (true) {
            int expected;
            String msg;
            Socket socket = null;
            InputStream stream = null;
            try {
                socket = serverSocket.accept();
                socket.setSoTimeout(10000);
                stream = socket.getInputStream();
            }
            catch (AccessControlException ace) {
                msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00245"), ace.getMessage());
                log.log(Level.WARNING, msg, ace);
                continue;
            }
            catch (IOException e) {
                msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00246"), e.toString());
                log.log(Level.SEVERE, msg, e);
                System.exit(1);
            }
            StringBuilder command = new StringBuilder();
            for (expected = 1024; expected < this.shutdown.length(); expected += this.random.nextInt(1024)) {
                if (this.random != null) continue;
                this.random = new SecureRandom();
            }
            while (expected > 0) {
                int ch = -1;
                try {
                    ch = stream.read();
                }
                catch (IOException e) {
                    String msg2 = MessageFormat.format(rb.getString("AS-WEB-CORE-00247"), e.toString());
                    log.log(Level.WARNING, msg2, e);
                    ch = -1;
                }
                if (ch < 32) break;
                command.append((char)ch);
                --expected;
            }
            try {
                socket.close();
            }
            catch (IOException ch) {
                // empty catch block
            }
            boolean match = command.toString().equals(this.shutdown);
            if (match) break;
            log.log(Level.WARNING, "AS-WEB-CORE-00248", LogCleanerUtil.neutralizeForLog(command.toString()));
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service findService(String name) {
        if (name == null) {
            return null;
        }
        Object object = this.servicesMonitor;
        synchronized (object) {
            for (int i = 0; i < this.services.length; ++i) {
                if (!name.equals(this.services[i].getName())) continue;
                return this.services[i];
            }
        }
        return null;
    }

    @Override
    public Service[] findServices() {
        return this.services;
    }

    public ObjectName[] getServiceNames() {
        ObjectName[] onames = new ObjectName[this.services.length];
        for (int i = 0; i < this.services.length; ++i) {
            onames[i] = ((StandardService)this.services[i]).getObjectName();
        }
        return onames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeService(Service service) {
        Object object = this.servicesMonitor;
        synchronized (object) {
            int j = -1;
            for (int i = 0; i < this.services.length; ++i) {
                if (service != this.services[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (this.services[j] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.services[j])).stop();
                }
                catch (LifecycleException i) {
                    // empty catch block
                }
            }
            int k = 0;
            Service[] results = new Service[this.services.length - 1];
            for (int i = 0; i < this.services.length; ++i) {
                if (i == j) continue;
                results[k++] = this.services[i];
            }
            this.services = results;
            this.support.firePropertyChange("service", service, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardServer[");
        sb.append(this.getPort());
        sb.append("]");
        return sb.toString();
    }

    private boolean isUseNaming() {
        boolean useNaming = true;
        String useNamingProperty = System.getProperty("catalina.useNaming");
        if (useNamingProperty != null && useNamingProperty.equals("false")) {
            useNaming = false;
        }
        return useNaming;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "This server has already been started");
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Object object = this.servicesMonitor;
        synchronized (object) {
            for (int i = 0; i < this.services.length; ++i) {
                if (!(this.services[i] instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)this.services[i])).start();
            }
        }
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        for (int i = 0; i < this.services.length; ++i) {
            if (!(this.services[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.services[i])).stop();
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    public void init() throws Exception {
        this.initialize();
    }

    @Override
    public void initialize() throws LifecycleException {
        if (this.initialized) {
            log.log(Level.INFO, "AS-WEB-CORE-00249");
            return;
        }
        this.lifecycle.fireLifecycleEvent("init", null);
        this.initialized = true;
        if (this.oname == null) {
            try {
                this.oname = new ObjectName("Catalina:type=Server");
            }
            catch (Exception e) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00250"), e.toString());
                log.log(Level.SEVERE, msg, e);
            }
        }
        for (int i = 0; i < this.services.length; ++i) {
            this.services[i].initialize();
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }
}

