/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import com.sun.enterprise.util.Utility;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;

public class SSLAuthenticator
extends AuthenticatorBase {
    protected static final String info = "org.apache.catalina.authenticator.SSLAuthenticator/1.0";

    @Override
    protected String getAuthMethod() {
        return "CLIENT_CERT";
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        Object[] certificates;
        Principal callerPrincipal = ((HttpServletRequest)request.getRequest()).getUserPrincipal();
        if (callerPrincipal != null) {
            if (this.debug >= 1) {
                this.log(MessageFormat.format(rb.getString("AS-WEB-CORE-00009"), callerPrincipal.getName()));
            }
            return true;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
        if (this.debug >= 1) {
            this.log(rb.getString("AS-WEB-CORE-00017"));
        }
        if (Utility.isEmpty(certificates = (X509Certificate[])request.getRequest().getAttribute("jakarta.servlet.request.X509Certificate"))) {
            certificates = (X509Certificate[])request.getRequest().getAttribute("org.apache.coyote.request.X509Certificate");
        }
        if (Utility.isEmpty(certificates)) {
            if (this.debug >= 1) {
                this.log(rb.getString("AS-WEB-CORE-00018"));
            }
            httpServletResponse.sendError(400);
            response.setDetailMessage(rb.getString("AS-WEB-CORE-00019"));
            return false;
        }
        callerPrincipal = this.context.getRealm().authenticate(request, (X509Certificate[])certificates);
        if (callerPrincipal == null) {
            if (this.debug >= 1) {
                this.log("Realm.authenticate() returned false");
            }
            httpServletResponse.sendError(401);
            response.setDetailMessage(rb.getString("AS-WEB-CORE-00020"));
            return false;
        }
        this.register(request, response, callerPrincipal, "CLIENT_CERT", null, null);
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (ssoId != null) {
            this.getSession(request, true);
        }
        return true;
    }
}

