/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jtsxa;

import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.otid_t;

public class XID
implements Xid {
    private int formatID = -1;
    private int gtrid_length;
    private int bqual_length;
    private byte[] data = new byte[128];
    private byte[] cachedBqual = null;
    private byte[] cachedGtrid = null;
    private static final int XIDDATASIZE = 128;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private static final String hextab = "0123456789ABCDEF";
    static Logger _logger = LogDomains.getLogger(XID.class, "jakarta.enterprise.system.core.transaction");

    public void copy(XID from) {
        this.formatID = -1;
        if (from == null) {
            return;
        }
        if (from.formatID == -1) {
            return;
        }
        this.gtrid_length = from.gtrid_length;
        this.bqual_length = from.bqual_length;
        if (this.data != null && from.data != null) {
            System.arraycopy(from.data, 0, this.data, 0, 128);
        }
        this.formatID = from.formatID;
    }

    public void copy(otid_t from) {
        this.formatID = -1;
        if (from == null) {
            return;
        }
        if (from.formatID == -1) {
            return;
        }
        int L = from.tid.length;
        this.gtrid_length = L - from.bqual_length;
        this.bqual_length = from.bqual_length;
        if (this.data != null) {
            System.arraycopy(from.tid, 0, this.data, 0, L);
        }
        this.formatID = from.formatID;
    }

    public boolean equals(Object o) {
        if (!(o instanceof XID)) {
            return false;
        }
        XID other = (XID)o;
        if (this.formatID == -1 && other.formatID == -1) {
            return true;
        }
        if (this.formatID != other.formatID || this.gtrid_length != other.gtrid_length || this.bqual_length != other.bqual_length) {
            return false;
        }
        int L = this.gtrid_length + this.bqual_length;
        for (int i = 0; i < L; ++i) {
            if (this.data[i] == other.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.formatID == -1) {
            return -1;
        }
        return this.formatID + this.gtrid_length - this.bqual_length;
    }

    public String toString() {
        if (_logger.isLoggable(Level.FINE)) {
            int L = this.gtrid_length + this.bqual_length;
            StringBuffer d = new StringBuffer(L + L);
            for (int i = 0; i < L; ++i) {
                int v = this.data[i] & 0xFF;
                d.append(hextab.charAt(v / 16));
                d.append(hextab.charAt(v & 0xF));
                if ((i + 1) % 4 != 0 || i + 1 >= L) continue;
                d.append(" ");
            }
            String s = "{XID: formatID(" + this.formatID + "), gtrid_length(" + this.gtrid_length + "), bqual_length(" + this.bqual_length + "), data(" + String.valueOf(d) + ")}";
            return s;
        }
        return "(Available at FINE log level)";
    }

    @Override
    public byte[] getBranchQualifier() {
        if (this.cachedBqual != null) {
            return this.cachedBqual;
        }
        byte[] bqual = new byte[this.bqual_length];
        System.arraycopy(this.data, this.gtrid_length, bqual, 0, this.bqual_length);
        return bqual;
    }

    public void setBranchQualifier(byte[] qual) {
        this.bqual_length = qual.length > 64 ? 64 : qual.length;
        System.arraycopy(qual, 0, this.data, this.gtrid_length, this.bqual_length);
        this.cachedBqual = qual;
    }

    public int getFormatID() {
        return this.formatID;
    }

    public void setFormatID(int formatID) {
        this.formatID = formatID;
    }

    public boolean isEqualBranchQualifier(byte[] data) {
        int L;
        int n = L = data.length > 64 ? 64 : data.length;
        if (L != this.bqual_length) {
            return false;
        }
        for (int i = 0; i < L; ++i) {
            if (data[i] == this.data[this.gtrid_length + i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualGtrid(XID xid) {
        if (this.gtrid_length != xid.gtrid_length) {
            return false;
        }
        for (int i = 0; i < this.gtrid_length; ++i) {
            if (this.data[i] == xid.data[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] getGlobalTransactionIdentifier() {
        if (this.cachedGtrid != null) {
            return this.cachedGtrid;
        }
        byte[] gtrid = new byte[this.gtrid_length];
        System.arraycopy(this.data, 0, gtrid, 0, this.gtrid_length);
        this.cachedGtrid = gtrid;
        return gtrid;
    }

    @Override
    public int getFormatId() {
        return this.getFormatID();
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.getGlobalTransactionIdentifier();
    }
}

