/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;

class LogDBHelper {
    String resName = "jdbc/TxnDS";
    private String serverName;
    private final String instanceName = Configuration.getPropertyValue("com.sun.jts.instancename");
    private DataSource ds = null;
    private Method getNonTxConnectionMethod = null;
    private static final String insertStatement = System.getProperty("com.sun.jts.dblogging.insertquery", "insert into  txn_log_table values ( ? , ? , ? , ? )");
    private static final String deleteStatement = System.getProperty("com.sun.jts.dblogging.deletequery", "delete from txn_log_table where localtid = ? and servername = ? ");
    private static final String selectStatement = System.getProperty("com.sun.jts.dblogging.selectquery", "select * from txn_log_table where servername = ? ");
    private static final String selectServerNameStatement = System.getProperty("com.sun.jts.dblogging.selectservernamequery", "select distinct servername from txn_log_table where instancename = ? ");
    private static final String createTableStatement = "create table txn_log_table (localtid varchar(20), servername varchar(150), instancename varchar(150), gtrid blob)";
    private static final boolean useNonTxConnectionForAddRecord = Boolean.getBoolean("com.sun.jts.dblogging.use.nontx.connection.for.add");
    private static Logger _logger = LogDomains.getLogger(LogDBHelper.class, "jakarta.enterprise.system.core.transaction");
    private static LogDBHelper _instance = new LogDBHelper();

    static LogDBHelper getInstance() {
        return _instance;
    }

    LogDBHelper() {
        if (Configuration.getPropertyValue("com.sun.jts.logResource") != null) {
            this.resName = Configuration.getPropertyValue("com.sun.jts.logResource");
        }
        try {
            InitialContext ctx = new InitialContext();
            this.ds = (DataSource)ctx.lookup(this.resName);
            Class<?> cls = this.ds.getClass();
            this.getNonTxConnectionMethod = cls.getMethod("getNonTxConnection", null);
            this.createTable();
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "jts.unconfigured_db_log_resource", this.resName);
            _logger.log(Level.SEVERE, "", t);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("LogDBHelper.resName: " + this.resName);
            _logger.fine("LogDBHelper.ds: " + String.valueOf(this.ds));
            _logger.fine("LogDBHelper.getNonTxConnectionMethod: " + String.valueOf(this.getNonTxConnectionMethod));
        }
    }

    void setServerName() {
        String s;
        String serverName0 = Configuration.getServerName();
        if (this.serverName != null && this.serverName.equals(serverName0)) {
            return;
        }
        this.serverName = serverName0;
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("LogDBHelper.setServerName for serverName: " + this.serverName);
            _logger.info("LogDBHelper.setServerName for instanceName: " + this.instanceName);
        }
        if ((s = this.getServerNameForInstanceName(this.instanceName)) == null) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("LogDBHelper.initTable adding marker record...");
            }
            this.addRecord(0L, null);
        } else if (!s.equals(this.serverName)) {
            _logger.log(Level.WARNING, "jts.exception_in_db_log_server_to_instance_mapping", new Object[]{this.instanceName, s, this.serverName});
            this.deleteRecord(0L, s);
            this.addRecord(0L, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addRecord(long localTID, byte[] data) {
        if (this.ds != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("LogDBHelper.addRecord for localTID: " + localTID);
                _logger.fine("LogDBHelper.addRecord for serverName: " + this.serverName);
                _logger.fine("LogDBHelper.addRecord for instanceName: " + this.instanceName);
            }
            Connection conn = null;
            Statement prepStmt1 = null;
            try {
                conn = useNonTxConnectionForAddRecord ? (Connection)this.getNonTxConnectionMethod.invoke((Object)this.ds, null) : this.ds.getConnection();
                prepStmt1 = conn.prepareStatement(insertStatement);
                prepStmt1.setString(1, Long.toString(localTID));
                prepStmt1.setString(2, this.serverName);
                prepStmt1.setString(3, this.instanceName);
                prepStmt1.setBytes(4, data);
                prepStmt1.executeUpdate();
                boolean bl = true;
                return bl;
            }
            catch (Throwable ex) {
                _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (prepStmt1 != null) {
                        prepStmt1.close();
                    }
                }
                catch (Exception ex1) {
                    _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex1);
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ex1) {
                    _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex1);
                }
            }
        }
        return false;
    }

    boolean deleteRecord(long localTID) {
        return this.deleteRecord(localTID, this.serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteRecord(long localTID, String serverName0) {
        if (this.ds != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("LogDBHelper.deleteRecord for localTID: " + localTID + " and serverName: " + serverName0);
            }
            Connection conn = null;
            Statement prepStmt1 = null;
            try {
                conn = (Connection)this.getNonTxConnectionMethod.invoke((Object)this.ds, null);
                prepStmt1 = conn.prepareStatement(deleteStatement);
                prepStmt1.setString(1, Long.toString(localTID));
                prepStmt1.setString(2, serverName0);
                prepStmt1.executeUpdate();
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (prepStmt1 != null) {
                        prepStmt1.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ex1) {
                    _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex1);
                }
            }
        }
        return false;
    }

    Map getGlobalTIDMap() {
        return this.getGlobalTIDMap(this.serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getGlobalTIDMap(String serverName0) {
        HashMap<GlobalTID, Long> gtidMap = new HashMap<GlobalTID, Long>();
        if (this.ds != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("LogDBHelper get records for serverName: " + serverName0);
            }
            Connection conn = null;
            Statement prepStmt1 = null;
            ResultSet rs = null;
            try {
                conn = (Connection)this.getNonTxConnectionMethod.invoke((Object)this.ds, null);
                prepStmt1 = conn.prepareStatement(selectStatement);
                prepStmt1.setString(1, serverName0);
                rs = prepStmt1.executeQuery();
                while (rs.next()) {
                    Long localTID = Long.valueOf(rs.getString(1));
                    byte[] gtridbytes = rs.getBytes(4);
                    if (gtridbytes == null) continue;
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("LogDBHelper found record for localTID: " + localTID + " and serverName: " + serverName0);
                        _logger.fine("LogDBHelper GlobalTID for localTID: " + localTID + " : " + String.valueOf(GlobalTID.fromTIDBytes(gtridbytes)));
                    }
                    gtidMap.put(GlobalTID.fromTIDBytes(gtridbytes), localTID);
                }
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex1) {
                    _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex1);
                }
                try {
                    if (prepStmt1 != null) {
                        prepStmt1.close();
                    }
                }
                catch (Exception ex1) {
                    _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex1);
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ex1) {
                    _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex1);
                }
            }
        }
        return gtidMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getServerNameForInstanceName(String instanceName0) {
        String serverName0 = null;
        if (this.ds != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("LogDBHelper get serverName for instanceName: " + instanceName0);
            }
            Connection conn = null;
            Statement prepStmt1 = null;
            ResultSet rs = null;
            try {
                conn = (Connection)this.getNonTxConnectionMethod.invoke((Object)this.ds, null);
                prepStmt1 = conn.prepareStatement(selectServerNameStatement);
                prepStmt1.setString(1, instanceName0);
                rs = prepStmt1.executeQuery();
                if (rs.next()) {
                    serverName0 = rs.getString(1);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("LogDBHelper found serverName: " + serverName0 + " for instanceName: " + instanceName0);
                    }
                }
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex1) {
                    _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex1);
                }
                try {
                    if (prepStmt1 != null) {
                        prepStmt1.close();
                    }
                }
                catch (Exception ex1) {
                    _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex1);
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ex1) {
                    _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex1);
                }
            }
        }
        return serverName0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable() {
        if (this.ds != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("LogDBHelper.createTable for instanceName: " + this.instanceName);
            }
            Connection conn = null;
            Statement stmt1 = null;
            try {
                conn = (Connection)this.getNonTxConnectionMethod.invoke((Object)this.ds, null);
                stmt1 = conn.createStatement();
                stmt1.execute(createTableStatement);
                _logger.fine("=== table created ===");
            }
            catch (Exception ex) {
                _logger.log(Level.INFO, "jts.exception_in_db_log_resource_create");
                _logger.log(Level.FINE, "jts.exception_in_db_log_table_create_error", ex);
            }
            finally {
                try {
                    if (stmt1 != null) {
                        stmt1.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ex1) {
                    _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex1);
                }
            }
        }
    }
}

