/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.faces;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.StateContext;
import com.sun.faces.facelets.tag.faces.PassThroughAttributeLibrary;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public final class ComponentSupport {
    private static final String MARK_DELETED = "com.sun.faces.facelets.MARK_DELETED";
    public static final String MARK_CREATED = "com.sun.faces.facelets.MARK_ID";
    private static final String MARK_ID_CACHE = "com.sun.faces.facelets.MARK_ID_CACHE";
    public static final String MARK_CHILDREN_MODIFIED = "com.sun.faces.facelets.MARK_CHILDREN_MODIFIED";
    public static final String REMOVED_CHILDREN = "com.sun.faces.facelets.REMOVED_CHILDREN";
    public static final String MARK_CREATED_REMOVED = StateContext.class.getName() + "_MARK_CREATED_REMOVED";
    private static final String IMPLICIT_PANEL = "com.sun.faces.facelets.IMPLICIT_PANEL";
    public static final String COMPONENT_TO_TAG_MAP_NAME = "com.sun.faces.facelets.COMPONENT_TO_LOCATION_MAP";

    public static boolean handlerIsResourceRelated(ComponentHandler handler) {
        ComponentConfig config = handler.getComponentConfig();
        if (!"jakarta.faces.Output".equals(config.getComponentType())) {
            return false;
        }
        String rendererType = config.getRendererType();
        return "jakarta.faces.resource.Script".equals(rendererType) || "jakarta.faces.resource.Stylesheet".equals(rendererType);
    }

    public static boolean isBuildingNewComponentTree(FacesContext context) {
        return !context.isPostback() || context.getCurrentPhaseId().equals(PhaseId.RESTORE_VIEW);
    }

    public static boolean isImplicitPanel(UIComponent component) {
        return component.getAttributes().containsKey(IMPLICIT_PANEL);
    }

    public static void finalizeForDeletion(UIComponent c) {
        Map<String, UIComponent> facets;
        c.getAttributes().remove(MARK_DELETED);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List<UIComponent> cl = c.getChildren();
            while (--sz >= 0) {
                cc = cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_DELETED)) continue;
                cl.remove(sz);
            }
        }
        if ((facets = c.getFacets()).size() > 0) {
            Set<Map.Entry<String, UIComponent>> col = facets.entrySet();
            Iterator<Map.Entry<String, UIComponent>> itr = col.iterator();
            while (itr.hasNext()) {
                Map.Entry<String, UIComponent> curEntry = itr.next();
                UIComponent fc = curEntry.getValue();
                Map<String, Object> attrs = fc.getAttributes();
                if (attrs.containsKey(MARK_DELETED)) {
                    itr.remove();
                    continue;
                }
                if (!"jakarta.faces.component.COMPOSITE_FACET_NAME".equals(curEntry.getKey()) && (!attrs.containsKey(IMPLICIT_PANEL) || curEntry.getKey().equals("jakarta_faces_metadata"))) continue;
                List<UIComponent> implicitPanelChildren = fc.getChildren();
                Iterator<UIComponent> innerItr = implicitPanelChildren.iterator();
                while (innerItr.hasNext()) {
                    UIComponent innerChild = innerItr.next();
                    if (!innerChild.getAttributes().containsKey(MARK_DELETED)) continue;
                    innerItr.remove();
                }
            }
        }
    }

    public static Tag setTagForComponent(FacesContext context, UIComponent c, Tag t) {
        Map<Object, Object> contextMap = context.getAttributes();
        HashMap<Integer, Tag> componentToTagMap = (HashMap<Integer, Tag>)contextMap.get(COMPONENT_TO_TAG_MAP_NAME);
        if (null == componentToTagMap) {
            componentToTagMap = new HashMap<Integer, Tag>();
            contextMap.put(COMPONENT_TO_TAG_MAP_NAME, componentToTagMap);
        }
        return componentToTagMap.put(System.identityHashCode(c), t);
    }

    public static Tag getTagForComponent(FacesContext context, UIComponent c) {
        Tag result = null;
        Map<Object, Object> contextMap = context.getAttributes();
        Map componentToTagMap = (Map)contextMap.get(COMPONENT_TO_TAG_MAP_NAME);
        if (null != componentToTagMap) {
            result = (Tag)componentToTagMap.get(System.identityHashCode(c));
        }
        return result;
    }

    public static UIComponent findChild(UIComponent parent, String id) {
        int sz = parent.getChildCount();
        if (sz > 0) {
            UIComponent c = null;
            List<UIComponent> cl = parent.getChildren();
            while (--sz >= 0) {
                c = cl.get(sz);
                if (!id.equals(c.getId())) continue;
                return c;
            }
        }
        return null;
    }

    public static UIComponent findUIInstructionChildByTagId(FacesContext context, UIComponent parent, String id) {
        UIComponent result = null;
        if (ComponentSupport.isBuildingNewComponentTree(context)) {
            return null;
        }
        if (ComponentSupport.isPartialStateSaving(context)) {
            result = ComponentSupport.getDescendantMarkIdCache(parent).get(id);
        }
        return result;
    }

    private static boolean isPartialStateSaving(FacesContext context) {
        return context.getAttributes().get((Object)WebConfiguration.BooleanWebContextInitParameter.PartialStateSaving) == Boolean.TRUE;
    }

    public static UIComponent findChildByTagId(FacesContext context, UIComponent parent, String id) {
        if (ComponentSupport.isPartialStateSaving(context)) {
            return ComponentSupport.getDescendantMarkIdCache(parent).get(id);
        }
        return ComponentSupport.findChildByTagIdFullStateSaving(context, parent, id);
    }

    private static UIComponent findChildByTagIdFullStateSaving(FacesContext context, UIComponent parent, String id) {
        List<UIComponent> components;
        UIComponent c = null;
        UIViewRoot root = context.getViewRoot();
        boolean hasDynamicComponents = null != root && root.getAttributes().containsKey("com.sun.faces.TreeHasDynamicComponents");
        String cid = null;
        String facetName = ComponentSupport.getFacetName(parent);
        if (null != facetName && null != (c = parent.getFacet(facetName)) && id.equals(cid = (String)c.getAttributes().get(MARK_CREATED))) {
            return c;
        }
        if (0 < parent.getFacetCount()) {
            components = new ArrayList<UIComponent>();
            components.addAll(parent.getFacets().values());
            components.addAll(parent.getChildren());
        } else {
            components = parent.getChildren();
        }
        int len = components.size();
        for (int i = 0; i < len; ++i) {
            UIComponent foundChild;
            c = components.get(i);
            cid = (String)c.getAttributes().get(MARK_CREATED);
            if (id.equals(cid)) {
                return c;
            }
            if (c instanceof UIPanel && c.getAttributes().containsKey(IMPLICIT_PANEL)) {
                for (UIComponent c2 : c.getChildren()) {
                    cid = (String)c2.getAttributes().get(MARK_CREATED);
                    if (!id.equals(cid)) continue;
                    return c2;
                }
            }
            if (!hasDynamicComponents || (foundChild = ComponentSupport.findChildByTagId(context, c, id)) == null) continue;
            return foundChild;
        }
        return null;
    }

    private static Map<String, UIComponent> getDescendantMarkIdCache(UIComponent component) {
        HashMap descendantMarkIdCache = (HashMap)component.getTransientStateHelper().getTransient(MARK_ID_CACHE);
        if (descendantMarkIdCache == null) {
            descendantMarkIdCache = new HashMap();
            component.getTransientStateHelper().putTransient(MARK_ID_CACHE, descendantMarkIdCache);
        }
        return descendantMarkIdCache;
    }

    public static void addToDescendantMarkIdCache(UIComponent component, UIComponent otherComponent) {
        Map<String, UIComponent> otherMarkIds;
        String markId = (String)otherComponent.getAttributes().get(MARK_CREATED);
        if (markId != null) {
            ComponentSupport.addSingleDescendantMarkId(component, markId, otherComponent);
        }
        if (!(otherMarkIds = ComponentSupport.getDescendantMarkIdCache(otherComponent)).isEmpty()) {
            ComponentSupport.addAllDescendantMarkIds(component, otherMarkIds);
        }
    }

    private static void addSingleDescendantMarkId(UIComponent component, String markId, UIComponent otherComponent) {
        ComponentSupport.getDescendantMarkIdCache(component).put(markId, otherComponent);
        UIComponent parent = component.getParent();
        if (parent != null) {
            ComponentSupport.addSingleDescendantMarkId(parent, markId, otherComponent);
        }
    }

    private static void addAllDescendantMarkIds(UIComponent component, Map<String, UIComponent> otherMarkIds) {
        ComponentSupport.getDescendantMarkIdCache(component).putAll(otherMarkIds);
        UIComponent parent = component.getParent();
        if (parent != null) {
            ComponentSupport.addAllDescendantMarkIds(parent, otherMarkIds);
        }
    }

    public static void removeFromDescendantMarkIdCache(UIComponent component, UIComponent otherComponent) {
        Map<String, UIComponent> otherMarkIds;
        String markId = (String)otherComponent.getAttributes().get(MARK_CREATED);
        if (markId != null) {
            ComponentSupport.removeSingleDescendantMarkId(component, markId);
        }
        if (!(otherMarkIds = ComponentSupport.getDescendantMarkIdCache(otherComponent)).isEmpty()) {
            ComponentSupport.removeAllDescendantMarkIds(component, otherMarkIds);
        }
    }

    private static void removeSingleDescendantMarkId(UIComponent component, String markId) {
        ComponentSupport.getDescendantMarkIdCache(component).remove(markId);
        UIComponent parent = component.getParent();
        if (parent != null) {
            ComponentSupport.removeSingleDescendantMarkId(parent, markId);
        }
    }

    private static void removeAllDescendantMarkIds(UIComponent component, Map<String, UIComponent> otherMarkIds) {
        Map<String, UIComponent> descendantMarkIdCache = ComponentSupport.getDescendantMarkIdCache(component);
        Iterator<String> iterator = otherMarkIds.keySet().iterator();
        while (iterator.hasNext()) {
            descendantMarkIdCache.remove(iterator.next());
        }
        UIComponent parent = component.getParent();
        if (parent != null) {
            ComponentSupport.removeAllDescendantMarkIds(parent, otherMarkIds);
        }
    }

    public static boolean isNotRenderingResponse(FacesContext context) {
        return !context.isReleased() && context.getCurrentPhaseId() != PhaseId.RENDER_RESPONSE;
    }

    public static Locale getLocale(FaceletContext ctx, TagAttribute attr) throws TagAttributeException {
        Object obj = attr.getObject(ctx);
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            try {
                return Util.getLocaleFromString(s);
            }
            catch (IllegalArgumentException iae) {
                throw new TagAttributeException(attr, "Invalid Locale Specified: " + s);
            }
        }
        throw new TagAttributeException(attr, "Attribute did not evaluate to a String or Locale: " + obj);
    }

    public static UIViewRoot getViewRoot(FaceletContext ctx, UIComponent parent) {
        UIComponent c = parent;
        do {
            if (!(c instanceof UIViewRoot)) continue;
            return (UIViewRoot)c;
        } while ((c = c.getParent()) != null);
        return ctx.getFacesContext().getViewRoot();
    }

    public static void markForDeletion(UIComponent c) {
        c.getAttributes().put(MARK_DELETED, Boolean.TRUE);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List<UIComponent> cl = c.getChildren();
            while (--sz >= 0) {
                cc = cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_CREATED)) continue;
                cc.getAttributes().put(MARK_DELETED, Boolean.TRUE);
            }
        }
        if (c.getFacets().size() > 0) {
            Set<Map.Entry<String, UIComponent>> col = c.getFacets().entrySet();
            for (Map.Entry<String, UIComponent> entry : col) {
                String facet = entry.getKey();
                UIComponent fc = entry.getValue();
                Map<String, Object> attrs = fc.getAttributes();
                if (attrs.containsKey(MARK_CREATED)) {
                    attrs.put(MARK_DELETED, Boolean.TRUE);
                    continue;
                }
                if ("jakarta.faces.component.COMPOSITE_FACET_NAME".equals(facet)) {
                    sz = fc.getChildCount();
                    if (sz <= 0) continue;
                    UIComponent cc = null;
                    List<UIComponent> cl = fc.getChildren();
                    while (--sz >= 0) {
                        cc = cl.get(sz);
                        cc.getAttributes().put(MARK_DELETED, Boolean.TRUE);
                    }
                    continue;
                }
                if (!attrs.containsKey(IMPLICIT_PANEL)) continue;
                List<UIComponent> implicitPanelChildren = fc.getChildren();
                Map<String, Object> innerAttrs = null;
                for (UIComponent cur : implicitPanelChildren) {
                    innerAttrs = cur.getAttributes();
                    if (!innerAttrs.containsKey(MARK_CREATED)) continue;
                    innerAttrs.put(MARK_DELETED, Boolean.TRUE);
                }
            }
        }
    }

    public static void encodeRecursive(FacesContext context, UIComponent viewToRender) throws IOException, FacesException {
        if (viewToRender.isRendered()) {
            viewToRender.encodeBegin(context);
            if (viewToRender.getRendersChildren()) {
                viewToRender.encodeChildren(context);
            } else if (viewToRender.getChildCount() > 0) {
                for (UIComponent kid : viewToRender.getChildren()) {
                    ComponentSupport.encodeRecursive(context, kid);
                }
            }
            viewToRender.encodeEnd(context);
        }
    }

    public static void removeTransient(UIComponent c) {
        UIComponent d;
        Iterator<UIComponent> itr;
        if (c.getChildCount() > 0) {
            itr = c.getChildren().iterator();
            while (itr.hasNext()) {
                d = itr.next();
                if (d.getFacets().size() > 0) {
                    Iterator<UIComponent> jtr = d.getFacets().values().iterator();
                    while (jtr.hasNext()) {
                        UIComponent e = jtr.next();
                        if (e.isTransient()) {
                            jtr.remove();
                            continue;
                        }
                        ComponentSupport.removeTransient(e);
                    }
                }
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(d);
            }
        }
        if (c.getFacets().size() > 0) {
            itr = c.getFacets().values().iterator();
            while (itr.hasNext()) {
                d = itr.next();
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(d);
            }
        }
    }

    public static void addComponent(FaceletContext ctx, UIComponent parent, UIComponent child) {
        String facetName = ComponentSupport.getFacetName(parent);
        if (facetName == null) {
            if (child.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
                int childIndex = (Integer)child.getAttributes().get("com.sun.faces.DynamicComponent");
                if (childIndex >= parent.getChildCount() || childIndex == -1) {
                    parent.getChildren().add(child);
                } else {
                    parent.getChildren().add(childIndex, child);
                }
            } else {
                parent.getChildren().add(child);
            }
        } else {
            UIComponent existing = parent.getFacets().get(facetName);
            if (existing != null && existing != child) {
                if (existing.getAttributes().get(IMPLICIT_PANEL) == null) {
                    UIComponent panelGroup = ctx.getFacesContext().getApplication().createComponent("jakarta.faces.Panel");
                    parent.getFacets().put(facetName, panelGroup);
                    Map<String, Object> attrs = panelGroup.getAttributes();
                    attrs.put(IMPLICIT_PANEL, true);
                    panelGroup.getChildren().add(existing);
                    existing = panelGroup;
                }
                if (existing.getAttributes().get(IMPLICIT_PANEL) != null) {
                    existing.getChildren().add(child);
                } else {
                    parent.getFacets().put(facetName, child);
                }
            } else {
                parent.getFacets().put(facetName, child);
            }
        }
    }

    public static String getFacetName(UIComponent parent) {
        return (String)parent.getAttributes().get("facelets.FACET_NAME");
    }

    public static boolean suppressViewModificationEvents(FacesContext ctx) {
        String viewId;
        UIViewRoot root = ctx.getViewRoot();
        if (root != null && (viewId = root.getViewId()) != null) {
            StateContext stateCtx = StateContext.getStateContext(ctx);
            return stateCtx.isPartialStateSaving(ctx, viewId);
        }
        return false;
    }

    public static void copyPassthroughAttributes(FaceletContext ctx, UIComponent c, Tag t) {
        if (null == c || null == t) {
            return;
        }
        for (String namespace : PassThroughAttributeLibrary.NAMESPACES) {
            TagAttribute[] passthroughAttrs = t.getAttributes().getAll(namespace);
            if (null == passthroughAttrs || 0 >= passthroughAttrs.length) continue;
            Map<String, Object> componentPassthroughAttrs = c.getPassThroughAttributes(true);
            Object attrValue = null;
            for (TagAttribute cur : passthroughAttrs) {
                attrValue = cur.isLiteral() ? cur.getValue(ctx) : cur.getValueExpression(ctx, Object.class);
                componentPassthroughAttrs.put(cur.getLocalName(), attrValue);
            }
        }
    }

    public static Collection<Object[]> saveDescendantInitialComponentStates(FacesContext facesContext, Iterator<UIComponent> childIterator, boolean saveChildFacets) {
        ArrayList<Object[]> childStates = null;
        while (childIterator.hasNext()) {
            UIComponent child;
            if (childStates == null) {
                childStates = new ArrayList<Object[]>();
            }
            if ((child = childIterator.next()).isTransient()) continue;
            Iterator<UIComponent> childsIterator = saveChildFacets ? child.getFacetsAndChildren() : child.getChildren().iterator();
            Collection<Object[]> descendantState = ComponentSupport.saveDescendantInitialComponentStates(facesContext, childsIterator, true);
            Object state = child.saveState(facesContext);
            childStates.add(new Object[]{state, descendantState});
        }
        return childStates;
    }

    public static Map<String, Object> saveDescendantComponentStates(FacesContext facesContext, Map<String, Object> stateMap, Iterator<UIComponent> childIterator, BiFunction<UIComponent, FacesContext, Object> stateSaver, boolean saveChildFacets) {
        while (childIterator.hasNext()) {
            UIComponent child = childIterator.next();
            if (child.isTransient()) continue;
            Iterator<UIComponent> childsIterator = saveChildFacets ? child.getFacetsAndChildren() : child.getChildren().iterator();
            stateMap = ComponentSupport.saveDescendantComponentStates(facesContext, stateMap, childsIterator, stateSaver, true);
            Object state = stateSaver.apply(child, facesContext);
            if (state == null) continue;
            if (stateMap == null) {
                stateMap = new HashMap<String, Object>();
            }
            stateMap.put(child.getClientId(facesContext), state);
        }
        return stateMap;
    }

    public static void restoreFullDescendantComponentStates(FacesContext facesContext, Iterator<UIComponent> childIterator, Object state, boolean restoreChildFacets) {
        Iterator descendantStateIterator = null;
        while (childIterator.hasNext()) {
            if (descendantStateIterator == null && state != null) {
                descendantStateIterator = ((Collection)state).iterator();
            }
            UIComponent component = childIterator.next();
            component.setId(component.getId());
            if (component.isTransient()) continue;
            Object childState = null;
            Object descendantState = null;
            if (descendantStateIterator != null && descendantStateIterator.hasNext()) {
                Object[] object = (Object[])descendantStateIterator.next();
                childState = object[0];
                descendantState = object[1];
            }
            component.clearInitialState();
            component.restoreState(facesContext, childState);
            component.markInitialState();
            Iterator<UIComponent> childsIterator = restoreChildFacets ? component.getFacetsAndChildren() : component.getChildren().iterator();
            ComponentSupport.restoreFullDescendantComponentStates(facesContext, childsIterator, descendantState, true);
        }
    }

    public static void restoreFullDescendantComponentDeltaStates(FacesContext facesContext, Iterator<UIComponent> childIterator, Object state, Object initialState, boolean restoreChildFacets) {
        Map descendantStateIterator = null;
        Iterator descendantFullStateIterator = null;
        while (childIterator.hasNext()) {
            if (descendantStateIterator == null && state != null) {
                descendantStateIterator = (Map)state;
            }
            if (descendantFullStateIterator == null && initialState != null) {
                descendantFullStateIterator = ((Collection)initialState).iterator();
            }
            UIComponent component = childIterator.next();
            component.setId(component.getId());
            if (component.isTransient()) continue;
            Object childInitialState = null;
            Object descendantInitialState = null;
            Object childState = null;
            if (descendantStateIterator != null && descendantStateIterator.containsKey(component.getClientId(facesContext))) {
                childState = descendantStateIterator.get(component.getClientId(facesContext));
            }
            if (descendantFullStateIterator != null && descendantFullStateIterator.hasNext()) {
                Object[] object = (Object[])descendantFullStateIterator.next();
                childInitialState = object[0];
                descendantInitialState = object[1];
            }
            component.clearInitialState();
            if (childInitialState != null) {
                component.restoreState(facesContext, childInitialState);
                component.markInitialState();
                component.restoreState(facesContext, childState);
            } else {
                component.restoreState(facesContext, childState);
                component.markInitialState();
            }
            Iterator<UIComponent> childsIterator = restoreChildFacets ? component.getFacetsAndChildren() : component.getChildren().iterator();
            ComponentSupport.restoreFullDescendantComponentDeltaStates(facesContext, childsIterator, state, descendantInitialState, true);
        }
    }

    public static void restoreTransientDescendantComponentStates(FacesContext facesContext, Iterator<UIComponent> childIterator, Map<String, Object> state, boolean restoreChildFacets) {
        while (childIterator.hasNext()) {
            UIComponent component = childIterator.next();
            component.setId(component.getId());
            if (component.isTransient()) continue;
            component.restoreTransientState(facesContext, state == null ? null : state.get(component.getClientId(facesContext)));
            Iterator<UIComponent> childsIterator = restoreChildFacets ? component.getFacetsAndChildren() : component.getChildren().iterator();
            ComponentSupport.restoreTransientDescendantComponentStates(facesContext, childsIterator, state, true);
        }
    }
}

